/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.session.impl;

import com.kingdee.bos.qing.common.session.AbstractQingSession;
import com.kingdee.bos.qing.common.session.impl.JVMMapCache;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class JVMQingSessionImpl
extends AbstractQingSession {
    static ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static long ttlIntervalMillis = TimeUnit.MINUTES.toMillis(1L);
    private static long SESSION_DEFAULT_TIMEOUT = TimeUnit.HOURS.toMillis(1L);
    private static Map<String, Long> allSessionCacheLastVisit = new ConcurrentHashMap<String, Long>();
    private static ConcurrentHashMap<String, JVMMapCache> allSessionCache = new ConcurrentHashMap();
    private static Runnable task;

    public JVMQingSessionImpl(String sessionId) {
        super(sessionId);
    }

    public static void stop() {
        scheduler.shutdown();
    }

    public static void start() {
        task = new CleanTask();
        scheduler.scheduleAtFixedRate(task, ttlIntervalMillis, ttlIntervalMillis, TimeUnit.MILLISECONDS);
    }

    private JVMMapCache getCache() {
        JVMMapCache newSessionMap;
        String sessionId = this.getKey();
        JVMMapCache oldSessionMap = allSessionCache.putIfAbsent(sessionId, newSessionMap = new JVMMapCache());
        if (oldSessionMap == null) {
            oldSessionMap = newSessionMap;
        }
        allSessionCacheLastVisit.put(sessionId, System.currentTimeMillis());
        return oldSessionMap;
    }

    @Override
    public boolean checkLogin() {
        if (allSessionCache.containsKey(this.getId())) {
            String value = this.get("login");
            return "true".equals(value);
        }
        return false;
    }

    @Override
    public void set(String key, String value) {
        this.getCache().set(key, value, 0, TimeUnit.SECONDS);
    }

    @Override
    public String get(String key) {
        return this.getCache().get(key);
    }

    @Override
    public void remove(String key) {
        this.getCache().remove(key);
    }

    static {
        JVMQingSessionImpl.start();
    }

    private static class CleanTask
    implements Runnable {
        private CleanTask() {
        }

        @Override
        public void run() {
            long currentTimeMillis = System.currentTimeMillis();
            HashSet sessionIDs = new HashSet();
            sessionIDs.addAll(allSessionCache.keySet());
            for (String sessionId : sessionIDs) {
                long lastVisit = (Long)allSessionCacheLastVisit.get(sessionId);
                if (currentTimeMillis - lastVisit < SESSION_DEFAULT_TIMEOUT) continue;
                allSessionCache.remove(sessionId);
                allSessionCacheLastVisit.remove(sessionId);
            }
        }
    }
}

