/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager;

import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CopyWriteCall
implements IWriteCall {
    private InputStream _inputStream;
    private boolean _isAutoCloseInputStream;

    public CopyWriteCall(InputStream inputStream, boolean isAutoCloseInputStream) {
        this._inputStream = inputStream;
        this._isAutoCloseInputStream = isAutoCloseInputStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void call(OutputStream outputStream) throws IOException {
        try {
            IOUtil.copy(this._inputStream, outputStream);
            if (!this._isAutoCloseInputStream) return;
        }
        catch (Throwable throwable) {
            if (!this._isAutoCloseInputStream) throw throwable;
            CloseUtil.close(this._inputStream);
            throw throwable;
        }
        CloseUtil.close(this._inputStream);
    }
}

