/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.localimpl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.filesystem.manager.AbstractQingFile;
import com.kingdee.bos.qing.filesystem.manager.ScheduleFailedManager;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileWriter;
import com.kingdee.bos.qing.filesystem.manager.localimpl.FileSysUtil;
import com.kingdee.bos.qing.filesystem.manager.localimpl.LocalQingFileWriter;
import com.kingdee.bos.qing.filesystem.manager.localimpl.UpdateHelper;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.stream.LocalFileQingInputStream;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class AbstractLocalQingFile
extends AbstractQingFile {
    protected String DIRECTORY_PATH = FileSysUtil.getAbsoluteFilePath(File.separator + "QingStorage" + File.separator + this.getRootDir() + File.separator);
    protected File file;

    private static void createRootDir() {
        String tempDirPath = FileSysUtil.getAbsoluteFilePath(File.separator + "QingStorage" + File.separator);
        File tempDir = new File(tempDirPath);
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
    }

    public AbstractLocalQingFile(AbstractQingFileType fileType) {
        super(fileType);
        FileSysUtil.createAbsolutePathDir(this.DIRECTORY_PATH);
        String fullPath = this.getFullPath();
        this.file = new File(fullPath);
    }

    protected AbstractLocalQingFile(AbstractQingFileType fileType, String name) {
        super(fileType, name);
        FileSysUtil.createAbsolutePathDir(this.DIRECTORY_PATH);
        String fullPath = this.getFullPath();
        this.file = new File(fullPath);
    }

    public abstract String getRootDir();

    public String getFullPath() {
        return this.getFullPath(this.getPath());
    }

    public String getFullPath(String filePath) {
        return this.checkPath(this.DIRECTORY_PATH + filePath);
    }

    private String checkPath(String path) {
        return path.replace("../", "#");
    }

    @Override
    public boolean exists() {
        if (this.getName() == null || "".equals(this.getName().trim())) {
            return false;
        }
        if (this.file == null) {
            return false;
        }
        return this.file.exists();
    }

    @Override
    public long getLength() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return this.file.length();
    }

    @Override
    public long getLastModifiedTimes() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return this.file.lastModified();
    }

    @Override
    public File getLocalFileSystemFile() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return this.file;
    }

    @Override
    public String getLocalFullPath() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return this.file.getCanonicalPath();
    }

    @Override
    protected boolean doCreateNewFile() throws IOException {
        File parentFile = this.file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        return this.file.createNewFile();
    }

    @Override
    protected boolean doDelete() {
        if (this.exists()) {
            if (this.file.delete()) {
                this.file = null;
                return true;
            }
            LogUtil.error("delete file fail, fileName:" + this.file.getPath());
            ScheduleFailedManager scheduleFailedManager = new ScheduleFailedManager();
            scheduleFailedManager.logDeleteFailedFile(this._fileType, this.file.getName(), QingContext.getCurrent().getAccountId());
        } else if (this.file != null) {
            LogUtil.error("delete file is not exists, fileName:" + this.file.getPath());
        }
        return false;
    }

    @Override
    public QingInputStream getInputStream() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return new QingInputStream(this.file.length(), new LocalFileQingInputStream(this.file));
    }

    @Override
    protected IQingFileWriter doCreateWriter() {
        return new LocalQingFileWriter(this._fileResourceService, this._fileResourceInfo, this.getFullPath());
    }

    static {
        AbstractLocalQingFile.createRootDir();
        UpdateHelper updateHelper = new UpdateHelper();
        updateHelper.update();
    }
}

