/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.resource.domain;

import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.filesystem.manager.fileresource.domain.FileResourceDomain;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourceVO;
import com.kingdee.bos.qing.resource.AbstractResourceManager;
import com.kingdee.bos.qing.resource.domain.IResInfoManagerDomain;
import com.kingdee.bos.qing.resource.domain.ResInfoManagerDomainFactory;
import com.kingdee.bos.qing.resource.exception.ResourceManagementException;
import com.kingdee.bos.qing.resource.model.ResInfoManagerType;
import com.kingdee.bos.qing.resource.model.ResourceInfoVO;
import com.kingdee.bos.qing.resource.model.ResourceTypeEnum;
import com.kingdee.bos.qing.schedule.domain.ScheduleExecuteDomain;
import com.kingdee.bos.qing.schedule.model.ScheduleExecuteVO;
import com.kingdee.bos.qing.util.DateUtils;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ResourceInfoDomain {
    private AbstractResourceManager resourceManager;
    private FileResourceDomain fileResourceDomain;
    private ScheduleExecuteDomain scheduleExecuteDomain;

    public ResourceInfoDomain(AbstractResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public FileResourceDomain getFileResourceDomain() {
        if (this.fileResourceDomain == null) {
            this.fileResourceDomain = this.resourceManager.getFileResourceDomain();
        }
        return this.fileResourceDomain;
    }

    public ScheduleExecuteDomain getScheduleExecuteDomain() {
        if (this.scheduleExecuteDomain == null) {
            this.scheduleExecuteDomain = this.resourceManager.getScheduleExecuteDomain();
        }
        return this.scheduleExecuteDomain;
    }

    public ResourceInfoVO resourceInfoStatistics() throws AbstractQingIntegratedException, ResourceManagementException {
        int otherUserTenantUseScheduleCount;
        BigDecimal otherUserTenantUseFileSize;
        ResourceInfoVO resourceInfo = new ResourceInfoVO();
        int userFreeFileSize = this.getFileResourceDomain().getUserFreeFileSize();
        int tenantFreeFileSize = this.getFileResourceDomain().getTenantFreeFileSize();
        BigDecimal userFreeFileSizeByte = new BigDecimal(0x100000L * (long)userFreeFileSize);
        BigDecimal tenantFreeFileSizeByte = new BigDecimal(0x100000L * (long)tenantFreeFileSize);
        BigDecimal tenantPayFileSize = this.getFileResourceDomain().findPaySizeByTenantId().multiply(new BigDecimal(0x100000L));
        BigDecimal tenantFileSize = tenantPayFileSize.add(tenantFreeFileSizeByte);
        BigDecimal tenantUseFileSize = this.getFileResourceDomain().findSumTenantUseFileSizeByTenantId();
        resourceInfo.setTenantFreeFileSize("" + tenantFreeFileSize);
        resourceInfo.setTenantPayFileSize(this.byteToMBStr(tenantPayFileSize));
        resourceInfo.setTenantFileSize(this.byteToMBStr(tenantFileSize));
        resourceInfo.setTenantUseFileSize(this.byteToMBStr(tenantUseFileSize));
        BigDecimal userUseFileSize = this.getFileResourceDomain().findSumFileSizeByUserId();
        BigDecimal bigDecimal = otherUserTenantUseFileSize = userUseFileSize.compareTo(userFreeFileSizeByte) < 0 ? tenantUseFileSize : tenantUseFileSize.subtract(userUseFileSize.subtract(userFreeFileSizeByte));
        if (otherUserTenantUseFileSize.compareTo(tenantFileSize) > 0) {
            otherUserTenantUseFileSize = tenantFileSize;
        }
        resourceInfo.setUserFreeFileSize("" + userFreeFileSize);
        resourceInfo.setUserUseFileSize(this.byteToMBStr(userUseFileSize));
        resourceInfo.setOtherUserTenantUseFileSize(this.byteToMBStr(otherUserTenantUseFileSize));
        BigDecimal totalFileSizeByte = tenantFileSize.add(userFreeFileSizeByte);
        resourceInfo.setTotalFileSize(this.byteToIntMBStr(totalFileSizeByte));
        resourceInfo.setAvaFileSize(this.byteToMBStr(userFreeFileSizeByte.add(tenantFileSize).subtract(userUseFileSize).subtract(otherUserTenantUseFileSize)));
        resourceInfo.setUserAvaFileSize(this.byteToMBStr(userFreeFileSizeByte.subtract(userUseFileSize)));
        resourceInfo.setTenantAvaFileSize(this.byteToMBStr(tenantFileSize.subtract(tenantUseFileSize)));
        resourceInfo.setUserUseFileSizePercent(userFreeFileSizeByte.compareTo(BigDecimal.ZERO) == 0 ? 0.0 : userUseFileSize.divide(userFreeFileSizeByte, 2, 4).doubleValue());
        resourceInfo.setTenantOTherUserFileSizePercent(otherUserTenantUseFileSize.divide(userFreeFileSizeByte.add(tenantFileSize), 2, 4).doubleValue());
        resourceInfo.setUserFreeFileSizePercent(userFreeFileSizeByte.divide(totalFileSizeByte, 2, 4).doubleValue());
        resourceInfo.setTenantUseFileSizePercent(tenantFileSize.compareTo(BigDecimal.ZERO) == 0 ? 0.0 : tenantUseFileSize.divide(tenantFileSize, 2, 4).doubleValue());
        int userFreeScheduleCount = this.getScheduleExecuteDomain().getUserFreeScheduleCount();
        int tenantFreeScheduleCount = this.getScheduleExecuteDomain().getTenantFreeScheduleCount();
        int tenantPayScheduleCount = this.getScheduleExecuteDomain().findPaySizeByTenantId();
        int tenantScheduleCount = tenantPayScheduleCount + tenantFreeScheduleCount;
        int tenantUseScheduleCount = this.getScheduleExecuteDomain().getTenantUseScheduleCountByTenant(DateUtils.getTimeMin(new Date()), DateUtils.getTimeMax(new Date()));
        int userUseScheduleCount = this.getScheduleExecuteDomain().getUserUseScheduleCountByUserId(DateUtils.getTimeMin(new Date()), DateUtils.getTimeMax(new Date()));
        int n = otherUserTenantUseScheduleCount = userUseScheduleCount < userFreeScheduleCount ? tenantUseScheduleCount : tenantUseScheduleCount - (userUseScheduleCount - userFreeScheduleCount);
        if (otherUserTenantUseScheduleCount > tenantScheduleCount) {
            otherUserTenantUseScheduleCount = tenantScheduleCount;
        }
        resourceInfo.setTenantFreeScheduleCount(tenantFreeScheduleCount);
        resourceInfo.setTenantPayScheduleCount(tenantPayScheduleCount);
        resourceInfo.setTenantScheduleCount(tenantScheduleCount);
        resourceInfo.setTenantUseScheduleCount(tenantUseScheduleCount);
        resourceInfo.setOtherUserTenantUseScheduleCount(otherUserTenantUseScheduleCount);
        resourceInfo.setUserFreeScheduleCount(userFreeScheduleCount);
        resourceInfo.setUserUseScheduleCount(userUseScheduleCount);
        resourceInfo.setTotalScheduleCount(userFreeScheduleCount + tenantScheduleCount);
        resourceInfo.setAvaScheduleCount(userFreeScheduleCount + tenantScheduleCount - userUseScheduleCount - otherUserTenantUseScheduleCount);
        resourceInfo.setUserAvaScheduleCount(userFreeScheduleCount - userUseScheduleCount);
        resourceInfo.setTenantAvaScheduleCount(tenantScheduleCount - tenantUseScheduleCount);
        resourceInfo.setUserUseScheduleCountPercent(this.percentToDouble(userUseScheduleCount, userFreeScheduleCount));
        resourceInfo.setTenantOTherScheduleCountPercent(this.percentToDouble(otherUserTenantUseScheduleCount, userFreeScheduleCount + tenantScheduleCount));
        resourceInfo.setUserFreeScheduleCountPercent(this.percentToDouble(userFreeScheduleCount, userFreeScheduleCount + tenantScheduleCount));
        resourceInfo.setTenantUseScheduleCountPercent(this.percentToDouble(tenantUseScheduleCount, tenantScheduleCount));
        return resourceInfo;
    }

    public List<?> getResourceInfoDetailList(String resourceType, String sortField, String sortOrder) throws AbstractQingIntegratedException, ResourceManagementException {
        if (ResourceTypeEnum.FILE.name().equals(resourceType)) {
            Map<ResInfoManagerType, Constructor<? extends IResInfoManagerDomain>> classMap = ResInfoManagerDomainFactory.getResInfoManagerDomainClassMap();
            ArrayList<FileResourceVO> list = new ArrayList<FileResourceVO>();
            for (ResInfoManagerType type : classMap.keySet()) {
                IResInfoManagerDomain infoDomain = ResInfoManagerDomainFactory.createResInfoManagerDomain(this.resourceManager.getQingContext(), this.resourceManager.getDBExcuter(), this.resourceManager.getTx(), type);
                List<FileResourceVO> resourceFileList = infoDomain.findResourceFileListByUserId();
                if (resourceFileList == null) continue;
                list.addAll(resourceFileList);
            }
            if (list != null) {
                Collections.sort(list, new Comparator<FileResourceVO>(){

                    @Override
                    public int compare(FileResourceVO arg0, FileResourceVO arg1) {
                        String fileSize0 = arg0.getFileSizeNoFormat();
                        String fileSize1 = arg1.getFileSizeNoFormat();
                        BigDecimal bigDecimal0 = new BigDecimal(fileSize0);
                        BigDecimal bigDecimal1 = new BigDecimal(fileSize1);
                        return bigDecimal1.compareTo(bigDecimal0);
                    }
                });
                for (FileResourceVO fileResourceVO : list) {
                    BigDecimal bigDecimal;
                    long fileSize = Long.parseLong(fileResourceVO.getFileSizeNoFormat());
                    if (fileSize <= 0x100000L) {
                        bigDecimal = new BigDecimal(fileSize).divide(new BigDecimal(1024), 2, 4);
                        fileResourceVO.setFileSize(bigDecimal + "KB");
                        continue;
                    }
                    bigDecimal = new BigDecimal(fileSize).divide(new BigDecimal(0x100000), 2, 4);
                    fileResourceVO.setFileSize(bigDecimal + "MB");
                }
            }
            return list;
        }
        if (ResourceTypeEnum.SCHEDULE.name().equals(resourceType)) {
            Map<ResInfoManagerType, Constructor<? extends IResInfoManagerDomain>> classMap = ResInfoManagerDomainFactory.getResInfoManagerDomainClassMap();
            ArrayList<ScheduleExecuteVO> list = new ArrayList<ScheduleExecuteVO>();
            for (ResInfoManagerType type : classMap.keySet()) {
                IResInfoManagerDomain infoDomain = ResInfoManagerDomainFactory.createResInfoManagerDomain(this.resourceManager.getQingContext(), this.resourceManager.getDBExcuter(), this.resourceManager.getTx(), type);
                List<ScheduleExecuteVO> scheduleExecuteList = infoDomain.findScheduleExecuteListByUserId(DateUtils.getTimeMin(new Date()), DateUtils.getTimeMax(new Date()));
                if (scheduleExecuteList == null) continue;
                list.addAll(scheduleExecuteList);
            }
            Collections.sort(list, new Comparator<ScheduleExecuteVO>(){

                @Override
                public int compare(ScheduleExecuteVO arg0, ScheduleExecuteVO arg1) {
                    long longArg1;
                    long longArg0 = arg0.getExecuteTime();
                    return longArg0 < (longArg1 = arg1.getExecuteTime().longValue()) ? 1 : (longArg0 == longArg1 ? 0 : -1);
                }
            });
            return list;
        }
        throw new ResourceManagementException("Unsupport resource type :" + resourceType);
    }

    private String byteToMBStr(BigDecimal bigDecimalByte) {
        BigDecimal bigDecimal = bigDecimalByte.divide(new BigDecimal(0x100000), 2, 4);
        return bigDecimal.toString();
    }

    private String byteToIntMBStr(BigDecimal bigDecimalByte) {
        return String.valueOf(bigDecimalByte.divide(new BigDecimal(0x100000), 0, 4).intValue());
    }

    private double percentToDouble(int dividend, int divisor) {
        if (divisor == 0) {
            return 0.0;
        }
        BigDecimal bigDecimal = new BigDecimal(dividend).divide(new BigDecimal(divisor), 2, 4);
        return bigDecimal.doubleValue();
    }

    public boolean hasResourceManager() {
        return this.resourceManager.hasResourceManager();
    }

    public int getLicenseStorageSize() throws AbstractQingIntegratedException, SQLException {
        return this.resourceManager.getLicenseStorageSize();
    }
}

