/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XmlUtil {
    private static JAXBContext createContext(Class<?> type) throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{type});
    }

    public static void marshall(Object target, OutputStream out) throws JAXBException {
        if (target == null || out == null) {
            return;
        }
        JAXBContext context = XmlUtil.createContext(target.getClass());
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal(target, out);
    }

    public static byte[] toByteArray(Element xml) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            XmlUtil.save(xml, outputStream);
        }
        catch (IOException e) {
            LogUtil.error(e.getMessage(), e);
        }
        return outputStream.toByteArray();
    }

    public static void save(Element xmlNode, OutputStream stream) throws IOException {
        Format format = Format.getRawFormat();
        format.setIndent("\t");
        format.setEncoding("UTF-8");
        format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
        XMLOutputter outputter = new XMLOutputter(format);
        outputter.output(xmlNode, stream);
    }

    public static void saveFile(Element xmlNode, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            XmlUtil.save(xmlNode, fos);
        }
        catch (Throwable throwable) {
            CloseUtil.close(fos);
            throw throwable;
        }
        CloseUtil.close(fos);
    }

    public static Document loadDocument(InputStream stream) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return builder.build(stream);
    }

    public static Element loadRootElement(InputStream stream) throws JDOMException, IOException {
        Document doc = XmlUtil.loadDocument(stream);
        return doc.getRootElement();
    }

    public static Element loadRootElementFromFile(File file) throws IOException, JDOMException {
        Element element;
        FileInputStream fis = new FileInputStream(file);
        try {
            element = XmlUtil.loadRootElement(fis);
        }
        catch (Throwable throwable) {
            CloseUtil.close(fis);
            throw throwable;
        }
        CloseUtil.close(fis);
        return element;
    }

    public static String toString(Element node) {
        try {
            return new String(XmlUtil.toByteArray(node), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static Element getChild(Element parentNode, String name) {
        return parentNode.getChild(name);
    }

    public static Element getChildNotNull(Element parentNode, String name) throws NullException {
        Element childNode = parentNode.getChild(name);
        if (childNode == null) {
            throw new NullException("Node <" + parentNode.getName() + "> has no child: " + name);
        }
        return childNode;
    }

    public static List<Element> getChildren(Element parentNode, String name) {
        return parentNode.getChildren(name);
    }

    public static List<Element> getChildren(Element parentNode) {
        return parentNode.getChildren();
    }

    public static String readAttrNotNull(Element xmlNode, String attributeKey) throws NullException {
        String attributeValue = xmlNode.getAttributeValue(attributeKey);
        if (attributeValue == null) {
            throw new NullException("Node <" + xmlNode.getName() + "> has no attribute: " + attributeKey);
        }
        return attributeValue;
    }

    public static void writeAttrNotNull(Element xmlNode, String attributeKey, String attributeValue) {
        xmlNode.setAttribute(attributeKey, attributeValue);
    }

    public static String readAttrWhenExist(Element xmlNode, String attributeKey) {
        String attributeValue = xmlNode.getAttributeValue(attributeKey);
        return attributeValue;
    }

    public static void writeAttrWhenExist(Element xmlNode, String attributeKey, String attributeValue) {
        if (attributeValue != null) {
            xmlNode.setAttribute(attributeKey, attributeValue);
        }
    }

    public static Boolean readAttrBoolWhenExist(Element xmlNode, String attributeKey) {
        String attributeValue = xmlNode.getAttributeValue(attributeKey);
        if (attributeValue != null) {
            return Boolean.parseBoolean(attributeValue);
        }
        return null;
    }

    public static void writeAttrBoolWhenExist(Element xmlNode, String attributeKey, Boolean attributeValue) {
        if (attributeValue != null) {
            xmlNode.setAttribute(attributeKey, attributeValue.toString());
        }
    }

    public static boolean readAttrDefaultFalse(Element xmlNode, String attributeKey) {
        String attributeValue = xmlNode.getAttributeValue(attributeKey);
        return attributeValue == null ? false : Boolean.parseBoolean(attributeValue);
    }

    public static void writeAttrDefaultFalse(Element xmlNode, String attributeKey, boolean attributeValue) {
        if (attributeValue) {
            xmlNode.setAttribute(attributeKey, Boolean.toString(true));
        }
    }

    public static boolean readAttrDefaultTrue(Element xmlNode, String attributeKey) {
        String attributeValue = xmlNode.getAttributeValue(attributeKey);
        return attributeValue == null ? true : Boolean.parseBoolean(attributeValue);
    }

    public static void writeAttrDefaultTrue(Element xmlNode, String attributeKey, boolean attributeValue) {
        if (!attributeValue) {
            xmlNode.setAttribute(attributeKey, Boolean.toString(false));
        }
    }

    public static int readAttrInt(Element xmlNode, String attributeKey) throws NullException {
        String attributeValue = xmlNode.getAttributeValue(attributeKey);
        if (attributeValue == null) {
            throw new NullException("Node <" + xmlNode.getName() + "> has no attribute: " + attributeKey);
        }
        try {
            return Integer.parseInt(attributeValue);
        }
        catch (NumberFormatException ex) {
            throw new NullException("Node <" + xmlNode.getName() + "> has no numerical attribute: " + attributeKey);
        }
    }

    public static void writeAttrInt(Element xmlNode, String attributeKey, int attributeValue) {
        xmlNode.setAttribute(attributeKey, Integer.toString(attributeValue));
    }

    public static Integer readAttrIntWhenExist(Element xmlNode, String attributeKey) {
        String attributeValue = xmlNode.getAttributeValue(attributeKey);
        if (attributeValue == null) {
            return null;
        }
        try {
            return Integer.parseInt(attributeValue);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static void writeAttrIntWhenExist(Element xmlNode, String attributeKey, Integer attributeValue) {
        if (attributeValue != null) {
            xmlNode.setAttribute(attributeKey, String.valueOf(attributeValue));
        }
    }

    public static long readAttrLong(Element xmlNode, String attributeKey) throws NullException {
        String attributeValue = xmlNode.getAttributeValue(attributeKey);
        if (attributeValue == null) {
            throw new NullException("Node <" + xmlNode.getName() + "> has no attribute: " + attributeKey);
        }
        try {
            return Long.parseLong(attributeValue);
        }
        catch (NumberFormatException ex) {
            throw new NullException("Node <" + xmlNode.getName() + "> has no numerical attribute: " + attributeKey);
        }
    }

    public static void writeAttrLong(Element xmlNode, String attributeKey, long attributeValue) {
        xmlNode.setAttribute(attributeKey, Long.toString(attributeValue));
    }

    public static Long readAttrLongWhenExist(Element xmlNode, String attributeKey) {
        String attributeValue = xmlNode.getAttributeValue(attributeKey);
        if (attributeValue == null) {
            return null;
        }
        try {
            return Long.parseLong(attributeValue);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static void writeAttrLongWhenExist(Element xmlNode, String attributeKey, Long attributeValue) {
        if (attributeValue != null) {
            xmlNode.setAttribute(attributeKey, String.valueOf(attributeValue));
        }
    }

    public static void addCDATA(Element nodeItem, String value) {
        if (value == null || value.indexOf("]]>") < 0) {
            nodeItem.addContent((Content)new CDATA(value));
            return;
        }
        String[] arrValue = value.split("]]>", -1);
        int length = arrValue.length;
        for (int i = 0; i < length; ++i) {
            String str = arrValue[i];
            if (i != 0) {
                str = ">" + str;
            }
            nodeItem.addContent((Content)new CDATA(str));
            if (i == length - 1) continue;
            nodeItem.addContent("]]");
        }
    }

    public static class NullException
    extends Exception {
        private static final long serialVersionUID = -8145245827944452494L;

        public NullException(String message) {
            super(message);
        }
    }
}

