/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.dataset;

import com.kingdee.bos.qing.api.customtable.interfaces.IQingTableRowDataProcessor;
import com.kingdee.bos.qing.api.customtable.model.FieldData;
import com.kingdee.bos.qing.api.customtable.model.TableRowObject;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.dataset.IQingUniteDataSet;
import com.kingdee.bos.qing.data.domain.source.dataset.IRowDataHandleCallBack;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import java.util.HashMap;
import java.util.Map;

public abstract class QingUniteDataSetHandleTemplate {
    private IRowDataHandleCallBack dataHandleCallBack;
    private IQingTableRowDataProcessor rowDataProcessor;

    public QingUniteDataSetHandleTemplate(IQingTableRowDataProcessor rowDataProcessor, IRowDataHandleCallBack dataHandleCallBack) {
        this.dataHandleCallBack = dataHandleCallBack;
        this.rowDataProcessor = rowDataProcessor;
    }

    public void processDataSet(RuntimeEntity runtimeEntity, IQingUniteDataSet dataSet) throws Exception {
        Map<String, FieldData> rowFieldDatas = this.initRowFieldDataMap(dataSet, runtimeEntity);
        while (dataSet.next()) {
            this.checkInterrupted();
            this.bindFieldData(dataSet, runtimeEntity, rowFieldDatas);
            TableRowObject rowObject = new TableRowObject(rowFieldDatas);
            this.rowDataProcessor.processRow(rowObject);
            Map<String, Object> data = new HashMap<String, Object>();
            rowObject.flushToMap(data);
            data = AbstractDataSourceDomain.getRowDataAfterCalculateAndFilter(data, runtimeEntity);
            boolean continueNext = this.dataHandleCallBack.doCallBack(data);
            rowObject.notifyRowDeleteState(null == data);
            if (continueNext) continue;
            break;
        }
    }

    protected void checkInterrupted() throws InterruptedException {
    }

    protected abstract void bindFieldData(IQingUniteDataSet var1, RuntimeEntity var2, Map<String, FieldData> var3) throws Exception;

    protected abstract Map<String, FieldData> initRowFieldDataMap(IQingUniteDataSet var1, RuntimeEntity var2) throws Exception;
}

