/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.trace.TraceSpan;
import com.kingdee.bos.qing.common.trace.TracerUtil;
import com.kingdee.bos.qing.data.domain.source.db.util.DataTypeUtil;
import com.kingdee.bos.qing.data.domain.source.file.FileResult;
import com.kingdee.bos.qing.data.domain.source.file.domain.AbstractFileSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.model.AbstractFileModel;
import com.kingdee.bos.qing.data.domain.source.file.model.Excel03Model;
import com.kingdee.bos.qing.data.domain.source.file.model.Excel07Model;
import com.kingdee.bos.qing.data.domain.source.file.model.ResultContent;
import com.kingdee.bos.qing.data.domain.source.file.model.RunningTimeParams;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.file.FileSourceSheetNotFoundException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.source.ExcelSource;
import com.kingdee.bos.qing.data.model.runtime.Field;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeFilterUtil;
import com.kingdee.bos.qing.data.model.runtime.Table;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.data.model.vo.LeafNode;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.data.util.ThreadCache;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExcelSourceDomain
extends AbstractFileSourceDomain {
    private static volatile AbstractFileSourceDomain thiz;
    private String XLSX = ".xlsx";

    private ExcelSourceDomain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AbstractFileSourceDomain newInstance() {
        if (thiz != null) return thiz;
        Class<ExcelSourceDomain> clazz = ExcelSourceDomain.class;
        synchronized (ExcelSourceDomain.class) {
            if (thiz != null) return thiz;
            thiz = new ExcelSourceDomain();
            // ** MonitorExit[var0] (shouldn't be in output)
            return thiz;
        }
    }

    @Override
    public AbstractNode getUsableEntities(QingContext qingContext, AbstractSource source) throws AbstractSourceException {
        FolderNode root = new FolderNode();
        ExcelSource fileSource = (ExcelSource)source;
        String fileName = fileSource.getFileName();
        String fileUrl = fileSource.getFileUrl();
        List<Object> sheets = new ArrayList();
        sheets = fileName.lastIndexOf(this.XLSX) > 0 ? new Excel07Model(fileUrl).getTableNames() : new Excel03Model(fileUrl).getTableNames();
        int sheetCount = sheets.size();
        for (int i = 0; i < sheetCount; ++i) {
            String name = (String)sheets.get(i);
            LeafNode leafNode = new LeafNode();
            leafNode.setName(name);
            leafNode.setDisplayName(name);
            leafNode.setCommentInfo(name);
            leafNode.setType("excel");
            root.addChild((AbstractNode)leafNode);
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreviewDataModel doGetPreviewData(QingContext qingContext, RuntimeEntity runtimeEntity, int topN) throws AbstractSourceException {
        ExcelSource fileSource = (ExcelSource)runtimeEntity.getSource();
        String fileName = fileSource.getFileName();
        String fileUrl = fileSource.getFileUrl();
        RuntimeFilterUtil.Prediction prediction = this.initRuntimeFilter(runtimeEntity);
        if (prediction.isAlwaysFalse()) {
            return new PreviewDataModel(new ArrayList<Object[]>());
        }
        IRuntimeFilter iRuntimeFilter = runtimeEntity.getPushdownableFilter();
        Integer colIndex = 0;
        ThreadCache.setIndex(colIndex);
        ThreadCache.setRow(new HashMap<String, Object>());
        RunningTimeParams params = new RunningTimeParams();
        params.setFileSourceDomain(this);
        params.setRuntimeFilter(iRuntimeFilter);
        params.setRuntimeEntity(runtimeEntity);
        params.setSource((AbstractSource)fileSource);
        params.setTopN(topN);
        params.setPreview(true);
        ResultContent rc = null;
        AbstractFileModel model = null;
        try {
            model = fileName.lastIndexOf(this.XLSX) > 0 ? new Excel07Model(fileUrl, runtimeEntity.getAssociateName()) : new Excel03Model(fileUrl, runtimeEntity.getAssociateName());
            model.setFileSourceDomain(this);
            rc = model.topNRow(params, null);
        }
        catch (AbstractDataSourceException e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
            PreviewDataModel previewDataModel = new PreviewDataModel(new ArrayList<Object[]>(), e.getMessage());
            return previewDataModel;
        }
        finally {
            ThreadCache.removeIndex();
            ThreadCache.removeRow();
        }
        StringBuilder msg = new StringBuilder();
        if (null != rc) {
            List<String> messages = rc.getMessages();
            if (messages.size() > 0) {
                for (int index = 0; index < messages.size(); ++index) {
                    msg.append(messages.get(index));
                    if (index >= messages.size() - 1) continue;
                    msg.append("\r\n");
                }
            }
            return new PreviewDataModel(rc.getPreviewResult(), msg.toString());
        }
        return new PreviewDataModel(null, msg.toString());
    }

    @Override
    public DesigntimeDataObject getDesigntimeDataObject(QingContext qingContext, AbstractSource source, String sheetName) throws AbstractSourceException {
        ExcelSource fileSource = (ExcelSource)source;
        Table table = this.getTable(sheetName, null, fileSource, qingContext);
        return DesigntimeDataObject.createSingleDataObject(Entity.fromTable(table));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doExtractData(QingContext qingContext, IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity, ProgressProcessor progressProcessor) throws AbstractSourceException, DataSourcePersistenceException {
        String string;
        TraceSpan traceSpan;
        String fileUrl;
        String fileName;
        ExcelSource fileSource;
        block5: {
            fileSource = (ExcelSource)runtimeEntity.getSource();
            fileName = fileSource.getFileName();
            fileUrl = fileSource.getFileUrl();
            Integer colIndex = 0;
            ThreadCache.setIndex(colIndex);
            ThreadCache.setRow(new HashMap<String, Object>());
            ThreadCache.setRowWithCalculate(new HashMap<String, Object>());
            traceSpan = null;
            traceSpan = TracerUtil.create((String)(Messages.getMLS((String)"excelDataTable", (String)"Excel\u6570\u636e\u8868[", (Messages.ProjectName)Messages.ProjectName.QING_DATA) + runtimeEntity.getAlias() + Messages.getMLS((String)"getData", (String)"]\u53d6\u6570", (Messages.ProjectName)Messages.ProjectName.QING_DATA)));
            traceSpan.addClassMethodAttribute(this.getClass().getName() + ".extractData");
            traceSpan.addAttribute(Messages.getMLS((String)"tableName", (String)"\u6570\u636e\u8868\u540d", (Messages.ProjectName)Messages.ProjectName.QING_DATA), runtimeEntity.getName());
            traceSpan.addAttribute(Messages.getMLS((String)"tableAlias", (String)"\u6570\u636e\u8868\u522b\u540d", (Messages.ProjectName)Messages.ProjectName.QING_DATA), runtimeEntity.getAlias());
            RuntimeFilterUtil.Prediction prediction = this.initRuntimeFilter(runtimeEntity);
            if (!prediction.isAlwaysFalse()) break block5;
            String string2 = null;
            ThreadCache.removeIndex();
            ThreadCache.removeRow();
            ThreadCache.removeRowWithCalculate();
            TracerUtil.close((TraceSpan)traceSpan);
            return string2;
        }
        try {
            List<String> messages;
            IRuntimeFilter iRuntimeFilter = runtimeEntity.getPushdownableFilter();
            RunningTimeParams params = new RunningTimeParams();
            params.setFileSourceDomain(this);
            params.setRuntimeFilter(iRuntimeFilter);
            params.setRuntimeEntity(runtimeEntity);
            params.setDataSourceWriter(dataSourceWriter);
            params.setSource((AbstractSource)fileSource);
            params.setPreview(false);
            params.setTopN(-2);
            params.setSourceRuntimeEntity(runtimeEntity.getSourceRuntimeEntity());
            ResultContent rc = null;
            AbstractFileModel model = null;
            model = fileName.lastIndexOf(this.XLSX) > 0 ? new Excel07Model(fileUrl, runtimeEntity.getAssociateName()) : new Excel03Model(fileUrl, runtimeEntity.getAssociateName());
            model.setFileSourceDomain(this);
            rc = model.topNRow(params, progressProcessor);
            StringBuilder msg = new StringBuilder();
            if (null != rc && (messages = rc.getMessages()).size() > 0) {
                for (int index = 0; index < messages.size(); ++index) {
                    msg.append(messages.get(index));
                    if (index >= messages.size() - 1) continue;
                    msg.append("\r\n");
                }
            }
            string = StringUtils.isBlank((CharSequence)msg.toString()) ? null : msg.toString();
        }
        catch (Throwable throwable) {
            ThreadCache.removeIndex();
            ThreadCache.removeRow();
            ThreadCache.removeRowWithCalculate();
            TracerUtil.close(traceSpan);
            throw throwable;
        }
        ThreadCache.removeIndex();
        ThreadCache.removeRow();
        ThreadCache.removeRowWithCalculate();
        TracerUtil.close((TraceSpan)traceSpan);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table getTable(String sheetName, RuntimeEntity runtimeEntity, ExcelSource fileSource, QingContext qingContext) throws AbstractSourceException {
        this.checkTableExist(fileSource, sheetName);
        Table table = null;
        String fileName = fileSource.getFileName();
        String fileUrl = fileSource.getFileUrl();
        String sourceName = fileSource.getName();
        FileResult result = new FileResult();
        Integer colIndex = 0;
        ThreadCache.setIndex(colIndex);
        ThreadCache.setRow(new HashMap<String, Object>());
        ThreadCache.setRowWithCalculate(new HashMap<String, Object>());
        AbstractFileModel model = null;
        try {
            model = fileName.lastIndexOf(this.XLSX) > 0 ? new Excel07Model(fileUrl, sheetName, fileSource.getDefineTypeRowCount()) : new Excel03Model(fileUrl, sheetName, fileSource.getDefineTypeRowCount());
            model.setFileSourceDomain(this);
            if (null != result) {
                table = new Table();
                table.setName(sheetName);
                table.setSource(sourceName);
                for (Map.Entry<Integer, String> c : model.getColIndexNameMap().entrySet()) {
                    Field field = new Field();
                    String columnName = c.getValue();
                    field.setName(columnName);
                    String className = model.getColType(c.getKey());
                    field.setClassName(className);
                    field.setDataType(DataTypeUtil.parseDataType((String)className));
                    table.addField(field);
                }
            }
        }
        finally {
            ThreadCache.removeIndex();
            ThreadCache.removeRow();
            ThreadCache.removeRowWithCalculate();
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long doGetDataCount(QingContext qingContext, RuntimeEntity runtimeEntity) throws AbstractSourceException {
        ExcelSource fileSource = (ExcelSource)runtimeEntity.getSource();
        String fileName = fileSource.getFileName();
        String fileUrl = fileSource.getFileUrl();
        RuntimeFilterUtil.Prediction prediction = this.initRuntimeFilter(runtimeEntity);
        if (prediction.isAlwaysFalse()) {
            return 0L;
        }
        IRuntimeFilter iRuntimeFilter = runtimeEntity.getPushdownableFilter();
        Integer colIndex = 0;
        ThreadCache.setIndex(colIndex);
        ThreadCache.setRow(new HashMap<String, Object>());
        ThreadCache.setRowWithCalculate(new HashMap<String, Object>());
        RunningTimeParams params = new RunningTimeParams();
        params.setFileSourceDomain(this);
        params.setRuntimeFilter(iRuntimeFilter);
        params.setRuntimeEntity(runtimeEntity);
        params.setSource((AbstractSource)fileSource);
        int count = 0;
        AbstractFileModel model = null;
        try {
            model = fileName.lastIndexOf(this.XLSX) > 0 ? new Excel07Model(fileUrl, runtimeEntity.getAssociateName()) : new Excel03Model(fileUrl, runtimeEntity.getAssociateName());
            model.setFileSourceDomain(this);
            count = model.getTotalRowCount(params);
        }
        finally {
            ThreadCache.removeIndex();
            ThreadCache.removeRow();
            ThreadCache.removeRowWithCalculate();
        }
        return count;
    }

    private void checkTableExist(ExcelSource fileSource, String sheetName) throws AbstractSourceException {
        String fileName = fileSource.getFileName();
        String fileUrl = fileSource.getFileUrl();
        List<Object> sheets = new ArrayList();
        sheets = fileName.lastIndexOf(this.XLSX) > 0 ? new Excel07Model(fileUrl).getTableNames() : new Excel03Model(fileUrl).getTableNames();
        if (!sheets.contains(sheetName)) {
            throw new FileSourceSheetNotFoundException();
        }
    }
}

