/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler;

import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellInfo;
import com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler.RowContentHandler;
import com.kingdee.bos.qing.data.domain.source.file.model.RunningTimeParams;
import com.kingdee.bos.qing.data.domain.unionsource.EntityExtractContext;
import com.kingdee.bos.qing.util.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class TotalRowCountHandler
extends RowContentHandler {
    public TotalRowCountHandler(RunningTimeParams runningTimeParams, Map<Integer, String> colIndexAndNameMap) {
        super(runningTimeParams, colIndexAndNameMap);
    }

    @Override
    public void handle(int rowNum, List<CellInfo> cellInfos) throws SAXException {
        if (rowNum == 1) {
            return;
        }
        if (this.haveNoFiltersAndColumnToRow()) {
            this.getHandleResult().increaseRowCount();
            return;
        }
        List<Object[]> convertedDataList = this.convertAndFilter(rowNum - 1, cellInfos);
        if (CollectionUtils.isNotEmpty(convertedDataList)) {
            for (Object[] convertedDatas : convertedDataList) {
                if (null == convertedDatas) continue;
                this.getHandleResult().increaseRowCount();
            }
        }
    }

    private boolean haveNoFiltersAndColumnToRow() {
        boolean isNoUnionColumnToRow = true;
        EntityExtractContext entityExtractContext = this.runningTimeParams.getRuntimeEntity().getEntityExtractContext();
        if (entityExtractContext != null && CollectionUtils.isNotEmpty(entityExtractContext.getColumnToRowProperties())) {
            isNoUnionColumnToRow = false;
        }
        return this.runningTimeParams.getRuntimeEntity().getUnPushdownableFilter() == null && this.runningTimeParams.getRuntimeFilter() == null && CollectionUtils.isEmpty(this.runningTimeParams.getRuntimeEntity().getOrinalEntity().getColumnToRowProperties()) && isNoUnionColumnToRow;
    }
}

