/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.parser;

import com.kingdee.bos.qing.data.domain.source.file.domain.AbstractFileSourceDomain;
import com.kingdee.bos.qing.data.domain.source.file.excel07.Excel07SaxReader;
import com.kingdee.bos.qing.data.domain.source.file.excel07.ExcelFastMeta;
import com.kingdee.bos.qing.data.domain.source.file.excel07.ExcelMetaInfoReadAndWriter;
import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.MergeCellRange;
import com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler.ColumnNameRowHandler;
import com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler.ColumnTypeHandler;
import com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler.FullExtractRowContentHandler;
import com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler.PreviewRowContentHandler;
import com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler.RowContentHandler;
import com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler.TotalRowCountHandler;
import com.kingdee.bos.qing.data.domain.source.file.excel07.rowhandler.TotalRowCountHandlerWithNoFilter;
import com.kingdee.bos.qing.data.domain.source.file.model.ResultContent;
import com.kingdee.bos.qing.data.domain.source.file.model.RunningTimeParams;
import com.kingdee.bos.qing.data.domain.unionsource.EntityExtractContext;
import com.kingdee.bos.qing.data.exception.AbstractFileSourceException;
import com.kingdee.bos.qing.data.exception.file.FileSourceFileParseException;
import com.kingdee.bos.qing.data.exception.file.sax.DataSourceExceptionSAXException;
import com.kingdee.bos.qing.data.exception.file.sax.InterruptedSAXException;
import com.kingdee.bos.qing.data.model.designtime.ColumnToRowProperty;
import com.kingdee.bos.qing.data.model.designtime.FilterItem;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class Excel07Parser {
    private static final String STYLES_TABLE = "stylesTable";
    private static final String SHARED_STRINGS_TABLE = "sharedStringsTable";
    private static final String ROW_ELEMENT_FLAG = "<row r=";
    private static final String SHEET_DATA_END_FLAG = "</sheetData>";
    private String filePath;
    private ExcelFastMeta fastMeta;
    private Map<String, String> sheetToSheetFileNameMap = new HashMap<String, String>();

    public Excel07Parser(String filePath) throws AbstractFileSourceException {
        this.filePath = filePath;
        ExcelMetaInfoReadAndWriter metaReader = new ExcelMetaInfoReadAndWriter();
        String fileName = this.filePath.substring(this.filePath.lastIndexOf(File.separator) + 1);
        this.fastMeta = metaReader.readExcelMeta(fileName);
        if (this.fastMeta == null) {
            this.fastMeta = new ExcelFastMeta();
            this.fastMeta.setOriginalExcelFileName(fileName);
            this.initExceBaseMetas();
        }
    }

    private void initExceBaseMetas() throws AbstractFileSourceException {
        this.readTableNames();
        HashMap<String, Long> unSucceedSheetMap = new HashMap<String, Long>();
        do {
            this.readTotalRowCountAndMergeCellInfo(unSucceedSheetMap);
        } while (unSucceedSheetMap.size() > 0);
        this.saveExcelFastMeta();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTotalRowCountAndMergeCellInfo(Map<String, Long> unSucceedSheetMap) {
        long start = System.currentTimeMillis();
        File zipFile = new File(this.filePath);
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                int tempMergeSearchIndex;
                ZipEntry entry = entries.nextElement();
                String zipEntryName = entry.getName();
                String currentSheet = this.findSheetName(zipEntryName);
                if (null == currentSheet) {
                    unSucceedSheetMap.remove(zipEntryName);
                    continue;
                }
                InputStream in = zip.getInputStream(entry);
                long reservedSize = unSucceedSheetMap.containsKey(zipEntryName) ? unSucceedSheetMap.get(zipEntryName) : 0x200000L;
                long availableSize = in.available();
                long skipLength = availableSize > reservedSize ? availableSize - reservedSize : 0L;
                in.skip(skipLength);
                int totalRow = -1;
                ArrayList<MergeCellRange> mergeCellRanges = new ArrayList<MergeCellRange>();
                int sheetDataEndIndex = -1;
                StringBuilder stringBuilder = new StringBuilder();
                byte[] buffer = new byte[1024];
                while (in.read(buffer) != -1) {
                    String stringValue = new String(buffer, "UTF-8");
                    stringBuilder.append(stringValue);
                }
                sheetDataEndIndex = stringBuilder.lastIndexOf(SHEET_DATA_END_FLAG);
                if (sheetDataEndIndex == -1 && skipLength == 0L) {
                    unSucceedSheetMap.remove(zipEntryName);
                    continue;
                }
                if (sheetDataEndIndex <= 0 && skipLength > 0L) {
                    unSucceedSheetMap.put(zipEntryName, reservedSize * 2L);
                    continue;
                }
                int lastRowBeginIndex = stringBuilder.lastIndexOf(ROW_ELEMENT_FLAG, sheetDataEndIndex);
                if (lastRowBeginIndex < 0) {
                    unSucceedSheetMap.put(zipEntryName, reservedSize * 2L);
                    continue;
                }
                int endRowNumberIndex = stringBuilder.indexOf("\"", lastRowBeginIndex + ROW_ELEMENT_FLAG.length() + 1);
                if (endRowNumberIndex > lastRowBeginIndex) {
                    totalRow = Integer.parseInt(stringBuilder.substring(lastRowBeginIndex + 8, endRowNumberIndex));
                }
                int nextMergeSearchIndex = tempMergeSearchIndex = sheetDataEndIndex;
                while ((tempMergeSearchIndex = stringBuilder.indexOf("<mergeCell ref=", nextMergeSearchIndex)) != -1) {
                    int endIndex;
                    nextMergeSearchIndex = tempMergeSearchIndex + 15;
                    if (-1 == tempMergeSearchIndex || (endIndex = stringBuilder.indexOf("\"", tempMergeSearchIndex + 16)) <= tempMergeSearchIndex) continue;
                    String mergeCellInfo = stringBuilder.substring(tempMergeSearchIndex + 16, endIndex);
                    mergeCellRanges.add(MergeCellRange.parse(mergeCellInfo));
                }
                if (totalRow != -1) {
                    this.fastMeta.setTotalCount(currentSheet, totalRow - 1);
                    this.fastMeta.setMergeCellRanges(currentSheet, mergeCellRanges);
                }
                in.close();
                unSucceedSheetMap.remove(zipEntryName);
            }
        }
        catch (Exception e) {
            try {
                unSucceedSheetMap.clear();
                LogUtil.error((String)"init excel total row and merge cell info error,this will not inflect bussiness,but will read whole excel ", (Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{zip});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{zip});
        }
        CloseUtil.close((Closeable[])new Closeable[]{zip});
        long endTime = System.currentTimeMillis();
        LogUtil.info((String)("init total row and merge cel info time:" + (endTime - start)));
    }

    private String findSheetName(String zipEntryName) {
        String currentSheet = null;
        for (String sheetName : this.fastMeta.getSheetNames()) {
            String sheetRawFileName = this.sheetToSheetFileNameMap.get(sheetName);
            if (!zipEntryName.equals(sheetRawFileName)) continue;
            currentSheet = sheetName;
            break;
        }
        return currentSheet;
    }

    public void saveExcelFastMeta() {
        ExcelMetaInfoReadAndWriter writer = new ExcelMetaInfoReadAndWriter();
        if (this.fastMeta.isContentChanged()) {
            String fileName = this.filePath.substring(this.filePath.lastIndexOf(File.separator) + 1);
            writer.writeExcelFastMeta(fileName, this.fastMeta);
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public List<String> getTableNames() throws AbstractFileSourceException {
        if (this.fastMeta.getSheetNames() != null) {
            return this.fastMeta.getSheetNames();
        }
        this.readTableNames();
        return this.fastMeta.getSheetNames();
    }

    private void readTableNames() throws AbstractFileSourceException {
        OPCPackage xlsxPackage = null;
        try {
            xlsxPackage = OPCPackage.open((String)this.filePath, (PackageAccess)PackageAccess.READ);
            XSSFReader xssfReader = new XSSFReader(xlsxPackage);
            XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            ArrayList<String> sheetNames = new ArrayList<String>(10);
            while (iter.hasNext()) {
                iter.next();
                sheetNames.add(iter.getSheetName());
                String sheetOriginalFileName = iter.getSheetPart().getPartName().getName();
                this.sheetToSheetFileNameMap.put(iter.getSheetName(), sheetOriginalFileName.substring(1));
            }
            this.fastMeta.setSheetNames(sheetNames);
        }
        catch (Exception e) {
            try {
                throw new FileSourceFileParseException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{xlsxPackage});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{xlsxPackage});
    }

    public Map<Integer, String> getColumnIndexMap(String sheetName, Map<String, Object> sheetAttributeCache) throws AbstractFileSourceException, DataSourcePersistenceException {
        if (this.fastMeta.getColIndexMap(sheetName) != null) {
            return this.fastMeta.getColIndexMap(sheetName);
        }
        ColumnNameRowHandler columnNameRowHandler = new ColumnNameRowHandler();
        Excel07SaxReader contentSaxHandler = Excel07SaxReader.newRowDatasReader(this.getMergeCell(sheetName, sheetAttributeCache), columnNameRowHandler);
        this.doParseSheet(sheetName, contentSaxHandler, sheetAttributeCache);
        ExcelMetaInfoReadAndWriter writer = new ExcelMetaInfoReadAndWriter();
        String fileName = this.filePath.substring(this.filePath.lastIndexOf(File.separator) + 1);
        ExcelFastMeta updatedMeta = writer.updateColIndex(fileName, sheetName, (Map<Integer, String>)columnNameRowHandler.getHandleResult());
        if (null != updatedMeta) {
            this.fastMeta = updatedMeta;
        }
        return columnNameRowHandler.getHandleResult();
    }

    public List<MergeCellRange> getMergeCell(String sheetName, Map<String, Object> sheetAttributeCache) throws AbstractFileSourceException, DataSourcePersistenceException {
        List<MergeCellRange> mergeCellRanges = this.fastMeta.getMergeCellRanges(sheetName);
        if (mergeCellRanges != null) {
            return mergeCellRanges;
        }
        TotalRowCountHandlerWithNoFilter rowCountHandler = new TotalRowCountHandlerWithNoFilter();
        Excel07SaxReader handler = Excel07SaxReader.newMergeCellReader(rowCountHandler);
        this.doParseSheet(sheetName, handler, sheetAttributeCache);
        ExcelMetaInfoReadAndWriter writer = new ExcelMetaInfoReadAndWriter();
        String fileName = this.filePath.substring(this.filePath.lastIndexOf(File.separator) + 1);
        int totalCount = rowCountHandler.getHandleResult().getTotalRowCount();
        List<MergeCellRange> mergeCellRangeList = handler.getContext().getUnrepeatedMergeCells();
        ExcelFastMeta updatedMeta = writer.updateMergeRangeAndTotalCounts(fileName, sheetName, totalCount, mergeCellRangeList);
        if (null != updatedMeta) {
            this.fastMeta = updatedMeta;
        }
        return mergeCellRangeList;
    }

    public ResultContent topNRow(String sheetName, RunningTimeParams params, ProgressProcessor progressProcessor) throws AbstractFileSourceException, DataSourcePersistenceException {
        boolean isPreview = params.isPreview();
        RowContentHandler rowDataHandler = null;
        HashMap<String, Object> sheetAttributeCache = new HashMap<String, Object>();
        rowDataHandler = isPreview ? new PreviewRowContentHandler(params, this.getColumnIndexMap(sheetName, sheetAttributeCache)) : new FullExtractRowContentHandler(params, progressProcessor, this.getColumnIndexMap(sheetName, sheetAttributeCache));
        Excel07SaxReader contentSaxHandler = Excel07SaxReader.newRowDatasReader(this.getMergeCell(sheetName, sheetAttributeCache), rowDataHandler);
        this.doParseSheet(sheetName, contentSaxHandler, sheetAttributeCache);
        return rowDataHandler.getHandleResult();
    }

    public Map<Integer, String> getColumeTypeMap(String sheetName, int limitRowCount) throws AbstractFileSourceException, DataSourcePersistenceException {
        if (this.fastMeta.getColTypes(sheetName) != null) {
            return this.fastMeta.getColTypes(sheetName);
        }
        HashMap<String, Object> sheetAttributeCache = new HashMap<String, Object>();
        Map<Integer, String> colIndexMap = this.getColumnIndexMap(sheetName, sheetAttributeCache);
        ColumnTypeHandler columnTypeHandler = new ColumnTypeHandler(colIndexMap, limitRowCount);
        Excel07SaxReader contentSaxHandler = Excel07SaxReader.newRowDatasReader(this.getMergeCell(sheetName, sheetAttributeCache), columnTypeHandler);
        this.doParseSheet(sheetName, contentSaxHandler, sheetAttributeCache);
        HashMap<Integer, String> colTypes = new HashMap<Integer, String>(colIndexMap.size());
        for (Map.Entry<Integer, String> entry : colIndexMap.entrySet()) {
            Set types = (Set)columnTypeHandler.getHandleResult().get(entry.getValue());
            String finalType = AbstractFileSourceDomain.caculateColumnType(types);
            colTypes.put(entry.getKey(), finalType);
        }
        ExcelMetaInfoReadAndWriter writer = new ExcelMetaInfoReadAndWriter();
        String fileName = this.filePath.substring(this.filePath.lastIndexOf(File.separator) + 1);
        ExcelFastMeta updatedMeta = writer.updateColTypes(fileName, sheetName, colTypes);
        if (null != updatedMeta) {
            this.fastMeta = updatedMeta;
        }
        return colTypes;
    }

    /*
     * WARNING - void declaration
     */
    public int getTotalRowCount(String sheetName, RunningTimeParams params) throws AbstractFileSourceException, DataSourcePersistenceException {
        void var7_12;
        List<ColumnToRowProperty> list;
        String originalFilterMd5 = this.fastMeta.getFilterMd5(sheetName);
        List<FilterItem> filterItems = params.getRuntimeEntity().getFilters();
        StringBuilder sb = new StringBuilder();
        for (FilterItem filterItem : filterItems) {
            sb.append(filterItem);
        }
        List<ColumnToRowProperty> columnToRowProperties = params.getRuntimeEntity().getOrinalEntity().getColumnToRowProperties();
        if (CollectionUtils.isNotEmpty(columnToRowProperties)) {
            for (ColumnToRowProperty columnToRowProperty : columnToRowProperties) {
                sb.append(columnToRowProperty);
            }
        }
        Object var7_10 = null;
        EntityExtractContext entityExtractContext = params.getRuntimeEntity().getEntityExtractContext();
        if (entityExtractContext != null && (list = entityExtractContext.getColumnToRowProperties()) != null) {
            for (ColumnToRowProperty columnToRowProperty : list) {
                sb.append(columnToRowProperty);
            }
        }
        String md5 = DigestUtils.md5Hex((String)sb.toString());
        if (originalFilterMd5 != null && md5.equals(originalFilterMd5)) {
            return this.fastMeta.getTotalCount(sheetName);
        }
        if (null == originalFilterMd5 && filterItems.isEmpty() && CollectionUtils.isEmpty(columnToRowProperties) && CollectionUtils.isEmpty((Collection)var7_12) && this.fastMeta.getTotalCount(sheetName) > 0) {
            return this.fastMeta.getTotalCount(sheetName);
        }
        HashMap<String, Object> sheetAttributeCache = new HashMap<String, Object>();
        TotalRowCountHandler rowCountHandler = new TotalRowCountHandler(params, this.getColumnIndexMap(sheetName, sheetAttributeCache));
        Excel07SaxReader contentSaxHandler = Excel07SaxReader.newRowDatasReader(this.getMergeCell(sheetName, sheetAttributeCache), rowCountHandler);
        this.doParseSheet(sheetName, contentSaxHandler, sheetAttributeCache);
        int totalCount = rowCountHandler.getHandleResult().getTotalRowCount();
        ExcelMetaInfoReadAndWriter writer = new ExcelMetaInfoReadAndWriter();
        String fileName = this.filePath.substring(this.filePath.lastIndexOf(File.separator) + 1);
        ExcelFastMeta updatedMeta = writer.updateTotalRowCountAndMd5(fileName, sheetName, totalCount, md5);
        if (null != updatedMeta) {
            this.fastMeta = updatedMeta;
        }
        return totalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doParseSheet(String sheetName, Excel07SaxReader contentSaxHandler, Map<String, Object> sheetAttributeCache) throws AbstractFileSourceException, DataSourcePersistenceException {
        InputStream sheetInputStream = null;
        OPCPackage xlsxPackage = null;
        try {
            StylesTable stylesTable;
            SharedStringsTable sharedStringsTable;
            xlsxPackage = OPCPackage.open((String)this.filePath, (PackageAccess)PackageAccess.READ);
            XSSFReader xssfReader = new XSSFReader(xlsxPackage);
            if (sheetAttributeCache == null) {
                sheetAttributeCache = new HashMap<String, Object>();
            }
            if (sheetAttributeCache.get(SHARED_STRINGS_TABLE) != null) {
                sharedStringsTable = (SharedStringsTable)sheetAttributeCache.get(SHARED_STRINGS_TABLE);
            } else {
                sharedStringsTable = xssfReader.getSharedStringsTable();
                sheetAttributeCache.put(SHARED_STRINGS_TABLE, sharedStringsTable);
            }
            if (sheetAttributeCache.get(STYLES_TABLE) != null) {
                stylesTable = (StylesTable)sheetAttributeCache.get(STYLES_TABLE);
            } else {
                stylesTable = xssfReader.getStylesTable();
                sheetAttributeCache.put(STYLES_TABLE, stylesTable);
            }
            contentSaxHandler.getContext().setSharedStringsTable(sharedStringsTable);
            contentSaxHandler.getContext().setStylesTable(stylesTable);
            sheetInputStream = this.getSheetInputStream(sheetName, xssfReader);
            InputSource sheetSource = new InputSource(sheetInputStream);
            XMLReader sheetParser = XMLHelper.newXMLReader();
            sheetParser.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            sheetParser.setContentHandler(contentSaxHandler);
            sheetParser.parse(sheetSource);
        }
        catch (Exception e) {
            try {
                this.handleException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{sheetInputStream, xlsxPackage});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{sheetInputStream, xlsxPackage});
        }
        CloseUtil.close((Closeable[])new Closeable[]{sheetInputStream, xlsxPackage});
    }

    private InputStream getSheetInputStream(String sheetName, XSSFReader xssfReader) throws IOException, InvalidFormatException {
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        while (iter.hasNext()) {
            InputStream inputream = iter.next();
            if (!iter.getSheetName().equals(sheetName)) continue;
            return inputream;
        }
        return null;
    }

    private void handleException(Exception ex) throws AbstractFileSourceException, DataSourcePersistenceException {
        if (ex instanceof AbstractFileSourceException) {
            throw (AbstractFileSourceException)((Object)ex);
        }
        if (ex instanceof InterruptedSAXException) {
            if (LogUtil.isDebugEnabled()) {
                LogUtil.error((String)ex.getMessage(), (Throwable)ex);
            }
        } else {
            if (ex instanceof DataSourceExceptionSAXException) {
                throw ((DataSourceExceptionSAXException)ex).getCause();
            }
            throw new FileSourceFileParseException(ex);
        }
    }
}

