/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.mdd;

public class Member {
    private final String parentUniqueName;
    private final String uniqueName;
    private final Type type;
    private final String name;
    private int ordinal;

    public Member(String uniqueName, String name, String parentUniqueName, Type type, int ordinal) {
        this.uniqueName = uniqueName;
        this.name = name;
        this.parentUniqueName = parentUniqueName;
        this.type = type;
        this.ordinal = ordinal;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.name;
    }

    public String getParentUniqueName() {
        return this.parentUniqueName;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isAll() {
        return this.type == Type.ALL;
    }

    public boolean isCalculated() {
        return this.type == Type.FORMULA;
    }

    public static enum TreeOp {
        CHILDREN(1, "Tree operation which returns only the immediate children."),
        SIBLINGS(2, "Tree operation which returns members on the same level."),
        PARENT(4, "Tree operation which returns only the immediate parent."),
        SELF(8, "Tree operation which returns itself in the list of returned rows."),
        DESCENDANTS(16, "Tree operation which returns all of the descendants."),
        ANCESTORS(32, "Tree operation which returns all of the ancestors.");

        private final int xmlaOrdinal;
        private String description;

        private TreeOp(int xmlaOrdinal, String description) {
            this.xmlaOrdinal = xmlaOrdinal;
            this.description = description;
        }

        public String xmlaName() {
            return "MDTREEOP_" + this.name();
        }

        public String getDescription() {
            return this.description;
        }

        public int xmlaOrdinal() {
            return this.xmlaOrdinal;
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type UNKNOWN = new Type(0);
        public static final /* enum */ Type REGULAR = new Type(1);
        public static final /* enum */ Type ALL = new Type(2);
        public static final /* enum */ Type MEASURE = new Type(3);
        public static final /* enum */ Type FORMULA = new Type(4);
        public static final /* enum */ Type NULL = new Type(5);
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int ordinal) {
            assert (ordinal == this.ordinal());
        }

        static {
            $VALUES = new Type[]{UNKNOWN, REGULAR, ALL, MEASURE, FORMULA, NULL};
        }
    }
}

