/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.model.runtime.process;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.exception.AbstractMacroException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.exception.db.DBCenterNoPermissionException;
import com.kingdee.bos.qing.data.exception.db.DBCenterOwnerNoPermissionException;
import com.kingdee.bos.qing.data.exception.db.DBKSQLExcuseException;
import com.kingdee.bos.qing.data.exception.db.DBKSQLNotSupportException;
import com.kingdee.bos.qing.data.exception.db.DBSPExecuteException;
import com.kingdee.bos.qing.data.exception.db.DBSPNotFoundResultSetException;
import com.kingdee.bos.qing.data.exception.db.DBSPNotSupportException;
import com.kingdee.bos.qing.data.exception.db.DBSQLExcuseException;
import com.kingdee.bos.qing.data.exception.entity.EntityNotSupportQingAnalysisException;
import com.kingdee.bos.qing.data.exception.entity.NoEntityPermissionException;
import com.kingdee.bos.qing.data.exception.macro.MacroDBUnsetException;
import com.kingdee.bos.qing.data.exception.macro.MacroNotFoundException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorInfo;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorState;
import com.kingdee.bos.qing.data.model.runtime.process.BoxFixScene;
import com.kingdee.bos.qing.data.model.runtime.process.EntityFixProcessable;
import com.kingdee.bos.qing.data.model.runtime.process.FixAbstractEntityProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixDuplicateAliasProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixEntityColumnToRowProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixEntityExtensionProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixEntityPkFilterProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixEntityWithLiveRuntimeProcess;
import com.kingdee.bos.qing.data.model.runtime.process.FixHistoryErrorProcesss;
import com.kingdee.bos.qing.data.model.runtime.process.FixIllegalEntityRuntimeProcess;
import com.kingdee.bos.qing.data.model.runtime.process.IParentEntityFilterProcessor;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.util.DesignTimeDataObjectUtil;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.Map;

public class FixEntityProcess
implements EntityFixProcessable<Entity> {
    private QingContext qingContext;
    private FixHistoryErrorProcesss historyErrorProcesss;
    private FixIllegalEntityRuntimeProcess fixIllegalEntityRuntimeProcess;
    private FixEntityWithLiveRuntimeProcess fixEntityWithLiveRuntimeProcess;
    private FixEntityExtensionProcess extensionProcess;
    private FixEntityColumnToRowProcess columnToRowProcess;
    private FixEntityPkFilterProcess pkFilterProcess;
    private FixDuplicateAliasProcess duplicateAliasProcess;
    private BoxFixScene fixScene;

    public FixEntityProcess(QingContext qingContext, Box box, BoxFixScene scene) {
        this.qingContext = qingContext;
        this.historyErrorProcesss = new FixHistoryErrorProcesss(box, scene);
        this.fixIllegalEntityRuntimeProcess = new FixIllegalEntityRuntimeProcess(scene);
        this.fixEntityWithLiveRuntimeProcess = new FixEntityWithLiveRuntimeProcess(scene);
        this.extensionProcess = new FixEntityExtensionProcess(scene);
        this.columnToRowProcess = new FixEntityColumnToRowProcess(scene);
        this.pkFilterProcess = new FixEntityPkFilterProcess(scene);
        this.duplicateAliasProcess = new FixDuplicateAliasProcess();
        this.fixScene = scene;
    }

    @Override
    public boolean process(FixAbstractEntityProcess abstractEntityProcess, Entity dmEntity, Map<String, AbstractSource> sourcesMap, Map<String, DesigntimeDataObject> designtimeDataObjectMap, Map<String, AbstractEntity> entitysMap, Map<String, Boolean> hasFixEntity) {
        if (dmEntity == null) {
            return true;
        }
        String entityName = dmEntity.getName();
        if (hasFixEntity.containsKey(entityName)) {
            return hasFixEntity.get(entityName);
        }
        AbstractSource source = sourcesMap.get(dmEntity.getSource());
        AbstractDataSourceDomain sourceDomain = null;
        try {
            sourceDomain = SourceDomainFactory.getSourceDomain(source);
        }
        catch (UnSupportDataSourceException e) {
            LogUtil.error((String)"fixSoruce\u5df2\u7ecf\u9a8c\u8bc1\u8fc7\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90,\u68c0\u67e5\u65b9\u6cd5\u8c03\u7528\u987a\u5e8f", (Throwable)e);
            return true;
        }
        this.historyErrorProcesss.process(this.qingContext, sourceDomain, dmEntity, source);
        String topEntityAssociateName = null;
        String parentEntityName = null;
        AbstractEntity parentEntity = dmEntity;
        while (parentEntity != null) {
            topEntityAssociateName = parentEntity.getAssociateName();
            parentEntityName = parentEntity.getParentName();
            if (parentEntityName != null) {
                parentEntity = entitysMap.get(parentEntityName);
                if (parentEntity == null) {
                    return true;
                }
                boolean isDeleteEntrty = abstractEntityProcess.process(parentEntity, sourcesMap, designtimeDataObjectMap, entitysMap, hasFixEntity);
                if (!isDeleteEntrty) continue;
                return true;
            }
            parentEntity = null;
        }
        sourceDomain.initEntityTitle(this.qingContext, dmEntity, source);
        this.checkDBCenterPermission(dmEntity, sourceDomain);
        this.checkEntityPermission(dmEntity, sourceDomain, source);
        if (!sourceDomain.canEntityChangeOnline()) {
            this.columnToRowProcess.process(dmEntity);
            return false;
        }
        this.historyErrorProcesss.proccess(this.qingContext, sourceDomain, dmEntity, designtimeDataObjectMap);
        DesigntimeDataObject designtimeDataObject = null;
        Entity liveEntity = null;
        if (sourceDomain.canEntityChangeOnline()) {
            try {
                designtimeDataObject = this.getDesigntimeDataObject(designtimeDataObjectMap, topEntityAssociateName, source, sourceDomain);
                if (designtimeDataObject != null && (liveEntity = designtimeDataObject.getEntityByAssosiateName(dmEntity.getAssociateName())) != null) {
                    if (CollectionUtils.isNotEmpty(dmEntity.getColumnToRowProperties())) {
                        liveEntity.setColumnToRowProperties(dmEntity.getColumnToRowProperties());
                        this.columnToRowProcess.process(liveEntity);
                    } else {
                        this.columnToRowProcess.reFixColumnToRowProperty(liveEntity);
                        liveEntity.setColumnToRowProperties(dmEntity.getColumnToRowProperties());
                    }
                }
            }
            catch (AbstractMacroException e) {
                this.setEntityMacroErrorState(e, dmEntity);
            }
            catch (DBKSQLNotSupportException e) {
                dmEntity.setErrorInfo(new EntityErrorInfo(EntityErrorState.KSQL_NOT_SUPPORT));
            }
            catch (DBSPNotSupportException e) {
                dmEntity.setErrorInfo(new EntityErrorInfo(EntityErrorState.STORED_PROCEDURE_NOT_SUPPORT));
            }
            catch (DBSQLExcuseException e) {
                dmEntity.setErrorInfo(new EntityErrorInfo(EntityErrorState.SQL_EXECUTE_EXCEPTION));
            }
            catch (DBKSQLExcuseException e) {
                dmEntity.setErrorInfo(new EntityErrorInfo(EntityErrorState.KSQL_EXECUTE_EXCEPTION));
            }
            catch (DBSPExecuteException e) {
                dmEntity.setErrorInfo(new EntityErrorInfo(EntityErrorState.SP_EXECUTE_EXCEPTION));
            }
            catch (DBSPNotFoundResultSetException e) {
                dmEntity.setErrorInfo(new EntityErrorInfo(EntityErrorState.SP_EXECUTE_EXCEPTION));
            }
        }
        this.columnToRowProcess.process(dmEntity);
        if (this.fixIllegalEntityRuntimeProcess.process(this.qingContext, sourceDomain, dmEntity, liveEntity)) {
            return true;
        }
        if (this.fixEntityWithLiveRuntimeProcess.process(sourceDomain, dmEntity, liveEntity)) {
            return true;
        }
        this.extensionProcess.process(this.qingContext, sourceDomain, source, dmEntity, entitysMap, designtimeDataObject);
        this.pkFilterProcess.process(dmEntity, sourceDomain);
        IParentEntityFilterProcessor parentEntityFilterProcessor = sourceDomain.createParentFilterProcessor();
        parentEntityFilterProcessor.fixFilterItemWithParentFilter(this.fixScene, dmEntity, entitysMap);
        this.duplicateAliasProcess.process(dmEntity);
        return false;
    }

    private void setEntityMacroErrorState(AbstractMacroException e, Entity dmEntity) {
        if (e instanceof MacroDBUnsetException) {
            EntityErrorInfo dbUnsetErrInfo = new EntityErrorInfo(EntityErrorState.MACROERROR_DBUNSET);
            String dbUnsetDesc = EntityErrorState.MACROERROR_DBUNSET.getI18n(this.qingContext);
            dbUnsetErrInfo.setErrorDesc(dbUnsetDesc.replace("#1", e.getMessage()));
            dbUnsetErrInfo.addCustomInfo("MacroName", e.getMessage());
            dmEntity.setErrorInfo(dbUnsetErrInfo);
        } else if (e instanceof MacroNotFoundException) {
            EntityErrorInfo macroNotFoundErrInfo = new EntityErrorInfo(EntityErrorState.MACROERROR_NOTFOUND);
            String notFoundDesc = EntityErrorState.MACROERROR_NOTFOUND.getI18n(this.qingContext);
            macroNotFoundErrInfo.setErrorDesc(notFoundDesc.replace("#1", e.getMessage()));
            macroNotFoundErrInfo.addCustomInfo("MacroId", e.getMessage());
            dmEntity.setErrorInfo(macroNotFoundErrInfo);
        }
    }

    private void checkDBCenterPermission(Entity entity, AbstractDataSourceDomain sourceDomain) {
        try {
            sourceDomain.checkDBCenterPermission(this.qingContext, entity);
        }
        catch (DBCenterNoPermissionException e) {
            this.setEntityErrorInfo(EntityErrorState.NO_DBCENTER_PERMISSION, entity);
        }
        catch (DBCenterOwnerNoPermissionException e) {
            this.setEntityErrorInfo(EntityErrorState.NO_DBCENTER_PERMISSION, entity);
        }
    }

    private void setEntityErrorInfo(EntityErrorState errorState, Entity entity) {
        EntityErrorInfo entityErrorInfo = new EntityErrorInfo(EntityErrorState.NO_DBCENTER_PERMISSION);
        String msg = EntityErrorState.NO_DBCENTER_PERMISSION.getI18n(this.qingContext);
        entityErrorInfo.setErrorDesc(msg);
        entityErrorInfo.setEntityName(entity.getName());
        entity.setErrorInfo(entityErrorInfo);
    }

    private void checkEntityPermission(Entity dmEntity, AbstractDataSourceDomain sourceDomain, AbstractSource source) {
        try {
            sourceDomain.checkEntityPermission(this.qingContext, dmEntity);
            sourceDomain.checkEntityPermission(this.qingContext, dmEntity, source);
            sourceDomain.checkSupportQingAnalysis(this.qingContext, dmEntity);
        }
        catch (NoEntityPermissionException e) {
            EntityErrorInfo errorInfo = new EntityErrorInfo(EntityErrorState.NOTEXISTUSERAUTHORITY);
            errorInfo.setErrorDesc(e.getMessage());
            dmEntity.setErrorInfo(errorInfo);
        }
        catch (EntityNotSupportQingAnalysisException e) {
            EntityErrorInfo errorInfo = new EntityErrorInfo(EntityErrorState.BIZMETANOTSUPPORT);
            errorInfo.setErrorDesc(e.getMessage());
            dmEntity.setErrorInfo(errorInfo);
        }
    }

    private DesigntimeDataObject getDesigntimeDataObject(Map<String, DesigntimeDataObject> designtimeDataObjectMap, String topEntityAssociateName, AbstractSource source, AbstractDataSourceDomain sourceDomain) throws AbstractMacroException, DBKSQLNotSupportException, DBSPNotSupportException, DBSQLExcuseException, DBSPExecuteException, DBKSQLExcuseException, DBSPNotFoundResultSetException {
        String designtimeDataObjectCacheKey = source.getName() + topEntityAssociateName;
        DesigntimeDataObject designtimeDataObject = designtimeDataObjectMap.get(designtimeDataObjectCacheKey);
        if (designtimeDataObject == null && null != (designtimeDataObject = DesignTimeDataObjectUtil.loadAndCache(this.qingContext, topEntityAssociateName, source, sourceDomain, this.fixScene))) {
            designtimeDataObjectMap.put(designtimeDataObjectCacheKey, designtimeDataObject);
        }
        return designtimeDataObject;
    }
}

