/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.util;

import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.util.DataTypeUtils;
import com.kingdee.bos.qing.datasource.meta.DataType;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class OutputDataTypeUtils {
    private static Map<DataType, IOutputDataTypeHandler> outputDataTypeHandlerMap = new HashMap<DataType, IOutputDataTypeHandler>();
    private static Map<DesigningDataType, IOutputDataTypeHandler> outputDesigningDataTypeHandlerMap = new HashMap<DesigningDataType, IOutputDataTypeHandler>();

    public static Object handle(DataType dataType, Object value) {
        IOutputDataTypeHandler outputDataTypeHandler = outputDataTypeHandlerMap.get(dataType);
        return outputDataTypeHandler.handle(value);
    }

    public static Object handle(DesigningDataType dataType, Object value) {
        IOutputDataTypeHandler outputDataTypeHandler = outputDesigningDataTypeHandlerMap.get((Object)dataType);
        return outputDataTypeHandler.handle(value);
    }

    static {
        StringOutputDataTypeHandler stringOutputDataTypeHandler = new StringOutputDataTypeHandler();
        BooleanOuputDataTypeHandler booleanOuputDataTypeHandler = new BooleanOuputDataTypeHandler();
        DateTimeOutputDataTypeHandler dateTimeOutputDataTypeHandler = new DateTimeOutputDataTypeHandler();
        DateOutputDataTypeHandler dateOutputDataTypeHandler = new DateOutputDataTypeHandler(dateTimeOutputDataTypeHandler);
        NumberOutputDataTypeHandler numberOutputDataTypeHandler = new NumberOutputDataTypeHandler();
        outputDataTypeHandlerMap.put(DataType.STRING, stringOutputDataTypeHandler);
        outputDataTypeHandlerMap.put(DataType.BOOLEAN, booleanOuputDataTypeHandler);
        outputDataTypeHandlerMap.put(DataType.DATETIME, dateTimeOutputDataTypeHandler);
        outputDataTypeHandlerMap.put(DataType.DATE, dateOutputDataTypeHandler);
        outputDataTypeHandlerMap.put(DataType.INT, numberOutputDataTypeHandler);
        outputDataTypeHandlerMap.put(DataType.NUMBER, numberOutputDataTypeHandler);
        outputDesigningDataTypeHandlerMap.put(DesigningDataType.STRING, stringOutputDataTypeHandler);
        outputDesigningDataTypeHandlerMap.put(DesigningDataType.BOOLEAN, booleanOuputDataTypeHandler);
        outputDesigningDataTypeHandlerMap.put(DesigningDataType.DATETIME, dateTimeOutputDataTypeHandler);
        outputDesigningDataTypeHandlerMap.put(DesigningDataType.DATE, dateOutputDataTypeHandler);
        outputDesigningDataTypeHandlerMap.put(DesigningDataType.INT, numberOutputDataTypeHandler);
        outputDesigningDataTypeHandlerMap.put(DesigningDataType.NUMBER, numberOutputDataTypeHandler);
    }

    static class BooleanOuputDataTypeHandler
    implements IOutputDataTypeHandler {
        BooleanOuputDataTypeHandler() {
        }

        @Override
        public Object handle(Object value) {
            if (null == value) {
                return null;
            }
            if (value instanceof String) {
                return Boolean.valueOf(String.valueOf(value));
            }
            if (value instanceof Boolean) {
                return value;
            }
            return null;
        }
    }

    static class StringOutputDataTypeHandler
    implements IOutputDataTypeHandler {
        StringOutputDataTypeHandler() {
        }

        @Override
        public String handle(Object value) {
            if (value == null) {
                return "";
            }
            if (!(value instanceof String)) {
                return value.toString();
            }
            return (String)value;
        }
    }

    static class NumberOutputDataTypeHandler
    implements IOutputDataTypeHandler {
        NumberOutputDataTypeHandler() {
        }

        @Override
        public BigDecimal handle(Object value) {
            if (value == null) {
                return null;
            }
            try {
                if (!(value instanceof BigDecimal)) {
                    if (value instanceof Number) {
                        return new BigDecimal(value.toString());
                    }
                    if (value instanceof String) {
                        String stringValue = (String)value;
                        if (DataTypeUtils.isNumeric(stringValue) || DataTypeUtils.isInteger(stringValue)) {
                            return new BigDecimal(stringValue);
                        }
                        return null;
                    }
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
            return (BigDecimal)value;
        }
    }

    static class DateTimeOutputDataTypeHandler
    implements IOutputDataTypeHandler {
        DateTimeOutputDataTypeHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Calendar handle(Object value) {
            if (value == null) {
                return null;
            }
            Calendar calendar = null;
            if (value instanceof Calendar) return (Calendar)value;
            if (!(value instanceof Date)) return null;
            Date date = (Date)value;
            calendar = Calendar.getInstance();
            calendar.setTimeInMillis(date.getTime());
            return calendar;
        }
    }

    static class DateOutputDataTypeHandler
    implements IOutputDataTypeHandler {
        private DateTimeOutputDataTypeHandler dateTimeOutputDataTypeHandler;

        DateOutputDataTypeHandler(DateTimeOutputDataTypeHandler dateTimeOutputDataTypeHandler) {
            this.dateTimeOutputDataTypeHandler = dateTimeOutputDataTypeHandler;
        }

        @Override
        public Calendar handle(Object value) {
            Calendar calendar = this.dateTimeOutputDataTypeHandler.handle(value);
            if (calendar == null) {
                return calendar;
            }
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar;
        }
    }

    static interface IOutputDataTypeHandler {
        public Object handle(Object var1);
    }
}

