/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.server;

import com.kingdee.bos.ctrl.semantic.design.exception.NotExistException;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.design.server.SchemaDesigntimeState;
import com.kingdee.bos.ctrl.semantic.manage.server.ShareSchemasAccess;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class DesigntimeManager {
    private static DesigntimeManager INST = new DesigntimeManager();
    private int CHECK_PERIOD = 600000;
    private int INACTIVE_LIMIT = 0x6DDD00;
    private Map _schemas = new HashMap();
    private Timer _timer;

    public static DesigntimeManager getInst() {
        return INST;
    }

    public synchronized SchemaDesigntimeState getState(String schemaId) throws SemanticDesignException {
        this.initTimer();
        SchemaDesigntimeState state = (SchemaDesigntimeState)this._schemas.get(schemaId);
        if (state == null) {
            String outDbName;
            try {
                if (!ShareSchemasAccess.checkIdExist(schemaId)) {
                    throw new NotExistException("Schema is deleted.");
                }
                outDbName = ShareSchemasAccess.getUsedOutsideDsName(schemaId);
            }
            catch (SQLException ex) {
                throw SemanticDesignException.wrap(ex);
            }
            state = new SchemaDesigntimeState(schemaId, outDbName);
            this._schemas.put(schemaId, state);
        }
        return state;
    }

    public synchronized void removeState(String schemaId) {
        SchemaDesigntimeState state = (SchemaDesigntimeState)this._schemas.remove(schemaId);
        if (state != null) {
            state.clearCache();
        }
    }

    public synchronized SchemaDesigntimeState[] getAllState() {
        return this._schemas.values().toArray(new SchemaDesigntimeState[0]);
    }

    public void setAutoKickerPerference(int[] p) {
        this.CHECK_PERIOD = p[0];
        this.INACTIVE_LIMIT = p[1];
        if (this.CHECK_PERIOD < 30000) {
            this.CHECK_PERIOD = 30000;
        }
        this.invalidateTimer();
        this.initTimer();
    }

    public int[] getAutoKickerPerference() {
        return new int[]{this.CHECK_PERIOD, this.INACTIVE_LIMIT};
    }

    private void initTimer() {
        if (this._timer == null) {
            this._timer = new Timer();
            this._timer.schedule((TimerTask)new Task(), this.CHECK_PERIOD, (long)this.CHECK_PERIOD);
        }
    }

    private void invalidateTimer() {
        if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
        }
    }

    private class Task
    extends TimerTask {
        private Task() {
        }

        @Override
        public void run() {
            boolean isAnyAlive = false;
            Iterator it = DesigntimeManager.this._schemas.values().iterator();
            while (it.hasNext()) {
                SchemaDesigntimeState state = (SchemaDesigntimeState)it.next();
                if (state.autoKickIdler(DesigntimeManager.this.INACTIVE_LIMIT)) {
                    state.clearCache();
                    it.remove();
                    continue;
                }
                isAnyAlive = true;
            }
            if (!isAnyAlive) {
                DesigntimeManager.this.invalidateTimer();
            }
        }
    }
}

