/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.manage.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.design.server.DesigntimeManager;
import com.kingdee.bos.ctrl.semantic.design.server.SchemaDesigntimeState;
import com.kingdee.bos.ctrl.semantic.manage.exception.LockedException;
import com.kingdee.bos.ctrl.semantic.manage.exception.NameExistException;
import com.kingdee.bos.ctrl.semantic.manage.exception.NotExistException;
import com.kingdee.bos.ctrl.semantic.manage.exception.SemanticManageException;
import com.kingdee.bos.ctrl.semantic.manage.server.ShareSchemasAccess;
import com.kingdee.bos.ctrl.semantic.model.trans.SchemaBriefModel;
import com.kingdee.eas.rpts.ctrlreport.bo.ExtReportOutDBBO;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;

class SchemasAccess
extends ShareSchemasAccess {
    SchemasAccess() {
    }

    static SchemaBriefModel createSchema(SchemaBriefModel params) throws SemanticManageException {
        String user;
        String datasource;
        Integer dsType;
        String name = params.getName();
        if (SchemasAccess.isNameExist(name, null)) {
            throw new NameExistException(name + " exist.");
        }
        Context ctx = ServerUtil.getContext();
        String uid = UID.create16();
        String currentDate = ServerUtil.getCurrentDate();
        Timestamp ts = Timestamp.valueOf(currentDate);
        String userId = ctx.getCaller().toString();
        if (params.isCurrentDs()) {
            dsType = new Integer(1);
            datasource = "";
        } else {
            dsType = new Integer(0);
            datasource = params.getOutsideDb();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_EXT_SemanticSchema (");
        sql.append("FID, FName, FDsType, FDatasource,");
        sql.append("FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime");
        sql.append(") values (");
        sql.append("?, ?, ?, ?, ?, ?, ?, ?");
        sql.append(")");
        try {
            DbUtil.executeUpdate(sql.toString(), new Object[]{uid, name, dsType, datasource, userId, ts, userId, ts});
        }
        catch (SQLException ex) {
            throw SemanticManageException.wrap(ex);
        }
        try {
            user = SchemasAccess.getUserText(userId);
        }
        catch (SQLException ex) {
            throw SemanticManageException.wrap(ex);
        }
        params.setId(uid);
        params.setCreator(user);
        params.setCreateTime(currentDate);
        params.setUpdator(user);
        params.setUpdateTime(currentDate);
        try {
            DesigntimeManager.getInst().getState(uid).registerEdit(ctx.getUserName());
        }
        catch (SemanticDesignException ex) {
            throw SemanticManageException.wrap(ex);
        }
        return params;
    }

    static void deleteSchema(SchemaBriefModel params) throws SemanticManageException {
        SchemasAccess.deleteSchema(params, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteSchema(SchemaBriefModel params, boolean isOnlyContent) throws SemanticManageException {
        SchemaDesigntimeState state;
        String schemaId = params.getId();
        if (!SchemasAccess.isIdExist(schemaId)) {
            throw new NotExistException("Not exist: " + schemaId);
        }
        try {
            state = DesigntimeManager.getInst().getState(schemaId);
        }
        catch (SemanticDesignException ex) {
            throw SemanticManageException.wrap(ex);
        }
        SchemaDesigntimeState schemaDesigntimeState = state;
        synchronized (schemaDesigntimeState) {
            if (state.isBusy()) {
                throw new LockedException(params.getName() + " is Editing.");
            }
            StringBuffer sqlDel1 = new StringBuffer();
            sqlDel1.append("delete from T_EXT_SemanticRelation");
            sqlDel1.append(" where FClientEntityID in");
            sqlDel1.append("(select TR.FClientEntityID");
            sqlDel1.append(" from T_EXT_SemanticEntity as TE join T_EXT_SemanticRelation as TR");
            sqlDel1.append(" on TE.FID = TR.FClientEntityID");
            sqlDel1.append(" where TE.FSchemaId=?)");
            String sqlDel2 = "delete from T_EXT_SemanticEntity where FSchemaID=?";
            String sqlDel3 = "delete from T_EXT_SemanticSchema where FID=?";
            Connection conn = null;
            try {
                conn = DbUtil.getConnection();
                conn.setAutoCommit(false);
                Object[] paramSchemaId = new Object[]{schemaId};
                DbUtil.executeUpdate(conn, sqlDel1.toString(), paramSchemaId);
                DbUtil.executeUpdate(conn, sqlDel2, paramSchemaId);
                if (!isOnlyContent) {
                    DbUtil.executeUpdate(conn, sqlDel3, paramSchemaId);
                }
                conn.commit();
            }
            catch (SQLException ex) {
                throw SemanticManageException.wrap(ex);
            }
            finally {
                DbUtil.closeConnection(conn);
            }
            DesigntimeManager.getInst().removeState(schemaId);
        }
    }

    static SchemaBriefModel preModifyProperty(SchemaBriefModel params) throws SemanticManageException {
        SchemaDesigntimeState state;
        String schemaId = params.getId();
        if (!SchemasAccess.isIdExist(schemaId)) {
            throw new NotExistException("Not exist: " + schemaId);
        }
        try {
            state = DesigntimeManager.getInst().getState(schemaId);
        }
        catch (SemanticDesignException ex) {
            throw SemanticManageException.wrap(ex);
        }
        if (!state.isBusy()) {
            params.setExtProperty("outDb_canModify", Boolean.TRUE);
        }
        try {
            params.setExtProperty("outDbList", SchemasAccess.getOutsideDsList());
        }
        catch (BOSException ex) {
            throw SemanticManageException.wrap((Exception)((Object)ex));
        }
        return params;
    }

    static SchemaBriefModel modifyProperty(SchemaBriefModel params) throws SemanticManageException {
        String user;
        SchemaDesigntimeState state;
        String id = params.getId();
        if (!SchemasAccess.isIdExist(id)) {
            throw new NotExistException("Not exist: " + id);
        }
        String name = params.getName();
        if (SchemasAccess.isNameExist(name, id)) {
            throw new NameExistException(name + " exist.");
        }
        try {
            state = DesigntimeManager.getInst().getState(id);
        }
        catch (SemanticDesignException ex) {
            throw SemanticManageException.wrap(ex);
        }
        Context ctx = ServerUtil.getContext();
        String currentDate = ServerUtil.getCurrentDate();
        Timestamp ts = Timestamp.valueOf(currentDate);
        String userId = ctx.getCaller().toString();
        Integer dsType = null;
        String datasource = null;
        boolean toModifyOutDb = (Boolean)params.getExtProperty("outDb_canModify");
        if (toModifyOutDb) {
            if (state.isBusy()) {
                throw new LockedException(id + " is Editing.");
            }
            if (params.isCurrentDs()) {
                dsType = new Integer(1);
                datasource = "";
            } else {
                dsType = new Integer(0);
                datasource = params.getOutsideDb();
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_EXT_SemanticSchema set");
        sql.append(" FName=?");
        if (toModifyOutDb) {
            sql.append(",FDsType=?");
            sql.append(",FDatasource=?");
        }
        sql.append(",FLastUpdateUserID=?");
        sql.append(",FLastUpdateTime=?");
        sql.append(" where FID=?");
        try {
            if (toModifyOutDb) {
                DbUtil.executeUpdate(sql.toString(), new Object[]{name, dsType, datasource, userId, ts, id});
                state.setOutDcInfo(datasource);
            } else {
                DbUtil.executeUpdate(sql.toString(), new Object[]{name, userId, ts, id});
            }
        }
        catch (ExtReportOutDBBO.OutDbNotFoundException ex) {
            throw SemanticManageException.wrap((Exception)((Object)ex));
        }
        catch (SQLException ex) {
            throw SemanticManageException.wrap(ex);
        }
        catch (SemanticDesignException ex) {
            throw SemanticManageException.wrap(ex);
        }
        try {
            user = SchemasAccess.getUserText(userId);
        }
        catch (SQLException ex) {
            throw SemanticManageException.wrap(ex);
        }
        params.setUpdator(user);
        params.setUpdateTime(currentDate);
        return params;
    }

    private static boolean isNameExist(String name, String exceptId) throws SemanticManageException {
        String id = SchemasAccess.getSchemaId(name);
        if (id != null) {
            return !StringUtil.equals((String)exceptId, (String)id);
        }
        return false;
    }

    static boolean isIdExist(String id) throws SemanticManageException {
        try {
            return SchemasAccess.checkIdExist(id);
        }
        catch (SQLException ex) {
            throw SemanticManageException.wrap(ex);
        }
    }

    static String getSchemaId(String name) throws SemanticManageException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_EXT_SemanticSchema");
        sql.append(" where FName=?");
        try {
            IRowSet rs = DbUtil.executeQuery(sql.toString(), new String[]{name});
            if (rs.next()) {
                return rs.getString("FID");
            }
            return null;
        }
        catch (SQLException ex) {
            throw SemanticManageException.wrap(ex);
        }
    }
}

