/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.cloud.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IMainMenuItem;
import com.kingdee.eas.base.permission.MainMenuItemCollection;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.OpenMethod;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.cloud.service.ExtCloudRptCategoryControllerFacade;
import com.kingdee.eas.rpts.cloud.service.IExtCloudRptCategoryController;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.data.PublishType;
import com.kingdee.eas.rpts.ctrlreport.mobile.util.MobileCardUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.rpts.snapshot.dispatch.pojo.ReportDispatchInfo;
import com.kingdee.eas.rpts.snapshot.dispatch.service.impl.ReportDispatchServiceImpl;
import com.kingdee.eas.rpts.snapshot.dispatch.util.DispatchCommonUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.log4j.Logger;

public class CloudRptPublishHelper {
    private static Logger log = LogUtil.getPackageLogger(CloudRptPublishHelper.class);

    public static String getCloudReportPublishName(Context context, DefineReportInfo reportInfo) throws BOSException, SQLException {
        boolean isMobile = reportInfo.getTempletType() == 2;
        String publishName = reportInfo.getName();
        String[] names = new String(publishName).split("\uff08CRC_.+_[0-9]{4}(\\$[0-9]{2}){0,2}\uff09(\\.kds)?");
        if (names != null && names.length == 1) {
            publishName = names[0];
        }
        SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMdd");
        String oldPublishName = publishName;
        String reportId = reportInfo.getId().toString();
        if (isMobile) {
            int i = 0;
            String systemID = reportInfo.getSystemID();
            while (CloudRptPublishHelper.checkPublishMobileName(context, reportId, publishName, systemID)) {
                publishName = oldPublishName + yyyyMMdd.format(new Date());
                if (i > 0) {
                    publishName = publishName + "_" + i;
                }
                ++i;
            }
        } else {
            IExtCloudRptCategoryController categoryController = context == null ? ExtCloudRptCategoryControllerFacade.getRemoteInst() : ExtCloudRptCategoryControllerFacade.getLocalInst(context);
            DefObj object = (DefObj)categoryController.getCloudRptDeployPath(reportId, 1);
            MainMenuItemInfo parent = (MainMenuItemInfo)object.getProperty("data");
            String menuItemId = parent.getId().toString();
            object = (DefObj)categoryController.getCloudRptDeployPath(reportId, 2);
            String bipath = object.getStrProperty("path");
            object = (DefObj)categoryController.getCloudRptDeployPath(reportId, 16);
            String easAppCenterPath = object.getAlias();
            int publishType = PublishType.getPublishTypeAll(reportInfo);
            String oldPublishName2 = null;
            if ((publishType & 1) != 0) {
                oldPublishName2 = CloudRptPublishHelper.getPublishGUIName(context, reportInfo.getMenuID().toString());
            }
            if (StringUtil.isEmptyString(oldPublishName2) && (publishType & 0x10) != 0) {
                String easAppCenterName = reportInfo.getEasWebAppCenterPath();
                oldPublishName2 = easAppCenterName.substring(easAppCenterName.lastIndexOf(47) + 1);
            }
            if (StringUtil.isEmptyString(oldPublishName2) && (publishType & 2) != 0) {
                String biPath = reportInfo.getBIPath();
                oldPublishName2 = biPath.substring(biPath.lastIndexOf(47) + 1);
            }
            int i = -1;
            while (true) {
                boolean hasCheck;
                if (!(hasCheck = false) && CloudRptPublishHelper.checkPublishGUIName(context, reportId, menuItemId, publishName)) {
                    hasCheck = true;
                }
                if (!hasCheck && CloudRptPublishHelper.checkPublishBIName(context, reportId, bipath, publishName)) {
                    hasCheck = true;
                }
                if (!hasCheck && CloudRptPublishHelper.checkEASAppCenterName(context, reportId, easAppCenterPath, publishName)) {
                    hasCheck = true;
                }
                if (!hasCheck) break;
                if (i == -1 && !StringUtil.isEmptyString((String)oldPublishName2)) {
                    publishName = oldPublishName2;
                } else {
                    publishName = oldPublishName + yyyyMMdd.format(new Date());
                    if (i > 0) {
                        publishName = publishName + "_" + i;
                    }
                }
                ++i;
            }
        }
        return publishName;
    }

    private static boolean checkEASAppCenterName(Context context, String reportId, String easAppCenterPath, String publishName) throws BOSException, SQLException {
        boolean bl;
        String sql = "select * from t_bas_definereport where fid <> ?  and feaswebappcenterpath = ?";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)context, (String)sql, (Object[])new Object[]{reportId, easAppCenterPath + "/" + publishName});
            bl = rs != null && rs.first();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                throw throwable;
            }
        }
        DBUtil.closeResultSet((ResultSet)rs);
        return bl;
    }

    private static boolean checkPublishBIName(Context context, String reportId, String bipath, String publishName) throws BOSException {
        boolean bl;
        String sql = "select * from t_bas_definereport where fid <> ?  and FBIPath like ?";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)context, (String)sql, (Object[])new Object[]{reportId, bipath + "/%" + publishName});
            bl = rs != null && rs.first();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                throw throwable;
            }
        }
        DBUtil.closeResultSet((ResultSet)rs);
        return bl;
    }

    private static boolean checkPublishMobileName(Context context, String reportId, String mobileName, String mobileTypeId) throws BOSException {
        boolean bl;
        StringBuffer querySQL = new StringBuffer();
        querySQL.append("Select 1 From t_bas_definereport Where fid <> ? and fmobilename =? and fmobiletypeid=?");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)context, (String)querySQL.toString(), (Object[])new Object[]{reportId, mobileName, mobileTypeId});
            bl = rs != null && rs.first();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(rs);
                throw throwable;
            }
        }
        DBUtil.closeResultSet((ResultSet)rs);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unPublishMobile(Context ctx, List<String> mobileReportFid) throws BOSException, SQLException {
        StringBuffer sqlBuf = new StringBuffer("update T_BAS_DEFINEREPORT set FLicenseStrategy = 0, FMobileName = null, FMenuUi=null, FMobileTypeId=null, fpubacctid=null where fid in (");
        StringBuffer reportIdList = new StringBuffer();
        for (String reportId : mobileReportFid) {
            reportIdList.append("'").append(reportId).append("'").append(",");
        }
        sqlBuf.append(reportIdList.substring(0, reportIdList.length() - 1)).append(")");
        ExtDBUtil.maintainRecord(ctx, sqlBuf.toString(), null);
        String sqlSelect = "select max(forderNumber) from t_ext_mobileOrderNum where freportId in (";
        String sqlDelete = "delete from t_ext_mobileOrderNum where freportId in (";
        String reportIds = reportIdList.substring(0, reportIdList.length() - 1);
        sqlSelect = sqlSelect + reportIds + ")";
        sqlDelete = sqlDelete + reportIds + ")";
        int maxOrderNumber = Integer.MAX_VALUE;
        IRowSet rowSet = null;
        try {
            rowSet = ExtDBUtil.executeQuery(ctx, sqlSelect, null);
            if (rowSet != null && rowSet.next()) {
                maxOrderNumber = rowSet.getInt(1);
            }
            String sqlUpdate = "update t_ext_mobileOrderNum set forderNumber=forderNumber-1 where forderNumber > " + maxOrderNumber;
            ArrayList<String> sqlList = new ArrayList<String>();
            sqlList.add(sqlUpdate);
            sqlList.add(sqlDelete);
            ExtDBUtil.executeBatch(ctx, sqlList);
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException sqlUpdate) {}
            }
        }
        if (ctx == null) {
            ReportDispatchServiceImpl reportCenterDispatchService = new ReportDispatchServiceImpl();
            try {
                for (String reportId : mobileReportFid) {
                    List list = reportCenterDispatchService.getReportDispatchList(" and s.freportid='" + reportId + "' and s.Fcodingruleid='null' and s.fsendmessage is null");
                    if (list.size() > 1) {
                        ArrayList<ReportDispatchInfo> list2 = new ArrayList<ReportDispatchInfo>();
                        for (int i = 1; i < list.size(); ++i) {
                            HashMap obj = (HashMap)list.get(i);
                            String jobProcessDefID = DispatchCommonUtil.clob2String(obj.get("fjobprocessdefid"));
                            if (jobProcessDefID == null) continue;
                            ReportDispatchInfo reportDispatchInfo = new ReportDispatchInfo();
                            reportDispatchInfo.setId((String)obj.get("fid"));
                            reportDispatchInfo.setJobProcessDefID(jobProcessDefID);
                            list2.add(reportDispatchInfo);
                        }
                        ReportDispatchServiceImpl impl = new ReportDispatchServiceImpl();
                        impl.deleteDispatch(list2);
                        impl.undoRelease(list2);
                    }
                    if (list.size() > 0) {
                        ReportDispatchInfo reportDispatchInfo;
                        boolean isenabledispatchplan = false;
                        HashMap obj = (HashMap)list.get(0);
                        int en = Integer.parseInt(obj.get("fisenabledispatchplan").toString());
                        isenabledispatchplan = en == 1;
                        String dispatchId = (String)obj.get("fid");
                        String strLocal = SysContext.getSysContext().getLocale().toString();
                        if (isenabledispatchplan && (reportDispatchInfo = reportCenterDispatchService.getReportDispatchInfoById(dispatchId, strLocal)) != null && reportDispatchInfo.getJobProcessDefID() != null) {
                            ArrayList<ReportDispatchInfo> reportDispatchInfoList = new ArrayList<ReportDispatchInfo>();
                            reportDispatchInfoList.add(reportDispatchInfo);
                            reportCenterDispatchService.undoRelease(reportDispatchInfoList);
                        }
                    }
                    try {
                        MobileCardUtil.releaseCard(ctx, reportId);
                    }
                    catch (Exception e) {
                        log.error((Object)"\u66f4\u65b0\u5361\u7247\u8c03\u5ea6\u8868\u5931\u8d25\uff01", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"\u66f4\u65b0\u540e\u53f0\u8c03\u5ea6\u8868\u5931\u8d25\uff01", (Throwable)e);
            }
        }
    }

    public static final void unDeployReport(Context ctx, String reportID, String menuID, boolean updateLicenseStrategy, Map stdInfo) throws BOSException {
        try {
            IMainMenuItem menu = ctx == null ? MainMenuItemFactory.getRemoteInstance() : MainMenuItemFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK menuPk_del = new ObjectUuidPK("id", new MainMenuItemInfo().getBOSType());
            menuPk_del.setKeyValue("id", (Object)menuID);
            menu.delete((IObjectPK)menuPk_del);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Boolean isNeedDelUI = (Boolean)stdInfo.get("isDelMenuUI");
        StringBuffer sqlBuf = new StringBuffer("update T_BAS_DEFINEREPORT set FdeployPath = null, FMenuID = null");
        if (isNeedDelUI.booleanValue()) {
            sqlBuf.append(",FMenuui = null ");
        }
        if (updateLicenseStrategy) {
            sqlBuf.append(",FLicenseStrategy=");
            sqlBuf.append(0);
        }
        sqlBuf.append(" where fid = ?");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(reportID);
        ExtDBUtil.maintainRecord(ctx, sqlBuf.toString(), queryValue);
    }

    public static MainMenuItemInfo getPublishGUIParentMenuItem(Context ctx, String reportCategoryName) throws BOSException {
        StringBuilder selectSQL = new StringBuilder("select FID FROM T_PM_MainMENUITEM WHERE FPARENT = 'OU7oknGyS+2CJyuxW6TfqRdCz6U=' and fname_l2 = '" + reportCategoryName + "'");
        IRowSet rs = null;
        String fid = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL.toString());
            if (rs.next()) {
                fid = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        if (fid == null) {
            return null;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)fid, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        IMainMenuItem iMainMenuItem = MainMenuItemFactory.getLocalInstance((Context)ctx);
        return iMainMenuItem.getMainMenuItemCollection(entityViewInfo).get(0);
    }

    private static String getPublishGUIName(Context ctx, String menuItemId) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)menuItemId, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        IMainMenuItem iMainMenuItem = MainMenuItemFactory.getLocalInstance((Context)ctx);
        MainMenuItemCollection collection = iMainMenuItem.getMainMenuItemCollection(entityViewInfo);
        if (collection == null || collection.size() == 0) {
            return null;
        }
        return collection.get(0).getName();
    }

    private static boolean checkPublishGUIName(Context ctx, String reportId, String menuItemId, String publishName) throws BOSException {
        StringBuilder selectSQL = new StringBuilder("select FID FROM T_PM_MainMENUITEM WHERE FPARENT = '" + menuItemId + "' and fname_l2 = '" + publishName + "' and FUICLASSNAME ='" + reportId + "'");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL.toString());
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    public static MainMenuItemInfo getMenuItemInfo(MainMenuItemInfo parent, String fname, String fid, String uiClassName) {
        MainMenuItemInfo mi = new MainMenuItemInfo();
        mi.setParent(parent);
        mi.setName(fname);
        String number = "KDRS" + System.currentTimeMillis() + RandomUtils.nextInt();
        mi.setNumber(number);
        mi.setDescription("");
        mi.setUiClassName(uiClassName);
        mi.setUiClassParam(fid);
        mi.setOpenMethod(OpenMethod.DEFAULT);
        mi.setOrder("255");
        mi.setEnabled(true);
        mi.setVisible(true);
        mi.setIsReport(false);
        return mi;
    }

    public static String getPublishEasAppCenterParentID(Context ctx, String reportCategoryName) throws BOSException, SQLException {
        String sql = "select * from T_JP_Page where FDisplayName like '{\"en\":\"%\",\"zh_CN\":\"" + reportCategoryName + "\",\"zh_TW\":\"" + STConverter.sc2tc((String)reportCategoryName) + "\"}'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[0]);
        String easAppCenterId = null;
        if (rs.next()) {
            easAppCenterId = rs.getString("FID");
        }
        return easAppCenterId;
    }

    public static void unDeployToBI(Context easCtx, String reportId, String bipath, boolean updateLicenseStrategy) throws BOSException {
        int n;
        if (bipath.equals("")) {
            return;
        }
        if (bipath.length() > 0 && (n = bipath.indexOf("@@")) != -1) {
            bipath = bipath.substring(0, n);
        }
        RptParams pr = new RptParams();
        pr.setString("MethodName", "delBIMenu");
        pr.setString("bipath", bipath);
        FacadeFactory.commonExecuteNever(easCtx, pr);
        StringBuffer sqlBuf = new StringBuffer("update T_BAS_DefineReport set FBIPath = null ");
        if (updateLicenseStrategy) {
            sqlBuf.append(",FLicenseStrategy =");
            sqlBuf.append(0);
        }
        sqlBuf.append(" where fid = '");
        sqlBuf.append(reportId).append('\'');
        ExtDBUtil.maintainRecord(easCtx, sqlBuf.toString(), null);
    }
}

