/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.cloud.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.uiframe.IMainFunctionMenu;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.rpts.cloud.model.CloudReportData;
import com.kingdee.eas.rpts.cloud.service.CloudRptCenterControllerFacade;
import com.kingdee.eas.rpts.cloud.service.ICloudRptCenterController;
import com.kingdee.eas.rpts.cloud.tool.CloudReportWorkflow;
import com.kingdee.eas.rpts.ctrlreport.CloudReportAuthBaseFactory;
import com.kingdee.eas.rpts.ctrlreport.CloudReportAuthBaseInfo;
import com.kingdee.eas.rpts.ctrlreport.ICloudReportAuthBase;
import com.kingdee.eas.rpts.ctrlreport.bo.CloudReportAuthBO;
import com.kingdee.eas.rpts.ctrlreport.data.CloudReportAuthVO;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.statistics.EASExtStatisticsInfoService;
import com.kingdee.eas.rpts.statistics.exception.SalmonBizException;
import com.kingdee.eas.rpts.statistics.info.EnterpriseInfo;
import com.kingdee.eas.rpts.statistics.util.ServiceUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class EASExtRptsCloudService {
    private static Logger log = LogUtil.getPackageLogger(EASExtRptsCloudService.class);
    private static Pattern paramPattern = Pattern.compile("[^A-Za-z0-9_]");
    private static EASExtRptsCloudService thiz = new EASExtRptsCloudService();
    private static final String CloudRptUploadStorageKey = "CloudRptUploadStorageKey";
    private static final String CloudRptRequestAuthStorageKey = "CloudRptRequestAuthStorageKey";
    private static final String GET_USERINFO = "getUserInfo";
    private static final String CHECK_RPTNAMES = "checkRptNames";
    private static final String UPLOAD_REPORT = "uploadReport";
    private static final String REQUEST_AUTH = "RequestAuth";
    private static final String COLLECT_REQUEST_AUTH = "collectRequestAuth";
    private static final String FINISH_REQUEST_AUTH = "finishRequestAuth";
    private static final String GET_RPT_AUTH = "getCloudReportAuth";
    private static final String SAVE_PERMISSION = "savePermission";
    private static final String IS_DOWNLOAD_COMPLETE = "isDownloadComplete";
    private static final String GET_UNFINISH_DOWNLOAD_LIST = "getUnfinishDownloadList";
    private static final String CANCEL_DOWNLOAD = "cancelDownload";
    private static final String CLEAR_DOWNLOAD = "clearDownload";
    private static final String DELETE_DEMO_AUTH = "deleteDemoAuth";
    private static final String GET_REPORT_SYNC_PROPERTIES = "getReportSyncProperties";

    private EASExtRptsCloudService() {
    }

    public static EASExtRptsCloudService INST() {
        return thiz;
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletOutputStream out;
        String method = req.getParameter("remoteMethod");
        if (StringUtil.isEmptyString((String)method)) {
            CloudReportWorkflow.insertProcessDef(this.getContext(req));
            this.gotoCloudRPTCenter(req, resp);
            return;
        }
        JSONObject json = new JSONObject();
        try {
            HashMap<String, Object> retValue = null;
            if (GET_USERINFO.equals(method)) {
                retValue = this.getUserInfo(req);
            } else if (CHECK_RPTNAMES.equals(method)) {
                retValue = this.checkRptNames(req);
            } else if (UPLOAD_REPORT.equals(method)) {
                retValue = this.uploadReport(req);
            } else if (REQUEST_AUTH.equals(method)) {
                retValue = this.requestAuth(req);
            } else if (COLLECT_REQUEST_AUTH.equals(method)) {
                this.collectRequestAuth(req);
            } else if (FINISH_REQUEST_AUTH.equals(method)) {
                retValue = this.finishRequestAuth(req);
            } else if (GET_RPT_AUTH.equals(method)) {
                retValue = this.getCloudReportAuth(req);
            } else if (SAVE_PERMISSION.equals(method)) {
                retValue = this.savePermission(req);
            } else if (IS_DOWNLOAD_COMPLETE.equals(method)) {
                retValue = this.isDownloadComplete(req);
            } else if (GET_UNFINISH_DOWNLOAD_LIST.equals(method)) {
                retValue = this.getUnfinishDownloadList(req);
            } else if (CANCEL_DOWNLOAD.equals(method)) {
                this.cancelDownload(req);
            } else if (CLEAR_DOWNLOAD.equals(method)) {
                this.clearDownload(req);
            } else if (DELETE_DEMO_AUTH.equals(method)) {
                this.deleteDemoAuth(req);
            } else if (GET_REPORT_SYNC_PROPERTIES.equals(method)) {
                retValue = this.getReportSyncProperties(req);
            }
            if (retValue != null) {
                json.put("retValue", (Object)retValue);
            }
            json.put("success", true);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                json.put("success", false);
                if (e instanceof ExtRptBizException) {
                    ExtRptBizException ex = (ExtRptBizException)e;
                    json.put("errorCode", ex.getErrorCode());
                    json.put("errorMessage", (Object)ex.getErrorMessage());
                } else {
                    json.put("exception", (Object)e.getMessage());
                }
            }
            catch (JSONException ex) {
                // empty catch block
            }
        }
        String jsonpCallback = req.getParameter("jsonpCallback");
        Matcher matcher = paramPattern.matcher(jsonpCallback);
        if (matcher.find()) {
            throw new ServletException("Parameter jsonpCallback is illegal");
        }
        if (StringUtil.isEmptyString((String)jsonpCallback)) {
            resp.setContentType("application/json; charset=utf-8");
            out = resp.getOutputStream();
            out.write(json.toString().getBytes("utf-8"));
        } else {
            resp.setContentType("text/javascript;charset=utf-8");
            resp.setHeader("Pragma", "No-cache");
            resp.setHeader("Cache-Control", "no-cache");
            resp.setDateHeader("Expires", 0L);
            resp.setHeader("Access-Control-Allow-Origin", "*");
            resp.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS");
            resp.setHeader("Access-Control-Allow-Headers", "x-requested-with,content-type");
            resp.setHeader("Access-Control-Allow-Private-Network", "true");
            out = resp.getOutputStream();
            String result = jsonpCallback + "(" + json.toString() + ")";
            out.write(result.getBytes("utf-8"));
        }
        out.flush();
    }

    private void deleteDemoAuth(HttpServletRequest req) {
        String cloudRptId = req.getParameter("cloudRptId");
        if (StringUtil.isEmptyString((String)cloudRptId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38");
        }
        Context ctx = this.getContext(req);
        UserInfo user = this.getLoginUser(req);
        ICloudRptCenterController cloudRptCenterController = CloudRptCenterControllerFacade.getLocalInst(ctx);
        cloudRptCenterController.deleteDemoDataAuth(user.getId().toString(), cloudRptId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelDownload(HttpServletRequest req) {
        HttpSession session;
        String rptId = req.getParameter("rptId");
        HttpSession httpSession = session = req.getSession();
        synchronized (httpSession) {
            HashMap cloudRptUploadStorage = (HashMap)session.getAttribute(CloudRptUploadStorageKey);
            if (cloudRptUploadStorage != null) {
                cloudRptUploadStorage.remove(rptId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDownload(HttpServletRequest req) {
        HttpSession session;
        HttpSession httpSession = session = req.getSession();
        synchronized (httpSession) {
            HashMap cloudRptUploadStorage = (HashMap)session.getAttribute(CloudRptUploadStorageKey);
            if (cloudRptUploadStorage != null) {
                cloudRptUploadStorage.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUnfinishDownloadList(HttpServletRequest req) {
        HttpSession session;
        ArrayList reportIds = new ArrayList();
        HttpSession httpSession = session = req.getSession();
        synchronized (httpSession) {
            HashMap cloudRptUploadStorage = (HashMap)session.getAttribute(CloudRptUploadStorageKey);
            if (cloudRptUploadStorage != null) {
                reportIds.addAll(cloudRptUploadStorage.keySet());
            }
            return reportIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object isDownloadComplete(HttpServletRequest req) {
        HttpSession session;
        HttpSession httpSession = session = req.getSession();
        synchronized (httpSession) {
            HashMap cloudRptUploadStorage = (HashMap)session.getAttribute(CloudRptUploadStorageKey);
            if (cloudRptUploadStorage != null) {
                return cloudRptUploadStorage.isEmpty();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object requestAuth(HttpServletRequest req) throws ExtRptBizException {
        boolean isPublish;
        try {
            String strIsPublish = req.getParameter("isPublish");
            isPublish = StringUtil.isEmptyString((String)strIsPublish) ? true : Boolean.valueOf(strIsPublish);
        }
        catch (Exception e) {
            isPublish = true;
        }
        String rptIdsString = req.getParameter("rptIds");
        try {
            HttpSession session;
            Context ctx = this.getContext(req);
            ICloudRptCenterController cloudRptCenterController = CloudRptCenterControllerFacade.getLocalInst(ctx);
            JSONArray rptIds = new JSONArray(rptIdsString);
            int count = rptIds.length();
            String userId = this.getLoginUser(req).getId().toString();
            ArrayList<String> reports = new ArrayList<String>();
            for (int index = 0; index < count; ++index) {
                String reportId = rptIds.getString(index);
                reports.add(reportId);
            }
            Object returnValue = cloudRptCenterController.requestAuth(reports, userId, isPublish);
            HttpSession httpSession = session = req.getSession();
            synchronized (httpSession) {
                HashMap cloudRptUploadStorage = (HashMap)session.getAttribute(CloudRptUploadStorageKey);
                if (cloudRptUploadStorage != null) {
                    for (String reportId : reports) {
                        cloudRptUploadStorage.remove(reportId);
                    }
                }
            }
            return returnValue;
        }
        catch (JSONException e) {
            throw ExtRptBizException.newIllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectRequestAuth(HttpServletRequest req) throws ExtRptBizException {
        HashMap<String, Serializable> cloudRptRequestAuthStorage;
        HttpSession session;
        boolean isPublish;
        try {
            String strIsPublish = req.getParameter("isPublish");
            isPublish = StringUtil.isEmptyString((String)strIsPublish) ? true : Boolean.valueOf(strIsPublish);
        }
        catch (Exception e) {
            isPublish = true;
        }
        Object object = session = req.getSession();
        synchronized (object) {
            cloudRptRequestAuthStorage = (HashMap<String, Serializable>)session.getAttribute(CloudRptRequestAuthStorageKey);
            if (cloudRptRequestAuthStorage == null) {
                cloudRptRequestAuthStorage = new HashMap<String, Serializable>();
                session.setAttribute(CloudRptRequestAuthStorageKey, cloudRptRequestAuthStorage);
            }
        }
        object = cloudRptRequestAuthStorage;
        synchronized (object) {
            if (cloudRptRequestAuthStorage.containsKey("isPublish")) {
                isPublish = (Boolean)cloudRptRequestAuthStorage.get("isPublish") == isPublish ? isPublish : !isPublish;
            }
            cloudRptRequestAuthStorage.put("isPublish", Boolean.valueOf(isPublish));
            HashSet rptIds = null;
            if (cloudRptRequestAuthStorage.containsKey("rptIds")) {
                rptIds = (HashSet)cloudRptRequestAuthStorage.get("rptIds");
            } else {
                rptIds = new HashSet();
                cloudRptRequestAuthStorage.put("rptIds", rptIds);
            }
            String rptIdsString = req.getParameter("rptIds");
            try {
                JSONArray rptIdsJsonArrayy = new JSONArray(rptIdsString);
                int count = rptIdsJsonArrayy.length();
                for (int index = 0; index < count; ++index) {
                    String reportId = rptIdsJsonArrayy.getString(index);
                    rptIds.add(reportId);
                }
            }
            catch (JSONException e) {
                throw ExtRptBizException.newIllegalArgumentException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object finishRequestAuth(HttpServletRequest req) throws ExtRptBizException {
        HttpSession session;
        HashMap cloudRptRequestAuthStorage = null;
        HttpSession httpSession = session = req.getSession();
        synchronized (httpSession) {
            cloudRptRequestAuthStorage = (HashMap)session.getAttribute(CloudRptRequestAuthStorageKey);
        }
        ArrayList<String> ids = new ArrayList<String>();
        boolean isPublish = false;
        HashMap hashMap = cloudRptRequestAuthStorage;
        synchronized (hashMap) {
            if (cloudRptRequestAuthStorage != null && cloudRptRequestAuthStorage.containsKey("isPublish") && cloudRptRequestAuthStorage.containsKey("rptIds")) {
                try {
                    isPublish = (Boolean)cloudRptRequestAuthStorage.get("isPublish");
                    HashSet reports = (HashSet)cloudRptRequestAuthStorage.get("rptIds");
                    for (String id : reports) {
                        ids.add(id);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Context ctx = this.getContext(req);
        ICloudRptCenterController cloudRptCenterController = CloudRptCenterControllerFacade.getLocalInst(ctx);
        String userId = this.getLoginUser(req).getId().toString();
        Object returnValue = cloudRptCenterController.requestAuth(ids, userId, isPublish);
        HttpSession httpSession2 = session;
        synchronized (httpSession2) {
            HashMap cloudRptUploadStorage = (HashMap)session.getAttribute(CloudRptUploadStorageKey);
            if (cloudRptUploadStorage != null) {
                for (String id : ids) {
                    cloudRptUploadStorage.remove(id);
                }
            }
            if ((cloudRptRequestAuthStorage = (HashMap)session.getAttribute(CloudRptRequestAuthStorageKey)) != null) {
                cloudRptRequestAuthStorage.remove("isPublish");
                cloudRptRequestAuthStorage.remove("rptIds");
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object uploadReport(HttpServletRequest req) throws ExtRptBizException {
        String reportDataString = req.getParameter("reportData");
        try {
            CloudReportData reportData;
            HttpSession session;
            JSONObject report = new JSONObject(reportDataString);
            String rptId = report.getString("rptId");
            String rptName = report.getString("rptName");
            String rptType = report.getString("rptType");
            String rptCategoryName = report.getString("rptCategoryName");
            int rptTemplateVersion = report.getInt("rptTemplateVersion");
            int rptContentVersion = report.getInt("rptContentVersion");
            int reportLength = report.getInt("reportLength");
            int dataIndex = report.getInt("dataIndex");
            String dataString = report.getString("data");
            Object object = session = req.getSession();
            synchronized (object) {
                HashMap<String, CloudReportData> cloudRptUploadStorage = (HashMap<String, CloudReportData>)session.getAttribute(CloudRptUploadStorageKey);
                if (cloudRptUploadStorage == null) {
                    cloudRptUploadStorage = new HashMap<String, CloudReportData>();
                    session.setAttribute(CloudRptUploadStorageKey, cloudRptUploadStorage);
                }
                if ((reportData = (CloudReportData)cloudRptUploadStorage.get(rptId)) == null) {
                    reportData = new CloudReportData(rptId, rptName, rptType, rptCategoryName, reportLength, rptContentVersion, rptTemplateVersion);
                    cloudRptUploadStorage.put(rptId, reportData);
                }
            }
            object = reportData;
            synchronized (object) {
                Context ctx = this.getContext(req);
                ICloudRptCenterController cloudRptCenterController = CloudRptCenterControllerFacade.getLocalInst(ctx);
                return cloudRptCenterController.collect(reportData, dataIndex, dataString);
            }
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38");
        }
    }

    private Object checkRptNames(HttpServletRequest req) throws ExtRptBizException {
        ArrayList<Map<Object, Object>> returnValue = new ArrayList<Map<Object, Object>>();
        String rptNamesString = req.getParameter("rptNames");
        try {
            Context ctx = this.getContext(req);
            ICloudRptCenterController cloudRptCenterController = CloudRptCenterControllerFacade.getLocalInst(ctx);
            JSONArray rptNames = new JSONArray(rptNamesString);
            int count = rptNames.length();
            String userId = this.getLoginUser(req).getId().toString();
            for (int index = 0; index < count; ++index) {
                JSONObject report = rptNames.getJSONObject(index);
                String downloadId = report.getString("downloadId");
                String rptId = report.getString("rptId");
                String rptName = report.getString("rptName");
                String rptType = report.getString("rptType");
                String rptCategory = report.getString("rptCategoryName");
                int rptTemplateVersion = report.getInt("rptTemplateVersion");
                int rptContentVersion = report.getInt("rptContentVersion");
                int rptBase64Length = report.getInt("rptBase64Length");
                CloudReportData reportData = new CloudReportData(rptId, rptName, rptType, rptCategory, rptContentVersion, rptTemplateVersion);
                Map<Object, Object> checkValue = new HashMap<String, Boolean>();
                try {
                    checkValue = cloudRptCenterController.checkCloudRpt(reportData, userId);
                    checkValue.put("isCheckSuccess", true);
                }
                catch (ExtRptBizException e) {
                    checkValue.put("isCheckSuccess", false);
                    checkValue.put("errorCode", e.getErrorCode());
                    checkValue.put("errorMessage", e.getErrorMessage());
                }
                checkValue.put("downloadId", downloadId);
                checkValue.put("rptId", rptId);
                checkValue.put("rptName", rptName);
                checkValue.put("rptType", rptType);
                checkValue.put("rptCategoryName", rptCategory);
                checkValue.put("rptTemplateVersion", rptTemplateVersion);
                checkValue.put("rptContentVersion", rptContentVersion);
                checkValue.put("rptBase64Length", rptBase64Length);
                returnValue.add(checkValue);
            }
        }
        catch (JSONException e) {
            throw ExtRptBizException.newIllegalArgumentException(e);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Object> getReportSyncProperties(HttpServletRequest req) throws ExtRptBizException {
        String fileName = System.getProperty("ctrlhome") + File.separator + "ext4xunt" + File.separator + "settings.properties";
        HashMap<String, Object> data = new HashMap<String, Object>();
        Context ctx = this.getContext(req);
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(fileName));
            Properties extProps = new Properties();
            data.put("cloudUrl", extProps.getProperty("cloud.pub.url"));
            extProps.load(in);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{in});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{in});
        }
        CloseUtil.close((Closeable[])new Closeable[]{in});
        data.put("sync2Cloud", CloudRptCenterControllerFacade.isCloudRptCenterEnable(ctx));
        ICloudRptCenterController cloudRptCenterController = CloudRptCenterControllerFacade.getLocalInst(ctx);
        return data;
    }

    private void gotoCloudRPTCenter(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        UserInfo user = this.getLoginUser(req);
        String outputString = null;
        if (UserType.SYSTEM == user.getType()) {
            outputString = "<iframe id='_cloud_report_center_iframe' src='/plt_bi/biweb/html/CloudReportCenter.htm?isSystemAdmin=true' style='width:100%;height:820px;border:none' frameborder='0' scrolling='no'\tnoresize='noresize' ></iframe>";
        } else {
            this.clearDownload(req);
            String isPublish = req.getParameter("isPublish");
            if (StringUtil.isEmptyString((String)isPublish)) {
                isPublish = "true";
            }
            StringBuffer strUrl = new StringBuffer("http://bos.kingdee.com");
            if (CloudRptCenterControllerFacade.isCloudRptCenterEnable(this.getContext(req))) {
                strUrl.append("/crc/webContent/report/index.html?serverName=" + req.getServerName() + "&serverPort=" + req.getServerPort() + "&isPublish=" + isPublish);
            } else {
                strUrl.append("/crc/webContent/rptcenter/CloudRptCenterDisable.html");
            }
            String url = URLEncoder.encode(strUrl.toString(), "UTF-8");
            outputString = "<iframe id='_cloud_report_center_iframe' src='/plt_bi/biweb/html/CloudReportCenter.htm?url=" + url + "' style='width:100%;height:820px;border:none' frameborder='0' scrolling='no'\tnoresize='noresize' ></iframe>";
        }
        resp.getWriter().println(outputString);
    }

    private Map<String, Object> getUserInfo(HttpServletRequest request) throws ExtRptBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Context ctx = this.getContext(request);
        ArrayList<Object> queryValues = new ArrayList<Object>();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        HashMap<String, String> personInfo = new HashMap<String, String>();
        personInfo.put("userId", userInfo.getId().toString());
        personInfo.put("userName", userInfo.getNumber());
        personInfo.put("userDisplayName", userInfo.getName());
        OrgUnitInfo orgInfo = ContextUtil.getCurrentOrgUnit((Context)ctx);
        personInfo.put("orgId", orgInfo.getId().toString());
        personInfo.put("orgName", orgInfo.getName());
        personInfo.put("phone", userInfo.getCell());
        personInfo.put("email", userInfo.getEmail());
        try {
            queryValues.add(userInfo.getPerson().getId().toString());
            String sql = "SELECT  \"POSITION\".FName_l2 \"POSITION.NAME\" \tFrom T_BD_PERSON \"PERSON\" \tLEFT JOIN T_ORG_PositionMember \"POSITIONMEMBER\" ON \"PERSON\".FID = \"POSITIONMEMBER\".FPersonID \tLEFT JOIN T_ORG_Position \"POSITION\" ON \"POSITIONMEMBER\".FPositionID = \"POSITION\".FID \twhere \"PERSON\".FID = ?";
            IRowSet rowSet = ServiceUtil.DBUtil.executeQuery(ctx, sql, queryValues);
            if (rowSet.next()) {
                String POSITION_NAME = rowSet.getString("POSITION.NAME");
                personInfo.put("title", POSITION_NAME);
            } else {
                personInfo.put("title", "");
            }
        }
        catch (Exception e) {
            log.info((Object)"\u83b7\u53d6\u7528\u6237\u804c\u4f4d\u5931\u8d25", (Throwable)e);
            personInfo.put("title", "");
        }
        result.put("personInfo", personInfo);
        EnterpriseInfo enterpriseInfo = null;
        try {
            enterpriseInfo = EASExtStatisticsInfoService.fetchEnterpriseInfo(ctx);
        }
        catch (SalmonBizException e) {
            throw ExtRptBizException.newFailed2LoadUserInfosException(e);
        }
        result.put("enterpriseInfo", EnterpriseInfo.wrapEnterpriseInfo(enterpriseInfo));
        HashMap<String, Object> env = new HashMap<String, Object>();
        result.put("env", env);
        try {
            IMainFunctionMenu iMainFunctionMenu = MainFunctionMenuFactory.getLocalInstance((Context)ctx);
            String version = iMainFunctionMenu.getEASOrBOSVersionFromServerAtProperties("EAS", ctx.getLocale());
            env.put("EASVersion", version);
            version = iMainFunctionMenu.getEASOrBOSVersionFromServerAtProperties("BOS", ctx.getLocale());
            env.put("BOSVersion", version);
        }
        catch (BOSException e1) {
            log.info((Object)"\u83b7\u53d6EAS\u7248\u672c\u5931\u8d25", (Throwable)e1);
            env.put("EASVersion", "");
            env.put("BOSVersion", "");
        }
        catch (EASBizException e) {
            log.info((Object)"\u83b7\u53d6EAS\u7248\u672c\u5931\u8d25", (Throwable)e);
            env.put("EASVersion", "");
            env.put("BOSVersion", "");
        }
        env.put("isJavaDataSetAvailable", false);
        return result;
    }

    private Map<String, Boolean> hasReportToolAuth(HttpServletRequest req) throws BOSException {
        Context ctx = this.getContext(req);
        String userId = this.getLoginUser(req).getId().toString();
        boolean hasNormalPerm = CloudReportAuthBO.hasReportToolAuth(ctx, userId);
        boolean hasMobilePerm = CloudReportAuthBO.hasMobileReportToolAuth(ctx, userId);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("hasNormalPerm", hasNormalPerm);
        map.put("hasMobilePerm", hasMobilePerm);
        return map;
    }

    private Object getCloudReportAuth(HttpServletRequest req) throws BOSException, JSONException, UnsupportedEncodingException {
        String sId = req.getParameter("sId");
        Context ctx = this.getContext(req);
        String authId = CloudReportAuthBO.getAuthIdByAssignId(ctx, sId);
        if (StringUtil.isEmptyString((String)authId)) {
            authId = sId;
            authId = URLDecoder.decode(authId, "UTF-8");
        }
        if (StringUtil.isEmptyString((String)authId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\uff0c\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CloudReportAuthVO userInfo = CloudReportAuthBO.getCloudReportAuthUser(ctx, authId);
        List<CloudReportAuthVO> rptInfos = CloudReportAuthBO.getCloudReportAuth(ctx, authId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userInfo", new JSONObject((Object)userInfo));
        map.put("reportInfos", new JSONArray(rptInfos, false));
        map.putAll(this.hasReportToolAuth(req));
        return map;
    }

    private String savePermission(HttpServletRequest req) throws BOSException, EASBizException, UnsupportedEncodingException {
        boolean isSumbit;
        Context ctx = this.getContext(req);
        String userId = this.getLoginUser(req).getId().toString();
        boolean hasNormalPerm = CloudReportAuthBO.hasReportToolAuth(ctx, userId);
        boolean hasMobilePerm = CloudReportAuthBO.hasMobileReportToolAuth(ctx, userId);
        if (!hasNormalPerm && !hasMobilePerm) {
            throw new BOSException("\u60a8\u65e0\u6b64\u64cd\u4f5c\u6743\u9650\uff01");
        }
        String authId = req.getParameter("authId");
        if (StringUtil.isEmptyString((String)authId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\uff0c\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String sumbit = req.getParameter("isSumbit");
        boolean bl = isSumbit = StringUtil.isEmptyString((String)sumbit) ? false : Boolean.valueOf(sumbit);
        if (!isSumbit) {
            CloudReportAuthVO vo = new CloudReportAuthVO();
            vo.setAuthId(authId);
            CloudReportAuthBO.updateAuthTime(ctx, vo);
            this.finishProcess(ctx, authId);
            return "finish";
        }
        String rptPermString = req.getParameter("rptPerm");
        ArrayList<CloudReportAuthVO> listVo = new ArrayList<CloudReportAuthVO>();
        try {
            JSONArray rptPerms = new JSONArray(rptPermString);
            int count = rptPerms.length();
            for (int index = 0; index < count; ++index) {
                JSONObject voObj = rptPerms.getJSONObject(index);
                CloudReportAuthVO vo = new CloudReportAuthVO();
                vo.setAuthId(voObj.getString("authId"));
                vo.setUserId(voObj.getString("userId"));
                vo.setReportId(voObj.getString("reportId"));
                vo.setPermission(voObj.getString("permission"));
                listVo.add(vo);
            }
        }
        catch (JSONException e) {
            log.error((Object)e);
        }
        CloudReportAuthBO.updateCloudReportAuth(ctx, listVo);
        this.finishProcess(ctx, authId);
        return "saveSuccess";
    }

    private void finishProcess(Context ctx, String authId) throws BOSException, EASBizException {
        ICloudReportAuthBase authBase = CloudReportAuthBaseFactory.getLocalInstance(ctx);
        authBase.savePermission((IObjectValue)((CloudReportAuthBaseInfo)authBase.getValue((IObjectPK)new ObjectUuidPK(authId))));
    }

    private Context getContext(HttpServletRequest req) {
        return WebContextUtil.getEasContext((HttpServletRequest)req);
    }

    private UserInfo getLoginUser(HttpServletRequest request) {
        HashMap result = new HashMap();
        Context ctx = this.getContext(request);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        return userInfo;
    }
}

