/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.cloud.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.service.IWfDefineService;
import com.kingdee.bos.workflow.service.WfDefineService;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtDBUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class CloudReportWorkflow {
    private static Logger logger = LogUtil.getPackageLogger(CloudReportWorkflow.class);
    private static final String P_ID = "f875efca-3f2e-484d-b75e-91e807cabd2bWFPRCDEF";

    public static void insertProcessDef(Context ctx) {
        String sqlSelect = "select fcode from T_WFD_PROCESSDEF where fprocessid=?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(P_ID);
        ArrayList resultList = null;
        try {
            resultList = ExtDBUtil.getResultListBySql(ctx, sqlSelect, queryValue);
        }
        catch (BOSException e) {
            logger.error((Object)"\u67e5\u8be2\u4e91\u62a5\u8868\u6388\u6743\u6d41\u7a0b\u5b9a\u4e49\u5931\u8d25\uff01", (Throwable)e);
        }
        Element root = CloudReportWorkflow.getProcessDef();
        if (root == null) {
            return;
        }
        String fnewCode = CloudReportWorkflow.getCode(root);
        if (resultList == null || resultList.isEmpty()) {
            CloudReportWorkflow.insertProcessDef1(ctx, root, fnewCode);
        } else {
            String fcode = (String)((HashMap)resultList.get(0)).get("fcode");
            if (!StringUtil.isEmptyString((String)fnewCode) && fnewCode.compareTo(fcode) > 0) {
                CloudReportWorkflow.insertProcessDef1(ctx, root, fnewCode);
            }
        }
    }

    private static void insertProcessDef1(Context ctx, Element root, String fcode) {
        String defXml = CloudReportWorkflow.getDefString(root);
        if (StringUtil.isEmptyString((String)defXml)) {
            logger.error((Object)"\u83b7\u53d6\u4e91\u62a5\u8868\u6388\u6743\u6d41\u7a0b\u5b9a\u4e49\u5185\u5bb9\u5931\u8d25\uff01");
            return;
        }
        String sqlDeleteWFD = "delete from T_WFD_PROCESSDEF where FPROCESSID='f875efca-3f2e-484d-b75e-91e807cabd2bWFPRCDEF'";
        String sqlInsertWFD = "insert into T_WFD_PROCESSDEF (FPROCESSID, FCODE, FNAME, FDESCRIPTION, FPROCESSXML, FCREATETIME, FAUTHORID, FPUBLISHSTATUS, FVERSION, FVALIDFROM, FVALIDTO, FSYSTEMVERSION, FPACKAGENAME, FFILENAME, FLockStatus, FPROCDEFTYPE, FUserId, FICONNAME, FINSTRUCTIONTYPE, FCHILDPROCESS) values ('f875efca-3f2e-484d-b75e-91e807cabd2bWFPRCDEF', ?, '\u4e91\u62a5\u8868\u6388\u6743', null, ?,  now(), 'administrator', 0, 'V6.1.0', ?, ?, '5.0.0', 'com.kingdee.eas.sem', '\u4e91\u62a5\u8868\u6388\u6743.kdwf', 0, 'NORMAL', '00000000-0000-0000-0000-00000000000013B7DE7F', 'wf_defaultflow.png', 0, null)";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = format.parse("1970-01-01 08:00:00");
            dateTo = format.parse("2050-01-01 00:00:00");
        }
        catch (ParseException e) {
            logger.error((Object)e);
        }
        StringReader reader = new StringReader(defXml);
        ArrayList<Object> paramValues = new ArrayList<Object>();
        paramValues.add(fcode);
        paramValues.add(reader);
        paramValues.add(new Timestamp(dateFrom.getTime()));
        paramValues.add(new Timestamp(dateTo.getTime()));
        HashMap<StringReader, Integer> mapParams = new HashMap<StringReader, Integer>();
        mapParams.put(reader, defXml.length());
        try {
            DbUtil.executeBatchUpdate(ctx, sqlInsertWFD, paramValues, paramValues.size(), sqlDeleteWFD, mapParams);
        }
        catch (SQLException e) {
            logger.error((Object)"\u66f4\u65b0\u4e91\u62a5\u8868\u6388\u6743\u6d41\u7a0b\u5b9a\u4e49\u5931\u8d25\uff01", (Throwable)e);
            return;
        }
        try {
            IWfDefineService wfService = WfDefineService.getService((Context)ctx);
            String adminId = "00000000-0000-0000-0000-00000000000013B7DE7F";
            wfService.releaseProcessDef(adminId, defXml, true);
        }
        catch (WfException e) {
            logger.error((Object)"\u53d1\u5e03\u4e91\u62a5\u8868\u6388\u6743\u6d41\u7a0b\u5b9a\u4e49\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    private static Element getProcessDef() {
        block8: {
            InputStream stm;
            block7: {
                stm = CloudReportWorkflow.class.getResourceAsStream("processDef.kdwf");
                if (stm != null) break block7;
                logger.error((Object)"processDef.kdwf config file not found.");
                break block8;
            }
            Element root = null;
            try {
                root = XmlUtil.loadXmlStream((InputStream)stm);
            }
            catch (IOException ex) {
                logger.error((Object)"Load processDef config file error.", (Throwable)ex);
                CloseUtil.close((Closeable[])new Closeable[]{stm});
            }
            catch (JDOMException ex2) {
                logger.error((Object)"Load processDef config file error.", (Throwable)ex2);
                {
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{stm});
                        throw throwable;
                    }
                }
                CloseUtil.close((Closeable[])new Closeable[]{stm});
            }
            CloseUtil.close((Closeable[])new Closeable[]{stm});
            if (root != null) {
                return root;
            }
        }
        return null;
    }

    private static String getDefString(Element root) {
        if (root == null) {
            return null;
        }
        return XmlUtil.outputString((Element)root);
    }

    private static String getCode(Element root) {
        if (root == null) {
            return null;
        }
        return root.getAttributeValue("Code");
    }
}

