/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.cloud.ui;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.NSPanelComponent;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.rpts.cloud.js.ExtCloudRptCenterJSFacade;
import com.kingdee.eas.rpts.cloud.ui.LoadCloudRptComponentUtil;
import com.kingdee.eas.rpts.cloud.ui.action.RefreshAction;
import com.kingdee.eas.rpts.ctrlreport.util.PortalUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import javax.swing.Action;

public class CloudRptCenterExplorer
extends CoreUI {
    private boolean isPageLoaed = false;
    private static final long serialVersionUID = 1L;
    private JWebBrowser browser;
    private ExtCloudRptCenterJSFacade jsFacade;
    private RefreshAction btnRefresh;
    private String cloudRptCetnerURL;

    public CloudRptCenterExplorer() throws Exception {
        MiscUtil.switchSWTLib((boolean)true, (boolean)true);
        SysContext ctx = SysContext.getSysContext();
        UserInfo user = ctx.getCurrentUserInfo();
        if (UserType.SYSTEM == user.getType()) {
            MessageUtil.msgboxInfo(null, (String)"\u7cfb\u7edf\u7ba1\u7406\u5458\u65e0\u6cd5\u4f7f\u7528\u8be5\u529f\u80fd\uff01");
            this.abort();
        } else {
            LoadCloudRptComponentUtil.loadComponent();
        }
    }

    public void onLoad() throws Exception {
        this.initUrl();
    }

    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        KDToolBar toolBar = this.getUIToolBar();
        toolBar.add((Action)this.btnRefresh);
    }

    public void initUIContentLayout() {
        this.btnRefresh = new RefreshAction(this);
        this.browser = new JWebBrowser(this.getNSOptions());
        this.jsFacade = new ExtCloudRptCenterJSFacade(this, this.browser);
        this.btnRefresh.setJsFacade(this.jsFacade);
        this.btnRefresh.setEnabled(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.browser);
    }

    private void initUrl() {
        String url = "/easportal/BIReport?servletType=rptCloudService";
        url = this.getUIContext().get("isEntryFromMenu") != null ? url + "&isPublish=false" : url + "&isPublish=true";
        url = url + "&ts=" + new Date().getTime();
        if ((url = PortalUtil.getGUItoPortalUrl(url)) == null) {
            MessageUtil.msgboxInfo(null, (String)"\u83b7\u53d6\u4e91\u62a5\u8868\u4e2d\u5fc3\u8def\u5f84\u5931\u8d25");
            this.abort();
        } else {
            this.cloudRptCetnerURL = url;
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.browser.navigate(this.cloudRptCetnerURL);
    }

    public boolean destroyWindow() {
        if (this.isPageLoaed) {
            if (this.jsFacade.canClose()) {
                return super.destroyWindow();
            }
            return false;
        }
        return super.destroyWindow();
    }

    public String getUITitle() {
        return "\u4e91\u62a5\u8868\u4e2d\u5fc3";
    }

    public void setIsPageLoaed(boolean isPageLoaed) {
        this.isPageLoaed = isPageLoaed;
    }

    public boolean reloadPage() {
        if (!this.isPageLoaed) {
            this.browser.navigate(this.cloudRptCetnerURL);
            return true;
        }
        return false;
    }

    private NSOption[] getNSOptions() {
        if (CtrlUtil.is64BitJVM()) {
            if (CtrlUtil.isWinOS()) {
                return new NSOption[]{NSPanelComponent.destroyOnFinalization(), NSPanelComponent.constrainVisibility()};
            }
            if (CtrlUtil.isLinuxOS()) {
                return new NSOption[]{JWebBrowser.useXULRunnerRuntime(), NSPanelComponent.destroyOnFinalization(), NSPanelComponent.constrainVisibility()};
            }
        }
        return new NSOption[]{JWebBrowser.useWebkitRuntime(), NSPanelComponent.destroyOnFinalization(), NSPanelComponent.constrainVisibility()};
    }
}

