/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.cloud.ui;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import org.apache.log4j.Logger;

public class WaitSplash
extends KDPanel {
    static Logger logger = CommonLogger.getLogger(WaitSplash.class);
    private Image logo = EASResource.getImage((String)"imgPic_wait_coffeecup");
    private Toolkit toolkit = this.getToolkit();
    private int image_width;
    private int image_height;
    private String tipString = "\u6b63\u5728\u52a0\u8f7d,\u8bf7\u7a0d\u5019...";

    public WaitSplash() {
        this.loadImage(this.logo, 0);
        this.image_width = this.logo.getWidth((ImageObserver)((Object)this));
        this.image_height = this.logo.getHeight((ImageObserver)((Object)this));
        this.setCursor(new Cursor(3));
        this.setSize(this.image_width + 200, this.image_height);
        int Xpos = (this.toolkit.getScreenSize().width - this.getSize().width) / 2;
        int Ypos = (this.toolkit.getScreenSize().height - this.getSize().height) / 2;
        this.setBounds(Xpos, Ypos, this.getSize().width, this.getSize().height);
    }

    public void setWaitTip(String tipString) {
        this.tipString = tipString;
        this.repaint();
    }

    private void loadImage(Image image, int ID) {
        if (image != null) {
            MediaTracker tracker = new MediaTracker((Component)((Object)this));
            tracker.addImage(image, ID);
            try {
                tracker.waitForID(ID);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void paint(Graphics g) {
        int logoX = this.getSize().width / 2 - this.image_width;
        int logoY = this.getSize().height / 2 - this.image_height;
        if (this.logo != null) {
            g.drawImage(this.logo, logoX, logoY, this.image_width, this.image_height, (ImageObserver)((Object)this));
        }
        g.setColor(new Color(0, 0, 0));
        g.drawString(this.tipString, 10 + logoX + this.image_width, this.getSize().height / 2 - this.image_height / 2);
    }

    public void run() {
        this.setCursor(new Cursor(3));
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

