/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.bo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ExtReportOutDBBO {
    private static Logger log = LogUtil.getPackageLogger(ExtReportOutDBBO.class);
    private static HashMap cacheOtherDataCenter = new HashMap();

    public static ArrayList getDBList(Context ctx) throws BOSException {
        String sql = "select * from T_CTR_ExtReportOutDB";
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoListBySQL");
        pr.setString("sql", sql);
        pr.setObject("lstValue", new ArrayList());
        RptParams ps_r = FacadeFactory.commonExecute(ctx, pr);
        ArrayList dataList = (ArrayList)ps_r.getObject("object");
        return dataList;
    }

    public static synchronized void cacheDataCenter(Context ctx) throws BOSException {
        cacheOtherDataCenter.clear();
        ArrayList list = ExtReportOutDBBO.getDBList(ctx);
        for (HashMap mapData : list) {
            DataCenterInfo vo = new DataCenterInfo();
            vo.setDbCenterName(CtrlReportUtil.getObjectString(mapData.get("fdbcentername")));
            vo.setDbAddress(CtrlReportUtil.getObjectString(mapData.get("fdbaddress")));
            vo.setDbPort(Integer.parseInt(CtrlReportUtil.getObjectString(mapData.get("fdbport"))));
            vo.setDbType(Integer.parseInt(CtrlReportUtil.getObjectString(mapData.get("fdbtype"))));
            vo.setDbName(CtrlReportUtil.getObjectString(mapData.get("fdbname")));
            vo.setUser(CtrlReportUtil.getObjectString(mapData.get("fuser")));
            vo.setPwd(CtrlReportUtil.getObjectString(mapData.get("fpwd")));
            cacheOtherDataCenter.put(vo.getDbCenterName(), vo);
        }
    }

    public static void refreshServerCache(Context ctx) throws BOSException {
        log.error((Object)"refreshServerCache starting");
        RptParams pr = new RptParams();
        pr.setString("MethodName", "refreshCache");
        FacadeFactory.commonExecute(ctx, pr);
    }

    public static DataCenterInfo getDataCenterFromCache(Context ctx, String outDB) throws BOSException {
        if (cacheOtherDataCenter.isEmpty()) {
            ExtReportOutDBBO.refreshServerCache(ctx);
        }
        int i = 0;
        while (true) {
            if (cacheOtherDataCenter.containsKey(outDB)) {
                return (DataCenterInfo)cacheOtherDataCenter.get(outDB);
            }
            if (i != 0) break;
            ExtReportOutDBBO.refreshServerCache(ctx);
            ++i;
        }
        throw new OutDbNotFoundException("Not found the datacenter :" + outDB + ", please setup it first");
    }

    public static void insert(DataCenterInfo vo) throws BOSException {
        RptParams pr = new RptParams();
        ArrayList<Object> queryValue = new ArrayList<Object>();
        StringBuffer sb = new StringBuffer();
        sb.append("insert into T_CTR_ExtReportOutDB (FDbCenterName, FDbType, FDbAddress, FDbPort, FDbName, FUser, FPWD) values (?,?,?,?,?,?,?)");
        queryValue.add(vo.getDbCenterName());
        queryValue.add(new Integer(vo.getDbType()));
        queryValue.add(vo.getDbAddress());
        queryValue.add(new Integer(vo.getDbPort()));
        queryValue.add(vo.getDbName());
        queryValue.add(vo.getUser());
        queryValue.add(vo.getPwd());
        pr.setString("sql", sb.toString());
        pr.setObject("lstValue", queryValue);
        pr.setString("MethodName", "maintainRecord");
        ReportFacadeFactory.getRemoteInstance().commonExecute(pr);
    }

    public static void update(DataCenterInfo vo, DataCenterInfo voOld) throws BOSException {
        RptParams pr = new RptParams();
        ArrayList<Object> queryValue = new ArrayList<Object>();
        StringBuffer sb = new StringBuffer();
        sb.append("update T_CTR_ExtReportOutDB set FDbCenterName = ?, FDbType = ?, FDbAddress = ?, FDbPort = ?, FDbName = ?, FUser = ?, FPWD = ? where FDbCenterName = ?");
        queryValue.add(vo.getDbCenterName());
        queryValue.add(new Integer(vo.getDbType()));
        queryValue.add(vo.getDbAddress());
        queryValue.add(new Integer(vo.getDbPort()));
        queryValue.add(vo.getDbName());
        queryValue.add(vo.getUser());
        queryValue.add(vo.getPwd());
        queryValue.add(voOld.getDbCenterName());
        pr.setString("sql", sb.toString());
        pr.setObject("lstValue", queryValue);
        pr.setString("MethodName", "maintainRecord");
        ReportFacadeFactory.getRemoteInstance().commonExecute(pr);
    }

    public static final void del(String name) throws EASBizException, BOSException {
        RptParams pr = new RptParams();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(name);
        String sql = "delete T_CTR_ExtReportOutDB where FDbCenterName = ? ";
        pr.setString("sql", sql);
        pr.setObject("lstValue", queryValue);
        pr.setString("MethodName", "maintainRecord");
        ReportFacadeFactory.getRemoteInstance().commonExecute(pr);
    }

    public static class OutDbNotFoundException
    extends BOSException {
        private static final long serialVersionUID = -65536L;

        public OutDbNotFoundException(String message) {
            super(message);
        }
    }
}

