/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.bo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.ByteContentFactory;
import com.kingdee.eas.rpts.ctrlreport.ByteContentInfo;
import com.kingdee.eas.rpts.ctrlreport.IByteContent;
import com.kingdee.eas.rpts.ctrlreport.IReportSnap;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.rpts.ctrlreport.ReportSnapFactory;
import com.kingdee.eas.rpts.ctrlreport.ReportSnapInfo;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.rpts.ctrlsqldesign.model.DateUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportSnapBO {
    private static Logger log = LogUtil.getPackageLogger(ReportSnapBO.class);
    public static String beanFullName = "com.kingdee.eas.rpts.ctrlreport.app.ReportSnapControllerBean";

    public static ArrayList getReportSnapList(Context ctx, String systemID) throws BOSException, SQLException, EASBizException {
        ObjectUuidPK orgPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentOrgUnit().getId());
        String strLocal = SysContext.getSysContext().getLocale().toString();
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select s.fid, s.FSystemID, s.FOrgID, s.FReportID, d.FSnapType, s.FReportTime, d.FCreatorID as reportCreatorID,");
        sbSQL.append("s.Fname_").append(strLocal).append(" as snapname, ");
        sbSQL.append("s.FMemo_").append(strLocal).append(" as memo, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as reportname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("up.Fname_").append(strLocal).append(" as update_user_name, ");
        sbSQL.append("s.fcreatorid, s.FCreateTime, s.FLastUpdateUserID, s.flastupdatetime ");
        sbSQL.append("from T_EXT_ReportSnap s ");
        sbSQL.append("LEFT OUTER JOIN T_BAS_DefineReport d on s.freportid = d.fid ");
        sbSQL.append("LEFT OUTER JOIN t_pm_user u on s.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN t_pm_user up on s.FLastUpdateUserID=up.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on s.FOrgID=org.fid ");
        sbSQL.append("where s.FsystemID = ? ");
        sbSQL.append("and s.FOrgID = ? and s.fidflag is null ");
        sbSQL.append("order by s.flastupdatetime desc");
        log.debug((Object)("getReportSnapList sql = " + sbSQL.toString()));
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(systemID);
        queryValue.add(orgPk.toString());
        return ExtDBUtil.getResultListBySql(ctx, sbSQL.toString(), queryValue);
    }

    public static ArrayList getReportSnapListAllSystemID(Context ctx) throws BOSException, SQLException, EASBizException {
        ObjectUuidPK orgPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentOrgUnit().getId());
        String strLocal = SysContext.getSysContext().getLocale().toString();
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select s.fid, s.FSystemID, s.FOrgID, s.FReportID, d.FSnapType, s.FReportTime, d.FCreatorID as reportCreatorID,");
        sbSQL.append("s.Fname_").append(strLocal).append(" as snapname, ");
        sbSQL.append("s.FMemo_").append(strLocal).append(" as memo, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as reportname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("up.Fname_").append(strLocal).append(" as update_user_name, ");
        sbSQL.append("s.fcreatorid, s.FCreateTime, s.FLastUpdateUserID, s.flastupdatetime ");
        sbSQL.append("from T_EXT_ReportSnap s ");
        sbSQL.append("LEFT OUTER JOIN T_BAS_DefineReport d on s.freportid = d.fid ");
        sbSQL.append("LEFT OUTER JOIN t_pm_user u on s.FCreatorID=u.fid ");
        sbSQL.append("LEFT OUTER JOIN t_pm_user up on s.FLastUpdateUserID=up.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on s.FOrgID=org.fid ");
        sbSQL.append("where s.FOrgID = ? and s.fidflag is null ");
        sbSQL.append("order by s.flastupdatetime desc");
        log.debug((Object)("getReportSnapList sql = " + sbSQL.toString()));
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(orgPk.toString());
        return ExtDBUtil.getResultListBySql(null, sbSQL.toString(), queryValue);
    }

    public static ArrayList getSnapListByFlag(Context ctx, String strLocal, int snapType, String systemID, String fOrgID, String snapFlag) throws BOSException {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select s.fid ");
        sbSQL.append("from T_EXT_ReportSnap s ");
        sbSQL.append("LEFT OUTER JOIN T_BAS_DefineReport d on s.freportid = d.fid ");
        sbSQL.append("where d.FSnapType = ? ");
        sbSQL.append("and s.fSystemID = ?  And s.fOrgID = ? And s.fsnapflag = ?");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(String.valueOf(snapType));
        queryValue.add(systemID);
        queryValue.add(fOrgID);
        queryValue.add(snapFlag);
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoListBySQL");
        pr.setString("sql", sbSQL.toString());
        pr.setObject("lstValue", queryValue);
        RptParams ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
        ArrayList dataList = (ArrayList)ps_r.getObject("object");
        return dataList;
    }

    public static ReportSnapInfo getReportSnapInfo(Context ctx, String fid) throws BOSException, SQLException, EASBizException {
        IReportSnap snap = null;
        snap = ctx == null ? ReportSnapFactory.getRemoteInstance() : ReportSnapFactory.getLocalInstance(ctx);
        ReportSnapInfo info = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)fid, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = snap.getCollection(entityViewInfo);
        if (collection != null && !collection.isEmpty()) {
            info = (ReportSnapInfo)collection.get(0);
        }
        return info;
    }

    public static ByteContentInfo getByteContentInfo(Context ctx, String fid) throws BOSException, SQLException, EASBizException {
        IByteContent snap = null;
        snap = ctx == null ? ByteContentFactory.getRemoteInstance() : ByteContentFactory.getLocalInstance(ctx);
        ByteContentInfo info = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)fid, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = snap.getCollection(entityViewInfo);
        if (collection != null && !collection.isEmpty()) {
            info = (ByteContentInfo)collection.get(0);
        }
        return info;
    }

    public static ArrayList getReportSnapByReportID(Context ctx, String reportID) throws BOSException {
        String sql = "select fid from T_EXT_ReportSnap where FReportID = ?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(reportID);
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoListBySQL");
        pr.setString("sql", sql);
        pr.setObject("lstValue", queryValue);
        RptParams ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
        ArrayList dataList = (ArrayList)ps_r.getObject("object");
        return dataList;
    }

    public static int getReportSnapInfoCount(Context ctx, String fReportID, String systemID) throws BOSException, SQLException, EASBizException {
        return ReportSnapBO.getReportSnapInfoCount(ctx, fReportID, systemID, null);
    }

    public static int getReportSnapInfoCount(Context ctx, String fReportID, String systemID, String fOrgID) throws BOSException, SQLException, EASBizException {
        int intRet = 0;
        IReportSnap snap = null;
        snap = ctx == null ? ReportSnapFactory.getRemoteInstance() : ReportSnapFactory.getLocalInstance(ctx);
        if (null == fOrgID) {
            fOrgID = ctx == null ? SysContext.getSysContext().getCurrentOrgUnit().getId().toString() : ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("reportID", (Object)fReportID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)fOrgID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("systemID", (Object)systemID, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and #1 and #2");
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = snap.getCollection(entityViewInfo);
        if (collection != null && !collection.isEmpty()) {
            intRet = collection.size();
        }
        return intRet;
    }

    public static boolean isexist(Context ctx, String strId, String fSystemID, String fname, String strLocal) throws BOSException {
        return ReportSnapBO.isexist(ctx, strId, fSystemID, fname, strLocal, null);
    }

    public static boolean isexist(Context ctx, String strId, String fSystemID, String fname, String strLocal, String fOrgID) throws BOSException {
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuffer sbSQL = new StringBuffer();
        if (null == fOrgID) {
            fOrgID = ctx == null ? SysContext.getSysContext().getCurrentOrgUnit().getId().toString() : ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        }
        if (CtrlReportUtil.getObjectString(strId).equals("")) {
            sbSQL.append("SELECT top 1 FID FROM T_EXT_ReportSnap WHERE fSystemID = ?  And fOrgID = ? ");
            sbSQL.append("and FName_").append(strLocal).append(" = ? ");
            queryValue.add(fSystemID);
            queryValue.add(fOrgID);
            queryValue.add(fname);
        } else {
            sbSQL.append("SELECT top 1 FID FROM T_EXT_ReportSnap WHERE fid <> ? AND fSystemID = ? And fOrgID = ? ");
            sbSQL.append("and FName_").append(strLocal).append(" = ?");
            queryValue.add(strId);
            queryValue.add(fSystemID);
            queryValue.add(fOrgID);
            queryValue.add(fname);
        }
        RptParams pr = new RptParams();
        pr.setString("MethodName", "exitsRecordBySQL");
        pr.setString("sql", sbSQL.toString());
        pr.setObject("lstValue", queryValue);
        RptParams ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
        return ps_r.getBoolean("flag");
    }

    public static void importSaveSnap(ReportSnapInfo snapInfo, ByteContentInfo byteInfo, String flastupdatetime) throws BOSException {
        String newPKID = null;
        if (snapInfo.getId() == null) {
            newPKID = ReportSnapBO.insert(null, snapInfo, byteInfo);
        } else {
            ReportSnapBO.update(null, snapInfo, byteInfo);
            newPKID = snapInfo.getId().toString();
        }
        if (flastupdatetime != null && flastupdatetime.length() > 0) {
            RptParams pr = new RptParams();
            ArrayList<String> queryValue = new ArrayList<String>();
            queryValue.add(newPKID);
            String sql = "update T_EXT_ReportSnap set flastupdatetime = {ts'" + flastupdatetime + "'} where fid = ?";
            pr.setString("sql", sql);
            pr.setObject("lstValue", queryValue);
            pr.setString("MethodName", "maintainRecord");
            ReportFacadeFactory.getRemoteInstance().commonExecute(pr);
        }
    }

    public static String insert(Context ctx, ReportSnapInfo snapInfo, ByteContentInfo byteInfo) throws BOSException {
        RptParams pr = new RptParams();
        pr.setObject("FullName", (Object)beanFullName);
        pr.setObject("MethodName", (Object)"insert");
        pr.setObject("ReportSnapInfo", (Object)snapInfo);
        pr.setObject("ByteContentInfo", (Object)byteInfo);
        RptParams pr_r = FacadeFactory.commonExecuteRequired(ctx, pr);
        String newPKID = pr_r.getString("Flag");
        return newPKID;
    }

    public static void update(Context ctx, ReportSnapInfo snapInfo, ByteContentInfo byteInfo) throws BOSException {
        RptParams pr = new RptParams();
        pr.setObject("FullName", (Object)beanFullName);
        pr.setObject("MethodName", (Object)"update");
        pr.setObject("ReportSnapInfo", (Object)snapInfo);
        pr.setObject("ByteContentInfo", (Object)byteInfo);
        FacadeFactory.commonExecuteRequired(ctx, pr);
    }

    public static void delete(ArrayList lstPK) throws BOSException {
        RptParams pr = new RptParams();
        int size = lstPK.size();
        IObjectPK[] arrayPK = new IObjectPK[size];
        for (int i = 0; i < size; ++i) {
            String strPK = lstPK.get(i).toString();
            BOSUuid tempID = BOSUuid.read((String)strPK);
            ObjectUuidPK pk = new ObjectUuidPK("id", tempID);
            arrayPK[i] = pk;
        }
        pr.setObject("FullName", (Object)beanFullName);
        pr.setObject("MethodName", (Object)"delete");
        pr.setObject("IObjectPKs", (Object)arrayPK);
        FacadeFactory.commonExecuteRequired(null, pr);
    }

    private static ArrayList getReportSnapListByType(Context ctx, Map parmMap) throws BOSException {
        String reportID = CtrlReportUtil.getObjectString(parmMap.get("reportID"));
        String orgOrUnitID = CtrlReportUtil.getObjectString(parmMap.get("orgOrUnitID"));
        String reportPeriod = CtrlReportUtil.getObjectString(parmMap.get("reportPeriod"));
        String sumRangeID = CtrlReportUtil.getObjectString(parmMap.get("sumRangeID"));
        String taskDistributeID = CtrlReportUtil.getObjectString(parmMap.get("taskDistributeID"));
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select s.fid, s.FReportTime ");
        sbSQL.append("from T_EXT_ReportSnap s ");
        sbSQL.append("LEFT OUTER JOIN T_BAS_DefineReport d on s.freportid = d.fid ");
        sbSQL.append("LEFT OUTER JOIN T_EXT_TaskDistribute td on s.FTaskDistributeID = td.fid");
        sbSQL.append("where s.freportid = ? And s.fOrgID = ? and td.FReportPeriod = ? and td.FSumRangeID = ? and td.FID = ? ");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(reportID);
        queryValue.add(orgOrUnitID);
        queryValue.add(reportPeriod);
        queryValue.add(sumRangeID);
        queryValue.add(taskDistributeID);
        return ExtDBUtil.getResultListBySql(ctx, sbSQL.toString(), queryValue);
    }

    public static HashMap existSameTypeSnap(Context ctx, Map parmMap) throws Exception {
        ArrayList lstReportSnap = ReportSnapBO.getReportSnapListByType(ctx, parmMap);
        if (lstReportSnap.isEmpty()) {
            return null;
        }
        String currentSnapDate = CtrlReportUtil.getObjectString(parmMap.get("currentSnapDate"));
        String reportPeriod = CtrlReportUtil.getObjectString(parmMap.get("reportPeriod"));
        int iSnapTypeValue = Integer.parseInt(reportPeriod);
        String[] currentSnapDateArr = DateUtil.getDateTimeArr(currentSnapDate);
        String currentYear = currentSnapDateArr[0];
        String currentMonth = currentSnapDateArr[1];
        String currentDay = currentSnapDateArr[2];
        switch (iSnapTypeValue) {
            case 1: {
                for (HashMap map : lstReportSnap) {
                    String freporttime = CtrlReportUtil.getObjectString(map.get("freporttime"));
                    if (!freporttime.startsWith(currentYear)) continue;
                    return map;
                }
                break;
            }
            case 2: {
                String yearHalfBegin = "";
                String yearHalfEnd = "";
                for (HashMap map : lstReportSnap) {
                    String[] arr;
                    String freporttime = CtrlReportUtil.getObjectString(map.get("freporttime"));
                    if (freporttime.equals("")) continue;
                    String[] dtArr = DateUtil.getDateTimeArr(freporttime = CtrlReportUtil.formatDateTime(freporttime));
                    int monthTemp = Integer.parseInt(dtArr[1]);
                    if (monthTemp <= 6) {
                        yearHalfBegin = currentYear + "-01-01";
                        yearHalfEnd = currentYear + "-06-30";
                    } else {
                        yearHalfBegin = currentYear + "-07-01";
                        yearHalfEnd = currentYear + "-12-31";
                    }
                    if ((freporttime = (arr = freporttime.split(" "))[0]).compareTo(yearHalfBegin) < 0 || freporttime.compareTo(yearHalfEnd) > 0) continue;
                    return map;
                }
                break;
            }
            case 3: {
                String quarBegin = DateUtil.getDateOfQuarter(currentSnapDate, true);
                String quarEnd = DateUtil.getDateOfQuarter(currentSnapDate, false);
                for (HashMap map : lstReportSnap) {
                    String freporttime = CtrlReportUtil.getObjectString(map.get("freporttime"));
                    if (freporttime.equals("")) continue;
                    freporttime = CtrlReportUtil.formatDateTime(freporttime);
                    String[] arr = freporttime.split(" ");
                    if ((freporttime = arr[0]).compareTo(quarBegin) < 0 || freporttime.compareTo(quarEnd) > 0) continue;
                    return map;
                }
                break;
            }
            case 4: {
                for (HashMap map : lstReportSnap) {
                    String[] dtArr;
                    String monthTemp;
                    String freporttime = CtrlReportUtil.getObjectString(map.get("freporttime"));
                    if (freporttime.equals("") || !currentMonth.equals(monthTemp = (dtArr = DateUtil.getDateTimeArr(freporttime = CtrlReportUtil.formatDateTime(freporttime)))[1])) continue;
                    return map;
                }
                break;
            }
            case 5: {
                String monthHalfBegin = "";
                String monthHalfEnd = "";
                for (HashMap map : lstReportSnap) {
                    String[] arr;
                    String freporttime = CtrlReportUtil.getObjectString(map.get("freporttime"));
                    if (freporttime.equals("")) continue;
                    String[] dtArr = DateUtil.getDateTimeArr(freporttime = CtrlReportUtil.formatDateTime(freporttime));
                    int dayTemp = Integer.parseInt(dtArr[2]);
                    if (dayTemp <= 15) {
                        monthHalfBegin = currentYear + "-" + currentMonth + "-01";
                        monthHalfEnd = currentYear + "-" + currentMonth + "-15";
                    } else {
                        monthHalfBegin = currentYear + "-" + currentMonth + "-16";
                        monthHalfEnd = currentYear + "-" + currentMonth + "-31";
                    }
                    if ((freporttime = (arr = freporttime.split(" "))[0]).compareTo(monthHalfBegin) < 0 || freporttime.compareTo(monthHalfEnd) > 0) continue;
                    return map;
                }
                break;
            }
            case 7: {
                Date date = DateUtil.sdf_yyyy_MM_dd.parse(currentSnapDate);
                String weekBegin = DateUtil.getDateOfWeek(date, 0);
                String weekEnd = DateUtil.getDateOfWeek(date, 6);
                for (HashMap map : lstReportSnap) {
                    String freporttime = CtrlReportUtil.getObjectString(map.get("freporttime"));
                    if (freporttime.equals("")) continue;
                    freporttime = CtrlReportUtil.formatDateTime(freporttime);
                    String[] arr = freporttime.split(" ");
                    if ((freporttime = arr[0]).compareTo(weekBegin) < 0 || freporttime.compareTo(weekEnd) > 0) continue;
                    return map;
                }
                break;
            }
            case 6: {
                for (HashMap map : lstReportSnap) {
                    String dateTimeString;
                    String freporttime = CtrlReportUtil.getObjectString(map.get("freporttime"));
                    if (!freporttime.startsWith(dateTimeString = currentYear + "-" + currentMonth + "-" + currentDay)) continue;
                    return map;
                }
                break;
            }
        }
        return null;
    }

    public static String getSnapFlagByType(int iSnapTypeValue, String currentSnapDate) throws Exception {
        if (iSnapTypeValue == -1 || iSnapTypeValue == 0) {
            return "empty";
        }
        String[] currentSnapDateArr = DateUtil.getDateTimeArr(currentSnapDate);
        String currentYear = currentSnapDateArr[0];
        String currentMonth = currentSnapDateArr[1];
        String currentDay = currentSnapDateArr[2];
        String strRet = "";
        switch (iSnapTypeValue) {
            case 1: {
                strRet = currentYear + "-01-01";
                break;
            }
            case 2: {
                if (Integer.parseInt(currentMonth) <= 6) {
                    strRet = currentYear + "-01-01";
                    break;
                }
                strRet = currentYear + "-07-01";
                break;
            }
            case 3: {
                String quarBegin;
                strRet = quarBegin = DateUtil.getDateOfQuarter(currentSnapDate, true);
                break;
            }
            case 4: {
                strRet = currentYear + "-" + currentMonth + "-01";
                break;
            }
            case 5: {
                if (Integer.parseInt(currentDay) <= 15) {
                    strRet = currentYear + "-" + currentMonth + "-01";
                    break;
                }
                strRet = currentYear + "-" + currentMonth + "-16";
                break;
            }
            case 7: {
                String weekBegin;
                Date date = DateUtil.sdf_yyyy_MM_dd.parse(currentSnapDate);
                strRet = weekBegin = DateUtil.getDateOfWeek(date, 0);
                break;
            }
            case 6: {
                strRet = currentYear + "-" + currentMonth + "-" + currentDay;
                break;
            }
        }
        return strRet;
    }

    public static final void updateByteLength(int length) {
        try {
            RptParams pr = new RptParams();
            ArrayList queryValue = new ArrayList();
            String sql = "delete T_EXT_ByteLength";
            pr.setString("sql", sql);
            pr.setObject("lstValue", queryValue);
            pr.setString("MethodName", "maintainRecord");
            ReportFacadeFactory.getRemoteInstance().commonExecuteNever(pr);
            sql = "insert into T_EXT_ByteLength(FLength) values(" + length + ")";
            pr.setString("sql", sql);
            pr.setObject("lstValue", queryValue);
            pr.setString("MethodName", "maintainRecord");
            ReportFacadeFactory.getRemoteInstance().commonExecuteNever(pr);
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public static final void alterByteContent(int length) {
        try {
            RptParams pr = new RptParams();
            ArrayList queryValue = new ArrayList();
            String sql = "alter table T_EXT_ByteContent alter FContent BLOB(" + length + ")";
            pr.setString("sql", sql);
            pr.setObject("lstValue", queryValue);
            pr.setString("MethodName", "maintainRecord");
            ReportFacadeFactory.getRemoteInstance().commonExecuteNever(pr);
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }
}

