/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.data;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import java.util.HashMap;
import java.util.Map;

public class PermissionKind {
    public static final String NO_PERM = "0";
    public static final String HAS_PERM = "1";
    public static final int DEFAULT_PRINT_NUM = 100;
    public static final int INT_VIEW = 0;
    public static final int INT_EXPORT = 1;
    public static final int INT_PRINT = 2;
    public static final int INT_PRINTNumber = 3;
    public static final int INT_MESSAGE_VIEW = 4;
    public static final PermissionKind VIEW = new PermissionKind("\u67e5\u770b\u6743", 0);
    public static final PermissionKind EXPORT = new PermissionKind("\u5bfc\u51fa\u6743", 1);
    public static final PermissionKind PRINT = new PermissionKind("\u6253\u5370\u6743", 2);
    public static final PermissionKind PRINTNumber = new PermissionKind("\u6253\u5370\u6b21\u6570", 3);
    public static final PermissionKind MESSAGE = new PermissionKind("\u6d88\u606f\u63a5\u6536\u6743", 4);
    public static final PermissionKind[] PermissionKinds = new PermissionKind[]{VIEW, EXPORT, PRINT, PRINTNumber, MESSAGE};
    public static final String NoAllPermission = "0;0;0";
    private String name;
    private int intValue;

    private PermissionKind(String name, int i) {
        this.name = name;
        this.intValue = i;
    }

    public int intValue() {
        return this.intValue;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public static final PermissionKind getPermissionKind(int intValue) {
        for (int i = 0; i < PermissionKinds.length; ++i) {
            PermissionKind pk = PermissionKinds[i];
            if (pk.intValue != intValue) continue;
            return pk;
        }
        return VIEW;
    }

    public static final PermissionKind getPermissionKind(String strValue) {
        int intValue = 0;
        if (!CtrlReportUtil.getObjectString(strValue).equals("")) {
            intValue = Integer.parseInt(strValue);
        }
        return PermissionKind.getPermissionKind(intValue);
    }

    private static final Map getPermissionKindMap(String permission, PermissionKind kind) {
        HashMap<PermissionKind, String> map = new HashMap<PermissionKind, String>();
        String[] perArr = permission.split(";");
        int perArrLength = perArr.length;
        for (int i = 0; i < PermissionKinds.length; ++i) {
            PermissionKind pk = PermissionKinds[i];
            String currentPerString = "";
            if (i < perArrLength) {
                currentPerString = perArr[i];
            }
            map.put(pk, currentPerString);
        }
        return map;
    }

    public static final String getPermissionString(String permission, PermissionKind kind) {
        Map map = PermissionKind.getPermissionKindMap(permission, kind);
        String flag = CtrlReportUtil.getObjectString(map.get(kind));
        if (StringUtil.isEmptyString((String)flag) && MESSAGE == kind) {
            flag = HAS_PERM;
        }
        return flag;
    }

    public static final boolean isHoldPermission(String permission, PermissionKind kind) {
        String value = PermissionKind.getPermissionString(permission, kind);
        return !value.equals(NO_PERM);
    }

    public static final String getPrintNumber(String permission, PermissionKind kind) {
        Map map = PermissionKind.getPermissionKindMap(permission, kind);
        return CtrlReportUtil.getObjectString(map.get(kind));
    }
}

