/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.macro.ui.action;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroDesignException;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.macro.resources.Resources;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.IExtRptMacroSelectionAware;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.action.AbstractExtRptAction;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.action.IExtRptMacroActionHost;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.mutex.MacroMutexLockService;
import java.awt.Component;
import java.util.ArrayList;
import org.apache.log4j.Logger;

class DeleteAction
extends AbstractExtRptAction
implements IExtRptMacroSelectionAware {
    private static Logger logger = CommonLogger.getLogger(DeleteAction.class);
    private static final long serialVersionUID = 1L;
    private ArrayList<String> mIdList = new ArrayList();
    private StringBuilder confirmPrompt;
    private StringBuilder ignorePrompt;

    DeleteAction(IExtRptMacroActionHost host) throws MacroDesignException {
        super(host, "\u5220\u9664", "imgTbtn_delete");
        host.register(this);
    }

    @Override
    protected boolean actionPerformed(IExtRptMacroActionHost host, IExtRptMacroController controller) {
        MacroVO[] selections = host.getSelections();
        if (selections == null || selections.length == 0) {
            return false;
        }
        this.mIdList.clear();
        if (this.check(selections) && MessageUtil.msgboxOkCancel(null, (String)this.confirmPrompt.toString())) {
            try {
                controller.d(this.mIdList.toArray(new String[0]));
                return true;
            }
            catch (MacroDesignException e) {
                logger.error((Object)e);
                MessageUtil.msgboxWarning((Component)this.window, (String)Resources.getResourceString("\u5220\u9664\u5b8f\u5931\u8d25\u3002"), (String)e.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public void selectionChanged(MacroVO[] currentSelection) {
        this.setEnabled(currentSelection != null && currentSelection.length > 0);
    }

    private boolean check(MacroVO[] selections) {
        this.confirmPrompt = new StringBuilder(Resources.getResourceString("\u786e\u5b9a\u8981\u5c06"));
        this.ignorePrompt = new StringBuilder();
        int deleteCount = 0;
        int index = 0;
        for (int i = 0; i < selections.length; ++i) {
            MacroVO vo = selections[i];
            String macroName = vo.getMacro().name();
            if (!MacroMutexLockService.requestLock(macroName, null)) {
                this.ignorePrompt.append("\u3010").append(vo.getMacro().name()).append("\u3011");
                continue;
            }
            MacroMutexLockService.releaseLock(macroName);
            this.mIdList.add(vo.getUuid());
            ++deleteCount;
            index = i;
        }
        if (deleteCount > 1) {
            this.confirmPrompt.append(Resources.getResourceString("\u8fd9")).append(deleteCount).append(Resources.getResourceString("\u4e2a"));
        } else {
            this.confirmPrompt.append("\u3010").append(selections[index].getMacro().name()).append("\u3011");
        }
        this.confirmPrompt.append(Resources.getResourceString("\u5b8f\u5220\u9664\u5417\uff1f"));
        if (this.ignorePrompt.length() != 0) {
            this.ignorePrompt.append(Resources.getResourceString("\u5df2\u88ab\u5176\u4ed6\u7f16\u8f91\u64cd\u4f5c\u9501\u5b9a"));
            MessageUtil.msgboxInfo((Component)this.window, (String)this.ignorePrompt.toString());
            if (this.mIdList.isEmpty()) {
                return false;
            }
        }
        return true;
    }
}

