/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.macro.ui.action;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroDesignException;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.macro.resources.Resources;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.IExtRptMacroSelectionAware;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.action.AbstractExtRptAction;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.action.IExtRptMacroActionHost;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.designer.ExtRptMacroDesignUI;
import com.kingdee.eas.rpts.ctrlreport.macro.ui.mutex.MacroMutexLockService;
import java.awt.Component;
import org.apache.log4j.Logger;

class EditAction
extends AbstractExtRptAction
implements IExtRptMacroSelectionAware {
    private static Logger logger = CommonLogger.getLogger(EditAction.class);
    private static final long serialVersionUID = 1L;

    EditAction(IExtRptMacroActionHost host) throws MacroDesignException {
        super(host, "\u7f16\u8f91", "imgTbtn_edit");
        host.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean actionPerformed(IExtRptMacroActionHost host, IExtRptMacroController controller) {
        MacroVO selection = host.getSelections()[0];
        String macroName = selection.getMacro().name();
        if (!MacroMutexLockService.requestLock(macroName, host.getCoreUI())) {
            return false;
        }
        try {
            ExtRptMacroDesignUI.showMacroDesigner(this.window, selection, controller);
            boolean bl = true;
            return bl;
        }
        catch (MacroDesignException e) {
            logger.error((Object)"failed to init ui", (Throwable)e);
            MessageUtil.msgboxWarning((Component)this.window, (String)Resources.getResourceString("\u6253\u5f00\u5b8f\u5b9a\u4e49\u8bbe\u8ba1\u5668\u5931\u8d25\u3002"), (String)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            MacroMutexLockService.releaseLock(macroName);
        }
    }

    @Override
    public void selectionChanged(MacroVO[] currentSelection) {
        this.setEnabled(currentSelection != null && currentSelection.length == 1);
    }
}

