/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.macro.ui.designer;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.base.uiframe.client.UINewTabFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroDesignException;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroRuntimeException;
import com.kingdee.eas.rpts.ctrlreport.macro.exec.ExtRptMacroExecuteFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroType;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroValue;
import com.kingdee.eas.rpts.ctrlreport.macro.resources.Resources;
import com.kingdee.eas.rpts.ctrlreport.model.SQLCustomType;
import com.kingdee.eas.rpts.ctrlsqldesign.client.DesignUI;
import com.kingdee.eas.rpts.ctrlsqldesign.client.PreviewKSQLPanelUI;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.KsqlObjectSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MacroValueDisplayPanel
extends CoreUI {
    private static final long serialVersionUID = 1L;
    private static Logger logger = CommonLogger.getLogger(MacroValueDisplayPanel.class);
    private MacroVO macro;
    private KDTable previewTable;

    public MacroValueDisplayPanel(MacroVO macro) throws Exception {
        this.macro = macro;
        this.initUIContentLayout();
    }

    public MacroValueDisplayPanel() throws Exception {
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.getTableForCommon();
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 10, 998, 613);
        cons.anchor = 15;
        this.previewTable.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.add((Component)this.previewTable);
        this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 1013, 629));
        this.setLayout((LayoutManager)new KDLayout());
        this.setPreferredSize(new Dimension(480, 300));
    }

    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        KDToolBar toolBar = this.getUIToolBar();
        toolBar.add((Action)new RefreshAction());
    }

    public void onLoad() throws Exception {
        this.macro = (MacroVO)this.getUIContext().get("InitDataObject");
        this.refreshTable(true);
    }

    private void refreshTable(boolean isShouldAbort) {
        MacroValue value;
        try {
            value = ExtRptMacroExecuteFacade.remoteExecute(null, this.macro);
        }
        catch (MacroRuntimeException e) {
            logger.error((Object)"failed to execute", (Throwable)e);
            MsgBox.showInfo((Component)((Object)this), (String)Resources.getResourceString("\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5b8f\u5b9a\u4e49\u3002"));
            if (isShouldAbort) {
                this.abort();
            }
            return;
        }
        this.previewTable.removeRows();
        this.previewTable.removeHeadRows();
        this.previewTable.removeColumns();
        IRow headRow0 = this.previewTable.addHeadRow();
        boolean isFirst = true;
        for (String string : value.getColums()) {
            this.previewTable.addColumn().setKey(string);
            headRow0.getCell(string).setValue((Object)(string + (isFirst ? "\uff08\u5b8f\u503c\uff09" : "")));
            isFirst = false;
        }
        for (String string : value.getValues()) {
            IRow row = this.previewTable.addRow();
            int col = 0;
            for (String dataCell : string) {
                row.getCell(col++).setValue(dataCell.getValue());
            }
        }
    }

    protected KDTable getTableForCommon() {
        this.previewTable = new KDTable();
        this.previewTable.getSelectManager().setSelectMode(10);
        return this.previewTable;
    }

    public boolean destroyWindow() {
        return true;
    }

    public String getUITitle() {
        return (String)this.getUIContext().get("MainMenuName");
    }

    public static void showInMainFrame(Component parent, String macroName, String macroUuid, MacroVO macro) {
        IUIWindow uiWindow;
        Frame mainFrame = UIFrameUtil.getCurrMainFrame((Component)parent);
        UIContext uiContext = new UIContext((Object)mainFrame);
        uiContext.put((Object)"InitDataObject", (Object)macro);
        uiContext.put((Object)"UIClassParam", (Object)macroUuid);
        uiContext.put((Object)"MainMenuName", (Object)macroName);
        uiContext.put((Object)"isEntryFromMenu", (Object)"false");
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)UINewTabFactory.class.getName());
            uiWindow = uiFactory.create(MacroValueDisplayPanel.class.getName(), (Map)uiContext, null, null);
        }
        catch (UIException e1) {
            logger.error((Object)Resources.getResourceString("\u521d\u59cb\u5316\u5b8f\u9884\u89c8\u754c\u9762\u5931\u8d25\u3002"), (Throwable)e1);
            MsgBox.showInfo((Component)parent, (String)Resources.getResourceString("\u521d\u59cb\u5316\u5b8f\u9884\u89c8\u754c\u9762\u5931\u8d25\u3002"));
            return;
        }
        uiWindow.show();
    }

    public void showInModalDialog(Component parent) {
        if (!(parent instanceof Window)) {
            parent = SwingUtilities.getWindowAncestor(parent);
        }
        final KDDialog dialog = parent instanceof Frame ? new KDDialog((Frame)parent) : (parent instanceof Dialog ? new KDDialog((Dialog)parent) : new KDDialog());
        dialog.setDefaultCloseOperation(2);
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setTitle(Resources.getResourceString("\u9884\u89c8"));
        KDPanel dialogPanel = new KDPanel((LayoutManager)new BorderLayout());
        if (this.macro.getMacro().mType() == ExtRptMacroType.MType.FUNCTION) {
            dialogPanel.add((Component)((Object)this));
            this.refreshTable(false);
            KDPanel southPanel = new KDPanel((LayoutManager)new BorderLayout());
            KDPanel controlPanel = new KDPanel((LayoutManager)new FlowLayout(2, 6, 6));
            KDButton confirm = new KDButton(Resources.getResourceString("\u786e\u5b9a"));
            confirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.dispose();
                }
            });
            controlPanel.add((Component)confirm);
            southPanel.add((Component)new KDSeparator(), (Object)"North");
            southPanel.add((Component)controlPanel, (Object)"South");
            dialogPanel.add((Component)southPanel, (Object)"South");
        } else {
            try {
                CtrlDesignQueryModel model = new CtrlDesignQueryModel();
                model.setObjectSelector(new KsqlObjectSelector());
                model.setQuery((IQuery)new CtrlDesignKsqlQuery(true));
                try {
                    CtrlDesignUtil.toObject(null, model, XmlUtil.loadXmlStream((InputStream)new ByteArrayInputStream(this.macro.getMacro().define().getBytes("UTF-8"))));
                }
                catch (Exception e) {
                    throw MacroDesignException.newFailed2LoadMacroModelException(e);
                }
                PreviewKSQLPanelUI ui = new PreviewKSQLPanelUI(model, this.macro);
                HashMap<String, SQLCustomType> mapData = DesignUI.getInstance().getMapData();
                if (mapData == null) {
                    mapData = new HashMap<String, SQLCustomType>();
                }
                mapData.put("customType", SQLCustomType.SQL);
                DesignUI.getInstance().setMapData(mapData);
                ui.preview(true, true);
                if (ui.getUIContext().get("report_ui_error") != null) {
                    MsgBox.showInfo((Component)parent, (String)Resources.getResourceString("\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5b8f\u5b9a\u4e49\u3002"));
                    return;
                }
                ui.configBtn4MacroPreview();
                KDLayout.Constraints cons = new KDLayout.Constraints();
                cons.originalBounds = new Rectangle(10, 10, 788, 450);
                cons.anchor = 15;
                ui.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
                dialogPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(10, 10, 800, 450));
                dialogPanel.setLayout((LayoutManager)new KDLayout());
                dialogPanel.setPreferredSize(new Dimension(800, 450));
                dialogPanel.add((Component)ui);
            }
            catch (Exception e) {
                logger.error((Object)Resources.getResourceString("\u521d\u59cb\u5316\u5b8f\u9884\u89c8\u754c\u9762\u5931\u8d25\u3002"), (Throwable)e);
                MsgBox.showInfo((Component)parent, (String)Resources.getResourceString("\u521d\u59cb\u5316\u5b8f\u9884\u89c8\u754c\u9762\u5931\u8d25\u3002"));
                return;
            }
        }
        dialog.setContentPane((Container)dialogPanel);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.show();
    }

    private class RefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        RefreshAction() {
            super(Resources.getResourceString("\u5237\u65b0"), Resources.getResourceIcon("imgTbtn_refresh"));
            this.putValue("ShortDescription", Resources.getResourceString("\u5237\u65b0"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MacroValueDisplayPanel.this.refreshTable(false);
        }
    }
}

