/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.mobile.server;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.CardContentBo;
import com.kingdee.eas.rpts.ctrlreport.mobile.util.MobileCardUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.apache.log4j.Logger;

public class CardContentDAO {
    private static Logger logger = CommonLogger.getLogger(CardContentDAO.class);
    public static final int BLOB_SIZE = 32768;

    public static void addContent(Context ctx, CardContentBo bo) throws ExtRptBizException {
        String sql = "insert into T_EXT_CARDCONTENT(FID,FCARDID,FLASTUPDATETIME,FCARDCONTENT,FCONTENTINDEX) values(?,?,?,?,?)";
        try {
            CardContentDAO.writeBlock(ctx, sql, bo);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newCardContentFailed2Execute(e);
        }
    }

    public static void getContentUpdateTime(Context ctx, String cardId) {
        String sql = "select FLASTUPDATETIME from T_EXT_CARDCONTENT where FCARDID=? and FCONTENTINDEX=0";
    }

    public static void deleteByCardId(Context ctx, String cardId) throws ExtRptBizException {
        String sql = "delete from T_EXT_CARDCONTENT where fcardid=?";
        Object[] params = new Object[]{cardId};
        try {
            MobileCardUtil.execute(ctx, sql, params);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newFailed2DeleteCardContentExecute(e);
        }
    }

    public static void updateContent(Context ctx, CardContentBo bo) throws ExtRptBizException {
        try {
            CardContentDAO.deleteByCardId(ctx, bo.getCardId());
            CardContentDAO.addContent(ctx, bo);
        }
        catch (ExtRptBizException e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newFailed2UpdateCardContent(e);
        }
    }

    public static CardContentBo getContentByCardId(Context ctx, String cardId) throws ExtRptBizException {
        String sql = "SELECT FCARDCONTENT, FLASTUPDATETIME FROM T_EXT_CARDCONTENT WHERE FCARDID=? ORDER BY FCONTENTINDEX ASC";
        Object[] params = new Object[]{cardId};
        try {
            return MobileCardUtil.queryCardContent(ctx, sql, params);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw ExtRptBizException.newFailed2GetCardContent(e);
        }
    }

    private static void writeBlock(Context ctx, String sql, CardContentBo bo) throws SQLException {
        byte[] blockData = bo.getCardContent();
        Integer length = blockData.length;
        if (length > 0) {
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (int i = 0; i < count; ++i) {
                Object[] param = new Object[5];
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                param[0] = UUID.randomUUID().toString();
                param[1] = bo.getCardId();
                param[2] = new Date();
                param[3] = CardContentDAO.createSqlParameterBytes(blockData, offset, contentSize);
                param[4] = i;
                offset += contentSize;
                params.add(param);
            }
            MobileCardUtil.executeBatch(ctx, sql, params);
        }
    }

    public static Object createSqlParameterBytes(byte[] buf, int offset, int length) {
        byte[] subBlock = new byte[length];
        System.arraycopy(buf, offset, subBlock, 0, length);
        return subBlock;
    }
}

