/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.mobile.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.mobile.model.MobileReportInfo;
import com.kingdee.eas.rpts.ctrlreport.mobile.model.MobileType;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class MobileTypeDAO {
    public RptParams getMobileReportInfoList(Context ctx, RptParams params) throws SQLException, BOSException {
        params.setObject("mobile_type_list", this.getAllMobileTypeList());
        params.setObject("mobile_rpt_list", this.getPublishedMobileRptList());
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RptParams getCloudMobileTypeList(Context ctx, RptParams params) throws SQLException {
        String sql = "select distinct mt.* from t_ext_mobiletype mt left join T_BAS_DEFINEREPORT dp on mt.Fid = dp.FSYSTEMID where mt.FPubAcctId = '718ea531-103a-467a-9cf5-7e07410373a5'  and dp.Fid is not null  order by fordernumber";
        IRowSet rs = null;
        ArrayList<MobileType> typeList = new ArrayList<MobileType>();
        try {
            rs = DbUtil.executeQuery(sql, null);
            if (rs != null) {
                while (rs.next()) {
                    MobileType mobileType = new MobileType();
                    mobileType.setId(rs.getString("fid"));
                    mobileType.setName(rs.getString("fname"));
                    mobileType.setOrderNumber(rs.getInt("fordernumber"));
                    mobileType.setPubAcctId(rs.getString("fpubacctid"));
                    typeList.add(mobileType);
                }
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        params.setObject("mobile_cloud_rpt_list", typeList);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MobileType> getAllMobileTypeList() throws SQLException {
        String sql = "select * from t_ext_mobiletype where fid not in (select distinct mt.fid from t_ext_mobiletype mt left join T_BAS_DefineReport r on mt.Fid = r.FSYSTEMID  where mt.FpubAcctId='718ea531-103a-467a-9cf5-7e07410373a5' and r.Fid is null ) order by fordernumber";
        IRowSet rs = null;
        ArrayList<MobileType> typeList = new ArrayList<MobileType>();
        try {
            rs = DbUtil.executeQuery(sql, null);
            if (rs != null) {
                while (rs.next()) {
                    MobileType mobileType = new MobileType();
                    mobileType.setId(rs.getString("fid"));
                    mobileType.setName(rs.getString("fname"));
                    mobileType.setOrderNumber(rs.getInt("fordernumber"));
                    mobileType.setPubAcctId(rs.getString("fpubacctid"));
                    typeList.add(mobileType);
                }
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return typeList;
    }

    public ArrayList<MobileReportInfo> getPublishedMobileRptListByTypeId(String typeId) throws SQLException {
        Object[] params;
        String typeWhere;
        if (StringUtil.isEmptyString((String)typeId)) {
            typeWhere = " and fmobiletypeid is null";
            params = new Object[]{2};
        } else {
            typeWhere = " and fmobiletypeid=?";
            params = new Object[]{2, typeId};
        }
        String sql = "select fid, fname_l2, fmobilename, fmobiletypeid, m.forderNumber from t_bas_definereport d left outer join T_EXT_MobileOrderNum m on d.fid=m.freportid where ftemplettype=? and fmobilename is not null";
        sql = sql + typeWhere;
        sql = sql + " order by m.forderNumber, fmobileDeployTime desc";
        return this.getMobileRptList(sql, params);
    }

    private ArrayList<MobileReportInfo> getPublishedMobileRptList() throws SQLException {
        String sql = "select fid, fname_l2, fmobilename, d.fmobiletypeid, m.forderNumber from t_bas_definereport d left outer join T_EXT_MobileOrderNum m on d.fid=m.freportid where ftemplettype=? and fmobilename is not null order by m.forderNumber, fmobileDeployTime desc";
        Object[] params = new Object[]{2};
        return this.getMobileRptList(sql, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<MobileReportInfo> getMobileRptList(String sql, Object[] params) throws SQLException {
        IRowSet rs = null;
        ArrayList<MobileReportInfo> infoList = new ArrayList<MobileReportInfo>();
        try {
            rs = DbUtil.executeQuery(sql, params);
            if (rs != null) {
                while (rs.next()) {
                    MobileReportInfo reportInfo = new MobileReportInfo();
                    reportInfo.setId(rs.getString("fid"));
                    reportInfo.setName(rs.getString("fname_l2"));
                    reportInfo.setPublishedName(rs.getString("fmobilename"));
                    reportInfo.setTypeId(rs.getString("fmobiletypeid"));
                    String orderNumber = rs.getString("forderNumber");
                    if (!StringUtil.isEmptyString((String)orderNumber)) {
                        reportInfo.setOrderNumber(Integer.valueOf(orderNumber));
                    }
                    infoList.add(reportInfo);
                }
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return infoList;
    }

    public RptParams deleteMobileTypeById(Context ctx, RptParams params) throws SQLException, BOSException {
        MobileType type = (MobileType)params.getObject("MobileType");
        String typeId = type.getId();
        String sql = "delete from t_ext_mobileType where fid=?";
        int resultType = DbUtil.executeUpdate(sql, new Object[]{typeId});
        params.setInt("resultType", resultType);
        return params;
    }

    public RptParams insertMobileType(Context ctx, RptParams params) throws SQLException, BOSException {
        MobileType type = (MobileType)params.getObject("MobileType");
        String typeId = type.getId();
        String typeName = type.getName();
        int orderNumber = type.getOrderNumber();
        String pubAcctId = type.getPubAcctId();
        if (this.hasSameName(typeName, pubAcctId)) {
            throw new BOSException("has the same name: " + typeName);
        }
        String sql = "insert into t_ext_mobileType values(?,?,?,?)";
        int resultType = DbUtil.executeUpdate(ctx, sql, new Object[]{typeId, typeName, orderNumber, pubAcctId});
        params.setInt("resultType", resultType);
        return params;
    }

    public RptParams updateMobileTypeById(Context ctx, RptParams params) throws SQLException, BOSException {
        String pubAcctId;
        MobileType type = (MobileType)params.getObject("MobileType");
        String typeId = type.getId();
        String typeName = type.getName();
        if (this.hasSameName(typeName, pubAcctId = type.getPubAcctId())) {
            throw new BOSException("has the same name: " + typeName);
        }
        String sql = "update t_ext_mobileType set fname=? where fid=?";
        int resultType = DbUtil.executeUpdate(ctx, sql, new Object[]{typeName, typeId});
        params.setInt("resultType", resultType);
        return params;
    }

    public RptParams moveTypePosition(Context ctx, RptParams params) throws SQLException {
        MobileType[] typeArr = (MobileType[])params.getObject("MobileParams");
        String[] sql = new String[typeArr.length];
        for (int i = 0; i < typeArr.length; ++i) {
            sql[i] = new StringBuffer().append("update t_ext_mobileType set fordernumber=").append(typeArr[i].getOrderNumber()).append(" where fid='").append(typeArr[i].getId()).append("'").toString();
        }
        boolean resultType = DbUtil.executeBatchUpdate(ctx, sql);
        params.setBoolean("resultType", resultType);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasSameName(String typeName, String pubAcctId) throws SQLException {
        IRowSet rs;
        block2: {
            boolean bl;
            rs = null;
            String sql = "select 1 from t_ext_mobileType where fname=? and fpubAcctId=?";
            try {
                rs = DbUtil.executeQuery(sql, new Object[]{typeName, pubAcctId});
                if (rs == null || !rs.next()) break block2;
                bl = true;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return false;
    }

    public RptParams moveReportPosition(Context ctx, RptParams params) throws SQLException {
        boolean updateAll = (Boolean)params.getObject("updateAll");
        ArrayList rptInfoList = (ArrayList)params.getObject("MobileParams");
        if (rptInfoList == null || rptInfoList.isEmpty()) {
            params.setBoolean("resultType", false);
            return params;
        }
        String[] sql = new String[rptInfoList.size() + 1];
        MobileReportInfo reportInfo = null;
        for (int i = 0; i < rptInfoList.size(); ++i) {
            reportInfo = (MobileReportInfo)rptInfoList.get(i);
            sql[i] = updateAll ? new StringBuffer().append("insert into t_ext_mobileOrderNum(forderNumber, freportId, fmobileTypeId) values (").append(reportInfo.getOrderNumber()).append(",'").append(reportInfo.getId()).append("','").append(reportInfo.getTypeId()).append("')").toString() : new StringBuffer().append("update t_ext_mobileOrderNum set forderNumber=").append(reportInfo.getOrderNumber()).append(" where freportId='").append(reportInfo.getId()).append("' and fmobileTypeId='").append(reportInfo.getTypeId()).append("'").toString();
        }
        if (updateAll && null != reportInfo) {
            String sqlDelete = "delete from t_ext_mobileOrderNum where fmobileTypeId=?";
            DbUtil.executeUpdate(ctx, sqlDelete, new Object[]{reportInfo.getTypeId()});
        }
        boolean resultType = DbUtil.executeBatchUpdate(ctx, sql);
        params.setBoolean("resultType", resultType);
        return params;
    }
}

