/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.mobile.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.snapshot.dispatch.server.app.MobileSnapshotDAO;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PubAcctsDAO {
    private static final String TABLE_NAME = "T_EXT_XUNT_PUBACCT";
    private static final String COLUMN_FID = "FID";
    private static final String COLUMN_ID = "FPUBACCTID";
    private static final String COLUMN_NAME = "FPUBACCTNAME";
    private static final String COLUMN_KEY = "FPUBACCTKEY";
    private static final String COLUMN_DESCRIPTION = "FDESCRIPTION";
    private static final String COLUMN_PIC = "FPICDATA";
    private static final String COLUMN_CREATETIME = "FCREATETIME";
    private static final String COLUMN_FCOMPANYEID = "FCOMPANYEID";
    private static final String COLOMN_FPUBACCTMSGTYPE = "FPUBACCTMSGTYPE";

    public static ArrayList<PubAcct> listPubAccts(Context easCtx) throws ExtRptBizException {
        return PubAcctsDAO.listPubAccts(easCtx, null);
    }

    public static ArrayList<PubAcct> listPubAccts(Context easCtx, String lastRefreshTime) throws ExtRptBizException {
        Timestamp ts = null;
        String string = lastRefreshTime = lastRefreshTime != null ? lastRefreshTime.trim() : "";
        if (!(lastRefreshTime.equals("") || lastRefreshTime.equals("0") || lastRefreshTime.equalsIgnoreCase("NaN"))) {
            ts = new Timestamp(Long.parseLong(lastRefreshTime.trim()));
        }
        String sql = "select FID,FPUBACCTID,FPUBACCTNAME,FPUBACCTKEY,FDESCRIPTION,FPICDATA,FCOMPANYEID,FPUBACCTMSGTYPE from T_EXT_XUNT_PUBACCT order by FCREATETIME";
        ArrayList<PubAcct> ret = new ArrayList<PubAcct>();
        try {
            ArrayList rowset = (ArrayList)PubAcctsDAO.executeQuery(new RptParams(), sql, easCtx).getObject("object");
            for (HashMap item : rowset) {
                PubAcct acct = new PubAcct();
                PubAcctsDAO.fillVO(easCtx, acct, item, ts);
                ret.add(acct);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ExtRptBizException.newFailed2LoadPubAcctsException(e);
        }
        return ret;
    }

    public static ArrayList<PubAcct> listPubAcctsHasReport(Context easCtx, String lastRefreshTime) throws ExtRptBizException {
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)easCtx);
        String userId = currentUserInfo.getId().toString();
        Timestamp ts = null;
        String string = lastRefreshTime = lastRefreshTime != null ? lastRefreshTime.trim() : "";
        if (!(lastRefreshTime.equals("") || lastRefreshTime.equals("0") || lastRefreshTime.equalsIgnoreCase("NaN"))) {
            ts = new Timestamp(Long.parseLong(lastRefreshTime.trim()));
        }
        String sql = "select distinct x.FID, x.FPUBACCTID, x.FPUBACCTNAME, x.FCREATETIME from T_EXT_XUNT_PUBACCT x  left join T_BAS_DefineReport d on x.fid= d.fpubacctid  LEFT OUTER JOIN t_pm_user u on d.FCreatorID=u.fid  LEFT OUTER JOIN T_ORG_BaseUnit org on d.FOrgID=org.fid  LEFT OUTER JOIN t_ext_mobiletype t on d.fmobiletypeid=t.fid  LEFT OUTER JOIN t_ext_mobileOrderNum o on o.freportid=d.fid  where d.fid in  (select p.FReportID from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r  on p.FReportID = r.fid  where p.FUserID = ? and fmobilename is not null  union all select p.FReportID from T_EXT_Permission p  INNER JOIN T_BAS_DefineReport r on p.FReportID = r.fid  where p.FUserID = ?  and p.FOrgID is null and fmobilename is not null  union all select p.FReportID  from T_EXT_Permission p  INNER JOIN T_BAS_DefineReport r  on p.FReportID = r.fid  INNER JOIN t_pm_userroleorg uro ON p.froleid = uro.froleid  where uro.FUserID = ? and fmobilename is not null  union all  select r.FID as FReportID from T_EXT_CloudReportDownloadList crdl  left join (select * from t_bas_definereport where FCloudRptVersion IS NOT NULL ) r on r.FCloudRptCenterId = crdl.FCloudRptId  where crdl.FUserId = ? and r.FTempletType=2 and r.FPubAcctId is not null ) order by x.FCREATETIME";
        RptParams params = new RptParams();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(userId);
        queryValue.add(userId);
        queryValue.add(userId);
        queryValue.add(userId);
        params.setObject("lstValue", queryValue);
        ArrayList<PubAcct> ret = new ArrayList<PubAcct>();
        try {
            ArrayList rowset = (ArrayList)PubAcctsDAO.executeQuery(params, sql, easCtx).getObject("object");
            for (HashMap item : rowset) {
                PubAcct acct = new PubAcct();
                PubAcctsDAO.fillVO(easCtx, acct, item, ts);
                ret.add(acct);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ExtRptBizException.newFailed2LoadPubAcctsException(e);
        }
        return ret;
    }

    public static boolean isEmptyPubAcct(Context easCtx, String pubAcctId) throws ExtRptBizException {
        try {
            return DefineReportBO.getMobileReportList(easCtx, pubAcctId, 1).isEmpty();
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw ExtRptBizException.newFailed2LoadPubAcctsException(e);
        }
    }

    private static void fillVO(Context easCtx, PubAcct acct, HashMap<String, Object> item, Timestamp ts) throws ExtRptBizException {
        acct.fid = (String)item.get(COLUMN_FID.toLowerCase());
        acct.xtPubAcctId = (String)item.get(COLUMN_ID.toLowerCase());
        acct.name = (String)item.get(COLUMN_NAME.toLowerCase());
        acct.key = (String)item.get(COLUMN_KEY.toLowerCase());
        acct.description = (String)item.get(COLUMN_DESCRIPTION.toLowerCase());
        acct.picData = (byte[])item.get(COLUMN_PIC.toLowerCase());
        acct.createTime = (Timestamp)item.get(COLUMN_CREATETIME.toLowerCase());
        acct.eid = (String)item.get(COLUMN_FCOMPANYEID.toLowerCase());
        acct.msgType = (String)item.get(COLOMN_FPUBACCTMSGTYPE.toLowerCase());
        if (easCtx != null) {
            acct.unread = ts != null ? MobileSnapshotDAO.unreadMessages(easCtx, PubAcctsDAO.getCurrentUserInfoId(easCtx), acct.fid, ts) : 0;
            acct.lastMessage = MobileSnapshotDAO.lastUnreadMessage(easCtx, PubAcctsDAO.getCurrentUserInfoId(easCtx), acct.fid, null);
        }
    }

    private static String getCurrentUserInfoId(Context easCtx) {
        if (easCtx == null) {
            return SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        }
        return easCtx.getCaller().toString();
    }

    public static PubAcct findPubAcct(Context easCtx, String pubAcctId) throws ExtRptBizException {
        PubAcct ret = new PubAcct();
        String sql = "select FPUBACCTID,FID,FPUBACCTNAME,FPUBACCTKEY,FDESCRIPTION,FPICDATA,FCOMPANYEID,FPUBACCTMSGTYPE from T_EXT_XUNT_PUBACCT where FID=?";
        RptParams params = new RptParams();
        ArrayList<String> list = new ArrayList<String>();
        list.add(pubAcctId);
        params.setObject("lstValue", list);
        try {
            ArrayList rowset = (ArrayList)PubAcctsDAO.executeQuery(params, sql, easCtx).getObject("object");
            Iterator iterator = rowset.iterator();
            if (iterator.hasNext()) {
                HashMap item = (HashMap)iterator.next();
                PubAcctsDAO.fillVO(easCtx, ret, item, null);
            }
        }
        catch (Exception e) {
            throw ExtRptBizException.newPubAcctPicVisitException(e);
        }
        return ret;
    }

    public static void addPubAcct(PubAcct acct) throws BOSException {
        String sql = "insert into T_EXT_XUNT_PUBACCT(FID,FPUBACCTID,FPUBACCTNAME,FPUBACCTKEY,FDESCRIPTION,FPICDATA,FCOMPANYEID,FPUBACCTMSGTYPE,FCREATETIME) values(?,?,?,?,?,?,?,?,now())";
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(acct.fid);
        list.add(acct.xtPubAcctId);
        list.add(acct.name);
        list.add(acct.key);
        list.add(acct.description);
        list.add(acct.picData);
        list.add(acct.eid);
        list.add(acct.msgType);
        PubAcctsDAO.execute(sql, list);
    }

    public static void deletePubAcct(String pubAcctId) throws BOSException {
        String sql = "delete T_EXT_XUNT_PUBACCT where FID=?";
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(pubAcctId);
        PubAcctsDAO.execute(sql, list);
    }

    public static void updatePubAcctID(String oldId, String newId) throws BOSException {
        String sql = "update T_EXT_XUNT_PUBACCTset FPUBACCTID=? where FPUBACCTID=?";
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(newId);
        list.add(oldId);
        PubAcctsDAO.execute(sql, list);
    }

    public static void updatePubAcctKey(String id, String key) throws BOSException {
        String sql = "update T_EXT_XUNT_PUBACCTset FPUBACCTKEY=? where FPUBACCTID=?";
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(key);
        list.add(id);
        PubAcctsDAO.execute(sql, list);
    }

    public static void updatePubAcctName(String id, String name) throws BOSException {
        String sql = "update T_EXT_XUNT_PUBACCT set FPUBACCTNAME=? where FID=?";
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(name);
        list.add(id);
        PubAcctsDAO.execute(sql, list);
    }

    public static void updatePubAcctDescription(String id, String description) throws BOSException {
        String sql = "update T_EXT_XUNT_PUBACCTset FDESCRIPTION=? where FPUBACCTID=?";
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(description);
        list.add(id);
        PubAcctsDAO.execute(sql, list);
    }

    public static void updatePubAcctPic(String id, byte[] pic) throws BOSException {
        String sql = "update T_EXT_XUNT_PUBACCTset FPICDATA=? where FPUBACCTID=?";
        ArrayList<Object> list = new ArrayList<Object>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Blob", pic);
        map.put("Length", pic.length);
        list.add(map);
        list.add(id);
        PubAcctsDAO.execute(sql, list);
    }

    public static void updatePubAcctCompanyEid(String id, String eid) throws BOSException {
        String sql = "update T_EXT_XUNT_PUBACCTset FCOMPANYEID=? where FPUBACCTID=?";
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(eid);
        list.add(id);
        PubAcctsDAO.execute(sql, list);
    }

    public static void updatePubAcctMsgType(String id, String msgType) throws BOSException {
        String sql = "update T_EXT_XUNT_PUBACCTset FPUBACCTMSGTYPE=? where FPUBACCTID=?";
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(msgType);
        list.add(id);
        PubAcctsDAO.execute(sql, list);
    }

    public static void updatePubAccts(List<PubAcct> pubAccts) throws BOSException {
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<String> sqlList = new ArrayList<String>();
        for (PubAcct pubAcct : pubAccts) {
            sqlBuilder.append("update ").append(TABLE_NAME).append(" set ").append(COLUMN_ID).append("='").append(pubAcct.xtPubAcctId).append("', ").append(COLUMN_KEY).append("='").append(pubAcct.key).append("', ").append(COLUMN_DESCRIPTION).append("='").append(pubAcct.description).append("', ").append(COLUMN_FCOMPANYEID).append("='").append(pubAcct.eid).append("', ").append(COLOMN_FPUBACCTMSGTYPE).append("='").append(pubAcct.msgType).append("' where ").append(COLUMN_FID).append("='").append(pubAcct.fid).append("'");
        }
        PubAcctsDAO.executeBatch(sqlList);
    }

    private static void execute(String sql, ArrayList<Object> list) throws BOSException {
        RptParams params = new RptParams();
        params.setString("MethodName", "maintainRecord");
        params.setString("sql", sql);
        params.setObject("lstValue", list);
        ReportFacadeFactory.getRemoteInstance().commonExecute(params);
    }

    private static RptParams executeQuery(RptParams params, String sql, Context easCtx) throws BOSException {
        params.setString("sql", sql);
        params.setString("MethodName", "getInfoListBySQL");
        params = easCtx == null ? ReportFacadeFactory.getRemoteInstance().commonExecute(params) : ReportFacadeFactory.getLocalInstance(easCtx).commonExecute(params);
        return params;
    }

    private static void executeBatch(List<String> sqlList) throws BOSException {
        RptParams params = new RptParams();
        params.setString("MethodName", "executeBatch");
        params.setObject("sqlList", sqlList);
        ReportFacadeFactory.getRemoteInstance().commonExecute(params);
    }

    public static class PubAcct {
        public String fid;
        public String xtPubAcctId;
        public String name;
        public String key;
        public String description;
        public String eid;
        public String msgType;
        public int unread;
        public byte[] picData;
        public Timestamp createTime;
        public Map<String, Object> lastMessage;
    }
}

