/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.bo.KSQLReportBO;
import com.kingdee.eas.rpts.ctrlreport.model.CheckJavaDataSetException;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.KSQLReportInfo;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.SqlDSModelDrill;
import com.kingdee.eas.rpts.ctrlsqldesign.param.IJavaDataSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CheckJavaDataSet {
    private static final Logger logger = CommonLogger.getLogger(CheckJavaDataSet.class);

    public static boolean checkUIType(Context ctx, String id) throws CheckJavaDataSetException {
        return CheckJavaDataSet.checkUIType(ctx, id, null, null, null);
    }

    public static boolean checkUIType(Context ctx, String id, String reportName, String systemId, String curOrgId) throws CheckJavaDataSetException {
        try {
            Book _book;
            DefineReportInfo reportInfo = DefineReportBO.getReportInfo(ctx, id);
            if (reportInfo == null) {
                reportInfo = DefineReportBO.getReportInfo(ctx, systemId, reportName, curOrgId, id);
            }
            if (!CheckJavaDataSet.checkUIType(_book = MiscUtil.unpack((byte[])reportInfo.getContent()), ctx)) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new CheckJavaDataSetException(e);
        }
        return true;
    }

    public static boolean checkUIType(Book book, Context ctx) throws CheckJavaDataSetException, BOSException {
        try {
            ExtDataSetManager dataSetManager = book.getDataSetManager();
            int size = dataSetManager.size();
            for (int i = 0; i < size; ++i) {
                ExtDataSet dataSet = dataSetManager.getAt(i);
                int customType = 0;
                String meta = dataSet.getMeta();
                if (StringUtil.isEmptyString((String)meta)) {
                    String define = dataSet.getDefine();
                    HashMap mapDefine = RunReportParam.splitDefineToMap(define);
                    if ("sql_ksql".endsWith((String)mapDefine.get("DataSetType"))) {
                        String dbsourcename;
                        String dbsourceid = CtrlReportUtil.getObjectString(mapDefine.get("DbSourceID"));
                        String orgID = CtrlReportUtil.getObjectString(mapDefine.get("OrgID"));
                        String systemid = CtrlReportUtil.getObjectString(mapDefine.get("SystemID"));
                        KSQLReportInfo info = KSQLReportBO.getKSQLReportInfo(ctx, systemid, dbsourcename = CtrlReportUtil.getObjectString(mapDefine.get("DbSourceName")), orgID, dbsourceid);
                        if (info == null) continue;
                        customType = info.getCustomType();
                        meta = new String(info.getContent());
                    }
                } else {
                    String innerLinkXmlString = SqlDSModelDrill.split2(meta);
                    if (innerLinkXmlString.indexOf(CtrlDesignUtil.CustomType + "=\"3\"") != -1) {
                        customType = 3;
                        meta = innerLinkXmlString;
                    }
                }
                if (3 != customType) continue;
                ArrayList className = CheckJavaDataSet.getClassName(meta);
                for (int j = 0; j < className.size(); ++j) {
                    IJavaDataSet iJavaDataSet = (IJavaDataSet)Class.forName(className.get(j).toString()).newInstance();
                    if (!iJavaDataSet.isUIType()) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new CheckJavaDataSetException(e);
        }
        return true;
    }

    private static ArrayList getClassName(String xml) {
        ArrayList<String> javaNodes = new ArrayList<String>();
        String regEx = ".+(<Java(.*?)</Java>)";
        Pattern p = Pattern.compile(regEx, 32);
        Matcher m = p.matcher(xml);
        while (m.find()) {
            javaNodes.add(m.group(1));
        }
        regEx = ".+fullname=\"(.*?)\"";
        p = Pattern.compile(regEx, 32);
        ArrayList<String> className = new ArrayList<String>();
        for (int i = 0; i < javaNodes.size(); ++i) {
            m = p.matcher(javaNodes.get(i).toString());
            while (m.find()) {
                className.add(m.group(1));
            }
        }
        return className;
    }
}

