/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.model;

import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.rpts.ctrlreport.bo.KSQLReportBO;
import com.kingdee.eas.rpts.ctrlreport.datasetfactory.IExtendReport;
import com.kingdee.eas.rpts.ctrlreport.datasetfactory.SQLReportImpl;
import com.kingdee.eas.rpts.ctrlreport.permission.IReportPermission;
import com.kingdee.eas.rpts.ctrlreport.permission.PermissionEasImpl;
import com.kingdee.eas.rpts.ctrlreport.sql.EntitySQL;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CtrlReportQuery {
    private static final ArrayList toLowerCase(List lst) throws SQLException {
        ArrayList lstNew = new ArrayList();
        if (lst != null) {
            for (Map map : lst) {
                HashMap mapNew = new HashMap();
                for (String key : map.keySet()) {
                    mapNew.put(key.toLowerCase(), map.get(key));
                }
                lstNew.add(mapNew);
            }
        }
        return lstNew;
    }

    public static ArrayList getDbSourceListBySystemID(String strFlag, String systemID) throws Exception {
        IExtendReport report = CtrlReportQuery.getIReportInstance(null, strFlag, systemID);
        IRowSet rs = report.getDbSourceListBySystemID(systemID);
        ArrayList lst = ExtDBUtil.setDataToList((ResultSet)rs);
        return lst;
    }

    public static ArrayList getMobileKSQLListBySystemID(String systemID) throws Exception {
        RptParams params = new RptParams();
        ArrayList<String> queryValue = new ArrayList<String>();
        String strSQL = EntitySQL.getKSQLListSQLWithoutOrg();
        queryValue.add(systemID);
        params.setString("MethodName", "getDBInfoBySQL");
        params.setString("sql", strSQL);
        params.setObject("lstValue", queryValue);
        RptParams ps_r = ReportFacadeFactory.getRemoteInstance().commonExecute(params);
        IRowSet rs = (IRowSet)ps_r.getObject("object");
        ArrayList lst = ExtDBUtil.setDataToList((ResultSet)rs);
        return lst;
    }

    public static ArrayList getDbSourceFieldList(String strFlag, String dbsourceid) throws Exception {
        return CtrlReportQuery.getDbSourceFieldList(strFlag, dbsourceid, null);
    }

    public static ArrayList getDbSourceFieldList(String strFlag, String dbsourceid, String innerXmlContent) throws Exception {
        List lst = null;
        if (innerXmlContent != null) {
            lst = CtrlReportQuery.getDbSrcFieldListFromXml(innerXmlContent);
        } else {
            IExtendReport report = CtrlReportQuery.getIReportInstance(null, strFlag, dbsourceid);
            lst = report.getDbSourceFieldList(dbsourceid);
        }
        ArrayList lstRet = CtrlReportQuery.toLowerCase(lst);
        return lstRet;
    }

    private static ArrayList getDbSrcFieldListFromXml(String innerXmlContent) throws CtrlReportException {
        CtrlDesignQueryModel model = KSQLReportBO.initModelFromXml(innerXmlContent);
        ArrayList list = SQLReportImpl.getSqlReportDbSrcFieldList(model);
        return list;
    }

    public static IExtendReport getIReportInstance(HashMap mapIReport, String strFlag, String dbsourceid) throws Exception {
        IExtendReport report = null;
        if (mapIReport == null) {
            report = strFlag.equals("2") ? new SQLReportImpl() : (IExtendReport)Class.forName(CtrlReportQuery.getDBSetType(strFlag)).newInstance();
            return report;
        }
        if (mapIReport.containsKey(dbsourceid)) {
            report = (IExtendReport)mapIReport.get(dbsourceid);
        } else {
            report = strFlag.equals("2") ? new SQLReportImpl() : (IExtendReport)Class.forName(CtrlReportQuery.getDBSetType(strFlag)).newInstance();
            mapIReport.put(dbsourceid, report);
        }
        return report;
    }

    private static String getDBSetType(String strFlag) {
        String DBType = null;
        if (strFlag.equals("3")) {
            DBType = "com.kingdee.eas.rpts.ctrlreport.datasetfactory.QueryReportImpl";
        } else if (strFlag.equals("4")) {
            DBType = "com.kingdee.eas.rpts.ctrlreport.app.FixReport";
        } else if (strFlag.equals("6")) {
            DBType = "com.kingdee.eas.rpts.ctrlreport.datasetfactory.EnumReportImpl";
        } else if (strFlag.equals("7")) {
            DBType = "com.kingdee.eas.rpts.ctrlreport.datasetfactory.JavaReportImpl";
        }
        return DBType;
    }

    public static IReportPermission getIReportPermissionInstance() throws Exception {
        PermissionEasImpl permission = null;
        permission = new PermissionEasImpl();
        return permission;
    }
}

