/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.permission;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.model.DiscreteDataFetchImp;
import com.kingdee.eas.rpts.ctrlreport.permission.IReportPermission;
import java.util.Map;
import org.apache.log4j.Logger;

public class PermissionEasImpl
implements IReportPermission {
    private static final Logger logger = CoreUIObject.getLogger(PermissionEasImpl.class);

    @Override
    public boolean hasDataPermission(Map map) throws Exception {
        IPermission permission = null;
        boolean flag = false;
        try {
            permission = PermissionFactory.getRemoteInstance();
            ObjectUuidPK userPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentUserInfo().getId());
            String report_id = CtrlReportUtil.getObjectString(map.get("report_id"));
            BOSUuid bid = BOSUuid.read((String)report_id);
            ObjectUuidPK reportPK = new ObjectUuidPK("id", bid);
            DiscreteDataFetchImp dsf = new DiscreteDataFetchImp();
            OrgType orgType = dsf.getBizDataOrgType((IObjectPK)reportPK);
            String permItemName = "ctrl_report_view_report_" + orgType.getName();
            flag = permission.hasDataPermission((IObjectPK)userPk, null, permItemName, (IObjectPK)reportPK);
        }
        catch (Exception e1) {
            logger.debug((Object)e1);
        }
        return flag;
    }

    @Override
    public boolean hasFunctionPermission(Map map) throws Exception {
        boolean flag = false;
        IPermission permission = PermissionFactory.getRemoteInstance();
        ObjectUuidPK orgPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentOrgUnit().getId());
        ObjectUuidPK userPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentUserInfo().getId());
        flag = permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ctrl_report_management");
        return flag;
    }

    @Override
    public boolean isPermissionByItemName(String permItemName) throws Exception {
        boolean flag = false;
        IPermission permission = PermissionFactory.getRemoteInstance();
        ObjectUuidPK orgPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentOrgUnit().getId());
        ObjectUuidPK userPk = new ObjectUuidPK("id", SysContext.getSysContext().getCurrentUserInfo().getId());
        flag = permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permItemName);
        return flag;
    }
}

