/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.propelling;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.PubAcctsDAO;
import com.kingdee.eas.rpts.ctrlreport.propelling.runtime.exception.MessageServiceException;
import com.kingdee.eas.rpts.ctrlreport.propelling.runtime.handler.XuntMessageHandler;
import com.kingdee.eas.rpts.ctrlreport.propelling.runtime.model.AbstractTypedExtMessage;
import com.kingdee.eas.rpts.ctrlreport.propelling.runtime.model.xunt.XuntExtMessage;
import com.kingdee.eas.rpts.snapshot.dispatch.server.app.MobileSnapshotDAO;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.log4j.Logger;

public class ExtMessageService {
    private static Logger logger = CommonLogger.getLogger(ExtMessageService.class);
    private XuntMessageHandler xHandler;
    private Context easCtx;
    public static String fileName = System.getProperty("ctrlhome") + File.separator + "ext4xunt" + File.separator + "settings.properties";
    private static Properties extProps = new Properties();

    private static void loadFromFile() {
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(fileName));
            extProps.load(in);
        }
        catch (IOException e) {
            try {
                logger.error((Object)"------can not load ext for xunt properties------", (Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{in});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{in});
        }
        CloseUtil.close((Closeable[])new Closeable[]{in});
        String xtEnv = System.getProperty("xt.properties.dir");
        if (xtEnv == null) {
            xtEnv = System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "properties" + File.separator + "mobile";
            if (!new File(xtEnv).exists()) {
                xtEnv = System.getProperty("EAS_HOME") + File.separator + extProps.getProperty("xt.properties.dir");
            }
            if (!new File(xtEnv).exists()) {
                logger.error((Object)"-------------failed to config xuntong enviroment-------------");
            }
        }
        System.setProperty("xt.properties.dir", xtEnv);
    }

    public ExtMessageService(Context easCtx) {
        this.easCtx = easCtx;
        this.loadXuntHandler();
    }

    private void loadXuntHandler() {
        ArrayList<PubAcctsDAO.PubAcct> accts = new ArrayList();
        try {
            accts = PubAcctsDAO.listPubAccts(this.easCtx);
        }
        catch (ExtRptBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        this.xHandler = new XuntMessageHandler(accts, this.pubVisitUrl());
    }

    public void pushMessage(AbstractTypedExtMessage message) {
        logger.error((Object)"----------------push message start----------------");
        switch (message.type()) {
            case XUNT: {
                XuntExtMessage xunt = (XuntExtMessage)message;
                List<String> users = xunt.getUsers();
                try {
                    MobileSnapshotDAO.tranlasteUserID4Xunt(this.easCtx, users);
                }
                catch (MessageServiceException e) {
                    logger.error((Object)e);
                    throw new IllegalArgumentException("translate userId to personId failed.", e);
                }
                this.xHandler.handle(this.easCtx, xunt);
                break;
            }
            default: {
                logger.warn((Object)"---------unknown message---------");
                logger.warn((Object)message.type());
                logger.warn((Object)message.message());
                logger.warn((Object)message.rptName());
                logger.warn((Object)message.rptId());
                logger.warn((Object)"---------------------------------");
            }
        }
        logger.error((Object)"----------------push message end----------------");
    }

    public String pubVisitUrl() {
        return "https://mbos.kdeascloud.com/mbos/page/loadPage?path=mobileReport&name=snapshot.navui";
    }

    static {
        File file = new File(fileName);
        FileAlterationObserver observer = new FileAlterationObserver(file.getParent());
        FileAlterationListenerAdaptor listener = new FileAlterationListenerAdaptor(){

            public void onFileChange(File file) {
                if (file.getName().toLowerCase(Locale.CHINA).equals("settings.properties")) {
                    logger.info((Object)("---------------------" + fileName + " file changed.already reloaded---------------------"));
                    extProps.clear();
                    ExtMessageService.loadFromFile();
                }
            }
        };
        observer.addListener((FileAlterationListener)listener);
        try {
            new FileAlterationMonitor(TimeUnit.SECONDS.toMillis(3L), new FileAlterationObserver[]{observer}).start();
        }
        catch (Exception e) {
            logger.debug((Object)"start file monitor error", (Throwable)e);
        }
    }
}

