/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.propelling.design;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.pe.beans.editor.formula.FormulaTextArea;
import com.kingdee.bos.ctrl.ext.ui.wizards.propelling.exception.ValidateException;
import com.kingdee.bos.ctrl.ext.ui.wizards.propelling.model.ExtMessage;
import com.kingdee.bos.ctrl.ext.ui.wizards.propelling.model.IndexDefine;
import com.kingdee.bos.ctrl.ext.ui.wizards.propelling.model.PropellingModel;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.util.ExtURL;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.eas.rpts.ctrlreport.model.ExtCallbackImpl;
import com.kingdee.eas.rpts.ctrlreport.propelling.design.AbstractMessageType;
import com.kingdee.eas.rpts.ctrlreport.propelling.design.DispatchAndPushSettingPanel;
import com.kingdee.eas.rpts.ctrlreport.propelling.design.TypeImage;
import com.kingdee.eas.rpts.ctrlreport.propelling.design.TypeMetro;
import com.kingdee.eas.rpts.ctrlreport.propelling.design.TypeTextOnly;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PushAndWarningWizard
extends KDDialog
implements ISpreadWizzard {
    private static Logger logger = CommonLogger.getLogger(PushAndWarningWizard.class);
    private Book book;
    private KDPanel pushAndWarning;
    private KDRadioButton radioTextOnly;
    private KDRadioButton radioTextPic;
    private KDRadioButton radioTextMetro;
    private AbstractMessageType msgType;
    private KDPanel msgTypePanel;
    private KDPanel sytleAndContentPanel;
    private KDPanel previewPanel;
    private KDPanel msgContentPanel;
    private KDButton btnOk;
    private KDButton btnCancel;
    private FormulaTextArea preConditionComposer;
    private boolean isCancel = false;
    private IndexDefine[] indexArr;
    private URL url;
    private ExtCallbackImpl _extcallBackImpl;
    private KDLayout.Constraints previewConstraints = new KDLayout.Constraints(300, 20, 440, 123, AbstractMessageType.anchor_left_right);
    private KDLayout.Constraints msgContentConstraints = new KDLayout.Constraints(10, 165, 770, 345, AbstractMessageType.anchor_all);
    private DispatchAndPushSettingPanel dppanel;

    public PushAndWarningWizard(KDExt ext, ExtCallbackImpl extCallbackImpl) {
        super((Frame)ext);
        this._extcallBackImpl = extCallbackImpl;
        this.book = MiscUtil.getActiveSpreadContext((KDExt)ext).getBook();
        this.initComponents();
        this.initListeners();
        this.setSize(800, 660);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setLocationRelativeTo(null);
        this.setTitle("\u9884\u8b66\u4e0e\u63a8\u9001");
        this.syncModel2Ui();
    }

    private void initComponents() {
        KDTabbedPane tabPane = new KDTabbedPane();
        tabPane.add("\u9884\u8b66\u6761\u4ef6", (Component)this.createWarningConditionsPanel());
        tabPane.add("\u6d88\u606f\u6837\u5f0f\u4e0e\u5185\u5bb9", (Component)this.createStyleAndContentsPanel());
        tabPane.add("\u8c03\u5ea6\u4e0e\u63a8\u9001", (Component)this.createScheduleAndPushPanel());
        this.pushAndWarning = new KDPanel();
        this.pushAndWarning.setLayout((LayoutManager)new KDLayout());
        this.pushAndWarning.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 750, 600));
        this.pushAndWarning.add((Component)tabPane, (Object)new KDLayout.Constraints(10, 10, 730, 580, AbstractMessageType.anchor_left_right));
        this.btnOk = new KDButton("\u786e\u5b9a");
        this.btnCancel = new KDButton("\u53d6\u6d88");
        this.pushAndWarning.add((Component)this.btnOk, (Object)new KDLayout.Constraints(580, 570, 40, 19, 10));
        this.pushAndWarning.add((Component)this.btnCancel, (Object)new KDLayout.Constraints(665, 570, 40, 19, 10));
        this.getContentPane().add((Component)this.pushAndWarning);
    }

    private KDPanel createWarningConditionsPanel() {
        KDPanel panel = new KDPanel();
        panel.setLayout((LayoutManager)new KDLayout());
        panel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 787, 514));
        KDLabel labelCondition = new KDLabel("\u9884\u8b66\u6761\u4ef6\uff1a");
        panel.add((Component)labelCondition, (Object)new KDLayout.Constraints(10, 10, 80, 19, 0));
        this.preConditionComposer = new FormulaTextArea();
        this.preConditionComposer.setRequired(true);
        panel.add((Component)this.preConditionComposer, (Object)new KDLayout.Constraints(80, 10, 695, 110, 12));
        KDPanel panelDesc = new KDPanel();
        panelDesc.setBorder((Border)new TitledBorder("\u9884\u8b66\u8868\u8fbe\u5f0f\u8bf4\u660e"));
        KDTextArea areaDesc = new KDTextArea();
        areaDesc.setAutoscrolls(true);
        areaDesc.setBorder(null);
        areaDesc.setEditable(false);
        String desc = "\u6839\u636e\u7528\u6237\u9700\u6c42\u8bbe\u5b9a\u9884\u8b66\u6761\u4ef6\u8868\u8fbe\u5f0f\uff0c\u5f53\u6761\u4ef6\u4e3a\u771f\u65f6\uff0c\u5c06\u542f\u7528\u6d88\u606f\u9884\u8b66\uff0c\u5426\u5219\u4e0d\u542f\u7528\u6d88\u606f\u9884\u8b66\u3002\n\u9884\u8b66\u6761\u4ef6\u652f\u6301\u8bbe\u7f6e\u4e3a\u56fa\u5b9a\u503c\u3001\u5355\u5143\u683c\u5f15\u7528\u6216\u8868\u8fbe\u5f0f\u3002\u7528\u6237\u53ef\u4ee5\u624b\u5199\u516c\u5f0f\uff0c\u6216\u8005\u901a\u8fc7\u70b9\u51fb\u8f93\u5165\u6846\u53f3\u4e0b\u89d2\u7684\u7bad\u5934\u56fe\u6807\u5f39\u51fa\u516c\u5f0f\u7f16\u8f91\u5668\uff0c\u5728\u516c\u5f0f\u7f16\u8f91\u5668\u4e2d\u4e66\u5199\u8868\u8fbe\u5f0f\u3002\n\u9884\u8b66\u8868\u8fbe\u5f0f\u652f\u6301\u7684\u64cd\u4f5c\u7b26\u5305\u62ec\uff1a+  -  * /  >   <   (   ) <>  =\n\n\u793a\u4f8b\uff1a\nIF\n(\n    SUM(EXS(C5)) > 10000, True, False\n)\n\u5bf9\u62a5\u8868\u4e2dC5\u6269\u5c55\u51fa\u6765\u7684\u5355\u5143\u683c\u8fdb\u884c\u7edf\u8ba1\u6c42\u548c\uff0c\u5f53\u7ed3\u679c\u5927\u4e8e10000\u65f6\uff0c\u8fd4\u56detrue\uff0c\u5426\u5219\u8fd4\u56defalse\u3002";
        areaDesc.setText(desc);
        panelDesc.setLayout((LayoutManager)new KDLayout());
        panelDesc.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(20, 130, 710, 450));
        panelDesc.add((Component)areaDesc, (Object)new KDLayout.Constraints(10, 30, 685, 350, 325));
        panel.add((Component)panelDesc, (Object)new KDLayout.Constraints(10, 130, 770, 380, 325));
        return panel;
    }

    private KDPanel createStyleAndContentsPanel() {
        this.sytleAndContentPanel = new KDPanel();
        KDLayout layout = new KDLayout();
        this.sytleAndContentPanel.setLayout((LayoutManager)layout);
        this.sytleAndContentPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 787, 514));
        this.msgTypePanel = new KDPanel();
        this.msgTypePanel.setLayout((LayoutManager)layout);
        this.msgTypePanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 770, 120));
        this.msgTypePanel.setBorder((Border)new TitledBorder("\u6d88\u606f\u6837\u5f0f"));
        this.sytleAndContentPanel.add((Component)this.msgTypePanel, (Object)new KDLayout.Constraints(10, 10, 770, 155, AbstractMessageType.anchor_left_right));
        KDButtonGroup radioGroup = new KDButtonGroup();
        this.radioTextOnly = new KDRadioButton("\u5355\u6587\u672c");
        this.radioTextPic = new KDRadioButton("\u56fe\u7247+\u6587\u672c");
        this.radioTextMetro = new KDRadioButton("\u8272\u5757+\u6587\u672c");
        radioGroup.add((AbstractButton)this.radioTextOnly);
        radioGroup.add((AbstractButton)this.radioTextPic);
        radioGroup.add((AbstractButton)this.radioTextMetro);
        this.radioTextOnly.setSelected(true);
        this.msgTypePanel.add((Component)this.radioTextOnly, (Object)new KDLayout.Constraints(10, 25, 100, 19, 0));
        this.msgTypePanel.add((Component)this.radioTextPic, (Object)new KDLayout.Constraints(10, 54, 100, 19, 0));
        this.msgTypePanel.add((Component)this.radioTextMetro, (Object)new KDLayout.Constraints(10, 83, 100, 19, 0));
        this.msgType = new TypeTextOnly();
        this.previewPanel = this.msgType.createPreviewPanel();
        this.msgTypePanel.add((Component)this.previewPanel, (Object)this.previewConstraints);
        this.msgContentPanel = this.msgType.createContentPanel();
        this.sytleAndContentPanel.add((Component)this.msgContentPanel, (Object)this.msgContentConstraints);
        return this.sytleAndContentPanel;
    }

    private KDPanel createScheduleAndPushPanel() {
        this.dppanel = new DispatchAndPushSettingPanel(this.book, this._extcallBackImpl);
        return this.dppanel;
    }

    private void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PushAndWarningWizard.this.isCancel = true;
                PushAndWarningWizard.this.setVisible(false);
                PushAndWarningWizard.this.dispose();
            }
        });
        TypeChangeActionListener typeChangeListener = new TypeChangeActionListener();
        this.radioTextOnly.addChangeListener((ChangeListener)typeChangeListener);
        this.radioTextPic.addChangeListener((ChangeListener)typeChangeListener);
        this.radioTextMetro.addChangeListener((ChangeListener)typeChangeListener);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PushAndWarningWizard.this.isCancel = true;
                PushAndWarningWizard.this.setVisible(false);
                PushAndWarningWizard.this.dispose();
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (PushAndWarningWizard.this.msgType instanceof TypeMetro) {
                    ((TypeMetro)PushAndWarningWizard.this.msgType).cacheIndexDefine();
                }
                if (!PushAndWarningWizard.this.checkEmpty()) {
                    return;
                }
                PropellingModel clone = PushAndWarningWizard.this.syncUi2CloneModel();
                try {
                    clone.validateAll();
                }
                catch (ValidateException ve) {
                    String errorMsg = ve.getMsg();
                    if (ve.getErrorObject() != null) {
                        errorMsg = "\u7b2c" + (Integer.valueOf(ve.getErrorObject().toString()) + 1) + "\u8272\u5757\uff0c" + ve.getMsg();
                    }
                    MessageUtil.msgboxInfo((Component)((Object)PushAndWarningWizard.this), (String)errorMsg);
                    return;
                }
                finally {
                    clone = null;
                }
                PushAndWarningWizard.this.syncUi2Model();
                PushAndWarningWizard.this.isCancel = true;
                PushAndWarningWizard.this.setVisible(false);
                PushAndWarningWizard.this.dispose();
            }
        });
    }

    private PropellingModel syncUi2CloneModel() {
        PropellingModel clone = this.book.getPropellingModel().clone();
        clone.setPreFormula(this.preConditionComposer.getFormula());
        clone.setTitleFormula(this.msgType.titleComposer.getFormula());
        clone.setContentFormula(this.msgType.descComposer.getFormula());
        clone.setMessageType(this.msgType.getMessageType());
        switch (this.msgType.getMessageType()) {
            case IMAGE: {
                clone.setImagePath(((TypeImage)this.msgType).imagePath);
                break;
            }
            case METRO: {
                TypeMetro typeMetro = (TypeMetro)this.msgType;
                clone.setMetroLayoutType(typeMetro.metroLayoutType);
                for (int j = 0; j < clone.metroSize(); ++j) {
                    IndexDefine define = clone.getIndexDefine(j);
                    IndexDefine indexArrJ = typeMetro.indexArr[j];
                    typeMetro.switchIndexDefine(indexArrJ, define);
                }
                break;
            }
        }
        return clone;
    }

    private boolean checkEmpty() {
        String name = StringUtil.isEmptyString((String)this.preConditionComposer.getFormula()) ? "\u9884\u8b66\u6761\u4ef6" : this.msgType.getEmptyName();
        if (!StringUtil.isEmptyString((String)name)) {
            MessageUtil.msgboxInfo((Component)((Object)this), (String)(name + "\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            return false;
        }
        return this.dppanel.validateEmpty();
    }

    public boolean prepare() {
        return false;
    }

    public void commit() {
    }

    public void show() {
        if (this.isCancel) {
            this.url = null;
            this.indexArr = null;
            this.syncModel2Ui();
            this.dppanel.setUIValue();
            this.isCancel = false;
        }
        super.show();
    }

    private void syncModel2Ui() {
        PropellingModel model = this.book.getPropellingModel();
        switch (model.getMessageType()) {
            case IMAGE: {
                this.radioTextPic.setSelected(true);
                TypeImage typeImage = (TypeImage)this.msgType;
                try {
                    URL url = ExtURL.parseURL((String)model.getImagePath());
                    typeImage.showPreviewImage(url);
                }
                catch (MalformedURLException e) {
                    logger.error((Object)"------can not open static image------", (Throwable)e);
                }
                break;
            }
            case METRO: {
                this.radioTextMetro.setSelected(true);
                TypeMetro typeMetro = (TypeMetro)this.msgType;
                typeMetro.initSelectedColorSchemes();
                typeMetro.initColorScheme();
                typeMetro.setMetroTypeLayout(model.getMetroLayoutType());
                typeMetro.syncFromModel(false);
                break;
            }
            case TEXT_ONLY: {
                this.radioTextOnly.setSelected(true);
            }
        }
        this.preConditionComposer.setFormula(model.getPreFormula());
        this.msgType.titleComposer.setFormula(model.getTitleFormula());
        this.msgType.descComposer.setFormula(model.getContentFormula());
    }

    private void syncUi2Model() {
        PropellingModel model = this.book.getPropellingModel();
        model.setPreFormula(this.preConditionComposer.getFormula());
        model.setTitleFormula(this.msgType.titleComposer.getFormula());
        model.setContentFormula(this.msgType.descComposer.getFormula());
        model.setMessageType(this.msgType.getMessageType());
        switch (this.msgType.getMessageType()) {
            case IMAGE: {
                model.setImagePath(((TypeImage)this.msgType).imagePath);
                break;
            }
            case METRO: {
                TypeMetro typeMetro = (TypeMetro)this.msgType;
                model.setMetroLayoutType(typeMetro.metroLayoutType);
                for (int j = 0; j < model.metroSize(); ++j) {
                    IndexDefine define = model.getIndexDefine(j);
                    IndexDefine indexArrJ = typeMetro.indexArr[j];
                    typeMetro.switchIndexDefine(indexArrJ, define);
                }
                break;
            }
        }
        this._extcallBackImpl.getScheduleModel().setFilterXML(this.dppanel.getScheduleModel().getFilterXML());
        this._extcallBackImpl.getScheduleModel().setSchedule(this.dppanel.getScheduleModel().getSchedule());
        this._extcallBackImpl.getScheduleModel().setHint(this.dppanel.getScheduleModel().getHint());
        this._extcallBackImpl.getScheduleModel().setSendStartScheduleTime(this.dppanel.getScheduleModel().getSendStartScheduleTime());
        this._extcallBackImpl.getScheduleModel().setSendFinishScheduleTime(this.dppanel.getScheduleModel().getSendFinishScheduleTime());
        this._extcallBackImpl.getScheduleModel().setEnableDispatchPlan(this.dppanel.getScheduleModel().isEnableDispatchPlan());
        this._extcallBackImpl.getScheduleModel().setStrategyType(this.dppanel.getScheduleModel().getStrategy());
    }

    public static void main(String[] agrs) {
        CtrlUIEnv.setKingdeeLAF();
        PushAndWarningWizard w = new PushAndWarningWizard(null, null);
        w.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testOutput(PropellingModel model) {
        FileOutputStream out = null;
        try {
            File file = new File("D:/" + model.getMetroLayoutType().name() + ".png");
            if (!file.exists()) {
                file.createNewFile();
            }
            out = new FileOutputStream(file);
            ExtMessage extMsg = model.execute();
            if (extMsg != null) {
                out.write(extMsg.pic());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static /* synthetic */ IndexDefine[] access$1102(PushAndWarningWizard x0, IndexDefine[] x1) {
        x0.indexArr = x1;
        return x1;
    }

    private class TypeChangeActionListener
    implements ChangeListener {
        private TypeChangeActionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            String titleFormula = null;
            String contentFormula = null;
            if (PushAndWarningWizard.this.msgType != null && ((PushAndWarningWizard)PushAndWarningWizard.this).msgType.titleComposer != null && ((PushAndWarningWizard)PushAndWarningWizard.this).msgType.descComposer != null) {
                titleFormula = ((PushAndWarningWizard)PushAndWarningWizard.this).msgType.titleComposer.getFormula();
                contentFormula = ((PushAndWarningWizard)PushAndWarningWizard.this).msgType.descComposer.getFormula();
            }
            if (PushAndWarningWizard.this.radioTextOnly.isSelected()) {
                if (PushAndWarningWizard.this.msgType instanceof TypeTextOnly) {
                    return;
                }
                PushAndWarningWizard.this.msgType = new TypeTextOnly();
            }
            if (PushAndWarningWizard.this.radioTextPic.isSelected()) {
                if (PushAndWarningWizard.this.msgType instanceof TypeImage) {
                    return;
                }
                PushAndWarningWizard.this.msgType = new TypeImage(PushAndWarningWizard.this.url);
            } else if (PushAndWarningWizard.this.msgType instanceof TypeImage) {
                PushAndWarningWizard.this.url = ((TypeImage)((PushAndWarningWizard)PushAndWarningWizard.this).msgType).url;
            }
            if (PushAndWarningWizard.this.radioTextMetro.isSelected()) {
                if (PushAndWarningWizard.this.msgType instanceof TypeMetro) {
                    return;
                }
                PushAndWarningWizard.this.msgType = new TypeMetro(PushAndWarningWizard.this.book, PushAndWarningWizard.this.indexArr);
            } else if (PushAndWarningWizard.this.msgType instanceof TypeMetro) {
                PushAndWarningWizard.access$1102(PushAndWarningWizard.this, ((TypeMetro)PushAndWarningWizard.this.msgType).cacheIndexDefine());
            }
            PushAndWarningWizard.this.msgTypePanel.remove((Component)PushAndWarningWizard.this.previewPanel);
            PushAndWarningWizard.this.previewPanel = PushAndWarningWizard.this.msgType.createPreviewPanel();
            PushAndWarningWizard.this.msgTypePanel.add((Component)PushAndWarningWizard.this.previewPanel, (Object)PushAndWarningWizard.this.previewConstraints);
            PushAndWarningWizard.this.sytleAndContentPanel.remove((Component)PushAndWarningWizard.this.msgContentPanel);
            PushAndWarningWizard.this.msgContentPanel = PushAndWarningWizard.this.msgType.createContentPanel();
            PushAndWarningWizard.this.sytleAndContentPanel.add((Component)PushAndWarningWizard.this.msgContentPanel, (Object)PushAndWarningWizard.this.msgContentConstraints);
            ((PushAndWarningWizard)PushAndWarningWizard.this).msgType.titleComposer.setFormula(titleFormula);
            ((PushAndWarningWizard)PushAndWarningWizard.this).msgType.descComposer.setFormula(contentFormula);
            PushAndWarningWizard.this.sytleAndContentPanel.revalidate();
        }
    }
}

