/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.propelling.runtime.handler;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.PubAcctsDAO;
import com.kingdee.eas.rpts.ctrlreport.propelling.runtime.model.xunt.XuntExtMessage;
import com.kingdee.eas.rpts.ctrlreport.propelling.runtime.model.xunt.XuntMessageAdapter;
import com.kingdee.lightapp.pa.PubAcctController;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.Logger;

public class XuntMessageHandler {
    private static Logger logger = CommonLogger.getLogger(XuntMessageHandler.class);
    private HashMap<String, PubAcctsDAO.PubAcct> pubAccts = new HashMap();
    private String pubVisitUrl;

    public XuntMessageHandler(List<PubAcctsDAO.PubAcct> pubAccts, String pubVisitUrl) {
        for (PubAcctsDAO.PubAcct next : pubAccts) {
            this.pubAccts.put(next.fid, next);
        }
        this.pubVisitUrl = pubVisitUrl;
    }

    public void handle(Context easCtx, XuntExtMessage message) {
        if (this.pubAccts.isEmpty()) {
            logger.error((Object)"pubacct not configured.message not send.");
            return;
        }
        logger.error((Object)"-------------------propelling message start-------------------");
        URL hyperlink = XuntMessageHandler.buildSnapshotVisitURL(this.pubVisitUrl, message.rptName(), message.rptId(), message.snapshotTag(), message.date());
        XuntMessageAdapter adapter = new XuntMessageAdapter(message, hyperlink);
        logger.error((Object)("-------------remote snapshot URL-------------\n" + hyperlink.toString() + "&pc=true"));
        if (!this.invokePush(easCtx, message, adapter)) {
            logger.error((Object)"-------------------send message failed-----------------------");
            logger.error((Object)PubAcctController.getRefrenceInfo());
        } else {
            logger.error((Object)("-----------send message successfully:" + message + "-----------"));
            for (String user : message.getUsers()) {
                logger.error((Object)("-----------message send to:" + user + "-----------"));
            }
        }
        logger.error((Object)"-------------------propelling message end-------------------");
    }

    public static URL buildSnapshotVisitURL(String pubVisitUrl, String rptName, String rptUuid, String snapshotUuid, Date date) {
        try {
            StringBuilder sb = new StringBuilder(pubVisitUrl);
            if (pubVisitUrl.indexOf("?") >= 0) {
                sb.append("&");
            } else {
                sb.append("?");
            }
            sb.append("title");
            sb.append("=");
            sb.append(URIUtil.encodeWithinQuery((String)rptName));
            sb.append("&");
            sb.append("reportId");
            sb.append("=");
            sb.append(URIUtil.encodeWithinQuery((String)rptUuid));
            sb.append("&");
            sb.append("snapshotTag");
            sb.append("=");
            sb.append(URIUtil.encodeWithinQuery((String)snapshotUuid));
            sb.append("&");
            sb.append("remoteMethod");
            sb.append("=");
            sb.append("extLightSnapshot");
            sb.append("&");
            sb.append("snapshotPrompt");
            sb.append("=");
            sb.append(URIUtil.encodeWithinQuery((String)XuntMessageAdapter.FORMATTER.format(date)));
            return new URL(sb.toString());
        }
        catch (Throwable e) {
            logger.error((Object)"can not build snapshot url");
            try {
                return new URL("http://www.kingdee.com");
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
    }

    private boolean invokePush(Context easCtx, XuntExtMessage message, XuntMessageAdapter adapter) {
        PubAcctsDAO.PubAcct entry = this.pubAccts.get(message.pubAcct());
        adapter.setAppId(entry.description);
        adapter.setEid(entry.eid);
        adapter.setType(entry.msgType);
        if (StringUtil.isEmptyString((String)entry.xtPubAcctId)) {
            logger.error((Object)("Unkown pubacct:" + message.pubAcct() + " for message" + message));
            return false;
        }
        try {
            return (Boolean)PubAcctController.class.getMethod("push", Context.class, IMessageAdapter.class, String.class, String.class, String.class, Boolean.TYPE).invoke(null, easCtx, adapter, entry.xtPubAcctId, entry.key, "0", false);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }
}

