/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.propelling.model.IndexDefine;
import com.kingdee.bos.ctrl.ext.ui.wizards.propelling.model.PropellingModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.showcase.WaterMarkInfo;
import com.kingdee.bos.ctrl.kds.expans.model.ExtConst;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.bos.ctrl.kds.expans.model.data.CommonCalculableProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.bos.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.UserObject;
import com.kingdee.bos.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.SortedNamedObjectNodeArray;
import com.kingdee.eas.rpts.ctrlreport.bo.KSQLReportBO;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroRuntimeException;
import com.kingdee.eas.rpts.ctrlreport.macro.exec.ExtRptMacroExecuteFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.ExtRptMacroControllerFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroType;
import com.kingdee.eas.rpts.ctrlreport.macro.model.IExtRptMacro;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroValue;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.SqlDSModelDrill;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ExtRptContentChecker {
    private static Logger logger = CommonLogger.getLogger(ExtRptContentChecker.class);
    private static Pattern SYSTEM_PARAM_PATTERN = Pattern.compile("'@ExtRpt[a-zA-Z]*'");
    private static Pattern MACRO_PARAM_PATTERN = Pattern.compile("[$]{1}[a-zA-Z]{1}[a-zA-Z0-9_]+");

    public static boolean[] needMoreCopy(Context easCtx, HashMap<String, DesignParameter> paramMap, Book template) {
        return ExtRptContentChecker.needMoreCopy(easCtx, paramMap, template, true);
    }

    public static boolean[] needMoreCopy(Context easCtx, HashMap<String, DesignParameter> paramMap, Book template, boolean checkKPI) {
        int i;
        boolean[] ret2 = new boolean[]{false, false};
        Iterator<String> keyIterator = paramMap.keySet().iterator();
        String value = null;
        while (keyIterator.hasNext()) {
            DesignParameter param = paramMap.get(keyIterator.next());
            value = param.getCurentValue();
            if (value == null) continue;
            String[] values = value.split("0xx1xx");
            int length = values.length;
            for (int i2 = 0; i2 < length; ++i2) {
                if (!ExtRptContentChecker.checkAndFill(ExtRptContentChecker.addPrefix(values[i2]), ret2)) continue;
                return ret2;
            }
        }
        ExtDataSetManager dsManager = template.getDataSetManager();
        for (i = 0; i < dsManager.size(); ++i) {
            ExtDataSet ds = dsManager.getAt(i);
            String sqlContent = ExtRptContentChecker.parseSQL(easCtx, ds);
            Matcher m = SYSTEM_PARAM_PATTERN.matcher(sqlContent);
            while (m.find()) {
                if (!ExtRptContentChecker.checkAndFill(ExtRptContentChecker.addPrefix(m.group()), ret2)) continue;
                return ret2;
            }
        }
        if (ExtRptContentChecker.checkNames(template.getNames(), ret2, checkKPI)) {
            return ret2;
        }
        for (i = 0; i < template.getSheetCount(); ++i) {
            Sheet sheet = template.getSheet(i);
            if (ExtRptContentChecker.checkNames(sheet.getNames(), ret2, checkKPI)) {
                return ret2;
            }
            Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, 1048575, 65535, true, true);
            while (iter.hasNext()) {
                if (!ExtRptContentChecker.checkAndFill(iter.next().getFormula(), ret2)) continue;
                return ret2;
            }
        }
        HashSet<String> usedMacros = new HashSet<String>();
        try {
            ExtRptContentChecker.analysisMacroUsage(easCtx, usedMacros, new HashMap(), template);
            IExtRptMacroController controller = easCtx != null ? ExtRptMacroControllerFacade.getLocalInst(easCtx) : ExtRptMacroControllerFacade.getRemoteInst();
            for (IExtRptMacro macro : controller.l(usedMacros)) {
                if (macro.mType() == ExtRptMacroType.MType.FUNCTION && ExtRptContentChecker.checkAndFill(ExtRptContentChecker.addPrefix(macro.define()), ret2)) {
                    return ret2;
                }
                String sqlContent = macro.define();
                Matcher m = SYSTEM_PARAM_PATTERN.matcher(sqlContent);
                while (m.find()) {
                    if (!ExtRptContentChecker.checkAndFill(ExtRptContentChecker.addPrefix(m.group()), ret2)) continue;
                    return ret2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (checkKPI) {
            PropellingModel model = template.getPropellingModel();
            if (ExtRptContentChecker.checkAndFill(ExtRptContentChecker.addPrefix(model.getContentFormula()), ret2)) {
                return ret2;
            }
            if (ExtRptContentChecker.checkAndFill(ExtRptContentChecker.addPrefix(model.getPreFormula()), ret2)) {
                return ret2;
            }
            if (ExtRptContentChecker.checkAndFill(ExtRptContentChecker.addPrefix(model.getTitleFormula()), ret2)) {
                return ret2;
            }
            for (int i3 = 0; i3 < model.metroSize(); ++i3) {
                IndexDefine define = model.getIndexDefine(i3);
                if (ExtRptContentChecker.checkAndFill(ExtRptContentChecker.addPrefix(define.getNameFormula()), ret2)) {
                    return ret2;
                }
                if (!ExtRptContentChecker.checkAndFill(ExtRptContentChecker.addPrefix(define.getDataFormula()), ret2)) continue;
                return ret2;
            }
        }
        return ret2;
    }

    public static boolean[] needMoreCopy(String sql) {
        boolean[] ret2 = new boolean[]{false, false};
        if (sql != null) {
            Matcher m = SYSTEM_PARAM_PATTERN.matcher(sql);
            while (m.find()) {
                if (!ExtRptContentChecker.checkAndFill(ExtRptContentChecker.addPrefix(m.group()), ret2)) continue;
                return ret2;
            }
        }
        return ret2;
    }

    private static String addPrefix(String source) {
        return source == null ? source : "=" + source;
    }

    private static boolean isUserInteractValue(String value) {
        return value != null && value.startsWith("=") && (value.indexOf("@ExtRptCurrentUserInfoID") != -1 || value.indexOf("@ExtRptCurrentUserInfoName") != -1 || value.indexOf("@ExtRptCurrentUserPersonID") != -1 || value.indexOf("@ExtRptCurrentUserPersonName") != -1 || value.indexOf("@ExtRptCurrentUserOrgRange") != -1);
    }

    private static boolean checkAndFill(String formula, boolean[] ret2) {
        if (!ret2[0] && ExtRptContentChecker.isUserInteractValue(formula)) {
            ret2[0] = true;
        }
        if (!ret2[1] && formula != null && formula.startsWith("=") && (formula.indexOf("@ExtRptCurrentAdminUnitID") != -1 || formula.indexOf("@ExtRptCurrentAdminUnitName") != -1 || formula.indexOf("@ExtRptCurrentCostUnitID") != -1 || formula.indexOf("@ExtRptCurrentCostUnitID") != -1 || formula.indexOf("@ExtRptCurrentCostUnitName") != -1 || formula.indexOf("@ExtRptCurrentCtrlUnitID") != -1 || formula.indexOf("@ExtRptCurrentCtrlUnitName") != -1 || formula.indexOf("@ExtRptCurrentFIUnitID") != -1 || formula.indexOf("@ExtRptCurrentFIUnitName") != -1 || formula.indexOf("@ExtRptCurrentHRUnitID") != -1 || formula.indexOf("@ExtRptCurrentHRUnitName") != -1 || formula.indexOf("@ExtRptCurrentOrgUnitID") != -1 || formula.indexOf("@ExtRptCurrentOrgUnitName") != -1 || formula.indexOf("@ExtRptCurrentProfitUnitID") != -1 || formula.indexOf("@ExtRptCurrentProfitUnitName") != -1 || formula.indexOf("@ExtRptCurrentPurchaseUnitID") != -1 || formula.indexOf("@ExtRptCurrentPurchaseUnitName") != -1 || formula.indexOf("@ExtRptCurrentSaleUnitID") != -1 || formula.indexOf("@ExtRptCurrentSaleUnitName") != -1 || formula.indexOf("@ExtRptCurrentStorageUnitID") != -1 || formula.indexOf("@ExtRptCurrentStorageUnitName") != -1 || formula.indexOf("@ExtRptCurrentTransportUnitID") != -1 || formula.indexOf("@ExtRptCurrentTransportUnitName") != -1)) {
            ret2[1] = true;
        }
        return ret2[0] && ret2[1];
    }

    private static boolean checkNames(SortedNamedObjectNodeArray names, boolean[] ret2, boolean checkKPI) {
        if (names != null) {
            for (int i = 0; i < names.size(); ++i) {
                Object obj = names.get(i);
                if (!(obj instanceof NamedObjectNode)) continue;
                NamedObjectNode no = (NamedObjectNode)obj;
                if (!checkKPI && no.isKPINameNode() || !ExtRptContentChecker.checkAndFill(no.getRefersTo(), ret2)) continue;
                return true;
            }
        }
        return false;
    }

    private static CtrlDesignQueryModel parseCtrlDesignQueryModel(Context easCtx, ExtDataSet ds) {
        String define = ds.getDefine();
        HashMap mapDefine = define.indexOf("rZns4x88ShmCrA4shCy6yENOfX0=\u3010\u6c47\u603b\u4e0a\u62a5\u4e13\u7528\u3011") != -1 ? (HashMap)RunReportParam.splitDefine2Map(define) : RunReportParam.splitDefineToMap(define);
        String dbsourceid = CtrlReportUtil.getObjectString(mapDefine.get("DbSourceID"));
        String orgID = CtrlReportUtil.getObjectString(mapDefine.get("OrgID"));
        String systemid = CtrlReportUtil.getObjectString(mapDefine.get("SystemID"));
        String dbsourcename = CtrlReportUtil.getObjectString(mapDefine.get("DbSourceName"));
        String innerLink = CtrlReportUtil.getObjectString(mapDefine.get("InnerLink"));
        String dataSetType = CtrlReportUtil.getObjectString(mapDefine.get("DataSetType"));
        String innerLinkXmlString = null;
        if (dataSetType.equals("sql_ksql")) {
            CtrlDesignQueryModel model = null;
            if (!innerLink.equals("")) {
                innerLinkXmlString = ds.getMeta();
                innerLinkXmlString = SqlDSModelDrill.split2(innerLinkXmlString);
                try {
                    model = KSQLReportBO.initModel(easCtx, null, null, null, null, innerLinkXmlString);
                }
                catch (CtrlReportException e) {
                    logger.error((Object)("failed to initialize the inner datasource," + ExtRptContentChecker.getDatasetDesc(ds)), (Throwable)e);
                    return null;
                }
            }
            try {
                model = KSQLReportBO.initModel(easCtx, systemid, dbsourcename, orgID, dbsourceid, null);
            }
            catch (CtrlReportException e) {
                logger.error((Object)("failed to locate the datasource," + ExtRptContentChecker.getDatasetDesc(ds)), (Throwable)e);
                return null;
            }
            return model;
        }
        return null;
    }

    private static String parseSQL(Context easCtx, ExtDataSet ds) {
        CtrlDesignQueryModel model = ExtRptContentChecker.parseCtrlDesignQueryModel(easCtx, ds);
        if (model != null) {
            try {
                return CtrlDesignQueryModel.makeSQL(easCtx, model);
            }
            catch (BOSException e) {
                logger.error((Object)("failed to fetch sql from dataset," + ExtRptContentChecker.getDatasetDesc(ds)), (Throwable)e);
                return "";
            }
        }
        return "";
    }

    private static String getDatasetDesc(ExtDataSet ds) {
        return "ExtDataSet{name:" + ds.toString() + ",define:(" + ds.getDefine() + "),type:" + ds.getDataSetType().getDisplayName() + "}";
    }

    public static void analysisMacroUsage(Context easCtx, Set<String> names, HashMap<String, DesignParameter> paramMap, CtrlDesignQueryModel model) throws MacroRuntimeException {
        names.clear();
        CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
        if (commonQuery == null) {
            return;
        }
        ExtRptContentChecker.analysisParamMacroUsage(names, paramMap);
        if (String.valueOf(1).equals(CtrlReportUtil.getObjectString(commonQuery.getProperties().get(CtrlDesignUtil.CustomType)))) {
            try {
                ExtRptContentChecker.checkAndFill(names, CtrlDesignQueryModel.makeSQL(easCtx, model));
            }
            catch (BOSException e) {
                throw MacroRuntimeException.newDatasetContentAnalysisException(e);
            }
        }
        for (String macroName : names) {
            MacroValue mv = easCtx == null ? ExtRptMacroExecuteFacade.remoteExecute(null, macroName) : ExtRptMacroExecuteFacade.localExecute(easCtx, null, macroName);
            StringBuilder currentValue = new StringBuilder(mv.getValues()[0][0].toString());
            for (int i = 1; i < mv.getValues().length; ++i) {
                currentValue.append("0xx1xx");
                currentValue.append(mv.getValues()[i][0]);
            }
            DesignParameter dp = new DesignParameter();
            dp.setCurentValue(currentValue.toString());
            dp.setDesignDataType(DesignDataType.TXT);
            dp.setName(macroName);
            paramMap.put(macroName + "_temp_macro_param_suffix", dp);
        }
    }

    public static void analysisMacroUsage(Context easCtx, Set<String> names, HashMap paramMap, Book template) throws MacroRuntimeException {
        WaterMarkInfo waterInfo;
        int i;
        names.clear();
        ExtRptContentChecker.analysisParamMacroUsage(names, paramMap);
        ExtDataSetManager dsManager = template.getDataSetManager();
        for (i = 0; i < dsManager.size(); ++i) {
            ExtRptContentChecker.checkAndFill(names, ExtRptContentChecker.parseSQL(easCtx, dsManager.getAt(i)));
        }
        for (i = 0; i < dsManager.size(); ++i) {
            List params;
            CtrlDesignCommonQuery query;
            CtrlDesignQueryModel model = ExtRptContentChecker.parseCtrlDesignQueryModel(easCtx, dsManager.getAt(i));
            if (model == null || (query = model.getCommonQuery()) == null || (params = query.getParameters()) == null) continue;
            for (Object p : params) {
                if (!(p instanceof DesignParameter)) continue;
                DesignParameter dp = (DesignParameter)((Object)p);
                ExtRptContentChecker.checkAndFill(names, dp.getDefaultValue());
                if (dp.getInputCtrl() == null || dp.getInputCtrl().getDataBind() != 7 || dp.getInputCtrl().getDefDbsource() == null) continue;
                names.add(dp.getInputCtrl().getDefDbsource().getName());
            }
        }
        ExtRptContentChecker.analysisNameNodeMacroUsage(names, template.getNames());
        for (i = 0; i < template.getSheetCount(); ++i) {
            Sheet sheet = template.getSheet(i);
            ExtRptContentChecker.analysisNameNodeMacroUsage(names, sheet.getNames());
            Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, 1048575, 65535, true, true);
            while (iter.hasNext()) {
                Cell cell = iter.next();
                ExtRptContentChecker.checkAndFill(names, cell.getFormula());
                ExtRptContentChecker.analysisLinkParamMacroUsage(names, cell);
            }
        }
        UserObject uo = template.getUserObject("MobileWaterMark");
        if (uo != null && !StringUtil.isEmptyString((String)(waterInfo = (WaterMarkInfo)JSONObject.parseObject((String)((String)uo.getValue()), (TypeReference)new TypeReference<WaterMarkInfo>(){}, (Feature[])new Feature[0])).getMacroText())) {
            names.add(waterInfo.getMacroText().substring(1));
        }
    }

    public static void analysisLinkParamMacroUsage(Set<String> names, Cell cell) {
        ExtProps ep = cell.getExtProps(false);
        if (ep == null) {
            return;
        }
        SortedExtPropFormulasArray formulaArr = ep.getFormulas(false);
        if (formulaArr == null) {
            return;
        }
        ICalculableProps prop = formulaArr.get(ExtConst.FORMULA_HYPERLINK);
        if (prop == null) {
            return;
        }
        HashMap tars = ((HyperlinkCalculableProps)prop).getTargets();
        if (tars == null) {
            return;
        }
        ETTargets ett = (ETTargets)tars.get("EXTRPT");
        if (ett == null) {
            return;
        }
        List targets = ett.getTargets();
        if (targets == null) {
            return;
        }
        for (ExtTransitionTarget target : targets) {
            if (target == null) continue;
            Map params = target.getParameters();
            Iterator ite = params.entrySet().iterator();
            while (ite.hasNext()) {
                CommonCalculableProps param = (CommonCalculableProps)ite.next().getValue();
                if (param == null) continue;
                String pValue = param.getFormula(cell.getSheet().getBook().getDeps().getExprContext(), (ICalculable)cell);
                ExtRptContentChecker.checkAndFill(names, pValue);
            }
        }
    }

    public static void analysisParamMacroUsage(Set<String> names, HashMap paramMap) {
        for (Object dp : paramMap.values()) {
            if (!(dp instanceof DesignParameter)) continue;
            ExtRptContentChecker.analysisParamMacroUsage(names, ((DesignParameter)((Object)dp)).getCurentValue());
        }
    }

    public static void analysisParamMacroUsage(Set<String> names, String value) {
        if (value == null) {
            return;
        }
        ExtRptContentChecker.checkAndFill(names, value);
    }

    private static void analysisNameNodeMacroUsage(Set<String> names, SortedNamedObjectNodeArray nodes) {
        if (nodes != null) {
            for (int i = 0; i < nodes.size(); ++i) {
                Object obj = nodes.get(i);
                if (!(obj instanceof NamedObjectNode)) continue;
                ExtRptContentChecker.checkAndFill(names, ((NamedObjectNode)obj).getRefersTo());
            }
        }
    }

    private static void checkAndFill(Set<String> names, String content) {
        if (content == null) {
            return;
        }
        Matcher m = MACRO_PARAM_PATTERN.matcher(content);
        while (m.find()) {
            names.add(m.group().substring(1).toUpperCase());
        }
    }
}

