/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.util.fi;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.DefaultContextHandler;
import com.kingdee.eas.fi.rpt.IContextHandler;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.rpts.ctrlreport.util.fi.FIParam;
import com.kingdee.eas.rpts.ctrlreport.util.fi.FIParamUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PlainFIContextHandler
implements IContextHandler {
    private static final long serialVersionUID = 1L;
    private List<FIParam> fiParams = new ArrayList<FIParam>();

    public PlainFIContextHandler(Object fiParams) {
        if (fiParams instanceof List) {
            for (Object p : (List)fiParams) {
                if (!(p instanceof FIParam)) continue;
                this.fiParams.add((FIParam)p);
            }
        }
    }

    public void handlerContext(Context ctx, ReportInfo report, ReportVariables iv) {
        CurrencyCollection initCurrencyCollection;
        CompanyOrgUnitInfo company;
        report.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        OrgUnitInfo org = (OrgUnitInfo)ctx.get((Object)"ext_rpts_report_bizOrg");
        try {
            company = FIParamUtil.getCompanyInfo(ctx, org);
            initCurrencyCollection = InitDataFacadaFactory.getLocalInstance((Context)ctx).getCurrency();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        report.setCompany(company);
        report.setOrgType(OrgType.Company);
        RptPeriodTypeEnum periodType = RptPeriodTypeEnum.MONTHLY;
        report.setPeriodType(periodType);
        int[] period = RPTDateUtil.getPeriod((Date)((Date)ctx.get((Object)"ext_rpts_report_bizDate")), (RptPeriodTypeEnum)periodType);
        report.setYear(period[0]);
        report.setPeriod((short)period[1]);
        report.setStartDate(RPTDateUtil.getPeriodFirstDate((int)period[0], (int)period[1], (RptPeriodTypeEnum)periodType));
        report.setEndDate(RPTDateUtil.getPeriodLastDate((int)period[0], (int)period[1], (RptPeriodTypeEnum)periodType));
        for (FIParam p : this.fiParams) {
            VariableEntry entry;
            int index;
            String variableName = p.getName();
            if ("Currency".equals(variableName)) {
                boolean setted = false;
                int size = initCurrencyCollection.size();
                for (int i = 0; i < size; ++i) {
                    CurrencyInfo currency = initCurrencyCollection.get(i);
                    if (!currency.getId().toString().equals(p.getValue())) continue;
                    report.setCurrency(initCurrencyCollection.get(i));
                    setted = true;
                    break;
                }
                if (setted) continue;
                report.setCurrency(FIParamUtil.getCurrency(company));
                continue;
            }
            if ("StartYear".equals(variableName) || "EndYear".equals(variableName) || "StartPeriod".equals(variableName) || "EndPeriod".equals(variableName)) {
                // empty if block
            }
            if ((index = iv.indexOf(entry = VariablesHelper.createReservedEntry((String)p.getName(), (String)p.getDesc(), (String)p.getSheetName(), (String)p.getValue(), (int)p.getDataType()))) < 0) {
                iv.add(entry);
                continue;
            }
            VariableEntry old = iv.get(index);
            old.copyFrom(entry);
        }
        iv.addAll(DefaultContextHandler.initSheetReservedVariables((Context)ctx, (String)"sheet1", (RptPeriodTypeEnum)report.getPeriodType()), false);
    }
}

