/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.data;

import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignDataType;

public class ProcedureDataType {
    public static final int INT_STRING = 0;
    public static final int INT_INTEGER = 1;
    public static final int INT_DOUBLE = 2;
    public static final int INT_DATE = 3;
    public static final int INT_DATETIME = 4;
    public static final int INT_TIME = 5;
    public static final int INT_CURSOR = 6;
    public static final ProcedureDataType STRING = new ProcedureDataType(MessageUtil.getMsgInfo("label298"), 0);
    public static final ProcedureDataType INTEGER = new ProcedureDataType(MessageUtil.getMsgInfo("label299"), 1);
    public static final ProcedureDataType DOUBLE = new ProcedureDataType(MessageUtil.getMsgInfo("label300"), 2);
    public static final ProcedureDataType DATE = new ProcedureDataType(MessageUtil.getMsgInfo("label301"), 3);
    public static final ProcedureDataType DATETIME = new ProcedureDataType(MessageUtil.getMsgInfo("label302"), 4);
    public static final ProcedureDataType TIME = new ProcedureDataType(MessageUtil.getMsgInfo("label303"), 5);
    public static final ProcedureDataType CURSOR = new ProcedureDataType(MessageUtil.getMsgInfo("label304"), 6);
    public static final ProcedureDataType[] ProcedureDataTypes = new ProcedureDataType[]{STRING, INTEGER, DOUBLE, DATE, DATETIME, TIME, CURSOR};
    public static final ProcedureDataType[] JavaDataTypes = new ProcedureDataType[]{STRING, INTEGER, DOUBLE, DATE, DATETIME, TIME};
    private String name;
    private int intValue;
    private static final String[] DB_Varchar = new String[]{"char", "nchar", "ntext", "nvarchar", "text", "varchar", "varchar2", "nvarchar2", "CHARACTER"};
    private static final String[] DB_INT = new String[]{"int", "smallint", "tinyint", "long", "integer"};
    private static final String[] DB_DOUBLE = new String[]{"decimal", "float", "numeric", "real", "number"};
    private static final String[] DB_DATE = new String[]{"datetime", "smalldatetime", "date"};
    private static final String[] DB_DATETIME = new String[]{"timestamp"};
    private static final String[] DB_TIME = new String[]{"time"};
    private static final String[] DB_CURSOR = new String[]{"REF CURSOR"};
    private static final String[] PG_Varchar = new String[]{"char", "nchar", "ntext", "nvarchar", "text", "varchar", "varchar2", "nvarchar2", "CHARACTER", "character varying"};
    private static final String[] PG_INT = new String[]{"int", "smallint", "tinyint", "long", "integer", "bigint"};
    private static final String[] PG_DOUBLE = new String[]{"decimal", "float", "numeric", "real", "number", "double precision"};
    private static final String[] PG_DATE = new String[]{"datetime", "smalldatetime", "date"};
    private static final String[] PG_DATETIME = new String[]{"timestamp", "timestamp with time zone", "timestamp without time zone"};
    private static final String[] PG_TIME = new String[]{"time", "times with time zone", "times without time zone"};
    private static final String[] PG_CURSOR = new String[]{"REF CURSOR", "REFCURSOR"};

    private ProcedureDataType(String name, int i) {
        this.name = name;
        this.intValue = i;
    }

    public int intValue() {
        return this.intValue;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public static final ProcedureDataType getDataTypee(int intValue) {
        switch (intValue) {
            case 0: {
                return STRING;
            }
            case 1: {
                return INTEGER;
            }
            case 2: {
                return DOUBLE;
            }
            case 3: {
                return DATE;
            }
            case 4: {
                return DATETIME;
            }
            case 5: {
                return TIME;
            }
            case 6: {
                return CURSOR;
            }
        }
        return null;
    }

    public static final ProcedureDataType PGTypeToPDType(String value) {
        if (ProcedureDataType.isExitsType(value, PG_Varchar)) {
            return STRING;
        }
        if (ProcedureDataType.isExitsType(value, PG_INT)) {
            return INTEGER;
        }
        if (ProcedureDataType.isExitsType(value, PG_DOUBLE)) {
            return DOUBLE;
        }
        if (ProcedureDataType.isExitsType(value, PG_DATE)) {
            return DATE;
        }
        if (ProcedureDataType.isExitsType(value, PG_DATETIME)) {
            return DATETIME;
        }
        if (ProcedureDataType.isExitsType(value, PG_TIME)) {
            return TIME;
        }
        if (ProcedureDataType.isExitsType(value, PG_CURSOR)) {
            return CURSOR;
        }
        return STRING;
    }

    private static final boolean isExitsType(String value, String[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (!value.equalsIgnoreCase(arr[i])) continue;
            return true;
        }
        return false;
    }

    public static final ProcedureDataType dBTypeToPDType(String value) {
        if (ProcedureDataType.isExitsType(value, DB_Varchar)) {
            return STRING;
        }
        if (ProcedureDataType.isExitsType(value, DB_INT)) {
            return INTEGER;
        }
        if (ProcedureDataType.isExitsType(value, DB_DOUBLE)) {
            return DOUBLE;
        }
        if (ProcedureDataType.isExitsType(value, DB_DATE)) {
            return DATE;
        }
        if (ProcedureDataType.isExitsType(value, DB_DATETIME)) {
            return DATETIME;
        }
        if (ProcedureDataType.isExitsType(value, DB_TIME)) {
            return TIME;
        }
        if (ProcedureDataType.isExitsType(value, DB_CURSOR)) {
            return CURSOR;
        }
        return STRING;
    }

    public static final DesignDataType toDesignDataType(ProcedureDataType pdt) {
        int intValue = pdt.intValue;
        switch (intValue) {
            case 0: {
                return DesignDataType.TXT;
            }
            case 1: 
            case 2: {
                return DesignDataType.NUMERICAL;
            }
            case 3: {
                return DesignDataType.DATE;
            }
            case 4: {
                return DesignDataType.DATETIME;
            }
            case 5: {
                return DesignDataType.TIME;
            }
        }
        return DesignDataType.TXT;
    }
}

