/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtil {
    public static final SimpleDateFormat sdf_yyyy_MM_dd = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat sdf_yyyy_MM_dd_HH_mm_ss = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final int[] CalendarWeek = new int[]{1, 2, 3, 4, 5, 6, 7};

    public static final String getMonthFirstDay(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-01");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 0);
        return sdf.format(cal.getTime());
    }

    public static final String getMonthLastDay(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String firstDay = DateUtil.getMonthFirstDay(date);
        Calendar cal = Calendar.getInstance();
        try {
            Date firstDate = sdf.parse(firstDay);
            cal.setTime(firstDate);
            cal.add(2, 1);
            cal.add(5, -1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sdf.format(cal.getTime());
    }

    public static final String tuneDate(String date, int amount) {
        String yesterday = null;
        try {
            Date curr = sdf_yyyy_MM_dd.parse(date);
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(curr);
            gc.add(5, amount);
            curr = gc.getTime();
            yesterday = sdf_yyyy_MM_dd.format(curr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return yesterday;
    }

    public static final String tuneSecond(String date, int amount) {
        String yesterday = null;
        try {
            Date curr = sdf_yyyy_MM_dd_HH_mm_ss.parse(date);
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(curr);
            gc.add(13, amount);
            curr = gc.getTime();
            yesterday = sdf_yyyy_MM_dd_HH_mm_ss.format(curr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return yesterday;
    }

    public static final String tuneDate(Date date, int amount) {
        String dateString = sdf_yyyy_MM_dd.format(date);
        return DateUtil.tuneDate(dateString, amount);
    }

    public static final String tuneDateTime(Date date, int amount) {
        String dateTimeString = sdf_yyyy_MM_dd_HH_mm_ss.format(date);
        String[] arr = dateTimeString.split(" ");
        String dateString = arr[0];
        String timeString = arr[1];
        return DateUtil.tuneDate(dateString, amount) + " " + timeString;
    }

    public static final String[] getDateTimeArr(String datetime) {
        if (datetime.indexOf(" ") != -1) {
            String[] arr = datetime.split(" ");
            String date = arr[0];
            String time = arr[1];
            String[] dateArr = date.split("-");
            String[] timeArr = time.split(":");
            String[] resultArr = new String[]{dateArr[0], dateArr[1], dateArr[2], timeArr[0], timeArr[1], timeArr[2]};
            return resultArr;
        }
        if (datetime.indexOf("-") != -1) {
            return datetime.split("-");
        }
        if (datetime.indexOf(":") != -1) {
            return datetime.split(":");
        }
        return null;
    }

    public static String getDateOfWeek(Date date, int week) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(7, CalendarWeek[week]);
        String result = sdf_yyyy_MM_dd.format(cal.getTime());
        System.out.println(result);
        return result;
    }

    public static String getDateOfQuarter(String date, boolean isBegin) {
        String quarBegin = "";
        String quarEnd = "";
        String[] arr = DateUtil.getDateTimeArr(date);
        String year = arr[0];
        String month = arr[1];
        switch (Integer.parseInt(month)) {
            case 1: 
            case 2: 
            case 3: {
                quarBegin = year + "-01-01";
                quarEnd = year + "-03-31";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                quarBegin = year + "-04-01";
                quarEnd = year + "-06-30";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                quarBegin = year + "-07-01";
                quarEnd = year + "-09-30";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                quarBegin = year + "-10-01";
                quarEnd = year + "-12-31";
                break;
            }
        }
        if (isBegin) {
            return quarBegin;
        }
        return quarEnd;
    }

    public static void main(String[] args) {
        Date d = null;
        try {
            d = sdf_yyyy_MM_dd.parse("2008-10-29");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DateUtil.getDateOfWeek(d, 0);
        DateUtil.getDateOfWeek(d, 3);
        DateUtil.getDateOfWeek(d, 6);
    }
}

