/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.model;

import com.kingdee.bos.ctrl.common.datacenter.DataCenterDBType;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.DateUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.SqlParamParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public class SqlWhereParser {
    public static final Logger log = LogUtil.getPackageLogger(SqlWhereParser.class);
    public static final String EX_LIST = "EX_LIST";
    public static final String EX_DATETIME = "EX_DATETIME";
    private static final String Formula_String = "Formula_String";
    private static final String Field_String = "Field_String";
    private static final String Operator_String = "Operator_String";
    private static final String Param_String = "Param_String";
    private static final String RealParamName = "realParamName";
    public static final String BEGIN0xx1xx = "BEGIN0XX1XX";
    public static final String END0xx1xx = " OR (END0XX1XX IS NULL)";
    private static final int IN_PARAM_MAXNUM = 500;
    public static final String DateTimeEnd = "01:02:03";
    private static final String ZERO = "00:00:00";

    private static final int indexOf(String source, String target, int n) {
        int index = 0;
        int i = 0;
        int fromIndex = 0;
        while ((index = source.indexOf(target, fromIndex)) != -1) {
            if (++i == n) {
                return index;
            }
            fromIndex = index + 1;
        }
        return index;
    }

    public static final String parseList(String sql, ArrayList lstParam) {
        HashMap mapFormula = SqlWhereParser.splitEX(sql, EX_LIST);
        if (null == mapFormula) {
            return sql;
        }
        String formula_list = mapFormula.get(Formula_String).toString();
        String field = mapFormula.get(Field_String).toString();
        String operator = mapFormula.get(Operator_String).toString();
        String paramString = mapFormula.get(Param_String).toString();
        String realParamName = mapFormula.get(RealParamName).toString();
        ArrayList<DesignParameter> lstNewAddParam = new ArrayList<DesignParameter>();
        StringBuffer newWhere = new StringBuffer();
        for (DesignParameter p : lstParam) {
            String currentName = p.getName();
            if (!realParamName.equalsIgnoreCase(currentName)) continue;
            String[] values = p.getCurentValueArr();
            if (null != values && values.length > 1) {
                int length = values.length;
                String newParamName = currentName + String.valueOf(CtrlReportUtil.getSystemTime());
                if (operator.equals("IN") || operator.equals("NOT IN")) {
                    newWhere.append(field).append(" ").append(operator).append(" (");
                } else {
                    newWhere.append("(");
                }
                for (int n = 0; n < length; ++n) {
                    String currentNewParamName = newParamName + "_" + n;
                    String newParamNameTemp = ExtStringUtil.replace(paramString, "@" + currentName, "@" + currentNewParamName, false, false);
                    if (operator.equals("IN") || operator.equals("NOT IN")) {
                        newWhere.append(newParamNameTemp);
                        if (n < length - 1) {
                            newWhere.append(", ");
                        }
                    } else {
                        newWhere.append(field).append(" ").append(operator).append(" ").append(newParamNameTemp);
                        if (n < length - 1) {
                            newWhere.append(" OR ");
                        }
                    }
                    DesignParameter pNew = new DesignParameter();
                    pNew.setName(currentNewParamName);
                    pNew.setDesignDataType(p.getDesignDataType());
                    pNew.setCurentValue(values[n]);
                    lstNewAddParam.add(pNew);
                }
                newWhere.append(")");
                break;
            }
            paramString = ExtStringUtil.replace(paramString, "@" + currentName, "@" + currentName, false, false);
            if (operator.equals("IN") || operator.equals("NOT IN")) {
                newWhere.append(field).append(" ").append(operator).append(" (").append(paramString).append(")");
                break;
            }
            newWhere.append("(").append(field).append(" ").append(operator).append(" ").append(paramString).append(")");
            break;
        }
        lstParam.addAll(lstNewAddParam);
        sql = ExtStringUtil.replace(sql, formula_list, newWhere.toString(), false, false);
        return SqlWhereParser.parseList(sql, lstParam);
    }

    public static final String getRealParamName(String source) {
        return SqlWhereParser.getRealParamNameBySymbol(source, "@");
    }

    public static final String getRealParamNameMacro(String source) {
        return SqlWhereParser.getRealParamNameBySymbol(source, "?");
    }

    public static final String getRealParamNameBySymbol(String source, String symbol) {
        String s;
        int start = source.indexOf(symbol);
        if (start == -1) {
            return null;
        }
        source = source.substring(start + 1);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < source.length() && !SqlParamParser.isErrorParamName(s = source.substring(i, i + 1)); ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static final String parseDialectDateTime(String sql, HashMap mapDesignParam, int tempParamSize, int DBType) {
        try {
            HashMap mapFormula = SqlWhereParser.splitEXSimple(sql, EX_DATETIME);
            if (null == mapFormula) {
                return sql;
            }
            String formula_string = mapFormula.get(Formula_String).toString();
            String field = mapFormula.get(Field_String).toString();
            String operator = mapFormula.get(Operator_String).toString();
            String paramString = mapFormula.get(Param_String).toString();
            String realParamName = mapFormula.get(RealParamName).toString();
            StringBuffer newWhere = new StringBuffer();
            paramString = ExtStringUtil.replace(paramString, "'", "");
            String subStr = "@" + realParamName;
            if (!mapDesignParam.containsKey(realParamName)) {
                return sql;
            }
            DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(realParamName));
            String currentName = p.getName();
            String valueDate = p.getCurentValue();
            int dataType = p.getDesignDataType().intValue();
            String newParamName = currentName + String.valueOf(CtrlReportUtil.getSystemTime()) + "_" + ++tempParamSize;
            boolean isUserNewParamName = false;
            String newValueDate = "";
            String replaceOldName = currentName;
            String replaceNewName = newParamName;
            if (dataType == 2) {
                if (DBType == DataCenterDBType.ORACLE.intValue()) {
                    replaceOldName = "TO_DATE('@" + currentName + " 00:00:00', 'YYYY-MM-DD HH24:MI:SS')";
                    replaceNewName = "TO_DATE('@" + replaceNewName + " 00:00:00', 'YYYY-MM-DD HH24:MI:SS')";
                } else {
                    replaceOldName = "'@" + currentName + " 00:00:00'";
                    replaceNewName = "'@" + replaceNewName + " 00:00:00'";
                }
                if (valueDate != null && valueDate.length() > 0) {
                    newValueDate = DateUtil.tuneDate(valueDate, 1);
                }
            } else if (dataType == 4) {
                if (DBType == DataCenterDBType.ORACLE.intValue()) {
                    replaceOldName = "TO_DATE('@" + currentName + "', 'YYYY-MM-DD HH24:MI:SS')";
                    replaceNewName = "TO_DATE('@" + replaceNewName + "', 'YYYY-MM-DD HH24:MI:SS')";
                } else {
                    replaceOldName = "'@" + currentName + "'";
                    replaceNewName = "'@" + replaceNewName + "'";
                }
                if (valueDate != null && valueDate.length() > 0) {
                    newValueDate = DateUtil.tuneSecond(valueDate, 1);
                }
            } else if (dataType == 5) {
                replaceOldName = "'@" + currentName + "'";
                if (DBType == 3) {
                    newWhere.append("CONVERT(varchar(12), ").append(field).append(", 108) ").append(operator).append(" ").append(replaceOldName);
                } else if (DBType == 2 || DBType == 5) {
                    newWhere.append("TO_CHAR(").append(field).append(", 'HH24:MI:SS') ").append(operator).append(" ").append(replaceOldName);
                } else if (DBType == 1) {
                    newWhere.append("SUBSTR(TO_CHAR(").append(field).append(", 'YYYY-MM-DD HH24:MI:SS'), 12, 8) ").append(operator).append(" ").append(replaceOldName);
                }
            } else {
                log.error((Object)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\u8f6c\u6362\uff0c\u8bf7\u4f7f\u7528\u5176\u4ed6\u65b9\u5f0f");
                return sql;
            }
            if (dataType != 5) {
                String paramString_end;
                String paramString_star;
                newWhere.append("(");
                if (operator.equals("=")) {
                    newWhere.append(field).append(" >= ");
                    paramString_star = ExtStringUtil.replaceFirst(paramString, subStr, replaceOldName);
                    newWhere.append(paramString_star);
                    newWhere.append(" AND ");
                    newWhere.append(field).append(" < ");
                    String paramString_end2 = ExtStringUtil.replaceFirst(paramString, subStr, replaceNewName);
                    newWhere.append(paramString_end2);
                    isUserNewParamName = true;
                } else if (operator.equals(">")) {
                    newWhere.append(field).append(" >= ");
                    paramString_end = ExtStringUtil.replaceFirst(paramString, subStr, replaceNewName);
                    newWhere.append(paramString_end);
                    isUserNewParamName = true;
                } else if (operator.equals(">=")) {
                    newWhere.append(field).append(" >= ");
                    paramString_end = ExtStringUtil.replaceFirst(paramString, subStr, replaceOldName);
                    newWhere.append(paramString_end);
                } else if (operator.equals("<")) {
                    newWhere.append(field).append(" < ");
                    paramString_end = ExtStringUtil.replaceFirst(paramString, subStr, replaceOldName);
                    newWhere.append(paramString_end);
                } else if (operator.equals("<=")) {
                    newWhere.append(field).append(" < ");
                    paramString_end = ExtStringUtil.replaceFirst(paramString, subStr, replaceNewName);
                    newWhere.append(paramString_end);
                    isUserNewParamName = true;
                } else if (operator.equals("<>")) {
                    newWhere.append(field).append(" < ");
                    paramString_star = ExtStringUtil.replaceFirst(paramString, subStr, replaceOldName);
                    newWhere.append(paramString_star);
                    newWhere.append(" AND ");
                    newWhere.append(field).append(" >= ");
                    String paramString_end3 = ExtStringUtil.replaceFirst(paramString, subStr, replaceNewName);
                    newWhere.append(paramString_end3);
                    isUserNewParamName = true;
                }
                newWhere.append(")");
            }
            if (isUserNewParamName) {
                DesignParameter pNew = new DesignParameter();
                pNew.setName(newParamName);
                pNew.setDesignDataType(p.getDesignDataType());
                pNew.setCurentValue(newValueDate);
                mapDesignParam.put(newParamName, pNew);
            }
            sql = ExtStringUtil.replaceFirst(sql, formula_string, newWhere.toString());
            return SqlWhereParser.parseDialectDateTime(sql, mapDesignParam, tempParamSize, DBType);
        }
        catch (Exception e) {
            log.error((Object)"parseDialectDateTime error", (Throwable)e);
            return sql;
        }
    }

    public static final String parseKSQLList(String whereString, String field, String operator, String paramString, HashMap mapDesignParam, HashMap mapParam) {
        String realParamName;
        String commaField;
        boolean isComma = false;
        String tempFlag = "";
        paramString = paramString == null ? "" : paramString;
        tempFlag = operator != null && (operator.equalsIgnoreCase("IN") || operator.equalsIgnoreCase("NOT IN")) ? "('" + paramString : "'" + paramString;
        String wString = whereString.toLowerCase();
        if (wString.indexOf(tempFlag.toLowerCase()) != -1) {
            isComma = true;
        }
        if (wString.indexOf(commaField = "'" + field + "'") == 0) {
            field = commaField;
        }
        if ((realParamName = SqlWhereParser.getRealParamName(paramString)) == null) {
            log.debug((Object)(paramString + " \u6ca1\u6709\u53c2\u6570\u6807\u8bc6@"));
            return null;
        }
        HashMap<String, DesignParameter> mapDesignParamNew = new HashMap<String, DesignParameter>();
        StringBuffer newWhere = new StringBuffer();
        Iterator it = mapDesignParam.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(name));
            String currentName = p.getName();
            DesignDataType ddt = p.getDesignDataType();
            if (!realParamName.equalsIgnoreCase(currentName)) continue;
            String[] values = null;
            String value = p.getCurentValue();
            value = StringUtil.isEmptyString((String)value) ? p.getDefaultValue() : value;
            String string = value = value == null ? "" : value;
            if (value.indexOf("0xx1xx") != -1) {
                values = value.split("0xx1xx", -1);
            }
            if (null != values && values.length > 1) {
                int length = values.length;
                String newParamName = currentName + String.valueOf(CtrlReportUtil.getSystemTime());
                if (null != operator && (operator.equalsIgnoreCase("IN") || operator.equalsIgnoreCase("NOT IN"))) {
                    newWhere.append(field).append(" ").append(operator).append(" (");
                } else {
                    newWhere.append("(");
                }
                for (int n = 0; n < length; ++n) {
                    String currentNewParamName = newParamName + "_" + n;
                    String newParamNameTemp = ExtStringUtil.replace(paramString, "@" + currentName, "@" + currentNewParamName, false, false);
                    if (isComma) {
                        newParamNameTemp = "'" + newParamNameTemp + "'";
                    }
                    if (null != operator && (operator.equalsIgnoreCase("IN") || operator.equalsIgnoreCase("NOT IN"))) {
                        newWhere.append(newParamNameTemp);
                        if (n + 1 < length && (n + 1) % 500 == 0) {
                            newWhere.append(") OR ").append(field).append(" ").append(operator).append(" (");
                        } else if (n < length - 1) {
                            newWhere.append(", ");
                        }
                    } else {
                        newWhere.append(field).append(" ").append(operator).append(" ").append(newParamNameTemp);
                        if (n < length - 1) {
                            newWhere.append(" or ");
                        }
                    }
                    DesignParameter pNew = new DesignParameter();
                    pNew.setName(currentNewParamName);
                    pNew.setDesignDataType(p.getDesignDataType());
                    pNew.setCurentValue(values[n]);
                    mapDesignParamNew.put(currentNewParamName, pNew);
                    mapParam.put(currentNewParamName, values[n]);
                }
                newWhere.append(")");
                break;
            }
            paramString = ExtStringUtil.replace(paramString, "@" + currentName, "@" + currentName, false, false);
            if (isComma) {
                paramString = "'" + paramString + "'";
            }
            if (null != operator && (operator.equalsIgnoreCase("IN") || operator.equalsIgnoreCase("NOT IN"))) {
                newWhere.append(field).append(" ").append(operator).append(" (").append(paramString).append(")");
                break;
            }
            newWhere.append("(").append(field).append(" ").append(operator).append(" ").append(paramString).append(")");
            break;
        }
        mapDesignParam.putAll(mapDesignParamNew);
        return newWhere.toString();
    }

    public static final String parseKSQLDateTime(String field, String operator, String paramString) {
        int start = paramString.indexOf("{TS '");
        int end = paramString.indexOf("'}");
        String dateTimeString = paramString.substring(start + 5, end);
        if (paramString.indexOf("{TS") != -1) {
            String[] arr = dateTimeString.split(" ");
            String strDate = arr[0];
            String strTime = arr[1];
            if (strTime.equals(DateTimeEnd)) {
                return SqlWhereParser.chgDate(field, operator, strDate);
            }
            return SqlWhereParser.chgDateTime(field, operator, dateTimeString);
        }
        if (paramString.indexOf("{T") != -1) {
            return SqlWhereParser.chgTime(field, operator, dateTimeString);
        }
        return null;
    }

    private static final String chgDate(String field, String operator, String strDate) {
        StringBuffer where = new StringBuffer();
        if (operator.equals("=")) {
            String dateAdd = DateUtil.tuneDate(strDate, 1);
            where.append("(");
            where.append(field).append(" >= ").append("{TS '").append(strDate).append(" ").append(ZERO).append("'}");
            where.append(" and ");
            where.append(field).append(" < ").append("{TS '").append(dateAdd).append(" ").append(ZERO).append("'}");
            where.append(")");
        } else if (operator.equals(">")) {
            String dateAdd = DateUtil.tuneDate(strDate, 1);
            where.append(field).append(" >= ").append("{TS '").append(dateAdd).append(" ").append(ZERO).append("'}");
        } else if (operator.equals(">=")) {
            where.append(field).append(" >= ").append("{TS '").append(strDate).append(" ").append(ZERO).append("'}");
        } else if (operator.equals("<")) {
            where.append(field).append(" < ").append("{TS '").append(strDate).append(" ").append(ZERO).append("'}");
        } else if (operator.equals("<=")) {
            String dateAdd = DateUtil.tuneDate(strDate, 1);
            where.append(field).append(" < ").append("{TS '").append(dateAdd).append(" ").append(ZERO).append("'}");
        } else if (operator.equals("<>")) {
            String dateAdd = DateUtil.tuneDate(strDate, 1);
            where.append("(");
            where.append(field).append(" < ").append("{TS '").append(strDate).append(" ").append(ZERO).append("'}");
            where.append(" and ");
            where.append(field).append(" >= ").append("{TS '").append(dateAdd).append(" ").append(ZERO).append("'}");
            where.append(")");
        }
        return where.toString();
    }

    private static final String chgDateTime(String field, String operator, String strDateTime) {
        StringBuffer where = new StringBuffer();
        if (operator.equals("=")) {
            String newDateTime = DateUtil.tuneSecond(strDateTime, 1);
            where.append("(");
            where.append(field).append(" >= ").append("{TS '").append(strDateTime).append("'}");
            where.append(" and ");
            where.append(field).append(" < ").append("{TS '").append(newDateTime).append("'}");
            where.append(")");
        } else if (operator.equals(">")) {
            String newDateTime = DateUtil.tuneSecond(strDateTime, 1);
            where.append(field).append(" >= ").append("{TS '").append(newDateTime).append("'}");
        } else if (operator.equals(">=")) {
            where.append(field).append(" >= ").append("{TS '").append(strDateTime).append("'}");
        } else if (operator.equals("<")) {
            where.append(field).append(" < ").append("{TS '").append(strDateTime).append("'}");
        } else if (operator.equals("<=")) {
            String newDateTime = DateUtil.tuneSecond(strDateTime, 1);
            where.append(field).append(" < ").append("{TS '").append(newDateTime).append("'}");
        } else if (operator.equals("<>")) {
            String newDateTime = DateUtil.tuneSecond(strDateTime, 1);
            where.append("(");
            where.append(field).append(" < ").append("{TS '").append(strDateTime).append("'}");
            where.append(" and ");
            where.append(field).append(" >= ").append("{TS '").append(newDateTime).append("'}");
            where.append(")");
        }
        return where.toString();
    }

    private static final String chgTime(String field, String operator, String strTime) {
        StringBuffer where = new StringBuffer();
        if (field.startsWith("\"")) {
            field = field.substring(1);
            where.append("\"");
        }
        where.append(BEGIN0xx1xx).append(field).append(" ").append(operator).append(" {T '").append(strTime).append("'}").append(END0xx1xx);
        return where.toString();
    }

    public static final String parseKSQLTime(String sql, int dbType) throws CtrlReportException {
        int begin = sql.indexOf(BEGIN0xx1xx);
        if (begin == -1) {
            return sql;
        }
        try {
            sql = "/*dialect*/" + TransUtil.Translate((String)sql, (int)dbType);
        }
        catch (SqlTranslateException e) {
            throw CtrlReportException.makeException("KSQL\u7ffb\u8bd1\u5931\u8d25" + e.getMessage(), e);
        }
        int n = begin = sql.indexOf(BEGIN0xx1xx) == -1 ? sql.toUpperCase().indexOf(BEGIN0xx1xx) : sql.indexOf(BEGIN0xx1xx);
        while (begin != -1) {
            StringBuffer where = new StringBuffer();
            int end = sql.indexOf(END0xx1xx) == -1 ? sql.toUpperCase().indexOf(END0xx1xx) : sql.indexOf(END0xx1xx);
            String temp = sql.substring(begin, end).trim();
            String sourceReplace = sql.substring(begin, end + END0xx1xx.length());
            String[] arr = temp.split(" ");
            String field = arr[0];
            if (field.indexOf("\".") != -1) {
                temp = sql.substring(begin - 1, end).trim();
                sourceReplace = sql.substring(begin - 1, end + END0xx1xx.length());
            }
            arr = temp.split(" ");
            field = arr[0];
            field = ExtStringUtil.replaceFirst(field, BEGIN0xx1xx, "");
            String operator = arr[1];
            String filterValue = arr[2];
            if (dbType == 3) {
                where.append("CONVERT(varchar(12), ").append(field).append(", 108) ").append(operator).append(" ").append(filterValue);
            } else if (dbType == 2) {
                sourceReplace = "(" + sourceReplace;
                filterValue = ExtStringUtil.replace(filterValue, "TO_DATE(", "", false, false);
                filterValue = ExtStringUtil.replace(filterValue, ",", "", false, false);
                where.append("TO_CHAR(").append(field).append(", 'HH24:MI:SS') ").append(operator).append(" ").append(filterValue);
            } else if (dbType == 1) {
                where.append("SUBSTR(TO_CHAR(").append(field).append(", 'YYYY-MM-DD HH24:MI:SS'), 12, 8) ").append(operator).append(" ").append(filterValue);
            } else if (dbType == 5) {
                filterValue = arr[arr.length - 1];
                filterValue = "'" + filterValue;
                filterValue = ExtStringUtil.replace(filterValue, "TO_DATE(", "", false, false);
                filterValue = ExtStringUtil.replace(filterValue, ",", "", false, false);
                where.append("TO_CHAR(").append(field).append(", 'HH24:MI:SS') ").append(operator).append(" ").append(filterValue);
            }
            sql = ExtStringUtil.replaceFirst(sql, sourceReplace, where.toString());
            begin = sql.indexOf(BEGIN0xx1xx) == -1 ? sql.toUpperCase().indexOf(BEGIN0xx1xx) : sql.indexOf(BEGIN0xx1xx);
        }
        return sql;
    }

    private static final String containsKeyIgnoreCase(Map map, String key) {
        if (map == null || map.isEmpty() || StringUtil.isEmptyString((String)key)) {
            return null;
        }
        for (Object k : map.keySet()) {
            if (!(k instanceof String) || !key.equalsIgnoreCase(k.toString())) continue;
            return k.toString();
        }
        return null;
    }

    public static final String parseDialect(String source, HashMap mapDesignParam, HashMap warnMap) throws Exception {
        String sqlNoRN;
        String warnMsg;
        StringBuffer sbSql = new StringBuffer();
        int start = source.indexOf("@");
        String sqlBefore = source.substring(0, start);
        String sqlAfter = source.substring(start + 1);
        String paramName = SqlWhereParser.getRealParamName("@" + sqlAfter);
        String parmaValue = "";
        DesignDataType parmaType = DesignDataType.TXT;
        boolean isAllowNull = true;
        boolean isIgnoreEmpty = false;
        String pName = SqlWhereParser.containsKeyIgnoreCase(mapDesignParam, paramName);
        if (!StringUtil.isEmptyString((String)pName)) {
            DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(pName));
            parmaValue = CtrlReportUtil.getObjectString(p.getCurentValue());
            parmaValue = StringUtil.isEmptyString((String)parmaValue) ? p.getDefaultValue() : parmaValue;
            parmaType = p.getDesignDataType();
            isAllowNull = p.isAllowNull();
            isIgnoreEmpty = p.isIgnoreNull();
        }
        boolean isFindWH = false;
        int wh = sqlAfter.indexOf("?");
        int art = sqlAfter.indexOf("@");
        if (wh != -1 && art != -1 && wh < art) {
            isFindWH = true;
        } else if (wh != -1 && art == -1) {
            isFindWH = true;
        }
        if (null == parmaValue) {
            parmaValue = "";
        }
        parmaValue = CtrlReportUtil.strFilterSQL(parmaValue);
        boolean isIcom = false;
        if (sqlAfter.indexOf(paramName + "'") != -1 || sqlAfter.indexOf(paramName + "%") != -1 || sqlAfter.indexOf(paramName + " " + ZERO) != -1) {
            isIcom = true;
        }
        String valueSplit = "";
        String[] values = parmaValue.split("0xx1xx", -1);
        if (null != values && values.length > 1) {
            for (String currentValue : values) {
                valueSplit = isIcom ? valueSplit + currentValue + "', '" : valueSplit + currentValue + ", ";
            }
            if (isIcom) {
                if (valueSplit.length() > 0) {
                    valueSplit = valueSplit.substring(0, valueSplit.length() - 4);
                }
            } else if (valueSplit.length() > 0) {
                valueSplit = valueSplit.substring(0, valueSplit.length() - 2);
            }
        } else {
            valueSplit = parmaValue;
            if (valueSplit.length() == 0 && isIgnoreEmpty) {
                if (isIcom) {
                    if (parmaType.equals(DesignDataType.DATE)) {
                        valueSplit = CtrlReportUtil.formatDate(new Date());
                    } else if (parmaType.equals(DesignDataType.DATETIME)) {
                        valueSplit = CtrlReportUtil.formatDate(new Date());
                        valueSplit = valueSplit + " " + DateTimeEnd;
                    } else if (parmaType.equals(DesignDataType.TIME)) {
                        valueSplit = DateTimeEnd;
                    } else if (parmaType.equals(DesignDataType.NUMERICAL)) {
                        valueSplit = "1234567890";
                    }
                } else {
                    valueSplit = "1234567890";
                }
            }
        }
        if (isFindWH) {
            sqlAfter = parmaValue.length() == 0 ? ExtStringUtil.replaceFirst(sqlAfter, " ? ", " null ") : ExtStringUtil.replaceFirst(sqlAfter, " ? ", " 0 ");
        }
        int dbType = 3;
        if (StringUtil.isEmptyString((String)(valueSplit = CtrlReportUtil.artToExart(valueSplit))) && !isIgnoreEmpty) {
            String sqlAfterTemp = sqlAfter;
            sqlAfterTemp = ExtStringUtil.replaceFirst("@" + sqlAfterTemp, "@" + paramName, valueSplit);
            Object[] result = SqlWhereParser.handleParamEmpty(sqlBefore, sqlAfterTemp, isIgnoreEmpty, dbType);
            isIgnoreEmpty = (Boolean)result[2];
            if (!isIgnoreEmpty) {
                sqlBefore = (String)result[0];
                sbSql.append(sqlBefore);
                sqlAfter = (String)result[1];
                log.error((Object)("\u4f7f\u7528\u7a7a\u503c\u8fc7\u6ee4\u7684SQL: " + sqlBefore + sqlAfter));
            }
        }
        if (!StringUtil.isEmptyString((String)valueSplit) || isIgnoreEmpty) {
            sbSql.append(sqlBefore);
            sqlAfter = ExtStringUtil.replaceFirst("@" + sqlAfter, "@" + paramName, valueSplit);
        }
        sbSql.append(sqlAfter);
        if (!isFindWH && isAllowNull && isIgnoreEmpty && (warnMsg = CtrlReportUtil.getObjectString(warnMap.get("warnMsg"))).equals("") && (sqlNoRN = (String)warnMap.get("sqlNoRN")).indexOf("? is null") == -1) {
            warnMap.put("warnMsg", MessageUtil.getMsgInfo("label340") + "\r\n" + MessageUtil.getMsgInfo("label341"));
        }
        return sbSql.toString();
    }

    private static Object[] handleParamEmpty(String sqlBefore, String sqlAfter, boolean isIgnoreEmpty, int dbType) {
        String upperBefore = sqlBefore.toUpperCase();
        int indexGTOE = upperBefore.lastIndexOf(">=");
        int indexLTOE = upperBefore.lastIndexOf("<=");
        int indexEqual = upperBefore.lastIndexOf("=");
        if (indexGTOE > 0 && indexGTOE == indexEqual - 1 || indexLTOE > 0 && indexLTOE == indexEqual - 1) {
            indexEqual = -1;
        }
        int indexNotEqual = upperBefore.lastIndexOf("<>");
        int indexGT = upperBefore.lastIndexOf(">");
        int indexLT = upperBefore.lastIndexOf("<");
        if (indexNotEqual > 0 && indexNotEqual == indexGT - 1 || indexGTOE > 0 && indexGTOE == indexGT) {
            indexGT = -1;
        }
        if (indexNotEqual > 0 && indexLT == indexEqual || indexLTOE > 0 && indexLTOE == indexLT) {
            indexLT = -1;
        }
        int indexIn = upperBefore.lastIndexOf(" IN ");
        int indexNotIn = upperBefore.lastIndexOf(" NOT IN ");
        if (indexNotIn > 0 && indexNotIn == indexIn - 4) {
            indexIn = -1;
        }
        int indexNotLike = upperBefore.lastIndexOf(" NOT LIKE ");
        int indexLike = upperBefore.lastIndexOf(" LIKE ");
        if (indexNotLike > 0 && indexNotLike == indexLike - 4) {
            indexLike = -1;
        }
        int[] operatorArr = new int[]{indexGTOE, indexLTOE, indexEqual, indexNotEqual, indexGT, indexLT, indexIn, indexNotIn, indexLike, indexNotLike};
        Arrays.sort(operatorArr);
        int indexOperator = operatorArr[operatorArr.length - 1];
        int indexFirstWhere = upperBefore.lastIndexOf("WHERE");
        Stack<Object> sOpen = new Stack<Object>();
        int indexLeft = SqlWhereParser.findIndexLeft(sqlBefore, indexFirstWhere, indexOperator, sOpen);
        int indexRight = -1;
        if (indexLeft <= indexFirstWhere + 4) {
            isIgnoreEmpty = true;
        } else {
            indexRight = SqlWhereParser.findIndexRight(sqlBefore, sqlAfter, indexLeft, sOpen);
            if (indexRight >= sqlAfter.length()) {
                isIgnoreEmpty = true;
            }
        }
        if (!isIgnoreEmpty) {
            if (indexGTOE == indexOperator || indexLTOE == indexOperator || indexEqual == indexOperator || indexIn == indexOperator || indexLike == indexOperator) {
                if (indexGTOE == indexOperator && 3 == dbType || indexLTOE == indexOperator && 3 != dbType) {
                    sqlAfter = sqlAfter.substring(0, indexRight) + " or null is null " + sqlAfter.substring(indexRight, sqlAfter.length());
                } else {
                    String strField = sqlBefore.substring(indexLeft + 1, indexOperator);
                    sqlAfter = sqlAfter.substring(0, indexRight) + " or " + strField + " is null " + sqlAfter.substring(indexRight, sqlAfter.length());
                }
            } else if (indexNotEqual == indexOperator || indexNotIn == indexOperator || indexNotLike == indexOperator) {
                if (3 != dbType) {
                    sqlBefore = sqlBefore.substring(0, indexLeft) + " is not null ";
                    sqlAfter = sqlAfter.substring(indexRight, sqlAfter.length());
                }
            } else {
                isIgnoreEmpty = true;
            }
        }
        return new Object[]{sqlBefore, sqlAfter, isIgnoreEmpty};
    }

    private static int findIndexLeft(String sqlBefore, int indexFirstWhere, int indexOperator, Stack<Object> sOpen) {
        int indexLeft;
        for (indexLeft = sqlBefore.length() - 1; indexLeft > indexFirstWhere + 4; --indexLeft) {
            char c = sqlBefore.charAt(indexLeft);
            if (c == '(') {
                if (!sOpen.isEmpty() && ')' == ((Character)sOpen.lastElement()).charValue()) {
                    sOpen.pop();
                    continue;
                }
                if (indexLeft < indexOperator) {
                    sOpen.push(Character.valueOf(c));
                    break;
                }
                sOpen.push(Character.valueOf(c));
                continue;
            }
            if (c != ')') continue;
            sOpen.push(Character.valueOf(c));
        }
        return indexLeft;
    }

    private static int findIndexRight(String sqlBefore, String sqlAfter, int indexLeft, Stack<Object> sOpen) {
        int indexRight;
        Stack<Character> sClose = new Stack<Character>();
        for (indexRight = 0; indexRight < sqlAfter.length(); ++indexRight) {
            char c = sqlAfter.charAt(indexRight);
            if (c == ')') {
                if (!sClose.isEmpty() && '(' == ((Character)sClose.lastElement()).charValue()) {
                    sClose.pop();
                } else {
                    sClose.push(Character.valueOf(c));
                }
            } else if (c == '(') {
                sClose.push(Character.valueOf(c));
            }
            if (sClose.size() == sOpen.size()) break;
        }
        return indexRight;
    }

    public static final String getOperator(int op) {
        String operator = null;
        switch (op) {
            case 10: {
                operator = "=";
                break;
            }
            case 11: {
                operator = ">";
                break;
            }
            case 12: {
                operator = ">=";
                break;
            }
            case 13: {
                operator = "is";
                break;
            }
            case 14: {
                operator = "<";
                break;
            }
            case 15: {
                operator = "<=";
                break;
            }
            case 16: {
                operator = "<>";
                break;
            }
            case 18: {
                operator = "like";
                break;
            }
            case 40: {
                operator = "not like";
                break;
            }
            case 41: {
                operator = "is not";
                break;
            }
        }
        return operator;
    }

    public static final HashMap splitEX(String sql, String ex_formula) {
        int param_end_location;
        HashMap<String, String> map = new HashMap<String, String>();
        String source = sql.toUpperCase();
        int iList = source.indexOf(ex_formula);
        if (iList == -1) {
            log.error((Object)("\u6ca1\u6709:" + ex_formula));
            return null;
        }
        String ex_list_star = source.substring(iList);
        int last_b_bk = SqlWhereParser.indexOf(ex_list_star, "}", 3);
        if (last_b_bk == -1) {
            log.error((Object)"\u5206\u79bb\u516c\u5f0f\u9519\u8bef\uff0c\u6ca1\u6709\u6700\u540e\u7684\u5927\u62ec\u53f7");
            return null;
        }
        String b_bk_star = ex_list_star.substring(last_b_bk);
        int last_l_bk = SqlWhereParser.indexOf(b_bk_star, ")", 1);
        if (last_l_bk == -1) {
            log.error((Object)"\u5206\u79bb\u516c\u5f0f\u9519\u8bef\uff0c\u6ca1\u6709\u6700\u540e\u7684\u5c0f\u62ec\u53f7");
            return null;
        }
        int end_location = last_b_bk + last_l_bk + 1;
        String formula_list = ex_list_star.substring(0, end_location);
        int field_star_location = SqlWhereParser.indexOf(formula_list, "{", 1);
        int field_end_location = SqlWhereParser.indexOf(formula_list, "}", 1);
        String field = formula_list.substring(field_star_location + 1, field_end_location);
        int operator_star_location = SqlWhereParser.indexOf(formula_list, "{", 2);
        int operator_end_location = SqlWhereParser.indexOf(formula_list, "}", 2);
        String operator = formula_list.substring(operator_star_location + 1, operator_end_location);
        operator = CtrlReportUtil.trimStr(operator);
        int param_star_location = SqlWhereParser.indexOf(formula_list, "{", 3);
        String paramString = formula_list.substring(param_star_location + 1, param_end_location = SqlWhereParser.indexOf(formula_list, "}", 3));
        String realParamName = SqlWhereParser.getRealParamName(paramString);
        if (realParamName == null) {
            log.error((Object)(paramString + " \u6ca1\u6709\u53c2\u6570\u6807\u8bc6@"));
            return null;
        }
        map.put(Formula_String, formula_list);
        map.put(Field_String, field);
        map.put(Operator_String, operator);
        map.put(Param_String, paramString);
        map.put(RealParamName, realParamName);
        return map;
    }

    public static final HashMap splitEXSimple(String sql, String ex_formula) {
        HashMap<String, String> map = new HashMap<String, String>();
        String source = sql.toUpperCase();
        int iList = source.indexOf(ex_formula);
        if (iList == -1) {
            log.info((Object)("\u6ca1\u6709:" + ex_formula));
            return null;
        }
        String ex_list_star = sql.substring(iList);
        int last_b_bk = SqlWhereParser.indexOf(ex_list_star, ")", 1);
        if (last_b_bk == -1) {
            log.error((Object)"\u5206\u79bb\u516c\u5f0f\u9519\u8bef\uff0c\u6ca1\u6709\u6700\u540e\u7684\u62ec\u53f7");
            return null;
        }
        String formula_string = sql.substring(iList, iList + last_b_bk + 1);
        String temp = ExtStringUtil.replace(formula_string, ex_formula, "", false, false);
        temp = ExtStringUtil.replaceFirst(temp, "(", "");
        temp = ExtStringUtil.replaceFirst(temp, ")", "");
        temp = temp.trim();
        String[] arr = temp.split(",");
        String field = arr[0].trim();
        String operator = arr[1].trim();
        String paramString = arr[2].trim();
        String realParamName = SqlWhereParser.getRealParamName(paramString);
        if (realParamName == null) {
            log.error((Object)(paramString + " \u6ca1\u6709\u53c2\u6570\u6807\u8bc6@"));
            return null;
        }
        map.put(Formula_String, formula_string);
        map.put(Field_String, field);
        map.put(Operator_String, operator);
        map.put(Param_String, paramString);
        map.put(RealParamName, realParamName);
        return map;
    }
}

