/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.mobileService.card;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.CardDAO;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.CardVO;
import com.kingdee.eas.rpts.mobileService.common.IResourceMethodHandler;
import com.kingdee.eas.rpts.mobileService.model.MobileResult;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class ExtLightCardListHandler
implements IResourceMethodHandler {
    @Override
    public MobileResult handle(Context easCtx, String ... args) throws ExtRptBizException {
        ArrayList<CardVO> cards;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)easCtx);
        String userId = userInfo.getId().toString();
        if (StringUtil.isEmptyString((String)userId)) {
            return new MobileResult("\u5931\u8d25,\u7528\u6237ID\u4e3a\u7a7a");
        }
        String count = args[0];
        int rowCount = -1;
        if (!StringUtil.isEmptyString((String)count)) {
            try {
                rowCount = Integer.parseInt(count);
            }
            catch (Exception e) {
                rowCount = -1;
            }
        }
        if ((cards = CardDAO.listCards(easCtx, userId, rowCount)) == null || cards.size() == 0) {
            return new MobileResult("success");
        }
        ArrayList ret = new ArrayList();
        try {
            for (CardVO card : cards) {
                TreeMap<String, String> e = new TreeMap<String, String>();
                e.put("fid", card.getFid());
                e.put("reportId", card.getReportId());
                e.put("reportName", card.getReportName());
                e.put("userId", card.getUserId());
                e.put("createTime", card.getCreateTime().toString());
                ret.add(e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TreeMap<String, Serializable> map = new TreeMap<String, Serializable>();
        map.put("subjects", ret);
        map.put("refreshTime", Long.valueOf(new Date().getTime()));
        return new MobileResult(map);
    }

    @Override
    public String[] loadArgs(Map<String, String> params) {
        return new String[]{params.get("rowCount")};
    }
}

