/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.dispatch.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.ext.ui.wizards.propelling.model.ScheduleModel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.rpts.snapshot.dispatch.pojo.ReportDispatchInfo;
import com.kingdee.eas.rpts.snapshot.dispatch.server.IReportDispatchDAO;
import com.kingdee.eas.rpts.snapshot.dispatch.server.impl.ReportDispatchDAOImpl;
import com.kingdee.eas.rpts.snapshot.dispatch.service.IReportDispatchService;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ReportDispatchServiceImpl
implements IReportDispatchService {
    private IReportDispatchDAO dispatchDAO;
    private static final String JobNamePre = "\u6269\u5c55\u62a5\u8868_";

    public IReportDispatchDAO getDispatchDAO() throws BOSException {
        if (this.dispatchDAO == null) {
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            try {
                this.dispatchDAO = (IReportDispatchDAO)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)ReportDispatchDAOImpl.class.getName(), IReportDispatchDAO.class);
            }
            catch (BOSException e) {
                throw new BOSException("Initial summary task facade error.", (Throwable)e);
            }
        }
        return this.dispatchDAO;
    }

    @Override
    public void InsertReoportDispatch(ReportDispatchInfo info) throws BOSException {
        if (info == null) {
            return;
        }
        info.setId(UID.create((int)44));
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        info.setCreatorId(userId);
        info.setLastUpdateUserId(userId);
        this.getDispatchDAO().InsertReportDispatch(info);
    }

    @Override
    public ReportDispatchInfo getReportDispatchInfoById(String dispatchId, String curLocale) {
        ReportDispatchInfo result = null;
        try {
            result = this.getDispatchDAO().getReportDispatchInfoById(dispatchId, curLocale);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void UpdateReportDispatch(ReportDispatchInfo info) throws BOSException {
        if (info == null) {
            return;
        }
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        info.setCreatorId(userId);
        info.setLastUpdateUserId(userId);
        this.getDispatchDAO().UpdateReportDispatch(info);
    }

    @Override
    public void updateJobProcessDef(String procDefId, String scheduleXml) throws BOSException {
        EASWfServiceClient workflowClient = this.getWorkflowClient();
        workflowClient.updateProcessSchedule(procDefId, scheduleXml);
        this.dispatchDAO.setJobHolderNull(procDefId);
    }

    private EASWfServiceClient getWorkflowClient() throws BOSException {
        EASWfServiceClient workflowClient = new EASWfServiceClient();
        workflowClient.init(UIConfig.getUrl(), SysContext.getSysContext().getSessionID());
        return workflowClient;
    }

    @Override
    public List getReportDispatchList(String whereSql) throws BOSException {
        String curLocale = SysContext.getSysContext().getLocale().toString();
        return this.getDispatchDAO().getReportDispatchList(null, curLocale, whereSql);
    }

    @Override
    public void deleteDispatch(List dispatchInfoList) throws BOSException {
        if (dispatchInfoList == null || dispatchInfoList.size() == 0) {
            return;
        }
        this.getDispatchDAO().deleteDispatch(dispatchInfoList);
    }

    @Override
    public void release(List dispatchInfoList) throws BOSException, EASBizException, SQLException {
        EASWfServiceClient workflowClient = this.getWorkflowClient();
        FunctionObjectInfo function = this.getFunction();
        OperationInfo operation = ReportDispatchServiceImpl.getOperationInfo(function);
        int size = dispatchInfoList.size();
        for (int i = 0; i < size; ++i) {
            ReportDispatchInfo dispatchInfo = (ReportDispatchInfo)dispatchInfoList.get(i);
            String fid = dispatchInfo.getId();
            ReportDispatchInfo infoDetail = this.getDispatchDAO().getReportDispatchInfoById(fid, EASUtil.gelLoginLocal());
            String dispatchServer = dispatchInfo.getDispatchServer();
            String jobDefName = JobNamePre + infoDetail.getName();
            int intCount = ReportDispatchServiceImpl.getJobDefCount(jobDefName);
            if (intCount > 0) {
                boolean flagExist;
                while (flagExist = ReportDispatchServiceImpl.isexistJobDef(jobDefName = jobDefName + intCount)) {
                    ++intCount;
                }
            }
            String defineXML = infoDetail.getScheduleXML();
            ScheduleDef sdef = KpdlParser.parseSchedule((String)defineXML);
            sdef.setInstructionType(1);
            defineXML = KpdlParser.scheduleToString((ScheduleDef)sdef);
            String jobProcessDefID = ReportDispatchServiceImpl.insertJobProcessDefForAppointServer(workflowClient, function, operation, infoDetail.getId(), jobDefName, defineXML, EASUtil.gelLoginLocal(), dispatchServer);
            dispatchInfo.setJobProcessDefID(jobProcessDefID);
            this.getDispatchDAO().updateDispatchJobProcessDefId(fid, jobProcessDefID);
        }
    }

    @Override
    public void releasePropellingDispatch(ReportDispatchInfo dispatchInfo) throws BOSException, EASBizException, SQLException {
        EASWfServiceClient workflowClient = this.getWorkflowClient();
        FunctionObjectInfo function = this.getFunction();
        OperationInfo operation = ReportDispatchServiceImpl.getOperationInfo(function);
        String fid = dispatchInfo.getId();
        ReportDispatchInfo infoDetail = this.getDispatchDAO().getReportDispatchInfoById(fid, EASUtil.gelLoginLocal());
        String jobDefName = "_" + infoDetail.getName() + "_\u6267\u884c\u4e8b\u52a1";
        String defineXML = infoDetail.getScheduleXML();
        ScheduleDef sdef = KpdlParser.parseSchedule((String)defineXML);
        if (dispatchInfo.getStrategy() != null) {
            sdef.setInstructionType(ScheduleModel.StrategyType.ExecuteNow == dispatchInfo.getStrategy() ? 1 : 0);
        } else {
            sdef.setInstructionType(0);
        }
        defineXML = KpdlParser.scheduleToString((ScheduleDef)sdef);
        String jobProcessDefID = ReportDispatchServiceImpl.insertJobProcessDef(workflowClient, function, operation, infoDetail.getId(), jobDefName, defineXML, EASUtil.gelLoginLocal());
        dispatchInfo.setJobProcessDefID(jobProcessDefID);
        this.getDispatchDAO().updateDispatchJobProcessDefId(fid, jobProcessDefID);
    }

    private FunctionObjectInfo getFunction() {
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.rpts.snapshot.dispatch.server.app.ReportDispatchFunction");
        FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)functionPK);
        return function;
    }

    private static final OperationInfo getOperationInfo(FunctionObjectInfo function) {
        OperationCollection operCols = function.getOperation();
        OperationInfo operation = null;
        operation = operCols.get(0);
        return operation;
    }

    public static int getJobDefCount(String fTitle) throws BOSException, SQLException, EASBizException {
        int intRet = 0;
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(fTitle);
        String sql = "select count(*) as totalcount from T_JOB_DEF where ftitle = ?";
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoMapBySQL");
        pr.setString("sql", sql);
        pr.setObject("lstValue", queryValue);
        RptParams ps_r = FacadeFactory.commonExecuteNever(null, pr);
        HashMap map = (HashMap)ps_r.getObject("object");
        String strCount = CtrlReportUtil.getObjectString(map.get("totalcount"));
        if (!strCount.equals("")) {
            intRet = Integer.parseInt(CtrlReportUtil.getObjectString(map.get("totalcount")));
        }
        return intRet;
    }

    public static boolean isexistJobDef(String fTitle) throws BOSException {
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(fTitle);
        String sql = "SELECT fjobdefid FROM T_JOB_DEF WHERE fTitle = ?";
        RptParams pr = new RptParams();
        pr.setString("MethodName", "exitsRecordBySQL");
        pr.setString("sql", sql);
        pr.setObject("lstValue", queryValue);
        RptParams ps_r = FacadeFactory.commonExecuteNever(null, pr);
        return ps_r.getBoolean("flag");
    }

    private static String insertJobProcessDef(EASWfServiceClient workflowClient, FunctionObjectInfo function, OperationInfo operation, String fid, String name, String scheduleXml, String strLocal) throws BOSException {
        HashMap<String, String> jobContext = new HashMap<String, String>();
        jobContext.put("dipatchId", fid);
        jobContext.put("locale", strLocal);
        String jobProcessDefID = workflowClient.createJobProcessDef(name, function, operation, jobContext, scheduleXml, SysContext.getSysContext().getLocale());
        return jobProcessDefID;
    }

    private static String insertJobProcessDefForAppointServer(EASWfServiceClient workflowClient, FunctionObjectInfo function, OperationInfo operation, String fid, String name, String scheduleXml, String strLocal, String dispatchServer) throws BOSException {
        HashMap<String, String> jobContext = new HashMap<String, String>();
        jobContext.put("dipatchId", fid);
        jobContext.put("locale", strLocal);
        if (dispatchServer != null) {
            jobContext.put("selectedServer", dispatchServer);
        }
        String jobProcessDefID = workflowClient.createJobProcessDef(name, function, operation, jobContext, scheduleXml, SysContext.getSysContext().getLocale());
        return jobProcessDefID;
    }

    @Override
    public boolean isExist(String dipatchName, String locale) throws BOSException {
        return false;
    }

    @Override
    public void undoRelease(List dispatchInfoList) throws BOSException, SQLException {
        if (dispatchInfoList == null || dispatchInfoList.size() == 0) {
            return;
        }
        this.getDispatchDAO().undoRelease(dispatchInfoList);
    }

    @Override
    public void undoReleaseSendJob(ReportDispatchInfo reportDispatchInfo) throws BOSException, SQLException {
        if (reportDispatchInfo == null) {
            return;
        }
        ArrayList<ReportDispatchInfo> list = new ArrayList<ReportDispatchInfo>();
        list.add(reportDispatchInfo);
        this.getDispatchDAO().undoReleaseSendJob(list);
    }

    @Override
    public String releaseSendPropellingDispatch(Context easCtx, String sourceDispatchId) throws BOSException, EASBizException, SQLException {
        FunctionObjectInfo function = this.getFunction();
        OperationInfo operation = ReportDispatchServiceImpl.getOperationInfo(function);
        ReportDispatchDAOImpl dao = new ReportDispatchDAOImpl(easCtx);
        ReportDispatchInfo infoDetail = dao.getReportDispatchInfoById(sourceDispatchId, EASUtil.gelLoginLocal());
        String jobDefName = "_" + infoDetail.getName() + "_\u6267\u884c\u4e8b\u52a1_\u6d88\u606f\u63a8\u9001";
        infoDetail.setName(jobDefName);
        infoDetail.setId(UID.create((int)44));
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)easCtx);
        infoDetail.setCreatorId(user.getId().toString());
        infoDetail.setLastUpdateUserId(user.getId().toString());
        infoDetail.setHinttype(ScheduleModel.MessagePushHint.RightNow);
        dao.InsertReportDispatch(infoDetail);
        String defineXML = infoDetail.getScheduleXML();
        ScheduleDef sdef = KpdlParser.parseSchedule((String)defineXML);
        if (infoDetail.getStrategy() != null) {
            sdef.setInstructionType(ScheduleModel.StrategyType.ExecuteNow == infoDetail.getStrategy() ? 1 : 0);
        } else {
            sdef.setInstructionType(0);
        }
        defineXML = KpdlParser.scheduleToString((ScheduleDef)sdef);
        HashMap<String, String> jobContext = new HashMap<String, String>();
        jobContext.put("reportId", infoDetail.getReportId());
        jobContext.put("dipatchId", infoDetail.getId());
        jobContext.put("locale", EASUtil.gelLoginLocal());
        jobContext.put("messageType", "XUNTONG");
        String sendJobProcessDefID = EnactmentServiceFactory.createEnactService((Context)easCtx).createJobProcessDef(jobDefName, function, operation, jobContext, defineXML, SysContext.getSysContext().getLocale());
        dao.updateSendDispatchJobProcessDefId(infoDetail.getId(), sendJobProcessDefID);
        return sendJobProcessDefID;
    }
}

