/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.manage.service.mailbox;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.rpts.snapshot.manage.exception.ShortcutMailboxException;
import com.kingdee.eas.rpts.snapshot.manage.exception.SnapshotException;
import com.kingdee.eas.rpts.snapshot.manage.exception.UserGroupException;
import com.kingdee.eas.rpts.snapshot.manage.pojo.PhantomSnapshot;
import com.kingdee.eas.rpts.snapshot.manage.pojo.so.ReportGroupItem;
import com.kingdee.eas.rpts.snapshot.manage.pojo.ug.SSUserInfo;
import com.kingdee.eas.rpts.snapshot.manage.pojo.ug.UserGroupInfo;
import com.kingdee.eas.rpts.snapshot.manage.server.mailbox.ISSMailboxDAO;
import com.kingdee.eas.rpts.snapshot.manage.server.mailbox.impl.SSMailboxDAO;
import com.kingdee.eas.rpts.snapshot.manage.server.ug.IUserGroupDAO;
import com.kingdee.eas.rpts.snapshot.manage.server.ug.impl.UserGroupDAO;
import com.kingdee.eas.rpts.snapshot.manage.service.SnapshotRelativeService;
import com.kingdee.eas.rpts.snapshot.manage.service.mailbox.ISSExpressDeliveryService;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SSExpressDeliveryService
extends ORMObject
implements ISSExpressDeliveryService {
    private IUserGroupDAO _userGroupDAO;
    private ISSMailboxDAO _mailboxDAO;

    public SSExpressDeliveryService() {
        this.registerInterface(ISSExpressDeliveryService.class, this);
        this._userGroupDAO = new UserGroupDAO();
        this._mailboxDAO = new SSMailboxDAO();
    }

    public static ISSExpressDeliveryService getInst() throws ShortcutMailboxException {
        String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
        try {
            return (ISSExpressDeliveryService)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)SSExpressDeliveryService.class.getName(), ISSExpressDeliveryService.class);
        }
        catch (BOSException e) {
            throw ShortcutMailboxException.wrap("Initial SSExpressDeliveryService error.", (Exception)((Object)e));
        }
    }

    @Override
    public int getUnReadCount() throws ShortcutMailboxException {
        return this._mailboxDAO.getUnReadCount();
    }

    @Override
    public List queryUsersAndGroups() throws ShortcutMailboxException {
        try {
            List groups = this._userGroupDAO.queryAllUserGroups();
            List users = this._userGroupDAO.queryAllUsers();
            groups.addAll(users);
            return groups;
        }
        catch (UserGroupException e) {
            throw ShortcutMailboxException.wrap(e);
        }
    }

    @Override
    public void updateReadStatus(List phantoms, int readStatus) throws ShortcutMailboxException {
    }

    @Override
    public void updateReadStatusByReportID(List reports, int readStatus) throws ShortcutMailboxException {
    }

    @Override
    public List queryGroups() throws ShortcutMailboxException {
        try {
            return this._userGroupDAO.queryAllUserGroups();
        }
        catch (UserGroupException e) {
            throw ShortcutMailboxException.wrap(e);
        }
    }

    @Override
    public List queryUsersByGroupID(String groupID) throws ShortcutMailboxException {
        try {
            return this._userGroupDAO.queryUsersByGroupID(new String[]{groupID});
        }
        catch (UserGroupException e) {
            throw ShortcutMailboxException.wrap(e);
        }
    }

    @Override
    public List queryAllUser() throws ShortcutMailboxException {
        try {
            return this._userGroupDAO.queryAllUsers();
        }
        catch (UserGroupException e) {
            throw ShortcutMailboxException.wrap(e);
        }
    }

    @Override
    public void deleteUserGroups(Object[] groups) throws ShortcutMailboxException {
        RptParams params = new RptParams();
        params.setString("FullName", this.getClass().getName());
        params.setString("MethodName", "_deleteUserGroups");
        params.setObject("GROUP_ARRAY", (Object)groups);
        try {
            RptParams rp = FacadeFactory.commonExecuteRequired(ServerUtil.getContext(), params);
            ShortcutMailboxException ex = (ShortcutMailboxException)rp.getObject("EXCEPTION");
            if (ex != null) {
                throw ex;
            }
        }
        catch (BOSException e) {
            throw ShortcutMailboxException.wrap((Exception)((Object)e));
        }
    }

    public RptParams _deleteUserGroups(Context ctx, RptParams pr) {
        Object[] groups = (Object[])pr.getObject("GROUP_ARRAY");
        RptParams rp = new RptParams();
        for (int i = 0; i < groups.length; ++i) {
            try {
                this._userGroupDAO.delUserGroup((UserGroupInfo)groups[i]);
                continue;
            }
            catch (UserGroupException e) {
                rp.setObject("EXCEPTION", (Object)ShortcutMailboxException.wrap(e));
            }
        }
        return rp;
    }

    @Override
    public UserGroupInfo saveUserGroup(UserGroupInfo group) throws ShortcutMailboxException {
        RptParams params = new RptParams();
        params.setString("FullName", this.getClass().getName());
        params.setString("MethodName", "_saveUserGroup");
        params.setObject("GROUP", (Object)group);
        try {
            RptParams rp = FacadeFactory.commonExecuteRequired(ServerUtil.getContext(), params);
            ShortcutMailboxException ex = (ShortcutMailboxException)rp.getObject("EXCEPTION");
            if (ex != null) {
                throw ex;
            }
            return (UserGroupInfo)rp.getObject("GROUP");
        }
        catch (BOSException e) {
            throw ShortcutMailboxException.wrap((Exception)((Object)e));
        }
    }

    public RptParams _saveUserGroup(Context ctx, RptParams pr) {
        UserGroupInfo group = (UserGroupInfo)pr.getObject("GROUP");
        RptParams rp = new RptParams();
        if (!StringUtil.isEmptyString((String)group.getId())) {
            group.setLastUpdateTime(new Timestamp(new Date().getTime()));
            group.setLastUpdatePerson(EASUtil.getCurrentUserID(ctx));
            try {
                this._userGroupDAO.updateUserGroup(group);
                String groupID = group.getId();
                List items = group.getItems();
                int size = items.size();
                for (int i = 0; i < size; ++i) {
                    SSUserInfo userInfo = (SSUserInfo)items.get(i);
                    userInfo.setGroupID(groupID);
                    userInfo.setId(UID.create((int)44));
                }
                this._userGroupDAO.updateUserGroupItems(group);
            }
            catch (UserGroupException e) {
                rp.setObject("EXCEPTION", (Object)ShortcutMailboxException.wrap(e));
            }
        } else {
            String groupID = UID.create((int)44);
            group.setId(groupID);
            group.setCreateTime(new Timestamp(new Date().getTime()));
            group.setCreatorID(EASUtil.getCurrentUserID(ctx));
            List items = group.getItems();
            int size = items.size();
            for (int i = 0; i < size; ++i) {
                SSUserInfo userInfo = (SSUserInfo)items.get(i);
                userInfo.setGroupID(groupID);
                userInfo.setId(UID.create((int)44));
            }
            try {
                this._userGroupDAO.insertUserGroup(group);
            }
            catch (UserGroupException e) {
                rp.setObject("EXCEPTION", (Object)ShortcutMailboxException.wrap(e));
            }
        }
        rp.setObject("GROUP", (Object)group);
        return rp;
    }

    @Override
    public void delSnapshotMails(List mails, List reportGroups) throws ShortcutMailboxException {
        RptParams params = new RptParams();
        params.setString("FullName", this.getClass().getName());
        params.setString("MethodName", "_delSnapshotMails");
        params.setObject("MAILS", (Object)mails);
        params.setObject("REPORTGROUPS", (Object)reportGroups);
        try {
            RptParams rp = FacadeFactory.commonExecuteRequired(ServerUtil.getContext(), params);
            ShortcutMailboxException ex = (ShortcutMailboxException)rp.getObject("EXCEPTION");
            if (ex != null) {
                throw ex;
            }
        }
        catch (BOSException e) {
            throw ShortcutMailboxException.wrap((Exception)((Object)e));
        }
    }

    public RptParams _delSnapshotMails(Context ctx, RptParams pr) {
        RptParams rp = new RptParams();
        List mails = (List)pr.getObject("MAILS");
        List reportGroups = (List)pr.getObject("REPORTGROUPS");
        if (reportGroups != null && reportGroups.size() > 0) {
            String[] reportIDs = new String[reportGroups.size()];
            for (int i = 0; i < reportIDs.length; ++i) {
                ReportGroupItem group = (ReportGroupItem)reportGroups.get(i);
                reportIDs[i] = group.getId();
            }
            try {
                this._mailboxDAO.delSnapshotMailsByReportID(reportIDs);
            }
            catch (ShortcutMailboxException e) {
                rp.setObject("EXCEPTION", (Object)e);
            }
        }
        if (mails != null && mails.size() > 0) {
            String[] mailIDs = new String[mails.size()];
            for (int i = 0; i < mailIDs.length; ++i) {
                PhantomSnapshot ps = (PhantomSnapshot)mails.get(i);
                mailIDs[i] = ps.getId();
            }
            try {
                this._mailboxDAO.delSnapshotMails(mailIDs);
            }
            catch (ShortcutMailboxException e) {
                rp.setObject("EXCEPTION", (Object)e);
            }
        }
        return rp;
    }

    @Override
    public List getMailsByReportGroupID(String reportID) throws ShortcutMailboxException {
        return this._mailboxDAO.queryReportGroupItems(reportID);
    }

    @Override
    public List getReportGroups() throws ShortcutMailboxException {
        return this._mailboxDAO.queryReportGroups();
    }

    @Override
    public boolean markReadState(List mails, List reportGroups, int readState) throws ShortcutMailboxException {
        RptParams params = new RptParams();
        params.setString("FullName", this.getClass().getName());
        params.setString("MethodName", "_markReadState");
        params.setObject("MAILS", (Object)mails);
        params.setObject("REPORTGROUPS", (Object)reportGroups);
        params.setInt("READ_STATE", readState);
        try {
            RptParams rp = FacadeFactory.commonExecuteRequired(ServerUtil.getContext(), params);
            ShortcutMailboxException ex = (ShortcutMailboxException)rp.getObject("EXCEPTION");
            if (ex != null) {
                throw ex;
            }
            return rp.getBoolean("RETURN_VALUE");
        }
        catch (BOSException e) {
            throw ShortcutMailboxException.wrap((Exception)((Object)e));
        }
    }

    public RptParams _markReadState(Context ctx, RptParams pr) {
        RptParams rp = new RptParams();
        List mails = (List)pr.getObject("MAILS");
        List reportGroups = (List)pr.getObject("REPORTGROUPS");
        int readState = pr.getInt("READ_STATE");
        boolean update = false;
        if (reportGroups != null && reportGroups.size() > 0) {
            String[] reportIDs = new String[reportGroups.size()];
            for (int i = 0; i < reportIDs.length; ++i) {
                ReportGroupItem group = (ReportGroupItem)reportGroups.get(i);
                reportIDs[i] = group.getId();
            }
            try {
                this._mailboxDAO.updateReadStatusByReportID(reportIDs, readState);
                update = true;
            }
            catch (ShortcutMailboxException e) {
                rp.setObject("EXCEPTION", (Object)e);
            }
        }
        rp.setBoolean("RETURN_VALUE", update);
        if (mails != null && mails.size() > 0) {
            ArrayList<String> mailIDLst = new ArrayList<String>();
            int size = mails.size();
            for (int i = 0; i < size; ++i) {
                PhantomSnapshot ps = (PhantomSnapshot)mails.get(i);
                if (ps.getReadState() == readState) continue;
                mailIDLst.add(ps.getId());
            }
            if (mailIDLst.size() == 0) {
                return rp;
            }
            String[] mailIDs = new String[mailIDLst.size()];
            mailIDLst.toArray(mailIDs);
            try {
                this._mailboxDAO.updateReadStatus(mailIDs, readState);
                update = true;
                rp.setBoolean("RETURN_VALUE", update);
            }
            catch (ShortcutMailboxException e) {
                rp.setObject("EXCEPTION", (Object)e);
            }
        }
        return rp;
    }

    @Override
    public void updateSnapshotMailsReadState(String[] mailsID, int readState) throws ShortcutMailboxException {
        this._mailboxDAO.updateReadStatus(mailsID, readState);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map deliveryMails(List mails, Object[] addressees) {
        HashSet<Object> users = new HashSet<Object>(addressees.length);
        HashMap<String, ShortcutMailboxException> msgMap = new HashMap<String, ShortcutMailboxException>();
        ArrayList<String> groups = new ArrayList<String>();
        for (Object object : addressees) {
            if (object instanceof UserGroupInfo) {
                groups.add(((UserGroupInfo)object).getId());
                continue;
            }
            users.add(object);
        }
        if (groups.size() > 0) {
            String[] groupIDs = new String[groups.size()];
            groups.toArray(groupIDs);
            try {
                void var8_15;
                List gUsers = this._userGroupDAO.queryUsersByGroupID(groupIDs);
                boolean bl = false;
                int isize = gUsers.size();
                while (var8_15 < isize) {
                    users.add(gUsers.get((int)var8_15));
                    ++var8_15;
                }
            }
            catch (UserGroupException e) {
                msgMap.put("\u53d1\u9001\u5230\u6240\u6709\u7528\u6237\u7ec4\u7684\u5feb\u7167\u90ae\u4ef6\u90fd\u5931\u8d25", ShortcutMailboxException.wrap("\u83b7\u5f97\u7528\u6237\u7ec4\u670d\u52a1\u5931\u8d25", e));
            }
        }
        Timestamp now = new Timestamp(new Date().getTime());
        String senderID = EASUtil.getCurrentUserID(ServerUtil.getContext());
        for (SSUserInfo sSUserInfo : users) {
            int size = mails.size();
            for (int i = 0; i < size; ++i) {
                PhantomSnapshot ps = (PhantomSnapshot)mails.get(i);
                ps.setId(UID.create((int)44));
                ps.setSender(senderID);
                ps.setSendTime(now);
                ps.setUserId(sSUserInfo.getUserID());
            }
            try {
                this._mailboxDAO.insertSnapshotMails(mails);
            }
            catch (ShortcutMailboxException e) {
                msgMap.put(this.getDeliveryFailMsg(sSUserInfo), ShortcutMailboxException.wrap(e));
            }
        }
        return msgMap;
    }

    private String getDeliveryFailMsg(SSUserInfo user) {
        StringBuffer msgBuf = new StringBuffer();
        msgBuf.append("\u53d1\u5230\u5230\u201c").append(user.getUserName()).append("\u201d\u7684\u5feb\u7167\u90ae\u4ef6\u5931\u8d25");
        return msgBuf.toString();
    }

    @Override
    public void favoriteMails(List mails, String locationPath, boolean deleteOrignal) throws ShortcutMailboxException {
        RptParams params = new RptParams();
        params.setString("FullName", this.getClass().getName());
        params.setString("MethodName", "_favoriteMails");
        params.setObject("MAILS", (Object)mails);
        params.setString("LOCATION_PATH", locationPath);
        params.setBoolean("DELETE_ORIGNAL", deleteOrignal);
        try {
            RptParams rp = FacadeFactory.commonExecuteRequired(ServerUtil.getContext(), params);
            ShortcutMailboxException ex = (ShortcutMailboxException)rp.getObject("EXCEPTION");
            if (ex != null) {
                throw ex;
            }
        }
        catch (BOSException e) {
            throw ShortcutMailboxException.wrap((Exception)((Object)e));
        }
    }

    public RptParams _favoriteMails(Context ctx, RptParams pr) {
        RptParams rp;
        block6: {
            List mails = (List)pr.getObject("MAILS");
            String locationPath = pr.getString("LOCATION_PATH");
            boolean deleteOrignal = pr.getBoolean("DELETE_ORIGNAL");
            rp = new RptParams();
            SnapshotRelativeService serv = new SnapshotRelativeService(ctx);
            try {
                if (mails == null || mails.size() <= 0) break block6;
                if (deleteOrignal) {
                    String[] mailIDs = new String[mails.size()];
                    for (int i = 0; i < mailIDs.length; ++i) {
                        PhantomSnapshot ps = (PhantomSnapshot)mails.get(i);
                        mailIDs[i] = ps.getId();
                    }
                    try {
                        this._mailboxDAO.delSnapshotMails(mailIDs);
                    }
                    catch (ShortcutMailboxException e) {
                        rp.setObject("EXCEPTION", (Object)ShortcutMailboxException.wrap(e));
                    }
                }
                serv.favoriteSnapshots(mails, locationPath);
            }
            catch (SnapshotException e) {
                rp.setObject("EXCEPTION", (Object)ShortcutMailboxException.wrap(e));
            }
        }
        return rp;
    }

    @Override
    public List getMailsByReportGroupIDNotLimited(String reportID) throws ShortcutMailboxException {
        return this._mailboxDAO.queryReportGroupItemsNotLimited(reportID);
    }
}

