/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.statistics.dynamic;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.io.kds.BookToKds;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.util.KDSDataOutputStream;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.IReportFacade;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroRuntimeException;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.ExtRptMacroControllerFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroFactory;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroType;
import com.kingdee.eas.rpts.ctrlreport.macro.model.IExtRptMacro;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.ExtRptContentChecker;
import com.kingdee.eas.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CycleException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignInputStream;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.SqlDSModelDrill;
import com.kingdee.eas.rpts.statistics.dynamic.IExtStatisticsRunner;
import com.kingdee.eas.rpts.statistics.info.StatisticsInfoPacket;
import com.kingdee.eas.rpts.sumreport.enumtype.TempletType;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class DefaultExtStatisticsRunner
implements IExtStatisticsRunner {
    private static String STATS_SQL;
    private static String STATS_SQL_WITH_TIME_FILTER;
    private StatisticsInfoPacket packet;

    public DefaultExtStatisticsRunner() {
        boolean isFirst = true;
        for (int i = 0; i < 2; ++i) {
            StringBuilder sb = new StringBuilder("SELECT ");
            sb.append("\"EXECUTORQUERY\".COUNT,");
            sb.append("\"PERSONINFOQUERY\".PERSONID,");
            sb.append("\"EXECUTORQUERY\".ACCOUNT,");
            sb.append("\"PERSONINFOQUERY\".\"POSITION.NAME\" \"POSITION\"");
            sb.append("FROM (");
            sb.append("SELECT ");
            sb.append("\"AuditList\".FEXECUTOR \"ACCOUNT\",COUNT(\"AuditList\".FEXECUTOR)\"COUNT\",\"PERSON\".FEMAIL \"EMAIL\",");
            sb.append("\"PERSON\".FCELL \"CELL\",\"PERSON\".FNUMBER \"NUMBER\" ");
            sb.append("FROM T_EXT_RptAuditList \"AuditList\" ");
            sb.append("LEFT JOIN T_PM_USER \"USER\" ON \"AuditList\".FEXECUTOR=\"USER\".FNUMBER ");
            sb.append("LEFT JOIN T_BD_PERSON \"PERSON\" ON \"USER\".FPERSONID=\"PERSON\".FID ");
            sb.append("WHERE \"AuditList\".FREPORTID=? ");
            if (isFirst) {
                sb.append("AND \"AuditList\".FSTATDATE>? ");
            }
            sb.append("GROUP BY \"AuditList\".FEXECUTOR,\"PERSON\".FNAME_L2,\"PERSON\".FEMAIL,");
            sb.append("\"PERSON\".FCELL,\"PERSON\".FNUMBER) \"EXECUTORQUERY\" ");
            sb.append("LEFT JOIN (");
            sb.append("SELECT DISTINCT \"PERSON\".FID \"PERSONID\",\"PERSON\".FNumber \"NUMBER\", \"PERSON\".FName_l2 \"NAME\", ");
            sb.append("\"ADMINORGUNIT\".FName_l2 \"ADMINORGUNIT.NAME\", ");
            sb.append("\"ADMINORGUNIT\".FDisplayName_l2 \"ADMINORGUNIT.DISPLAYNAME\", ");
            sb.append("\"POSITION\".FName_l2 \"POSITION.NAME\", \"CU2\".FID \"CU.ID\" ");
            sb.append("FROM T_BD_Person \"PERSON\" ");
            sb.append("INNER JOIN ");
            sb.append("T_ORG_PositionMember \"POSITIONMEMBER\" ON \"PERSON\".FID = \"POSITIONMEMBER\".FPersonID ");
            sb.append("INNER JOIN T_ORG_Position \"POSITION\" ON \"POSITIONMEMBER\".FPositionID = \"POSITION\".FID ");
            sb.append("INNER JOIN T_ORG_Admin \"ADMINORGUNIT\" ON \"POSITION\".FAdminOrgUnitID = \"ADMINORGUNIT\".FID ");
            sb.append("INNER JOIN T_ORG_CtrlUnit \"CU2\" ON \"ADMINORGUNIT\".FControlUnitID = \"CU2\".FID)");
            sb.append("\"PERSONINFOQUERY\" ON \"EXECUTORQUERY\".NUMBER=\"PERSONINFOQUERY\".NUMBER");
            if (isFirst) {
                STATS_SQL_WITH_TIME_FILTER = sb.toString();
            } else {
                STATS_SQL = sb.toString();
            }
            isFirst = false;
        }
        this.packet = null;
    }

    @Override
    public boolean nextRptPackage(Context easCtx) {
        DefineReportInfo info = null;
        try {
            info = this.findRpt(easCtx);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        if (info != null) {
            this.packet = new StatisticsInfoPacket();
            this.packet.setRptName(info.getName());
            this.packet.setRptUuid(info.getId().toString());
            this.packet.setSystemId(info.getSystemID());
            this.packet.setTemplateData(DefaultExtStatisticsRunner.innerlinkDS(easCtx, info.getContent()));
            String tt = TempletType.getTempletType(info.getTempletType()).getName();
            this.packet.setTemplateType(StringUtil.isEmptyString((String)tt) ? "\u666e\u901a\u62a5\u8868" : tt);
            this.packet.setTemplateVersion(String.valueOf(info.getLastUpdateTime().getTime()));
            this.packet.setRptUsageStatus(this.nextRptUsageStatus(easCtx, this.packet.getRptUuid()));
            try {
                Book book = BookIOUtil.unpack((byte[])info.getContent());
                this.packet.setCloudRptUuid(book.getCloudRptUuid());
                this.packet.setRawCloudRpt(book.getUserObject("CLOUD_REPORT_DEMO_BOOK_DATA") != null);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    @Override
    public StatisticsInfoPacket get() {
        return this.packet;
    }

    @Override
    public String strategyVersion() {
        return "DEFAULT";
    }

    private DefineReportInfo findRpt(Context easCtx) throws Throwable {
        String fetchNewRpts = "(SELECT TOP 1 FID FROM T_BAS_DEFINEREPORT D WHERE (D.FMENUID IS NOT NULL OR D.FBIPATH IS NOT NULL OR D.FPORTLETID IS NOT NULL OR D.FMOBILENAME IS NOT NULL) AND D.FID NOT IN (SELECT FID FROM T_EXT_EXPORTEDRPT)) ORDER BY FLASTUPDATETIME ASC";
        String fetchNewUpdateRpts = "(SELECT TOP 1 E.FID FROM T_EXT_EXPORTEDRPT E LEFT JOIN T_BAS_DEFINEREPORT D ON E.FID=D.FID WHERE D.FLASTUPDATETIME>E.FLASTACCESSTIME AND E.FID IN (SELECT FID FROM T_EXT_EXPORTEDRPT WHERE FRECORDTIME IS NOT NULL AND FID IN (SELECT FID FROM T_BAS_DEFINEREPORT D WHERE D.FMENUID IS NOT NULL OR D.FBIPATH IS NOT NULL OR D.FPORTLETID IS NOT NULL OR D.FMOBILENAME IS NOT NULL)))";
        String rptUuid = null;
        RptParams params = new RptParams();
        IReportFacade facade = easCtx == null ? ReportFacadeFactory.getRemoteInstance() : ReportFacadeFactory.getLocalInstance(easCtx);
        params.setString("sql", fetchNewRpts);
        params.setString("MethodName", "getDBInfoBySQL");
        IRowSet rs = (IRowSet)facade.commonExecute(params).getObject("object");
        if (rs.next()) {
            rptUuid = rs.getString(1);
        }
        rs.close();
        if (rptUuid == null) {
            params.setString("sql", fetchNewUpdateRpts);
            params.setString("MethodName", "getDBInfoBySQL");
            rs = (IRowSet)facade.commonExecute(params).getObject("object");
            if (rs.next()) {
                rptUuid = rs.getString(1);
            }
            rs.close();
        }
        if (rptUuid == null) {
            return null;
        }
        String insertSQL = "INSERT INTO T_EXT_EXPORTEDRPT(FID,FLASTACCESSTIME) VALUES(?,?)";
        String updateSQL = "UPDATE T_EXT_EXPORTEDRPT SET FLASTACCESSTIME=? WHERE FID=?";
        Timestamp ts = new Timestamp(new Date().getTime());
        params.setString("sql", "SELECT FID FROM T_EXT_EXPORTEDRPT WHERE FID=?");
        ArrayList<Object> queryValues = new ArrayList<Object>();
        queryValues.add(rptUuid);
        params.setObject("lstValue", queryValues);
        params.setString("MethodName", "getDBInfoBySQL");
        rs = (IRowSet)facade.commonExecute(params).getObject("object");
        if (rs.next()) {
            params.setString("sql", updateSQL);
            queryValues.clear();
            queryValues.add(ts);
            queryValues.add(rptUuid);
            params.setObject("lstValue", queryValues);
            params.setString("MethodName", "maintainRecord");
            facade.commonExecute(params);
        } else {
            params.setString("sql", insertSQL);
            queryValues.clear();
            queryValues.add(rptUuid);
            queryValues.add(ts);
            params.setObject("lstValue", queryValues);
            params.setString("MethodName", "maintainRecord");
            facade.commonExecute(params);
        }
        rs.close();
        return DefineReportBO.getReportInfo(easCtx, rptUuid);
    }

    public static byte[] innerlinkDS(Context easCtx, byte[] rptData) {
        try {
            Book book = BookIOUtil.unpack((byte[])rptData);
            ExtDataSetManager manager = book.getDataSetManager();
            int size = manager.size();
            for (int n = 0; n < size; ++n) {
                String dbsourcename;
                String defineNew;
                String define;
                ExtDataSet dateset = manager.getAt(n);
                ExtDataSetType dsType = dateset.getDataSetType();
                if (dsType != ExtDataSetType.SQL_KSQL || (define = dateset.getDefine()).startsWith(defineNew = dsType.getPrefixedString("InnerLink"))) continue;
                Map mapDefine = define.indexOf("rZns4x88ShmCrA4shCy6yENOfX0=\u3010\u6c47\u603b\u4e0a\u62a5\u4e13\u7528\u3011") != -1 ? RunReportParam.splitDefine2Map(define) : RunReportParam.splitDefineToMap(define);
                String dbsourceid = CtrlReportUtil.getObjectString(mapDefine.get("DbSourceID"));
                String orgID = CtrlReportUtil.getObjectString(mapDefine.get("OrgID"));
                String systemid = CtrlReportUtil.getObjectString(mapDefine.get("SystemID"));
                CtrlDesignInputStream in = new CtrlDesignInputStream(easCtx, systemid, dbsourcename = CtrlReportUtil.getObjectString(mapDefine.get("DbSourceName")), orgID, dbsourceid);
                if (!in.isFound()) continue;
                String sqlModelXmlString = in.getXmlString();
                try {
                    sqlModelXmlString = SqlDSModelDrill.drillOnly(easCtx, sqlModelXmlString, orgID);
                }
                catch (CycleException _) {
                    continue;
                }
                String dbsourceidNew = dbsourceid + System.currentTimeMillis();
                define = ExtStringUtil.replace(define, dbsourceid, dbsourceidNew);
                defineNew = ExtStringUtil.replace(define, "sql_ksql@@", defineNew + "@@");
                dateset.setDefine(defineNew);
                dateset.setMeta(sqlModelXmlString);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DefaultExtStatisticsRunner.innerMacroDefine(easCtx, book);
            new BookToKds().export(book, new KDSDataOutputStream((OutputStream)out));
            return out.toByteArray();
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    public static byte[] innerMacroDefine(Context easCtx, Book book) {
        try {
            Element macros = new Element("macros");
            HashSet<String> names = new HashSet<String>();
            ExtRptContentChecker.analysisMacroUsage(easCtx, names, new HashMap(), book);
            IExtRptMacroController controller = easCtx != null ? ExtRptMacroControllerFacade.getLocalInst(easCtx) : ExtRptMacroControllerFacade.getRemoteInst();
            for (String macro : names) {
                MacroVO vo;
                try {
                    vo = controller.r(macro);
                }
                catch (MacroRuntimeException e) {
                    e.printStackTrace();
                    continue;
                }
                IExtRptMacro m = vo.getMacro();
                Element e = new Element("macro");
                e.setAttribute("name", m.name());
                e.setAttribute("mType", m.mType().name());
                e.setAttribute("vType", m.vType().name());
                Element define = new Element("define");
                define.setText(m.define() == null ? "" : m.define());
                e.addContent((Content)define);
                Element description = new Element("description");
                description.setText(vo.getDescription() == null ? "" : vo.getDescription());
                e.addContent((Content)description);
                macros.addContent((Content)e);
            }
            return BookIOUtil.pack((Book)book);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    public static Map<String, MacroVO> loadUsedMacros(Context easCtx, String rptId) {
        if (!StringUtil.isEmptyString((String)rptId)) {
            try {
                return DefaultExtStatisticsRunner.loadUsedMacros(BookIOUtil.unpack((byte[])DefineReportBO.getReportInfo(easCtx, rptId).getContent()));
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        return new HashMap<String, MacroVO>();
    }

    public static Map<String, MacroVO> loadUsedMacros(Book book) {
        HashMap<String, MacroVO> innerMacroDefineMap = new HashMap<String, MacroVO>();
        if (book == null) {
            return innerMacroDefineMap;
        }
        Object value = book.getUserObjectValue("EXT_REPORT_USED_MACRO_DEFINE");
        try {
            if (value instanceof String) {
                ByteArrayInputStream in = new ByteArrayInputStream(((String)value).getBytes("UTF-8"));
                Element macros = new SAXBuilder().build((InputStream)in).getRootElement();
                for (Object o : macros.getChildren("macro")) {
                    if (!(o instanceof Element)) continue;
                    Element m = (Element)o;
                    innerMacroDefineMap.put(m.getAttributeValue("name").toUpperCase(), ExtRptMacroFactory.emptyMacro(ExtRptMacroType.MType.valueOf(m.getAttributeValue("mType"))).setVType(ExtRptMacroType.VType.valueOf(m.getAttributeValue("vType"))).setName(m.getAttributeValue("name")).setDefine(m.getChild("define").getText()).setDescription(m.getChild("description").getText()));
                }
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        return innerMacroDefineMap;
    }

    public static String getCurrentUserTitle(Context easCtx) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT DISTINCT ");
        sb.append("\"POSITION\".FName_l2 \"POSITION.NAME\" ");
        sb.append("FROM T_BD_Person \"PERSON\" ");
        sb.append("INNER JOIN ");
        sb.append("T_ORG_PositionMember \"POSITIONMEMBER\" ON \"PERSON\".FID = \"POSITIONMEMBER\".FPersonID ");
        sb.append("INNER JOIN T_ORG_Position \"POSITION\" ON \"POSITIONMEMBER\".FPositionID = \"POSITION\".FID ");
        sb.append("INNER JOIN T_PM_USER \"USER\" ON \"PERSON\".FID = \"USER\".FPERSONID WHERE \"USER\".FID=?");
        ArrayList<String> params = new ArrayList<String>();
        params.add(easCtx == null ? SysContext.getSysContext().getCurrentUserInfo().getId().toString() : ContextUtil.getCurrentUserInfo((Context)easCtx).getId().toString());
        try {
            ArrayList ret = ExtDBUtil.getResultListBySql(easCtx, sb.toString(), params);
            if (ret.size() > 0) {
                return (String)((Map)ret.get(0)).get("POSITION.NAME".toLowerCase());
            }
            return "";
        }
        catch (BOSException e) {
            return "UNKNOWN";
        }
    }

    @Override
    public Element nextRptUsageStatus(Context easCtx, String rptUuid) {
        IReportFacade facade;
        Element rptStats = new Element("rptStats");
        try {
            facade = easCtx == null ? ReportFacadeFactory.getRemoteInstance() : ReportFacadeFactory.getLocalInstance(easCtx);
        }
        catch (Throwable e) {
            rptStats.setAttribute("success", "false");
            rptStats.setText(e.getMessage());
            return rptStats;
        }
        Timestamp lastStatDate = this.findLastRecodeTime(rptUuid, facade, rptStats);
        boolean withTimeFilter = lastStatDate != null;
        HashMap<String, Element> executors = new HashMap<String, Element>();
        RptParams params = new RptParams();
        ArrayList<Object> queryValues = new ArrayList<Object>();
        params.setString("sql", withTimeFilter ? STATS_SQL_WITH_TIME_FILTER : STATS_SQL);
        params.setString("MethodName", "getDBInfoBySQL");
        params.setObject("lstValue", queryValues);
        queryValues.add(rptUuid);
        if (withTimeFilter) {
            queryValues.add(lastStatDate);
        }
        try {
            params = facade.commonExecute(params);
            IRowSet rowset = (IRowSet)params.getObject("object");
            while (rowset.next()) {
                Element executor;
                String number = rowset.getString("ACCOUNT");
                if (!executors.containsKey(number)) {
                    String c;
                    executor = new Element("executor");
                    String p = rowset.getString("PERSONID");
                    if (p != null) {
                        executor.setAttribute("personId", p);
                    }
                    if ((c = rowset.getString("COUNT")) != null) {
                        executor.setAttribute("exeCount", c);
                    }
                    this.fillLastExecuteTime(rptUuid, number, facade, executor);
                    executors.put(number, executor);
                    rptStats.addContent((Content)executor);
                } else {
                    executor = (Element)executors.get(number);
                }
                Element job = new Element("job");
                String p = rowset.getString("POSITION");
                if (p != null) {
                    job.setText(p);
                }
                executor.addContent((Content)job);
                executors.put(number, executor);
            }
            if (executors.isEmpty()) {
                return null;
            }
        }
        catch (Throwable e) {
            rptStats.setAttribute("success", "false");
            rptStats.setText(e.getMessage());
        }
        rptStats.setAttribute("success", "true");
        return rptStats;
    }

    private Timestamp findLastRecodeTime(String rptUuid, IReportFacade facade, Element rptStats) {
        RptParams params = new RptParams();
        ArrayList<String> queryValues = new ArrayList<String>();
        params.setString("sql", "SELECT FRECORDTIME FROM T_EXT_EXPORTEDRPT WHERE FID=?");
        params.setString("MethodName", "getDBInfoBySQL");
        params.setObject("lstValue", queryValues);
        queryValues.add(rptUuid);
        Element lastStatsTime = new Element("lastStatsTime");
        rptStats.addContent((Content)lastStatsTime);
        try {
            params = facade.commonExecute(params);
            IRowSet rowset = (IRowSet)params.getObject("object");
            if (rowset.next()) {
                Timestamp lastStatDate = rowset.getTimestamp("FRECORDTIME");
                if (lastStatDate != null) {
                    lastStatsTime.setAttribute("success", "true");
                    lastStatsTime.setText(String.valueOf(lastStatDate.getTime()));
                }
                return lastStatDate;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            lastStatsTime.setAttribute("success", "false");
            lastStatsTime.setText(e.getMessage());
        }
        return null;
    }

    private void fillLastExecuteTime(String rptUuid, String number, IReportFacade facade, Element executor) throws BOSException, SQLException {
        RptParams params = new RptParams();
        ArrayList<String> queryValues = new ArrayList<String>();
        params.setString("sql", "SELECT TOP 1 FSTATDATE FROM T_EXT_RptAuditList WHERE FREPORTID=? AND FEXECUTOR=? ORDER BY FSTATDATE DESC");
        params.setString("MethodName", "getDBInfoBySQL");
        params.setObject("lstValue", queryValues);
        queryValues.add(rptUuid);
        queryValues.add(number);
        params = facade.commonExecute(params);
        IRowSet rowset2 = (IRowSet)params.getObject("object");
        if (rowset2.next()) {
            executor.setAttribute("lastExeute", String.valueOf(rowset2.getDate("FSTATDATE").getTime()));
        }
    }
}

