/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.statistics.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.RemoteBOSObjectFactory;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.IReportFacade;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.rpts.statistics.exception.SalmonBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class ServiceUtil {

    public static class ClusterUtilRemoteModel
    implements IClusterUtilRemoteModel {
        public ClusterUtilRemoteModel(Context easCtx) {
        }

        public ClusterUtilRemoteModel() {
        }

        @Override
        public boolean deleteClusterFile(String filePath) {
            if (StringUtil.isEmptyString((String)filePath)) {
                return false;
            }
            if (ClusterUtil.isFileExists(filePath)) {
                return new File(filePath).delete();
            }
            return false;
        }

        @Override
        public byte[] loadClusterFile(String filePath, int start) throws SalmonBizException {
            return ClusterUtil.loadFile(filePath, start);
        }

        public IORMModel queryInterface(Class type) throws ORMCoreException {
            return this;
        }

        @Override
        public boolean isClusterFileExists(String filePath) {
            return new File(filePath).exists();
        }

        public Context getContext() {
            return null;
        }

        public String getName() {
            return "com.kingdee.eas.rpts.statistics.util.ServiceUtil.ClusterUtilRemoteModel";
        }

        public BOSObjectType getType() {
            return new BOSObjectType("446A557E");
        }
    }

    public static interface IClusterUtilRemoteModel
    extends IBOSObject {
        public byte[] loadClusterFile(String var1, int var2) throws SalmonBizException;

        public boolean deleteClusterFile(String var1);

        public boolean isClusterFileExists(String var1);
    }

    public static class ClusterUtil {
        public static final long PACKAGE_SIZE = 0xA00000L;

        public static byte[] loadClusterFile(Context easCtx, String tcpUrl, String filePath, int start) throws SalmonBizException {
            if (StringUtil.isEmptyString((String)filePath)) {
                return null;
            }
            if (ClusterUtil.isFileExists(filePath)) {
                return ClusterUtil.loadFile(filePath, start);
            }
            if (!ClusterUtil.getCurrentTcpUrl().equals(tcpUrl)) {
                return (byte[])ClusterUtil.runRemoteMethod(tcpUrl, "loadClusterFile", filePath, start);
            }
            throw new SalmonBizException("last package has been deleted.", null);
        }

        private static byte[] loadFile(String filePath, int start) throws SalmonBizException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            FileInputStream in = null;
            try {
                in = new FileInputStream(filePath);
                in.skip(start);
                int read = in.read(buffer);
                while (read != -1) {
                    out.write(buffer, 0, read);
                    if ((long)(out.size() + 1024) > 0xA00000L) break;
                    read = in.read(buffer);
                }
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            catch (FileNotFoundException e) {
                throw new SalmonBizException("[BOSException]failed to load stats file.", e);
            }
            catch (IOException e) {
                throw new SalmonBizException("[IOException]failed to load stats file.", e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public static void deleteClusterFile(Context easCtx, String tcpUrl, String filePath) throws SalmonBizException {
            if (StringUtil.isEmptyString((String)filePath)) {
                return;
            }
            if (ClusterUtil.isFileExists(filePath)) {
                new File(filePath).delete();
            } else if (!ClusterUtil.getCurrentTcpUrl().equals(tcpUrl)) {
                ClusterUtil.runRemoteMethod(tcpUrl, "deleteClusterFile", filePath, -1);
            }
        }

        public static boolean isClusterFileExists(Context easCtx, String tcpUrl, String filePath) throws SalmonBizException {
            if (StringUtil.isEmptyString((String)filePath)) {
                return false;
            }
            if (ClusterUtil.isFileExists(filePath)) {
                return true;
            }
            if (!ClusterUtil.getCurrentTcpUrl().equals(tcpUrl)) {
                return (Boolean)ClusterUtil.runRemoteMethod(tcpUrl, "isClusterFileExists", filePath, -1);
            }
            return false;
        }

        private static boolean isFileExists(String filePath) {
            File file = new File(filePath);
            return file.exists();
        }

        private static Object runRemoteMethod(String tcpUrl, String method, String filePath, int start) throws SalmonBizException {
            IClusterUtilRemoteModel facade;
            try {
                facade = (IClusterUtilRemoteModel)RemoteBOSObjectFactory.getInstance((String)tcpUrl).createObject(ClusterUtilRemoteModel.class.getName(), IClusterUtilRemoteModel.class);
            }
            catch (BOSException e) {
                throw new SalmonBizException("[BOSException]failed to load remote function stub.", e);
            }
            if (StringUtil.equals((String)method, (String)"loadClusterFile")) {
                return facade.loadClusterFile(filePath, start);
            }
            if (StringUtil.equals((String)method, (String)"deleteClusterFile")) {
                return facade.deleteClusterFile(filePath);
            }
            if (StringUtil.equals((String)method, (String)"isClusterFileExists")) {
                return facade.isClusterFileExists(filePath);
            }
            throw new SalmonBizException("IClusterUtilRemoteModel unkown method[" + method + "].", null);
        }

        public static String getCurrentTcpUrl() {
            try {
                return "tcp://" + InetAddress.getLocalHost().getHostAddress() + ":" + System.getProperty("tcpConnectionPort");
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return "tcp://localhost:" + System.getProperty("tcpConnectionPort");
            }
        }
    }

    public static class DBUtil {
        public static void executeMaintainRecord(Context easCtx, String sql, Object ... queryParams) throws SalmonBizException {
            try {
                if (easCtx != null) {
                    DbUtil.execute((Context)easCtx, (String)sql, (Object[])queryParams);
                } else {
                    IReportFacade facade = ReportFacadeFactory.getRemoteInstance();
                    RptParams params = new RptParams();
                    params.setString("sql", sql);
                    params.setString("MethodName", "maintainRecord");
                    if (queryParams != null && queryParams.length > 0) {
                        ArrayList<Object> queryValues = new ArrayList<Object>();
                        for (int i = 0; i < queryParams.length; ++i) {
                            queryValues.add(queryParams[i]);
                        }
                        params.setObject("lstValue", queryValues);
                    }
                    facade.commonExecute(params);
                }
            }
            catch (BOSException e) {
                throw new SalmonBizException("[BOSException]failed to maintain record source sql is " + sql + ".", e);
            }
        }

        public static IRowSet executeQuery(Context easCtx, String sql, ArrayList<Object> queryValues) throws SalmonBizException {
            try {
                if (easCtx != null) {
                    return DbUtil.executeQuery((Context)easCtx, (String)sql, (Object[])(queryValues == null ? new String[]{} : queryValues.toArray(new Object[0])));
                }
                IReportFacade facade = ReportFacadeFactory.getRemoteInstance();
                RptParams params = new RptParams();
                params.setString("sql", sql);
                params.setString("MethodName", "getDBInfoBySQL");
                if (queryValues != null) {
                    params.setObject("lstValue", queryValues);
                }
                params = facade.commonExecute(params);
                return (IRowSet)params.getObject("object");
            }
            catch (BOSException e) {
                throw new SalmonBizException("[BOSException]failed to query record source sql is " + sql + ".", e);
            }
        }
    }
}

