/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.debug.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.eas.rpts.sumreport.data.SnapDataBean;
import com.kingdee.eas.rpts.sumreport.data.TaskDetailInfo;
import com.kingdee.eas.rpts.sumreport.data.TaskDistributeInfo;
import com.kingdee.eas.rpts.sumreport.debug.server.IDebugTaskBOFacade;
import com.kingdee.eas.rpts.sumreport.debug.server.impl.DebugTaskBOFacade;
import com.kingdee.eas.rpts.sumreport.exceptions.SumTaskException;
import com.kingdee.eas.rpts.sumreport.model.InfoException;
import com.kingdee.eas.rpts.sumreport.service.inf.ITaskService;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DebugTaskService
implements ITaskService {
    private IDebugTaskBOFacade _facade;
    private String _local = EASUtil.gelLoginLocal();
    public static final int BLOCK_SIZE = 65536;

    private IDebugTaskBOFacade getFacade() throws SumTaskException {
        if (this._facade == null) {
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            try {
                this._facade = (IDebugTaskBOFacade)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)DebugTaskBOFacade.class.getName(), IDebugTaskBOFacade.class);
            }
            catch (BOSException e) {
                throw SumTaskException.wrap("Initial summary task facade error.", (Exception)((Object)e));
            }
        }
        return this._facade;
    }

    @Override
    public boolean verifySame(TaskDistributeInfo vo, String taskID) throws BOSException, InfoException {
        if (this.getFacade().isExistTaskName(taskID, vo.getName(this._local), this._local)) {
            throw new InfoException("\u5df2\u5b58\u5728\u8be5\u540d\u79f0\u7684\u4efb\u52a1,\u8bf7\u4fee\u6539\uff01");
        }
        return false;
    }

    private void addUpInfos(TaskDistributeInfo vo, boolean update) {
        if (!update) {
            vo.setId(UID.create((int)44));
        }
        vo.setCreator(EASUtil.getCurrentUserID());
        vo.setCreateTime(new Timestamp(new Date().getTime()));
        vo.setOrgID(EASUtil.getCurrentOrgID());
        List details = vo.getDetailList();
        int size = details.size();
        for (int i = 0; i < size; ++i) {
            TaskDetailInfo info = (TaskDetailInfo)details.get(i);
            if (StringUtil.isEmptyString((String)info.getId())) {
                info.setId(UID.create((int)44));
            }
            info.setTaskDistributeID(vo.getId());
            info.setDistributorID(vo.getCreator());
            info.setDistributeTime(new Timestamp(new Date().getTime()));
        }
    }

    @Override
    public void addTask(TaskDistributeInfo vo) throws BOSException, InfoException {
        if (this.verifySame(vo, vo.getId())) {
            return;
        }
        this.addUpInfos(vo, false);
        this.getFacade().insertTask(vo);
    }

    @Override
    public void deleteTask(TaskDistributeInfo[] infos) throws BOSException {
        this.getFacade().deleteTask(infos);
    }

    @Override
    public Collection queryTaskDetailsByTask(String taskId) throws BOSException {
        return this.getFacade().getTaskDetailsInfoByTask(taskId);
    }

    @Override
    public List queryTasksByOrg() throws BOSException {
        return this.getFacade().getTaskListByOrgID(EASUtil.getCurrentOrgID(), this._local);
    }

    @Override
    public void updateTask(TaskDistributeInfo oldVO, TaskDistributeInfo newVO, Map info) throws BOSException, InfoException {
        newVO.setId(oldVO.getId());
        newVO.setUpdatePerson(EASUtil.getCurrentUserID());
        if (info == null) {
            this.addUpInfos(newVO, true);
            this.getFacade().updateTask(oldVO, newVO);
        } else {
            Set updateSet = (Set)info.get(UPDATE_ACTIVITY_LIST);
            List delLst = (List)info.get(DEL_ACTIVITY_LIST);
            boolean updateUploadTemplate = !oldVO.getUpLoadReportID().equals(newVO.getUpLoadReportID());
            boolean updateSumTemplate = !oldVO.getSumReportID().equals(newVO.getSumReportID());
            this.getFacade().updateTask(newVO, updateSet, delLst, updateUploadTemplate, updateSumTemplate);
        }
    }

    public byte[] queryASnapshotData(String id) throws BOSException {
        return this.getFacade().querySnapshotByID(id);
    }

    public Map getChildActivitysId2NameMap(String activityID) throws BOSException {
        return this.getFacade().queryChildsId2NameMap(activityID);
    }

    public Map getChildActivitysId2DataMap(String activityID) throws BOSException {
        return this.getFacade().queryChildsId2DataMap(activityID);
    }

    public void delSnapshot(String[] activityIDs) throws BOSException {
        this.getFacade().delSnaphost(activityIDs);
    }

    public void updateSnapshot(String activityID, byte[] data) throws BOSException {
        SnapDataBean[] blocks = this.cutApart(data);
        this.getFacade().updateSnapshot(activityID, blocks);
    }

    public void saveSnapshot(String activityID, byte[] data) throws BOSException {
        SnapDataBean[] blocks = this.cutApart(data);
        this.getFacade().insertSnapshot(activityID.toString(), blocks);
    }

    private SnapDataBean[] cutApart(byte[] source) {
        int leaveBytes = source.length;
        int index = 0;
        int srcPos = 0;
        int size = leaveBytes / 65536 + (leaveBytes % 65536 > 0 ? 1 : 0);
        SnapDataBean[] blocks = new SnapDataBean[size];
        while (leaveBytes > 0) {
            int bytes = 65536;
            if (65536 > leaveBytes) {
                bytes = leaveBytes;
            }
            byte[] buffer = new byte[bytes];
            System.arraycopy(source, srcPos, buffer, 0, bytes);
            leaveBytes -= 65536;
            SnapDataBean block = new SnapDataBean(buffer, index);
            srcPos += 65536;
            blocks[index] = block;
            ++index;
        }
        return blocks;
    }

    @Override
    public List queryAllTasks() throws BOSException {
        return null;
    }
}

