/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.sumreport.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.ByteContentInfo;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.ReportSnapInfo;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.bo.ReportSnapBO;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.rpts.sumreport.data.LogInfo;
import com.kingdee.eas.rpts.sumreport.data.TaskDetailInfo;
import com.kingdee.eas.rpts.sumreport.data.TaskDistributeInfo;
import com.kingdee.eas.rpts.sumreport.exceptions.ExecutorException;
import com.kingdee.eas.rpts.sumreport.exceptions.SnapshotDataException;
import com.kingdee.eas.rpts.sumreport.server.IExecutorBOFacade;
import com.kingdee.eas.rpts.sumreport.server.ISnapshotBOFacade;
import com.kingdee.eas.rpts.sumreport.server.ISumTaskBOFacade;
import com.kingdee.eas.rpts.sumreport.server.impl.ExecutorBOFacade;
import com.kingdee.eas.rpts.sumreport.server.impl.SnapshotBOFacade;
import com.kingdee.eas.rpts.sumreport.server.impl.SumTaskBOFacade;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import com.kingdee.eas.rpts.sumreport.util.MixUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;

public class ExecutorService {
    private IExecutorBOFacade _exeFacade;
    private ISnapshotBOFacade _snapFacade;
    private ISumTaskBOFacade _taskFacade;

    public IExecutorBOFacade getFacade() throws ExecutorException {
        if (this._exeFacade == null) {
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            try {
                this._exeFacade = (IExecutorBOFacade)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)ExecutorBOFacade.class.getName(), IExecutorBOFacade.class);
            }
            catch (BOSException e) {
                throw ExecutorException.wrap("Initial Executor BO facade error.", (Exception)((Object)e));
            }
        }
        return this._exeFacade;
    }

    public ISnapshotBOFacade getSnapFacade() throws ExecutorException {
        if (this._snapFacade == null) {
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            try {
                this._snapFacade = (ISnapshotBOFacade)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)SnapshotBOFacade.class.getName(), ISnapshotBOFacade.class);
            }
            catch (BOSException e) {
                throw ExecutorException.wrap("Initial Snapshot facade error.", (Exception)((Object)e));
            }
        }
        return this._snapFacade;
    }

    public ISumTaskBOFacade getTaskFacade() throws ExecutorException {
        if (this._taskFacade == null) {
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            try {
                this._taskFacade = (ISumTaskBOFacade)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)SumTaskBOFacade.class.getName(), ISumTaskBOFacade.class);
            }
            catch (BOSException e) {
                throw ExecutorException.wrap("Initial summary task facade error.", (Exception)((Object)e));
            }
        }
        return this._taskFacade;
    }

    private ReportSnapInfo packSnapVO(TaskDetailInfo vo) {
        ReportSnapInfo snapInfo = new ReportSnapInfo();
        snapInfo.setId(BOSUuid.create((BOSObjectType)snapInfo.getBOSType()));
        snapInfo.setOrgID(EASUtil.getCurrentOrgID());
        snapInfo.setReportTime(new Timestamp(new Date().getTime()));
        snapInfo.setName(vo.getName());
        snapInfo.setMemo("\u6c47\u603b\u4e0a\u62a5\u751f\u6210\uff01");
        snapInfo.setReportID(BOSUuid.read((String)vo.getReportID()));
        snapInfo.setTaskDetailID(vo.getId());
        snapInfo.setTaskDistributeID(vo.getTaskDistributeID());
        snapInfo.setIDFlag(vo.getIdFlag());
        return snapInfo;
    }

    public void saveSnap(TaskDetailInfo vo, byte[] reportData, String logRemark) throws ExecutorException {
        RptParams pr = new RptParams();
        pr.setObject("FullName", (Object)ReportSnapBO.beanFullName);
        pr.setObject("MethodName", (Object)"insert");
        ReportSnapInfo snapInfo = this.packSnapVO(vo);
        pr.setObject("ReportSnapInfo", (Object)snapInfo);
        ByteContentInfo snapData = new ByteContentInfo();
        snapData.setId(snapInfo.getId());
        snapData.setContent(reportData);
        pr.setObject("ByteContentInfo", (Object)snapData);
        LogInfo log = new LogInfo(UID.create((int)44), EASUtil.getCurrentUserID(), new Timestamp(new Date().getTime()), logRemark);
        log.setActivityID(vo.getId());
        pr.setObject("LogInfo", (Object)log);
        try {
            FacadeFactory.commonExecuteRequired(null, pr);
        }
        catch (BOSException e) {
            throw ExecutorException.wrap("\u4fdd\u5b58\u5feb\u7167\u5931\u8d25", (Exception)((Object)e));
        }
    }

    public void updateSnap(String activityID, byte[] reportData, String logRemark) throws ExecutorException {
        try {
            String snapID = this.getSnapFacade().getSnapPK(activityID);
            RptParams pr = new RptParams();
            ByteContentInfo snapData = new ByteContentInfo();
            snapData.setId(BOSUuid.read((String)snapID));
            snapData.setContent(reportData);
            pr.setObject("ByteContentInfo", (Object)snapData);
            LogInfo log = new LogInfo(UID.create((int)44), EASUtil.getCurrentUserID(), new Timestamp(new Date().getTime()), logRemark);
            log.setActivityID(activityID);
            pr.setObject("LogInfo", (Object)log);
            pr.setObject("FullName", (Object)ReportSnapBO.beanFullName);
            pr.setObject("MethodName", (Object)"update");
            FacadeFactory.commonExecuteRequired(null, pr);
        }
        catch (Exception e) {
            throw ExecutorException.wrap(e);
        }
    }

    public void deleteSnap(String activityID, String logRemark) throws ExecutorException {
        try {
            String snapID = this.getSnapFacade().getSnapPK(activityID);
            IObjectPK[] pks = new IObjectPK[]{new ObjectUuidPK("id", snapID)};
            RptParams pr = new RptParams();
            pr.setObject("IObjectPKs", (Object)pks);
            LogInfo log = new LogInfo(UID.create((int)44), EASUtil.getCurrentUserID(), new Timestamp(new Date().getTime()), logRemark);
            log.setActivityID(activityID);
            pr.setObject("LogInfo", (Object)log);
            pr.setObject("FullName", (Object)ReportSnapBO.beanFullName);
            pr.setObject("MethodName", (Object)"delete");
            FacadeFactory.commonExecuteRequired(null, pr);
        }
        catch (Exception e) {
            throw ExecutorException.wrap(e);
        }
    }

    public void submit(TaskDetailInfo vo) throws ExecutorException {
        vo.setState(1);
        vo.setMakerID(EASUtil.getCurrentUserID());
        vo.setMakeTime(new Timestamp(new Date().getTime()));
        if (vo.getIdFlag() == 1) {
            this.getFacade().submit(vo, null, -1);
        } else {
            Map id2Names = this.getChildIDs(vo.getTaskDistributeID(), vo.getUnitOrOrgID());
            this.getFacade().submit(vo, id2Names.keySet().toArray(), 4);
        }
    }

    public void approve(TaskDetailInfo vo) throws ExecutorException {
        vo.setState(2);
        vo.setApproverID(EASUtil.getCurrentUserID());
        vo.setApproveTime(new Timestamp(new Date().getTime()));
        this.getFacade().approve(vo);
    }

    public void report(TaskDetailInfo vo) throws ExecutorException {
        int state = 3;
        if (StringUtil.isEmptyString((String)vo.getParentID()) && vo.getIdFlag() == 0) {
            state = 4;
        }
        vo.setState(state);
        vo.setUploadUserID(EASUtil.getCurrentUserID());
        vo.setUploadTime(new Timestamp(new Date().getTime()));
        this.getFacade().report(vo);
    }

    public void revokeSubmit(TaskDetailInfo vo) throws ExecutorException {
        vo.setState(0);
        if (vo.getIdFlag() == 1) {
            this.getFacade().revokeSubmit(vo, null, -1);
        } else {
            Map id2Names = this.getChildIDs(vo.getTaskDistributeID(), vo.getUnitOrOrgID());
            this.getFacade().revokeSubmit(vo, id2Names.keySet().toArray(), 3);
        }
    }

    public void revokeApprove(TaskDetailInfo vo) throws ExecutorException {
        vo.setState(1);
        this.getFacade().revokeApprove(vo);
    }

    public void revokeReport(TaskDetailInfo vo) throws ExecutorException {
        vo.setState(2);
        this.getFacade().revokeReport(vo);
    }

    public void jumpBack(TaskDetailInfo vo) throws ExecutorException {
        vo.setState(0);
        this.getFacade().jumpBack(vo, null);
    }

    public boolean isSavedBefore(String activityID) throws ExecutorException {
        try {
            return this.getSnapFacade().getSnapPK(activityID) != null;
        }
        catch (SnapshotDataException e) {
            throw ExecutorException.wrap((Exception)((Object)e));
        }
    }

    public byte[] queryASnapshotData(String id) throws ExecutorException {
        try {
            String snapID = this.getSnapFacade().getSnapPK(id);
            snapID = MixUtil.toString(snapID);
            return this.getSnapFacade().queryEntity(snapID);
        }
        catch (SnapshotDataException e) {
            throw ExecutorException.wrap("\u83b7\u53d6\u5feb\u7167\u6570\u636e\u5931\u8d25", (Exception)((Object)e));
        }
    }

    public DefineReportInfo queryReportTemplateInfo(String reportID) throws ExecutorException {
        try {
            return DefineReportBO.getReportInfo(null, reportID);
        }
        catch (BOSException e) {
            throw ExecutorException.wrap("\u83b7\u53d6\u6a21\u677f\u6570\u636e\u5931\u8d25", (Exception)((Object)e));
        }
    }

    public Map getChildIDs(String taskID, String activityID) throws ExecutorException {
        try {
            TaskDistributeInfo taskVO = this.getTaskFacade().getTaskInfoByID(taskID);
            taskVO.setId(taskID);
            return this.getTaskFacade().getChildsNameID(activityID, taskVO, EASUtil.gelLoginLocal());
        }
        catch (BOSException e) {
            throw ExecutorException.wrap((Exception)((Object)e));
        }
    }

    public Map getChildSnapDatas(Object[] activityIDs) throws ExecutorException {
        try {
            return this.getSnapFacade().queryEntitys(activityIDs);
        }
        catch (SnapshotDataException e) {
            throw ExecutorException.wrap((Exception)((Object)e));
        }
    }

    public String determineChildAState(TaskDetailInfo entity) throws ExecutorException {
        try {
            Map id2Name = this.getChildIDs(entity.getTaskDistributeID(), entity.getUnitOrOrgID());
            String[] unreporteds = this.getSnapFacade().determineAcivitiesState(id2Name.keySet().toArray());
            if (unreporteds != null && unreporteds.length > 0) {
                StringBuffer msg = new StringBuffer("\u73b0\u5728\u751f\u6210\u6c47\u603b\u62a5\u8868\u6570\u636e\u53ef\u80fd\u4f1a\u6709\u9519\u8bef\uff0c\u539f\u56e0\u662f\u4e0b\u5217\u62a5\u8868\u672a\u4e0a\u62a5\uff1a\r\n");
                for (int i = 0; i < unreporteds.length; ++i) {
                    String id = unreporteds[i];
                    msg.append('\u3010').append(id2Name.get(id)).append("\u3011\n");
                }
                return msg.toString();
            }
            return null;
        }
        catch (SnapshotDataException e) {
            throw ExecutorException.wrap((Exception)((Object)e));
        }
    }
}

