/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.tobi;

import chrriis.dj.nativeswing.common.Utils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.analysis.web.ajax.PageManager;
import com.kingdee.bos.ctrl.analysis.web.ext.IWebReportService;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.eas.rpts.ctrlreport.innerlink.InnerLinkException;
import com.kingdee.eas.rpts.ctrlreport.innerlink.LinkParamVo;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.tobi.domain.WebReportDomain;
import com.kingdee.eas.rpts.web.filter.DataType;
import com.kingdee.eas.rpts.web.filter.ReportParamDescription;
import com.kingdee.eas.rpts.web.model.LinkModel;
import com.kingdee.eas.rpts.web.vo.Entry;
import com.kingdee.eas.rpts.web.vo.FilterInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class WebReportService
implements IWebReportService {
    private WebReportDomain webReportDomain = new WebReportDomain();

    public String loadReport(com.kingdee.bos.json.JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        return this.webReportDomain.loadReport(oJson, request);
    }

    public String applyFilter(com.kingdee.bos.json.JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        return this.webReportDomain.applyFilter(oJson, request);
    }

    public String applyRefresh() throws BIReportException, JSONException {
        return this.webReportDomain.applyRefresh();
    }

    public String getReportParams(com.kingdee.bos.json.JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        String pageId = oJson.getString("pageId");
        String paramCacheId = oJson.getString("paramCacheId");
        List<ReportParamDescription> paramList = this.webReportDomain.getReportParams(pageId, request);
        boolean isHyperLink = this.handleHyperLinkParams(paramCacheId, paramList);
        HashMap<String, List<String>> paramRef = new HashMap<String, List<String>>();
        for (ReportParamDescription define : paramList) {
            String name = define.getName();
            List<String> relations = define.getRelations();
            if (relations == null || relations.isEmpty()) continue;
            Iterator<String> iter = relations.iterator();
            while (iter.hasNext()) {
                if (!name.equals(iter.next())) continue;
                iter.remove();
            }
            if (relations.isEmpty()) continue;
            paramRef.put(name, relations);
        }
        Map<String, Object> map = this.webReportDomain.getReportScheme(oJson, request);
        List schemeList = (List)map.get("schemeList");
        FilterInfo info = new FilterInfo();
        info.setParamList(paramList);
        info.setSchemeList(schemeList);
        info.setHyperLink(isHyperLink);
        info.setHasDefaultEnter((Boolean)map.get("hasDeFaultEnter"));
        info.setDefaultEnter((String)map.get("defaultEnter"));
        String v = new com.kingdee.bos.json.JSONObject((Object)info).toString();
        String v2 = JSON.toJSONString(paramRef);
        return v.substring(0, v.length() - 1) + ",\"associate\":" + v2 + "}";
    }

    private boolean handleHyperLinkParams(String paramCacheId, List<ReportParamDescription> paramlist) throws JSONException {
        com.kingdee.bos.json.JSONObject paramJson = PageManager.getCacheParam((String)paramCacheId);
        if (paramJson == null) {
            return false;
        }
        String strParams = paramJson.getString("paramValues");
        JSONArray attParam = new JSONArray(strParams);
        if (attParam.length() != 0) {
            int size = -1;
            if (paramlist != null && (size = paramlist.size()) > 0) {
                for (int i = 0; i < size; ++i) {
                    ReportParamDescription dp = paramlist.get(i);
                    String paramName = dp.getName();
                    com.kingdee.bos.json.JSONObject oParam = null;
                    for (int j = 0; j < attParam.length(); ++j) {
                        oParam = (com.kingdee.bos.json.JSONObject)attParam.get(j);
                        if (paramName.toUpperCase(Locale.ENGLISH).equals(oParam.getString("paramName").toUpperCase(Locale.ENGLISH))) break;
                    }
                    String strVars = null;
                    String dataType = null;
                    if (null != oParam) {
                        strVars = oParam.getString("paramVars");
                        dataType = oParam.getString("dataType");
                    }
                    JSONArray arrVar = new JSONArray(strVars);
                    StringBuilder sbValue = new StringBuilder();
                    StringBuilder sbText = new StringBuilder();
                    ArrayList defaultValue = new ArrayList();
                    for (int j = 0; j < arrVar.length(); ++j) {
                        Date date;
                        com.kingdee.bos.json.JSONObject var = (com.kingdee.bos.json.JSONObject)arrVar.get(j);
                        String value = var.getString("value");
                        String text = var.getString("text");
                        if (DataType.Date.name().equalsIgnoreCase(dataType) && StringUtil.isNumeric((String)value)) {
                            date = Variant.decimalToCalender((BigDecimal)new BigDecimal(value)).getTime();
                            value = CtrlReportUtil.sdf_yyyy_MM_dd.format(date);
                        }
                        if (DataType.DateTime.name().equalsIgnoreCase(dataType) && StringUtil.isNumeric((String)value)) {
                            date = Variant.decimalToCalender((BigDecimal)new BigDecimal(value)).getTime();
                            value = CtrlReportUtil.sdfDateTime.format(date);
                        }
                        if (DataType.Time.name().equalsIgnoreCase(dataType) && StringUtil.isNumeric((String)value)) {
                            date = Variant.decimalToCalender((BigDecimal)new BigDecimal(value)).getTime();
                            value = CtrlReportUtil.sdfTime.format(date);
                        }
                        sbValue.append(value);
                        sbText.append(text);
                        Entry<String, String> entry = new Entry<String, String>();
                        entry.setValue(value);
                        entry.setText(text);
                        defaultValue.add(entry);
                    }
                    dp.setDefaultValue(defaultValue);
                }
            }
        }
        return true;
    }

    public String getFilterSchemes(com.kingdee.bos.json.JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        return this.webReportDomain.getFilterSchemes(oJson, request);
    }

    public String delFilterScheme(com.kingdee.bos.json.JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        return this.webReportDomain.delFilterScheme(oJson, request);
    }

    public String saveFilterScheme(com.kingdee.bos.json.JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        return this.webReportDomain.saveFilterScheme(oJson, request);
    }

    public String getDelaySuppliedValue(com.kingdee.bos.json.JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        return this.webReportDomain.getDelaySuppliedValue(oJson, request);
    }

    public String switchSheet(com.kingdee.bos.json.JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        return this.webReportDomain.switchSheet(oJson, request);
    }

    public String cacheParam(com.kingdee.bos.json.JSONObject oJson) throws BIReportException, JSONException {
        return this.webReportDomain.cacheParam(oJson);
    }

    public String lazyLoadFragment(com.kingdee.bos.json.JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        return this.webReportDomain.lazyLoadFragment(oJson, request);
    }

    public String lazyLoadTree(com.kingdee.bos.json.JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        return this.webReportDomain.lazyLoadTree(oJson, request);
    }

    public void closeReport(com.kingdee.bos.json.JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        this.webReportDomain.closeReport(oJson, request);
    }

    public String chartInnerLink(com.kingdee.bos.json.JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        LinkModel linkModel;
        Context ctx = BISystem.getContext((HttpServletRequest)request);
        String currentSheetName = oJson.getString("sheetName");
        String pageId = oJson.getString("pageId");
        String dataJson = Utils.decodeBase64((String)oJson.getString("params"));
        Object oDataJson = JSONObject.parse((String)dataJson);
        JSONObject jMapData = (JSONObject)oDataJson;
        LinkParamVo linkParam = new LinkParamVo();
        linkParam.setCategoryName(String.valueOf(jMapData.get((Object)"categoryName")));
        linkParam.setSeriesName(String.valueOf(jMapData.get((Object)"seriesName")));
        linkParam.setSeriesValue(String.valueOf(jMapData.get((Object)"seriesValue")));
        linkParam.setLinkSrc(String.valueOf(jMapData.get((Object)"linkSrc")));
        String result = null;
        try {
            linkModel = this.webReportDomain.chartInnerLink(ctx, linkParam, pageId, currentSheetName);
        }
        catch (InnerLinkException e) {
            throw new BIReportException((Throwable)e);
        }
        if (linkModel != null) {
            result = new com.kingdee.bos.json.JSONObject((Object)linkModel).toString();
        }
        return result;
    }

    public String cellInnerLink(com.kingdee.bos.json.JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        LinkModel linkModel;
        Context ctx = BISystem.getContext((HttpServletRequest)request);
        String currentSheetName = oJson.getString("sheetName");
        String pageId = oJson.getString("pageId");
        String linkSrc = oJson.getString("linkSrc");
        String result = null;
        try {
            linkModel = this.webReportDomain.cellInnerLink(ctx, pageId, currentSheetName, linkSrc);
        }
        catch (InnerLinkException e) {
            throw new BIReportException((Throwable)e);
        }
        if (linkModel != null) {
            result = new com.kingdee.bos.json.JSONObject((Object)linkModel).toString();
        }
        return result;
    }

    public void cacheAnalysisReportParam(com.kingdee.bos.json.JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        this.webReportDomain.cacheAnalysisReportParam(oJson, request);
    }

    public String getSecretKey() throws BIReportException, JSONException {
        return this.webReportDomain.getSecretKey();
    }
}

