/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.tobi.domain;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroRuntimeException;
import com.kingdee.eas.rpts.ctrlreport.macro.exec.ExtRptMacroExecuteFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroValue;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.rpts.ctrlsqldesign.model.OrgRangeManage;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.param.ArgInputComponentFactory;
import com.kingdee.eas.rpts.snapshot.dispatch.util.ReportDispatchContext;
import com.kingdee.eas.rpts.statistics.dynamic.DefaultExtStatisticsRunner;
import com.kingdee.eas.rpts.tobi.domain.ISuppliedValueProvider;
import com.kingdee.eas.rpts.tobi.util.BosContextUtil;
import com.kingdee.eas.rpts.web.vo.Entry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SuppliedValueProvider
implements ISuppliedValueProvider {
    private Context ctx;
    private DesignParameter designParam;
    private String orgId;
    private HashMap sqlDbMap;
    private String reportId;
    private Map<String, DesignParameter> srcAll;

    public SuppliedValueProvider(Context ctx, DesignParameter dp, String orgId, HashMap sqlDbMap, String reportId) {
        this.ctx = ctx;
        this.designParam = dp;
        this.orgId = orgId;
        this.sqlDbMap = sqlDbMap;
        this.reportId = reportId;
    }

    public SuppliedValueProvider(Context ctx, DesignParameter dp, String orgId, HashMap sqlDbMap, String reportId, Map<String, DesignParameter> srcAll) {
        this(ctx, dp, orgId, sqlDbMap, reportId);
        this.srcAll = srcAll;
    }

    @Override
    public List<Entry<String, String>> getSuppliedValues() throws BIReportException {
        IInputCtrl inputCtrl = this.designParam.getInputCtrl();
        if (null == inputCtrl) {
            return null;
        }
        List<Entry<String, String>> suppliedValues = null;
        switch (inputCtrl.getDataBind()) {
            case 0: {
                DesignParameter[] relatedParams = null;
                boolean shouldRelated = true;
                relatedParams = ArgInputComponentFactory.fetchSuppliers(this.ctx, this.designParam, this.srcAll);
                suppliedValues = this.getSupperliedValuesByDB(inputCtrl, relatedParams);
                break;
            }
            case 6: {
                suppliedValues = this.getSupperliedValuesBySystem(inputCtrl);
                break;
            }
            case 1: {
                Iterator itemDataIter = inputCtrl.getSelfList().iterator();
                suppliedValues = this.buildSupperliedValues(itemDataIter, null, null);
                break;
            }
            case 7: {
                String macroName = inputCtrl.getDefDbsource().getName();
                try {
                    MacroValue mv = this.ctx != null ? ExtRptMacroExecuteFacade.localExecute(this.ctx, DefaultExtStatisticsRunner.loadUsedMacros(this.ctx, this.reportId), macroName) : ExtRptMacroExecuteFacade.remoteExecute(DefaultExtStatisticsRunner.loadUsedMacros(this.ctx, this.reportId), macroName);
                    int valueIndex = -1;
                    int displayIndex = -1;
                    for (int k = 0; k < mv.getColums().length; ++k) {
                        if (StringUtil.equalsIgnoreCase((String)inputCtrl.getDefValue().getName(), (String)mv.getColums()[k])) {
                            valueIndex = k;
                        }
                        if (StringUtil.equalsIgnoreCase((String)inputCtrl.getDefDisplay().getName(), (String)mv.getColums()[k])) {
                            displayIndex = k;
                        }
                        if (valueIndex != -1 && displayIndex != -1) break;
                    }
                    if (valueIndex == -1) {
                        valueIndex = 0;
                    }
                    if (displayIndex == -1) {
                        displayIndex = 0;
                    }
                    suppliedValues = new ArrayList<Entry<String, String>>();
                    mv = this.ctx == null ? ExtRptMacroExecuteFacade.remoteExecute(DefaultExtStatisticsRunner.loadUsedMacros(this.ctx, this.reportId), macroName) : ExtRptMacroExecuteFacade.localExecute(this.ctx, DefaultExtStatisticsRunner.loadUsedMacros(this.ctx, this.reportId), macroName);
                    for (int i = 0; i < mv.getValues().length; ++i) {
                        Entry<String, String> entry = new Entry<String, String>();
                        entry.setText(String.valueOf(mv.getValues()[i][displayIndex]));
                        entry.setValue(String.valueOf(mv.getValues()[i][valueIndex]));
                        suppliedValues.add(entry);
                    }
                    break;
                }
                catch (MacroRuntimeException e) {
                    throw new BIReportException("\u6267\u884c\u5b8f\u5931\u8d25\u3010$" + macroName + "\u3011");
                }
            }
        }
        return suppliedValues;
    }

    private List<Entry<String, String>> getSupperliedValuesBySystem(IInputCtrl inputCtrl) {
        String displayKey = inputCtrl.getDefDisplay().getName();
        String valueKey = inputCtrl.getDefValue().getName();
        DefObj def = inputCtrl.getDefDbsource();
        int systemVarType = Integer.valueOf(def.getName());
        String userId = null;
        if (ReportDispatchContext.getInstance().isSchedule()) {
            userId = ReportDispatchContext.getInstance().getUserId();
        }
        if (StringUtil.isEmptyString(userId)) {
            userId = BosContextUtil.getCurrentUserId(this.ctx);
        }
        ArrayList<HashMap<String, String>> lst = OrgRangeManage.getOrgRangeList(this.ctx, userId, systemVarType, this.reportId);
        Iterator<HashMap<String, String>> itemDataIter = lst.iterator();
        return this.buildSupperliedValues(itemDataIter, valueKey.toLowerCase(), displayKey.toLowerCase());
    }

    private List<Entry<String, String>> getSupperliedValuesByDB(IInputCtrl inputCtrl, DesignParameter[] relatedParams) throws BIReportException {
        String displayKey = "alias";
        String valueKey = "value";
        String dataSetType = inputCtrl.getDataSetType();
        boolean isKSQL = !"6".equals(dataSetType);
        DefObj def = inputCtrl.getDefDbsource();
        String fid = def.getName();
        String dbsourceName = def.getAlias();
        if (isKSQL) {
            displayKey = inputCtrl.getDefDisplay().getName();
            valueKey = inputCtrl.getDefValue().getName();
            String systemid = CtrlReportUtil.getObjectString(def.getProperty("systemID"));
            if (!systemid.equals("")) {
                fid = fid + "\\" + systemid + "\\" + dbsourceName;
            }
        }
        Iterator itemDataIter = null;
        String orgName = BosContextUtil.getCurrentOrgName(this.ctx);
        try {
            itemDataIter = RunReportParam.getBizDataList(this.ctx, isKSQL, fid, this.orgId, orgName, this.sqlDbMap, relatedParams).iterator();
        }
        catch (Exception e) {
            throw new BIReportException((Throwable)e);
        }
        return this.buildSupperliedValues(itemDataIter, valueKey.toLowerCase(), displayKey.toLowerCase());
    }

    private List<Entry<String, String>> buildSupperliedValues(Iterator itemDataIter, String valueKey, String displayKey) {
        ArrayList<Entry<String, String>> supperliedValues = new ArrayList<Entry<String, String>>();
        if (itemDataIter == null) {
            return supperliedValues;
        }
        String defName = "";
        String defAlias = "";
        while (itemDataIter.hasNext()) {
            Object dataItem = itemDataIter.next();
            Entry<String, String> item = null;
            if (dataItem instanceof DefObj) {
                item = this.createItem(((DefObj)dataItem).getName(), ((DefObj)dataItem).getAlias());
            } else if (dataItem instanceof Map && !StringUtils.isEmpty((String)valueKey)) {
                Map mapItem = (Map)dataItem;
                defName = CtrlReportUtil.getObjectString(mapItem.get(valueKey));
                defAlias = CtrlReportUtil.getObjectString(mapItem.get(displayKey));
                item = this.createItem(defName, defAlias);
            }
            if (null == item) continue;
            supperliedValues.add(item);
        }
        return supperliedValues;
    }

    private Entry<String, String> createItem(String name, String alias) {
        Entry<String, String> item = new Entry<String, String>();
        item.setValue(name);
        item.setText(alias);
        return item;
    }
}

