/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.tobi.util;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.json.JSONObject;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.log4j.Logger;

public class AnalysisReportUtil {
    private static Logger log = LogUtil.getPackageLogger(AnalysisReportUtil.class);
    public static final String FILTER_VALUE = "value";
    public static final String FILTER_TEXT = "text";
    public static final String REQUEST_PARAMETER = "parameter";
    public static final String FILTER_PARAMETER = "filter";
    public static final String JSON_PARAMETER = "oJson_param";
    public static final String CONNECTOR = "&";

    public static void cacheReportFilterValue(String userId, String reportId, Map paramMap) {
        String key = AnalysisReportUtil.getCacheFilterKey(userId, reportId);
        String value = new JSONObject(paramMap).toString();
        AnalysisReportUtil.cacheFilter(key, value);
    }

    public static void clearReportFilterCache(String userId, String reportId) {
        AnalysisReportUtil.removeFilterCache(userId, reportId);
    }

    public static String getCacheFilterKey(String userId, String reportId) {
        return userId + CONNECTOR + reportId + CONNECTOR;
    }

    public static void cacheFilter(String key, String value) {
        try {
            Class<?> clazz = Class.forName("com.kingdee.bos.qingReport.common.utils.QingAnalysisFilterSynCacheUtil");
            Method method = clazz.getMethod("cacheFilter", String.class, String.class);
            method.invoke(null, key, value);
        }
        catch (Exception e) {
            log.error((Object)("\u7f13\u5b58\u8fc7\u6ee4\u6761\u4ef6\u5931\u8d25\uff1a" + e.getCause()));
        }
    }

    public static String getFilterCache(String userId, String reportId) {
        String key = AnalysisReportUtil.getCacheFilterKey(userId, reportId);
        try {
            Class<?> clazz = Class.forName("com.kingdee.bos.qingReport.common.utils.QingAnalysisFilterSynCacheUtil");
            Method method = clazz.getMethod("getFilter", String.class);
            return (String)method.invoke(null, key);
        }
        catch (Exception e) {
            log.error((Object)("\u83b7\u53d6\u7f13\u5b58\u8fc7\u6ee4\u6761\u4ef6\u5931\u8d25\uff1a" + e.getCause()));
            return null;
        }
    }

    public static String removeFilterCache(String userId, String reportId) {
        String key = AnalysisReportUtil.getCacheFilterKey(userId, reportId);
        try {
            Class<?> clazz = Class.forName("com.kingdee.bos.qingReport.common.utils.QingAnalysisFilterSynCacheUtil");
            Method method = clazz.getMethod("removeFilter", String.class);
            return (String)method.invoke(null, key);
        }
        catch (Exception e) {
            log.error((Object)("\u83b7\u53d6\u7f13\u5b58\u8fc7\u6ee4\u6761\u4ef6\u5931\u8d25\uff1a" + e.getCause()));
            return null;
        }
    }
}

