/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.tobi.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.rpts.tobi.util.ExtSysContext;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BosContextUtil {
    public static String LOGIN_ORGID;
    public static String LOGIN_ORGNAME;

    public static void setSysContext(ExtSysContext sysCtx) {
        ExtSysContext.setSysContext(sysCtx);
    }

    public static String getClientCurrentOrgId() {
        return SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
    }

    public static HashMap<String, String> getCurUserLoginOrgInfo(Context ctx, String userId) {
        RptParams params = new RptParams();
        String sql = "select org.fid, org.fname_l2 from t_pm_user usr left join t_org_baseunit org on usr.fdeforgunitid=org.fid where usr.fid=?";
        params.setString("sql", sql);
        params.setString("MethodName", "getInfoListBySQL");
        ArrayList<String> list = new ArrayList<String>();
        list.add(userId);
        params.setObject("lstValue", list);
        try {
            params = ctx == null ? ReportFacadeFactory.getRemoteInstance().commonExecute(params) : ReportFacadeFactory.getLocalInstance(ctx).commonExecute(params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList rowset = (ArrayList)params.getObject("object");
        if (rowset != null && !rowset.isEmpty()) {
            LOGIN_ORGID = (String)((HashMap)rowset.get(0)).get("fid");
            LOGIN_ORGNAME = (String)((HashMap)rowset.get(0)).get("fname_l2");
        }
        return map;
    }

    public static String getCurUserLoginOrgId(Context ctx, String userId) {
        if (StringUtil.isEmptyString((String)LOGIN_ORGID)) {
            BosContextUtil.getCurUserLoginOrgInfo(ctx, userId);
        }
        return LOGIN_ORGID;
    }

    public static String getCurUserLoginOrgName(Context ctx, String userId) {
        if (StringUtil.isEmptyString((String)LOGIN_ORGNAME)) {
            BosContextUtil.getCurUserLoginOrgInfo(ctx, userId);
        }
        return LOGIN_ORGNAME;
    }

    public static String getCurrentOrgId(Context ctx) {
        if (ctx != null) {
            return ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        }
        OrgUnitInfo orgInfo = ExtSysContext.getSysContext().getCurrentOrgUnit();
        if (orgInfo == null) {
            return BosContextUtil.getCurUserLoginOrgId(ctx, BosContextUtil.getCurrentUserId(ctx));
        }
        return orgInfo.getId().toString();
    }

    public static String getCurrentUserId(Context ctx) {
        if (ctx != null) {
            return ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        UserInfo userInfo = ExtSysContext.getSysContext().getCurrentUserInfo();
        if (userInfo == null) {
            return SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        }
        return userInfo.getId().toString();
    }

    public static String getCurrentOrgName(Context ctx) {
        if (ctx != null) {
            return ContextUtil.getCurrentOrgUnit((Context)ctx).getName();
        }
        OrgUnitInfo orgInfo = ExtSysContext.getSysContext().getCurrentOrgUnit();
        if (orgInfo == null) {
            return BosContextUtil.getCurUserLoginOrgName(ctx, BosContextUtil.getCurrentUserId(ctx));
        }
        return orgInfo.getName().toString();
    }

    public static String getCurrentUserName(Context ctx) {
        if (ctx != null) {
            return ContextUtil.getCurrentUserInfo((Context)ctx).getName();
        }
        UserInfo userInfo = ExtSysContext.getSysContext().getCurrentUserInfo();
        return userInfo.getName().toString();
    }

    public static void updateSysContext(HashMap map) {
        ExtSysContext sysContext = ExtSysContext.getSysContext();
        BosContextUtil.updateImpl(sysContext, map);
    }

    private static void updateImpl(SysContext sysContext, HashMap map) {
        sysContext.setCurrentUserInfo(SysContext.getSysContext().getCurrentUserInfo());
        List orgTypeList = OrgType.getEnumList();
        for (int i = 0; i < orgTypeList.size(); ++i) {
            OrgType curOrgType = (OrgType)orgTypeList.get(i);
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)map.get(curOrgType);
            if (OrgType.UnionDebt.equals((Object)curOrgType)) continue;
            sysContext.setCurrentOrgUnit(curOrgType, orgUnitInfo);
        }
        FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)map.get("CurOU");
        sysContext.setCurrentOrgUnit((OrgUnitInfo)ouInfo);
        OrgUnitInfo fiInfo = (OrgUnitInfo)map.get(OrgType.Company);
        if (fiInfo != null) {
            sysContext.setProperty((Object)"CompanyInfo", (Object)fiInfo);
            sysContext.setProperty((Object)"CurCompanyId", (Object)fiInfo.getId().toString());
        }
    }
}

